/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pipeline;

import com.dataiku.dip.analysis.ml.DKUMLUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelperFactory;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.ServiceUtils;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;

public class PipelineabilityEvaluator {
    @Autowired
    private DatasetsDAO datasetsDAO;
    private final RecipePipelineHelper.PipelineType pipelineType;
    private RecipePipelineHelperFactory recipePipelineHelperFactory;
    public static final Pipelineability NOT_PIPELINEABLE;
    private static DKULogger logger;

    public PipelineabilityEvaluator(RecipePipelineHelper.PipelineType pipelineType) {
        SpringUtils.getInstance().autowire((Object)this);
        this.pipelineType = pipelineType;
        this.recipePipelineHelperFactory = new RecipePipelineHelperFactory(pipelineType);
    }

    Pipelineability isPipelineable(final JobActivity activity, AuthCtx authCtx) throws DKUSecurityException {
        Pipelineability basePipelineability = new AbstractPipelineabilityEvaluator(authCtx){

            @Override
            boolean canFullSQL() throws IOException, DKUSecurityException {
                return ServiceUtils.canFullSQL(this.authCtx, activity, PipelineabilityEvaluator.this.datasetsDAO).canUse();
            }

            @Override
            DatasetInspector.SQLAbleFlavor getSQLAbleFlavor() throws IOException, DKUSecurityException {
                return ServiceUtils.getSQLAbleFlavor(this.authCtx, activity, PipelineabilityEvaluator.this.datasetsDAO);
            }

            @Override
            String getId() {
                return activity.id();
            }

            @Override
            RecipePipelineHelper recipePipelineHelper() throws Exception {
                return PipelineabilityEvaluator.this.recipePipelineHelperFactory.build(activity, this.authCtx);
            }
        }.buildPipelineability();
        for (FlowComputable flowComputable : activity.getSubgraph().getTargets()) {
            try {
                if (flowComputable.getRebuildBehavior() == SerializedDataset.RebuildBehavior.NORMAL) continue;
                return new Pipelineability(basePipelineability.start, false);
            }
            catch (IOException e) {
                logger.warn((Object)("Unable to check rebuild behavior of " + flowComputable.getFullId() + ". Considering not pipelineable"), (Throwable)e);
                return NOT_PIPELINEABLE;
            }
        }
        return basePipelineability;
    }

    public Pipelineability isPipelineable(final FlowRecipe flowRecipe, AuthCtx authCtx) throws DKUSecurityException {
        return new AbstractPipelineabilityEvaluator(authCtx){

            @Override
            boolean canFullSQL() throws IOException, DKUSecurityException {
                return ServiceUtils.canFullSQL(this.authCtx, flowRecipe, PipelineabilityEvaluator.this.datasetsDAO);
            }

            @Override
            DatasetInspector.SQLAbleFlavor getSQLAbleFlavor() throws IOException, DKUSecurityException {
                return ServiceUtils.getSQLAbleFlavor(this.authCtx, flowRecipe, PipelineabilityEvaluator.this.datasetsDAO);
            }

            @Override
            String getId() {
                return flowRecipe.getFullId();
            }

            @Override
            RecipePipelineHelper recipePipelineHelper() throws Exception {
                return PipelineabilityEvaluator.this.recipePipelineHelperFactory.build(flowRecipe.getModel(), this.authCtx);
            }
        }.buildPipelineability();
    }

    static {
        DKUMLUtils.loadClasses();
        ScriptStep.loadClass();
        NOT_PIPELINEABLE = new Pipelineability(false, false);
        logger = DKULogger.getLogger((String)"dku.flow.compute.pipelines.evaluator");
    }

    public static class Pipelineability
    extends InfoMessage.InfoMessages {
        public final boolean start;
        public final boolean merge;

        Pipelineability(boolean start, boolean merge) {
            this.start = start;
            this.merge = merge;
        }
    }

    abstract class AbstractPipelineabilityEvaluator {
        AuthCtx authCtx;

        AbstractPipelineabilityEvaluator(AuthCtx authCtx) {
            this.authCtx = authCtx;
        }

        abstract boolean canFullSQL() throws IOException, DKUSecurityException;

        abstract DatasetInspector.SQLAbleFlavor getSQLAbleFlavor() throws IOException, DKUSecurityException;

        abstract String getId();

        abstract RecipePipelineHelper recipePipelineHelper() throws Exception;

        Pipelineability buildPipelineability() throws DKUSecurityException {
            if (PipelineabilityEvaluator.this.pipelineType == RecipePipelineHelper.PipelineType.SQL) {
                try {
                    if (!this.canFullSQL()) {
                        logger.infoV("Activity %s does not run in full SQL mode (all sources and targets must use the same DB connection)", new Object[]{this.getId()});
                        return NOT_PIPELINEABLE;
                    }
                    DatasetInspector.SQLAbleFlavor flavor = this.getSQLAbleFlavor();
                    if (flavor != DatasetInspector.SQLAbleFlavor.REAL_SQL && flavor != DatasetInspector.SQLAbleFlavor.TRINO) {
                        logger.infoV("Activity %s does not run in full SQL mode (%s is not pipelineable)", new Object[]{this.getId(), flavor});
                        return NOT_PIPELINEABLE;
                    }
                }
                catch (IOException e) {
                    logger.warnV((Throwable)e, "Failed to determine if activity %s can run full SQL, fallback to non pipelineable", new Object[]{this.getId()});
                    return NOT_PIPELINEABLE;
                }
            }
            try {
                return this.recipePipelineHelper().buildPipelineability();
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to compute engine for recipe, fallback to non-pipelineable", (Throwable)e);
                return NOT_PIPELINEABLE;
            }
        }
    }
}

