/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataquality.rules;

import com.dataiku.dip.dataquality.RuleValidationError;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricsComputationService;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public interface MetricsBasedDataQualityRule {
    public List<Metric> getMetrics();

    @Nullable
    default public RuleValidationError checkComputedMetricsPresent(List<Metric> expectedMetrics, List<MetricsComputationService.ValuedMetric> computedMetrics) {
        Set missingMetrics = expectedMetrics.stream().map(Metric::getId).collect(Collectors.toSet());
        missingMetrics.removeAll(computedMetrics.stream().map(metric -> metric.metricId).collect(Collectors.toSet()));
        if (!missingMetrics.isEmpty()) {
            return new RuleValidationError("Some required metrics can't be computed : " + String.join((CharSequence)", ", missingMetrics));
        }
        return null;
    }

    @Nullable
    default public RuleValidationError checkComputedMetricsPresent(List<MetricsComputationService.ValuedMetric> computedMetrics) {
        return this.checkComputedMetricsPresent(this.getMetrics(), computedMetrics);
    }
}

