/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.SSHConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.FSProviderCodes;
import com.dataiku.dip.datasets.fs.AbstractFSEnumerationResult;
import com.dataiku.dip.datasets.fs.ChrootUtils;
import com.dataiku.dip.datasets.fs.FSDatasetUtils;
import com.dataiku.dip.datasets.fs.FSLikeFSProvider;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSBrowsePath;
import com.dataiku.dip.fs.FSEnumerationResult;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.input.remote.RemoteFileUtils;
import com.dataiku.dip.input.remote.SSHRemote;
import com.dataiku.dip.input.stream.AutoEnrichedInputStream;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.io.OutputStreamWrapper;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.PathUtils;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SSHFSProvider
extends FSLikeFSProvider {
    public static final int MAX_RECURSION_DEPTH = 20;
    protected final AuthCtx authCtx;
    protected final SSHConnection connection;
    protected final String root;
    protected final boolean useRelativePaths;
    protected final int timeout;
    protected SSHRemote sshRemote = null;
    @Autowired
    protected ICredentialsService connectionCredentialsService;
    private final int enumerationLimit = DKUApp.getParams().getIntParam("dku.fsproviders.enumerationLimit", Integer.valueOf(1000000));
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fsproviders.ssh");

    public SSHFSProvider(AuthCtx authCtx, DSSConnection connection, String root, int timeout) {
        this.authCtx = authCtx;
        this.connection = (SSHConnection)connection;
        this.root = PathUtils.canonical((String)ChrootUtils.getChrootedPath(this.connection.params.chroot, root, true));
        boolean bl = this.useRelativePaths = StringUtils.isBlank((String)this.root) || this.root.charAt(0) != '/';
        if (PathUtils.makeNotLeadingNoTrailing((String)root).startsWith("..")) {
            throw new IllegalArgumentException("Cannot access '" + this.root + "' outside the connection root directory");
        }
        this.timeout = timeout;
        logger.info((Object)("Effective root : '" + this.root + "' from '" + this.connection.params.chroot + "' / '" + root + "' useRelativePaths=" + this.useRelativePaths));
    }

    protected SSHRemote getRemote() throws IOException, DKUSecurityException {
        if (this.sshRemote == null) {
            this.sshRemote = this.createRemote();
        }
        return this.sshRemote;
    }

    protected abstract SSHRemote createRemote() throws IOException, DKUSecurityException;

    protected String getPathInsideRoot(String path) {
        return PathUtils.slashes((String)(this.root + "/" + path), null, (Boolean)false, (boolean)true, (String)"/");
    }

    private void checkPathStaysInsideRoot(String path) {
        if (!path.startsWith(this.root)) {
            throw ErrorContext.iae((String)("Cannot reach outside " + path));
        }
    }

    private String preparePathForRemote(String path) {
        if (StringUtils.isBlank((String)path)) {
            if (this.useRelativePaths) {
                return ".";
            }
            return "/";
        }
        if (path.charAt(0) != '/') {
            if (this.useRelativePaths) {
                return path;
            }
            return "/" + path;
        }
        if (this.useRelativePaths) {
            return path.length() == 1 ? "." : path.substring(1);
        }
        return path;
    }

    public void close() throws IOException {
        if (this.sshRemote != null) {
            this.sshRemote.close();
        }
    }

    @Override
    public String getConnectionRootWithinURIAuthority() {
        return StringUtils.defaultIfEmpty((String)this.connection.params.chroot, (String)"");
    }

    @Override
    public String getRoot() {
        return this.root;
    }

    public void makeEmpty(String prefix) throws IOException, DKUSecurityException {
        FSPathOrDirectory status = this.stat(prefix);
        if (status != null && !status.isDirectory) {
            this.write(prefix).close();
        } else {
            this.deleteRecursive(prefix);
            SSHRemote remote = this.getRemote();
            String path = this.getPathInsideRoot(prefix);
            remote.mkdirs(this.preparePathForRemote(path));
        }
    }

    public void ensureDirectory(String prefix) throws IOException, DKUSecurityException {
        FSPathOrDirectory status = this.stat(prefix);
        if (status != null && !status.isDirectory) {
            throw new IOException("Cannot make directory, '" + prefix + "' is a file");
        }
        SSHRemote remote = this.getRemote();
        String path = this.getPathInsideRoot(prefix);
        remote.mkdirs(this.preparePathForRemote(path));
    }

    public FSBrowsePath browse(String prefix, FSProvider.FSBrowseStrategy strategy) throws IOException, DKUSecurityException {
        PathUtils.ensurePathStaysWithinRoot((String)prefix);
        SSHRemote remote = this.getRemote();
        String path = this.getPathInsideRoot(prefix);
        if (!path.startsWith(this.root)) {
            throw ErrorContext.iae((String)("Cannot reach outside " + path));
        }
        FSBrowsePath ret = FSBrowsePath.makeRoot((String)prefix, (boolean)this.useRelativePaths);
        RemoteFileUtils.RemoteFile rr = remote.get(this.preparePathForRemote(path));
        if (rr != null) {
            if (!(rr.isDirectory() || strategy != FSProvider.FSBrowseStrategy.FILE_OR_DIRECTORY && strategy != FSProvider.FSBrowseStrategy.FILE)) {
                ret.exists = true;
                ret.directory = false;
                ret.size = rr.size();
                ret.lastModified = rr.mtime();
                return ret;
            }
            if (rr.isDirectory() && (strategy == FSProvider.FSBrowseStrategy.FILE_OR_DIRECTORY || strategy == FSProvider.FSBrowseStrategy.DIRECTORY)) {
                ret.exists = true;
                ret.directory = true;
                List<RemoteFileUtils.RemoteFile> remoteFiles = remote.list(this.preparePathForRemote(path));
                if (ret.children.size() + remoteFiles.size() > this.enumerationLimit) {
                    throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_TOO_MANY_FILES, String.format("There are too many files in this SCP/SFTP location (> %d). Enumeration aborted.", this.enumerationLimit));
                }
                for (RemoteFileUtils.RemoteFile r : remoteFiles) {
                    ret.children.add(FSBrowsePath.makeChild((FSBrowsePath)ret, (String)r.basename(), (boolean)r.isDirectory(), (long)r.size(), (long)r.mtime()));
                }
                return ret;
            }
        }
        return new FSBrowsePath();
    }

    public FSEnumerationResult enumerateRecursive(String prefix, FSEnumerationSettings enumerationSettings) {
        try {
            PathUtils.ensurePathStaysWithinRoot((String)prefix);
            List<FSPath> paths = this.enumerateFilesystem(prefix, enumerationSettings);
            if (paths == null) {
                return SSHFSEnumerationResult.fromNonExistingPrefix();
            }
            return SSHFSEnumerationResult.fromPaths(enumerationSettings.filter(paths));
        }
        catch (Exception e) {
            return SSHFSEnumerationResult.fromError(e);
        }
    }

    private List<FSPath> enumerateFilesystem(String prefix, FSEnumerationSettings settings) throws IOException, DKUSecurityException {
        logger.info((Object)("Enumerating SFTP prefix=" + (String)prefix));
        ArrayList<FSPath> ret = new ArrayList<FSPath>();
        SSHRemote remote = this.getRemote();
        String pathInsideRoot = this.getPathInsideRoot((String)prefix);
        RemoteFileUtils.RemoteFile file = remote.get(this.preparePathForRemote(pathInsideRoot));
        if (file == null) {
            return null;
        }
        if (!((String)prefix).startsWith("/")) {
            prefix = "/" + (String)prefix;
        }
        if (!file.isDirectory()) {
            ret.add(new FSPath((String)prefix, file.size(), file.mtime()));
        } else if (!settings.selectionRules.excludesPrefix(((String)prefix).substring(1))) {
            this.enumerateRec(file, (String)prefix, ret, 0, settings, 0L);
        }
        return ret;
    }

    private long enumerateRec(RemoteFileUtils.RemoteFile cur, String relPath, List<FSPath> list, int depth, FSEnumerationSettings settings, long size) throws IOException, DKUSecurityException {
        assert (cur.isDirectory());
        if (depth > 20) {
            throw new RuntimeException("Directory depth is too high (>20)");
        }
        long totalSize = size;
        SSHRemote remote = this.getRemote();
        String pathInsideRoot = this.getPathInsideRoot(relPath);
        List<RemoteFileUtils.RemoteFile> ret = remote.list(this.preparePathForRemote(pathInsideRoot));
        for (RemoteFileUtils.RemoteFile f : ret) {
            Object path = relPath + "/" + f.basename();
            path = PathUtils.slashes((String)path, (Boolean)true, (Boolean)false, (boolean)true, (String)"");
            if (!f.isDirectory()) {
                if (this.shouldSkipFile(f, settings, (String)path)) continue;
                if (list.size() + 1 > this.enumerationLimit) {
                    throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_TOO_MANY_FILES, String.format("There are too many files in this SCP/SFTP location (> %d). Enumeration aborted.", this.enumerationLimit));
                }
                list.add(new FSPath((String)path, f.size(), f.mtime()));
                totalSize += f.size();
            } else if (!settings.selectionRules.excludesPrefix(((String)path).substring(1))) {
                totalSize = this.enumerateRec(f, (String)path, list, depth + 1, settings, totalSize);
            }
            if (!settings.shouldStopEnumeration(list, totalSize)) continue;
            return totalSize;
        }
        return totalSize;
    }

    private boolean shouldSkipFile(RemoteFileUtils.RemoteFile f, FSEnumerationSettings settings, String path) {
        if (FSDatasetUtils.isBadFile(f.basename(), settings.showHiddenFiles) || FSDatasetUtils.isBadPath(path) || !settings.selectionRules.includes(path.substring(1))) {
            return true;
        }
        return settings.firstNonEmpty && f.size() == 0L;
    }

    public FSPathOrDirectory stat(String prefix) throws IOException, DKUSecurityException {
        String datasetRootPath;
        PathUtils.ensurePathStaysWithinRoot((String)prefix);
        SSHRemote remote = this.getRemote();
        String path = this.getPathInsideRoot(prefix);
        if (!path.startsWith(this.root)) {
            throw ErrorContext.iae((String)("Cannot reach outside " + path));
        }
        try {
            RemoteFileUtils.RemoteFile datasetRoot = remote.get(this.preparePathForRemote(this.root));
            if (datasetRoot == null) {
                throw new FileNotFoundException();
            }
            datasetRootPath = datasetRoot.path();
            if (datasetRootPath == null) {
                throw new FileNotFoundException();
            }
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("Dataset root path does not exist : " + this.root), (Throwable)e);
            return null;
        }
        RemoteFileUtils.RemoteFile status = null;
        try {
            status = remote.get(this.preparePathForRemote(path));
        }
        catch (FileNotFoundException e) {
            return null;
        }
        if (status == null) {
            return null;
        }
        Object filePathInDataset = status.path().replace(datasetRootPath, "");
        if (!((String)filePathInDataset).startsWith("/")) {
            filePathInDataset = "/" + (String)filePathInDataset;
        }
        return new FSPathOrDirectory((String)filePathInDataset, status.size(), status.mtime(), status.isDirectory());
    }

    public void deleteRecursive(String prefix) throws IOException, DKUSecurityException {
        this.checkConnectionWritability();
        PathUtils.ensurePathStaysWithinRoot((String)prefix);
        SSHRemote remote = this.getRemote();
        String path = this.getPathInsideRoot(prefix);
        if (!path.startsWith(this.root)) {
            throw ErrorContext.iae((String)("Cannot reach outside " + path));
        }
        remote.forceRemove(this.preparePathForRemote(path));
    }

    private void rename(String from, String to) throws IOException, DKUSecurityException {
        this.checkConnectionWritability();
        PathUtils.ensurePathStaysWithinRoot((String)from);
        PathUtils.ensurePathStaysWithinRoot((String)to);
        SSHRemote remote = this.getRemote();
        String fromPath = this.getPathInsideRoot(from);
        this.checkPathStaysInsideRoot(fromPath);
        String toPath = this.getPathInsideRoot(to);
        this.checkPathStaysInsideRoot(toPath);
        FSDatasetUtils.checkDestPathDoesNotExist(to, this.stat(to));
        this.ensureDirectory(PathUtils.getParent((String)to));
        remote.rename(this.preparePathForRemote(fromPath), this.preparePathForRemote(toPath));
    }

    public void moveDirectory(String from, String to) throws IOException, DKUSecurityException {
        this.rename(from, to);
    }

    public void moveFile(String from, String to) throws IOException, DKUSecurityException {
        this.rename(from, to);
    }

    public EnrichedInputStream read(String prefix) throws IOException, DKUSecurityException {
        PathUtils.ensurePathStaysWithinRoot((String)prefix);
        SSHRemote remote = this.getRemote();
        String path = this.getPathInsideRoot(prefix);
        if (!path.startsWith(this.root)) {
            throw ErrorContext.iae((String)("Cannot reach outside " + path));
        }
        RemoteFileUtils.RemoteFile remoteFile = remote.get(this.preparePathForRemote(path));
        if (remoteFile == null) {
            throw new IOException("File '" + prefix + "' doesn't exist");
        }
        return new RemoteFileEnrichedInputStream(this, prefix, remoteFile, path);
    }

    public OutputStream write(String prefix) throws IOException, DKUSecurityException {
        this.checkConnectionWritability();
        PathUtils.ensurePathStaysWithinRoot((String)prefix);
        SSHRemote remote = this.getRemote();
        String path = this.getPathInsideRoot(prefix);
        if (!path.startsWith(this.root)) {
            throw ErrorContext.iae((String)("Cannot reach outside " + path));
        }
        remote.mkdirs(this.preparePathForRemote(PathUtils.getParent((String)path)));
        SSHRemote streamRemote = this.createRemote();
        return new SeparateClientSSHRemoteOutputStream(streamRemote, streamRemote.getOutputStream(this.preparePathForRemote(path)));
    }

    private void checkConnectionWritability() {
        if (!this.connection.allowWrite) {
            throw new IllegalArgumentException("Cannot write on connection " + this.connection.name);
        }
    }

    public void setLastModified(String prefix, long lastModified) throws IOException, DKUSecurityException {
        PathUtils.ensurePathStaysWithinRoot((String)prefix);
        SSHRemote remote = this.getRemote();
        String path = this.getPathInsideRoot(prefix);
        if (!path.startsWith(this.root)) {
            throw ErrorContext.iae((String)("Cannot reach outside " + path));
        }
        remote.setLastModified(this.preparePathForRemote(path), lastModified);
    }

    static class SSHFSEnumerationResult
    extends AbstractFSEnumerationResult {
        public SSHFSEnumerationResult() {
        }

        public SSHFSEnumerationResult(List<FSPath> paths) {
            super(paths);
        }

        public SSHFSEnumerationResult(Throwable error) {
            super(error);
        }

        private static SSHFSEnumerationResult fromError(Throwable error) {
            return new SSHFSEnumerationResult(error);
        }

        private static SSHFSEnumerationResult fromPaths(List<FSPath> paths) {
            return new SSHFSEnumerationResult(paths);
        }

        private static SSHFSEnumerationResult fromNonExistingPrefix() {
            return new SSHFSEnumerationResult();
        }
    }

    public static class RemoteFileEnrichedInputStream
    extends AutoEnrichedInputStream {
        private final RemoteFileUtils.RemoteFile file;
        private final SSHFSProvider provider;

        public RemoteFileEnrichedInputStream(SSHFSProvider provider, String pathWithinProvider, RemoteFileUtils.RemoteFile file, String desc) {
            super(file.size(), pathWithinProvider, file.basename(), desc, file::mtime);
            this.provider = provider;
            this.file = file;
        }

        protected InputStream getBasicInputStream() throws IOException, DKUSecurityException {
            final SSHRemote remote = this.provider.createRemote();
            return new FilterInputStream(remote.getInputStream(this.file.path())){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)"Error closing input stream", (Throwable)e);
                    }
                    finally {
                        remote.close();
                    }
                }
            };
        }

        protected InputStream getBasicHeadInputStream(long size) throws IOException, DKUSecurityException {
            return this.getBasicInputStream();
        }
    }

    class SeparateClientSSHRemoteOutputStream
    extends OutputStreamWrapper {
        protected boolean closed;
        private final SSHRemote streamRemote;

        SeparateClientSSHRemoteOutputStream(SSHRemote streamRemote, OutputStream out) {
            super(out);
            this.closed = false;
            this.streamRemote = streamRemote;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                super.close();
            }
            finally {
                this.streamRemote.close();
            }
        }
    }
}

