/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sample;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Pattern;
import org.springframework.util.unit.DataSize;

public class SampleDatasetMetaDataLogo {
    protected static final long SIZE_LIMIT_IN_MB = DKUApp.getParams().getLongParam("dku.plugins.sampleDataset.logo.fileSizeLimitInMb", 100L);
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.datasets.resourcefile");

    private static String encodeURI(String value) {
        try {
            return new URI(null, null, value, null).getRawPath();
        }
        catch (URISyntaxException e) {
            return value;
        }
    }

    protected static String buildLogoUrl(String logo, File pluginResourceFolder, String pluginId) {
        String defaultLogo = "/static/dataiku/images/flow/sample-default_logo.svg";
        if (logo == null) {
            return "/static/dataiku/images/flow/sample-default_logo.svg";
        }
        if (pluginId.equals("default-samples")) {
            return String.format("/static/dataiku/images/flow/%s", SampleDatasetMetaDataLogo.encodeURI(logo));
        }
        if (SampleDatasetMetaDataLogo.isLogoValid(logo, pluginResourceFolder)) {
            return String.format("/plugins/%s/resource/%s", pluginId, SampleDatasetMetaDataLogo.encodeURI(logo));
        }
        logger.warnV("Logo file \"resource/%s\" was invalid for plugin \"%s\", fallback on default logo", new Object[]{logo, pluginId});
        return "/static/dataiku/images/flow/sample-default_logo.svg";
    }

    private static boolean isLogoValid(String logoName, File pluginResourceFolder) {
        File logoFile;
        if (SampleDatasetMetaDataLogo.logoFilenameIsValid(logoName) && SampleDatasetMetaDataLogo.logoFileExtensionIsValid(logoName) && SampleDatasetMetaDataLogo.logoFileExists(logoFile = DKUFileUtils.getWithin((File)pluginResourceFolder, (String[])new String[]{logoName}), logoName)) {
            return SampleDatasetMetaDataLogo.logoFileSizeIsValid(logoFile);
        }
        return false;
    }

    protected static boolean logoFileSizeIsValid(File logoFile) {
        DataSize sizeLimit = DataSize.ofMegabytes((long)SIZE_LIMIT_IN_MB);
        return DataSize.ofBytes((long)logoFile.length()).compareTo(sizeLimit) < 0;
    }

    protected static boolean logoFileExists(File logoFile, String expectedLogoName) {
        try {
            return logoFile.exists() && logoFile.getCanonicalPath().endsWith(expectedLogoName);
        }
        catch (IOException e) {
            return false;
        }
    }

    protected static boolean logoFileExtensionIsValid(String logoName) {
        String[] allowedExtensions = new String[]{".apng", ".png", ".avif", ".gif", ".jpg", ".jpeg", ".jfif", ".svg", ".webp", ".bmp", ".ico", ".cur"};
        String lowerCaseLogo = logoName.toLowerCase(Locale.ROOT);
        return Arrays.stream(allowedExtensions).anyMatch(lowerCaseLogo::endsWith);
    }

    protected static boolean logoFilenameIsValid(String logoName) {
        Pattern filenamePattern = Pattern.compile("^[a-zA-Z0-9. _-]+$");
        return filenamePattern.matcher(logoName).matches() && !logoName.startsWith(".");
    }
}

