/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards;

import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.engine.ComputationResultDataStreamer;
import com.dataiku.dip.eda.worksheets.cards.Card;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractCompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NullChecker;
import javax.annotation.Nullable;

public class PlaygroundCard
extends Card {
    public static final String TYPE = "playground";
    public String rawComputation;

    private PlaygroundCard() {
    }

    public PlaygroundCard(String rawComputation) {
        this.rawComputation = rawComputation;
    }

    @Override
    protected CompiledCard compileNoSplitNoFilter() {
        return new CompiledPlaygroundCard();
    }

    private class CompiledPlaygroundCard
    extends AbstractCompiledCard<MultiComputation, MultiComputation.MultiComputationResult> {
        Computation parsedComputation;
        String errorMessage;

        CompiledPlaygroundCard() {
            try {
                this.parsedComputation = (Computation)((Object)JSON.parse((String)PlaygroundCard.this.rawComputation, Computation.class));
                NullChecker.checkObject((Object)((Object)this.parsedComputation));
            }
            catch (Exception e) {
                this.errorMessage = e.getMessage();
            }
        }

        @Override
        public MultiComputation getComputationPlan() {
            return this.errorMessage == null ? new MultiComputation(this.parsedComputation) : new MultiComputation(new Computation[0]);
        }

        @Override
        protected CardResult buildFromAvailableResult(MultiComputation.MultiComputationResult result, ComputationResultDataStreamer dataStreamer) {
            PlaygroundCardResult debugCardResult = new PlaygroundCardResult();
            if (this.errorMessage == null) {
                debugCardResult.rawResult = JSON.pretty((Object)((Object)result.get(0)));
            } else {
                debugCardResult.errorMessage = this.errorMessage;
            }
            return debugCardResult;
        }
    }

    public static class PlaygroundCardResult
    extends CardResult {
        @Nullable
        public String rawResult;
        @Nullable
        public String errorMessage;
    }
}

