/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards.fragments;

import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.computations.univariate.MatchTimeStep;
import com.dataiku.dip.eda.compute.computations.univariate.MaxTime;
import com.dataiku.dip.eda.compute.computations.univariate.MinTime;
import com.dataiku.dip.utils.ImmutableValueObject;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

@UIModel
public class TimeInfoFragment
extends ImmutableValueObject {
    @Nullable
    public String min;
    @Nullable
    public String max;
    @Nullable
    public StepInfo stepInfo;

    public static Computation getComputationPlan(String column, boolean detectTimeStep) {
        ArrayList<Computation> computations = new ArrayList<Computation>();
        computations.add(new MinTime(column));
        computations.add(new MaxTime(column));
        if (detectTimeStep) {
            computations.add(new MatchTimeStep(column));
        }
        return new MultiComputation(computations);
    }

    public static TimeInfoFragment build(ComputationResult result) {
        ComputationResult result1;
        TimeInfoFragment timeInfo = new TimeInfoFragment();
        if (!result.isAvailable()) {
            return timeInfo;
        }
        MultiComputation.MultiComputationResult multiResult = result.asMulti();
        ComputationResult result0 = multiResult.get(0);
        if (result0.isFullyAvailable()) {
            MinTime.MinTimeResult minTimeResult = result0.as(MinTime.MinTimeResult.class);
            timeInfo.min = minTimeResult.timestamp;
        }
        if ((result1 = multiResult.get(1)).isFullyAvailable()) {
            MaxTime.MaxTimeResult maxTimeResult = result1.as(MaxTime.MaxTimeResult.class);
            timeInfo.max = maxTimeResult.timestamp;
        }
        if (multiResult.size() < 3) {
            return timeInfo;
        }
        ComputationResult result2 = multiResult.get(2);
        if (result2.isFullyAvailable()) {
            MatchTimeStep.MatchTimeStepResult matchTimeStepResult = result2.as(MatchTimeStep.MatchTimeStepResult.class);
            StepInfo stepInfo = new StepInfo();
            stepInfo.steps = matchTimeStepResult.steps;
            stepInfo.nSteps = matchTimeStepResult.nSteps;
            timeInfo.stepInfo = stepInfo;
        }
        return timeInfo;
    }

    public static class StepInfo
    extends ImmutableValueObject {
        public List<MatchTimeStep.MatchTimeStepResult.Step> steps;
        public int nSteps;
    }
}

