/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.exceptions;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.google.gson.JsonElement;
import org.apache.commons.lang.StringUtils;

public class ConfValidators {
    public static void checkNotNull(Object o, InfoMessage.MessageCode code, String argName) throws CodedException {
        if (o == null) {
            throw new CodedException(code, argName + " should not be null");
        }
    }

    public static void checkNotJsonNull(JsonElement o, InfoMessage.MessageCode code, String argName) throws CodedException {
        if (o == null || o.isJsonNull()) {
            throw new CodedException(code, argName + " should not be null");
        }
    }

    public static void checkNotBlank(String s, InfoMessage.MessageCode code, String argName) throws CodedException {
        if (StringUtils.isBlank((String)s)) {
            throw new CodedException(code, argName + " should not be left blank");
        }
    }

    public static void checkNotBlankRuntime(String s, InfoMessage.MessageCode code, String argName) {
        if (StringUtils.isBlank((String)s)) {
            throw new CodedRuntimeException(code, argName + " should not be left blank");
        }
    }

    public static void checkStrictlyPositive(Number n, InfoMessage.MessageCode code, String argName) throws CodedException {
        if (n == null || n.doubleValue() <= 0.0) {
            throw new CodedException(code, argName + " should be strictly positive");
        }
    }
}

