/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.export.CustomExporterDesc;
import com.dataiku.dip.io.AbstractNonImpersonatedSecretProtectedPythonKernel;
import com.dataiku.dip.io.SingleCommandKernelLink;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.process.IsolableProcess;
import com.dataiku.dip.security.tickets.APITicketService;
import com.google.gson.JsonObject;
import java.io.IOException;

public class CustomExporterPythonKernel
extends AbstractNonImpersonatedSecretProtectedPythonKernel<SingleCommandKernelLink> {
    private final APITicketService.Ticket ticket;

    public CustomExporterPythonKernel(AuthCtx authCtx, SingleCommandKernelLink link, String pluginResourceFolderPath, String pluginPythonLibFolderPath, String projectKey, String envName, APITicketService.Ticket ticket) {
        super(authCtx, link, GeneralSettingsDAO.CGrouppableProcessType.CUSTOM_PYTHON_DATA_ACCESS_COMPONENT, pluginResourceFolderPath, CustomExporterPythonKernel.makePythonLibs("plugin-lib", pluginPythonLibFolderPath), projectKey, envName);
        this.ticket = ticket;
    }

    @Override
    protected IsolableProcess createAndStartProcess(ProcessBuilder pb, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType) throws DKUSecurityException, IOException, InterruptedException {
        pb.environment().put("DKU_API_TICKET", this.ticket.getSecret());
        return super.createAndStartProcess(pb, cgrouppableProcessType);
    }

    @Override
    protected String getPythonModule() {
        return "dataiku.exporter.server";
    }

    public static class PythonCommand {
        public String task;
        public CustomExporterDesc.ExportBehavior exportBehavior;
        public String code;
        public Schema schema;
        public JsonObject config;
        public JsonObject pluginConfig;
        public String destinationFilePath;
        public SendFileBackMode sendFileBack;

        public PythonCommand(String task, CustomExporterDesc.ExportBehavior exportBehavior, String code, Schema schema, JsonObject config, JsonObject pluginConfig) {
            this.task = task;
            this.exportBehavior = exportBehavior;
            this.code = code;
            this.schema = schema;
            this.config = config;
            this.pluginConfig = pluginConfig;
        }
    }

    public static enum SendFileBackMode {
        NONE,
        FILE,
        DIR;

    }
}

