/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.avro;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.formats.avro.SchemaConverter;
import com.dataiku.dip.shaker.types.Boolean;
import com.dataiku.dip.shaker.types.Date;
import com.dataiku.dip.shaker.types.DateOnly;
import com.dataiku.dip.shaker.types.DatetimeNoTz;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.io.Encoder;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AvroRowConverter {
    private static Logger logger = Logger.getLogger((String)"dku.output.avro");
    private final Boolean booleanMeaning = new Boolean();
    private final Date dateMeaning = new Date();
    private final DateOnly dateOnlyMeaning = new DateOnly();
    private final DatetimeNoTz datetimeNoTzMeaning = new DatetimeNoTz();
    private Schema writerSchema;
    private List<SchemaColumn> schemaColumns;
    private List<Column> columns = new ArrayList<Column>();

    public AvroRowConverter(ColumnFactory columnFactory, com.dataiku.dip.coremodel.Schema dssSchema, Schema writerSchema) {
        this.schemaColumns = dssSchema.getColumns();
        for (SchemaColumn sc : this.schemaColumns) {
            this.columns.add(columnFactory.column(sc.getName()));
        }
        this.writerSchema = writerSchema;
    }

    public void write(Row row, Encoder out) throws IOException {
        try {
            for (int i = 0; i < this.columns.size(); ++i) {
                Column columnHandle = this.columns.get(i);
                Schema avroSchema = this.writerSchema.getField(columnHandle.getName()).schema();
                String rawCellValue = row.get(columnHandle);
                try {
                    this.writeNullable(rawCellValue, out, this.schemaColumns.get(i), avroSchema);
                    continue;
                }
                catch (Exception e) {
                    throw new IOException("Error: \"" + e.getMessage() + "\", in column " + columnHandle.getName() + ": " + rawCellValue, e);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Unable to encode row in Avro", (Throwable)e);
            throw e;
        }
    }

    private void writeNullable(Object rawCellValue, Encoder out, SchemaColumn schemaColumn, Schema field) throws IOException, JSONException {
        boolean isNull;
        Schema underlyingType = SchemaConverter.getNullableTypeFromUnion(field);
        boolean bl = isNull = rawCellValue == null;
        if (!isNull && rawCellValue instanceof String && underlyingType.getType() != Schema.Type.STRING) {
            isNull = StringUtils.isBlank((String)((String)rawCellValue));
            if ("null".equals(rawCellValue) && (underlyingType.getType() == Schema.Type.ARRAY || underlyingType.getType() == Schema.Type.RECORD || underlyingType.getType() == Schema.Type.MAP)) {
                isNull = true;
            }
        }
        if (isNull) {
            int nullIndex = SchemaConverter.getNullIndexInUnion(field);
            out.writeIndex(nullIndex);
            out.writeNull();
        } else {
            assert (rawCellValue != null);
            int fieldIndex = field.getIndexNamed(underlyingType.getFullName());
            out.writeIndex(fieldIndex);
            switch (underlyingType.getType()) {
                case RECORD: {
                    if (rawCellValue instanceof String) {
                        this.writeNonNullableRecord((String)rawCellValue, out, schemaColumn, underlyingType);
                        break;
                    }
                    if (rawCellValue instanceof JSONObject) {
                        this.writeNonNullableRecord((JSONObject)rawCellValue, out, schemaColumn, underlyingType);
                        break;
                    }
                    throw new RuntimeException("Expected String or JSONObject. This is a bug.");
                }
                case ARRAY: {
                    if (rawCellValue instanceof String) {
                        this.writeNonNullableArray((String)rawCellValue, out, schemaColumn, underlyingType);
                        break;
                    }
                    if (rawCellValue instanceof JSONArray) {
                        this.writeNonNullableArray((JSONArray)rawCellValue, out, schemaColumn, underlyingType);
                        break;
                    }
                    throw new RuntimeException("Expected String or JSONArray. This is a bug.");
                }
                case MAP: {
                    if (rawCellValue instanceof String) {
                        this.writeNonNullableMap((String)rawCellValue, out, schemaColumn, underlyingType);
                        break;
                    }
                    if (rawCellValue instanceof JSONObject) {
                        this.writeNonNullableMap((JSONObject)rawCellValue, out, schemaColumn, underlyingType);
                        break;
                    }
                    throw new RuntimeException("Expected String or JSONObject. This is a bug.");
                }
                case STRING: {
                    this.writeNonNullableString(rawCellValue.toString(), out, schemaColumn, underlyingType);
                    break;
                }
                case INT: {
                    if (underlyingType.getLogicalType() != null && "date".equalsIgnoreCase(underlyingType.getLogicalType().getName())) {
                        long daysSinceEpoch = this.dateOnlyMeaning.msSinceEpoch(rawCellValue.toString()) / 86400000L;
                        out.writeInt((int)daysSinceEpoch);
                        break;
                    }
                    if (rawCellValue instanceof Number) {
                        out.writeInt(((Number)rawCellValue).intValue());
                        break;
                    }
                    out.writeInt(Integer.parseInt(rawCellValue.toString()));
                    break;
                }
                case LONG: {
                    if (underlyingType.getLogicalType() != null && "timestamp-millis".equalsIgnoreCase(underlyingType.getLogicalType().getName())) {
                        out.writeLong(this.dateMeaning.msSinceEpoch(rawCellValue.toString()));
                        break;
                    }
                    if (underlyingType.getLogicalType() != null && "local-timestamp-millis".equalsIgnoreCase(underlyingType.getLogicalType().getName())) {
                        out.writeLong(this.datetimeNoTzMeaning.msSinceEpoch(rawCellValue.toString()));
                        break;
                    }
                    if (rawCellValue instanceof Number) {
                        out.writeLong(((Number)rawCellValue).longValue());
                        break;
                    }
                    out.writeLong(Long.parseLong(rawCellValue.toString()));
                    break;
                }
                case FLOAT: {
                    if (rawCellValue instanceof Number) {
                        out.writeFloat(((Number)rawCellValue).floatValue());
                        break;
                    }
                    out.writeFloat(Float.parseFloat(rawCellValue.toString()));
                    break;
                }
                case DOUBLE: {
                    if (rawCellValue instanceof Number) {
                        out.writeDouble(((Number)rawCellValue).doubleValue());
                        break;
                    }
                    out.writeDouble(Double.parseDouble(rawCellValue.toString()));
                    break;
                }
                case BOOLEAN: {
                    if (rawCellValue instanceof java.lang.Boolean) {
                        out.writeBoolean(((java.lang.Boolean)rawCellValue).booleanValue());
                        break;
                    }
                    out.writeBoolean(this.booleanMeaning.parse(rawCellValue.toString()));
                    break;
                }
                case NULL: {
                    throw new RuntimeException("Should not be NULL here: this is a bug");
                }
                default: {
                    throw new RuntimeException("Avro writer doesn't support type:" + String.valueOf(underlyingType));
                }
            }
        }
    }

    private void writeNonNullableString(String rawCellValue, Encoder out, SchemaColumn schemaColumn, Schema field) throws IOException {
        if (schemaColumn.getType() == Type.DATE) {
            // empty if block
        }
        out.writeString(rawCellValue);
    }

    private void writeNonNullableMap(String rawCellValue, Encoder out, SchemaColumn schemaColumn, Schema field) throws JSONException, IOException {
        JSONObject parsedMap = new JSONObject(rawCellValue);
        this.writeNonNullableMap(parsedMap, out, schemaColumn, field);
    }

    private void writeNonNullableMap(JSONObject parsedMap, Encoder out, SchemaColumn schemaColumn, Schema field) throws JSONException, IOException {
        int len = parsedMap.length();
        out.writeMapStart();
        out.setItemCount((long)len);
        Iterator it = parsedMap.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object val = parsedMap.get(key);
            if (val != null && val.equals(JSONObject.NULL)) {
                val = null;
            }
            out.startItem();
            this.writeNonNullableString(key, out, schemaColumn.mapKeys, Schema.create((Schema.Type)Schema.Type.STRING));
            this.writeNullable(val, out, schemaColumn.mapValues, field.getValueType());
        }
        out.writeMapEnd();
    }

    private void writeNonNullableArray(String rawCellValue, Encoder out, SchemaColumn schemaColumn, Schema field) throws JSONException, IOException {
        JSONArray parsedMap = new JSONArray(rawCellValue);
        this.writeNonNullableArray(parsedMap, out, schemaColumn, field);
    }

    private void writeNonNullableArray(JSONArray parsedArray, Encoder out, SchemaColumn schemaColumn, Schema field) throws IOException, JSONException {
        out.writeArrayStart();
        int len = parsedArray.length();
        out.setItemCount((long)len);
        for (int i = 0; i < len; ++i) {
            out.startItem();
            Object val = parsedArray.get(i);
            if (val != null && val.equals(JSONObject.NULL)) {
                val = null;
            }
            this.writeNullable(val, out, schemaColumn.arrayContent, field.getElementType());
        }
        out.writeArrayEnd();
    }

    private void writeNonNullableRecord(String rawCellValue, Encoder out, SchemaColumn schemaColumn, Schema field) throws JSONException, IOException {
        JSONObject parsedObject = new JSONObject(rawCellValue);
        this.writeNonNullableRecord(parsedObject, out, schemaColumn, field);
    }

    private void writeNonNullableRecord(JSONObject parsedObject, Encoder out, SchemaColumn schemaColumn, Schema field) throws JSONException, IOException {
        for (int i = 0; i < schemaColumn.objectFields.size(); ++i) {
            SchemaColumn dssType = (SchemaColumn)schemaColumn.objectFields.get(i);
            Schema avroType = field.getField(dssType.getName()).schema();
            Object val = null;
            if (parsedObject.has(dssType.getName()) && (val = parsedObject.get(dssType.getName())) != null && val.equals(JSONObject.NULL)) {
                val = null;
            }
            this.writeNullable(val, out, dssType, avroType);
        }
    }
}

