/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive;

import com.dataiku.dip.cluster.ClusterDependentKernelsManager;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.cluster.HiveSettings;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.hive.HProxyKernelHandle;
import com.dataiku.dip.hive.IHProxyKernelsManager;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class HProxyKernelsManager
extends ClusterDependentKernelsManager<HProxyKernelHandle>
implements IHProxyKernelsManager {
    @PostConstruct
    public void onStart() {
        logger.info((Object)"Init hproxies kernels service");
        if (!HadoopLoader.hadoopEnabled()) {
            logger.info((Object)"HProxy kernel manager not started because no hadoop configured");
        }
        logger.debug((Object)"Done init hproxies kernels service");
    }

    @Override
    public String getPrefix() {
        return "hproxy";
    }

    @Override
    protected HProxyKernelHandle instantiateKernel(String kernelId, String key) {
        return new HProxyKernelHandle(kernelId, key);
    }

    @Override
    protected String getKey(ClusterSettings clusterSettings) {
        HiveSettings hiveSettings = clusterSettings.getHiveSettings();
        HadoopSettings hadoopSettings = clusterSettings.getHadoopSettings();
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.defaultIfBlank((String)hiveSettings.hiveAdditionalJars, (String)""));
        sb.append("-");
        sb.append(StringUtils.defaultIfBlank((String)hiveSettings.hiveSparkHome, (String)""));
        sb.append("-");
        sb.append(JSON.json((Object)hadoopSettings.extraConf));
        sb.append("-");
        sb.append(JSON.json((Object)hadoopSettings.validationKernelsExtraEnv));
        return DKUtils.md5Base64((String)sb.toString());
    }
}

