/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.csv;

import com.dataiku.dip.input.formats.CSVParserUtils;
import com.dataiku.dip.input.formats.csv.CSVParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;

public class FastRFC4180CSVParser
implements CSVParser {
    private final char[] buffer = new char[4096];
    private int bufAvailLen = 0;
    private int bufIdx = 0;
    private int currentLine = 1;
    private StringBuilder currentField = new StringBuilder();
    private boolean inQuotes;
    private BufferedReader br;
    private char delimiter;
    private char quote = (char)34;
    private boolean mightNeedToSkipLF;
    private Integer maxRowChars;

    public FastRFC4180CSVParser(Reader reader, char delimiter) {
        this(reader, delimiter, null);
    }

    public FastRFC4180CSVParser(Reader reader, char delimiter, Integer maxRowChars) {
        this.delimiter = delimiter;
        this.br = new BufferedReader(reader);
        this.maxRowChars = maxRowChars;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean next(List<String> out) throws IOException {
        assert (!this.inQuotes);
        out.clear();
        int currentRowLength = 0;
        while (true) {
            if (this.bufIdx == this.bufAvailLen) {
                this.bufAvailLen = this.br.read(this.buffer, 0, this.buffer.length);
                this.bufIdx = 0;
                if (this.bufAvailLen > 0 && this.mightNeedToSkipLF && this.buffer[this.bufIdx] == '\n') {
                    ++this.bufIdx;
                }
            }
            if (this.bufAvailLen < 0) {
                if (this.inQuotes) {
                    throw new IOException("Unterminated quoted field at the end of the file");
                }
                if (this.currentField.length() > 0) {
                    out.add(this.currentField.toString());
                    this.currentField.setLength(0);
                    ++this.currentLine;
                    CSVParserUtils.checkRowLength((int)currentRowLength, (Integer)this.maxRowChars, (int)this.currentLine);
                    return true;
                }
                return false;
            }
            while (this.bufIdx < this.bufAvailLen) {
                block22: {
                    char c2;
                    block23: {
                        c2 = this.buffer[this.bufIdx];
                        if (c2 != this.quote) break block23;
                        if (!this.inQuotes) {
                            this.inQuotes = true;
                            break block22;
                        } else if (this.bufAvailLen > this.bufIdx + 1 && this.buffer[this.bufIdx + 1] == this.quote) {
                            this.currentField.append('\"');
                            ++this.bufIdx;
                            break block22;
                        } else {
                            this.inQuotes = false;
                        }
                        break block22;
                    }
                    if (c2 == this.delimiter) {
                        if (this.inQuotes) {
                            this.currentField.append(c2);
                        } else {
                            out.add(this.currentField.toString());
                            this.currentField.setLength(0);
                        }
                    } else if (c2 == '\r' || c2 == '\n') {
                        if (c2 == '\r' && this.bufAvailLen > this.bufIdx + 1 && this.buffer[this.bufIdx + 1] == '\n') {
                            ++this.bufIdx;
                        } else if (c2 == '\r' && this.bufAvailLen == this.bufIdx + 1) {
                            this.mightNeedToSkipLF = true;
                        }
                        if (!this.inQuotes) {
                            out.add(this.currentField.toString());
                            this.currentField.setLength(0);
                            ++this.bufIdx;
                            ++this.currentLine;
                            CSVParserUtils.checkRowLength((int)currentRowLength, (Integer)this.maxRowChars, (int)this.currentLine);
                            return true;
                        }
                        this.currentField.append('\n');
                    } else {
                        this.currentField.append(c2);
                    }
                }
                ++this.bufIdx;
                ++currentRowLength;
            }
            CSVParserUtils.checkRowLength((int)currentRowLength, (Integer)this.maxRowChars, (int)this.currentLine);
        }
    }
}

