/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.labeling.classification;

import com.dataiku.dip.labeling.LabelingAnswer;
import com.dataiku.dip.labeling.SimpleClassificationLabelingMetrics;
import com.dataiku.dip.labeling.VerifiedLabel;
import com.dataiku.dip.labeling.VerifiedLabelingAnswer;
import com.dataiku.dip.labeling.classification.ClassificationAnnotation;
import com.dataiku.dip.labeling.classification.SimpleClassificationScore;
import com.dataiku.dip.labeling.score.LabelingScoreComputer;
import java.util.List;
import java.util.stream.Collectors;

public class SimpleClassificationScoreComputer
extends LabelingScoreComputer<SimpleClassificationScore, SimpleClassificationLabelingMetrics> {
    @Override
    public VerifiedLabel.ClassificationVerifiedLabel computeVerifiedLabel(LabelingAnswer answer, VerifiedLabelingAnswer verifiedAnswer) {
        List<String> verifiedCategories = verifiedAnswer.label.annotations.stream().map(a -> ((ClassificationAnnotation)a).category).collect(Collectors.toList());
        return new VerifiedLabel.ClassificationVerifiedLabel(verifiedCategories);
    }

    @Override
    public SimpleClassificationScore score(LabelingAnswer answer) {
        SimpleClassificationScore ret = new SimpleClassificationScore();
        if (answer.verifiedLabel == null) {
            return ret;
        }
        VerifiedLabel.ClassificationVerifiedLabel verifiedLabel = (VerifiedLabel.ClassificationVerifiedLabel)answer.verifiedLabel;
        if (((ClassificationAnnotation)answer.label.annotations.get((int)0)).category.equals(verifiedLabel.verifiedCategories.get(0))) {
            ++ret.numCorrectAnnotations;
        } else {
            ++ret.numIncorrectAnnotations;
        }
        return ret;
    }

    @Override
    public SimpleClassificationLabelingMetrics getMetrics(SimpleClassificationScore score) {
        SimpleClassificationLabelingMetrics metrics = new SimpleClassificationLabelingMetrics();
        if (score.numCorrectAnnotations + score.numIncorrectAnnotations > 0) {
            metrics.accuracy = (double)score.numCorrectAnnotations * 1.0 / (double)(score.numCorrectAnnotations + score.numIncorrectAnnotations);
        }
        return metrics;
    }

    @Override
    public void incrementScore(SimpleClassificationScore originalScore, SimpleClassificationScore newScore) {
        originalScore.numCorrectAnnotations += newScore.numCorrectAnnotations;
        originalScore.numIncorrectAnnotations += newScore.numIncorrectAnnotations;
    }

    @Override
    public SimpleClassificationScore initScore() {
        return new SimpleClassificationScore();
    }
}

