/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.utils;

import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.streaming.endpoints.httpsse.MiniSSEEmitter;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;

public class StreamingChunkEmitter {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.utils.StreamingChunkEmitter");
    protected final MiniSSEEmitter miniSSEEmitter;

    public StreamingChunkEmitter(MiniSSEEmitter miniSSEEmitter) {
        this.miniSSEEmitter = miniSSEEmitter;
    }

    public void initSuccess() {
        this.miniSSEEmitter.initSuccess();
    }

    public void emitCompletionChunk(LLMClient.StreamedCompletionResponseChunk chunk) throws Exception {
        boolean urgent = "event".equals(chunk.type);
        this.miniSSEEmitter.sendEventWithData("completion-chunk", JSON.json((Object)chunk), urgent);
    }

    public void emitCompletionFooter(LLMClient.StreamedCompletionResponseFooter footer) throws Exception {
        this.miniSSEEmitter.sendEventWithData("completion-end", JSON.json((Object)footer), false);
    }

    public void emitEmulateStreamingInfoChunk(String message) throws Exception {
        this.miniSSEEmitter.sendEventWithData("no-streaming", message, false);
    }

    public void setInterruptCallback(AutoCloseable autoCloseable) {
        this.miniSSEEmitter.setInterruptCallback((ExceptionUtils.ThrowingRunnable<Exception>)((ExceptionUtils.ThrowingRunnable)() -> {
            logger.info((Object)"streaming interrupted");
            autoCloseable.close();
        }));
    }

    public boolean isInterrupted() {
        return this.miniSSEEmitter.isInterrupted();
    }
}

