/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.mec;

import com.dataiku.dip.analysis.ml.prediction.flow.EvaluationDatasetHelper;
import com.dataiku.dip.analysis.model.core.BaseUserMeta;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.mec.AgentModelEvaluation;
import com.dataiku.dip.mec.FullModelEvaluationId;
import com.dataiku.dip.mec.LLMModelEvaluation;
import com.dataiku.dip.mec.TabularModelEvaluation;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@PolyJSON(value={@Mapping(value=TabularModelEvaluation.class, type="tabular"), @Mapping(value=LLMModelEvaluation.class, type="llm"), @Mapping(value=AgentModelEvaluation.class, type="agent")}, defaultType="tabular")
public abstract class AbstractModelEvaluation {
    @JSON.FileTransient
    public FullModelEvaluationId ref;
    public BaseUserMeta userMeta = new BaseUserMeta();
    public long created;
    public long nbEvaluationRows = -1L;
    public DataType dataType;
    public JsonObject dataParams;
    public EvaluationDatasetHelper.EvaluationDatasetType evaluationDatasetType = EvaluationDatasetHelper.EvaluationDatasetType.CLASSIC;
    public boolean limitSampling = true;

    protected AbstractModelEvaluation() {
    }

    public <T extends EvaluatedData> T getDataParamsAs(Class<T> clazz) {
        return (T)((EvaluatedData)JSON.parse((JsonElement)this.dataParams, clazz));
    }

    public boolean isTabular() {
        return this instanceof TabularModelEvaluation;
    }

    public boolean isLLM() {
        return this instanceof LLMModelEvaluation;
    }

    public boolean isAgent() {
        return this instanceof AgentModelEvaluation;
    }

    public abstract boolean onDSSSavedModel();

    public abstract Schema getDataSchema() throws IOException;

    public void setTransientReference(FullModelEvaluationId ref) {
        this.ref = ref;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.ref.equals(((AbstractModelEvaluation)object).ref);
    }

    public int hashCode() {
        return Objects.hash(this.ref);
    }

    public Schema getDriftReferenceSchema() throws IOException {
        if (this.ref.hasDriftReference()) {
            return (Schema)JSON.parseFile((File)this.ref.getDriftReferenceSchemaFile(), Schema.class);
        }
        return null;
    }

    public static interface EvaluatedData {
    }

    public static class EvaluatedSplit
    implements EvaluatedData {
        public long generationDate;
        public String datasetName;
        public List<String> partitions = Lists.newArrayList();
    }

    public static class EvaluatedDataset
    implements EvaluatedData {
        public String ref;
        public List<String> partitions = Lists.newArrayList();
    }

    public static enum DataType {
        DATASET,
        SPLIT,
        EXTERNAL;

    }
}

