/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics;

import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.ProbesSet;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.metrics.probes.ProbeType;
import com.dataiku.dip.utils.DKULogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class MetricUtils {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.metrics");

    public static ProbesSet probesSetFromMetricIds(ProbesSet baseSet, List<String> metricIds) {
        ProbesSet probesToCompute = new ProbesSet();
        probesToCompute.engineConfig = baseSet.engineConfig;
        HashSet<String> selectedTypes = new HashSet<String>();
        for (String metricId : metricIds) {
            ProbeType type = ProbeType.getProbeType(Metric.deserializeMetric(metricId).getType());
            logger.infoV("Metric: %s -> probe: %s", new Object[]{metricId, type.type});
            if (selectedTypes.contains(type.type)) continue;
            selectedTypes.add(type.type);
            for (Probe probe : baseSet.probes) {
                if (!probe.getType().equals(type.type)) continue;
                probesToCompute.probes.add(probe);
            }
        }
        return probesToCompute;
    }

    public static class CustomMetricsSet {
        public List<String> metricIds = new ArrayList<String>();
    }
}

