/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.checks;

import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.metrics.checks.Check;
import com.dataiku.dip.metrics.checks.MetricCheck;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class MetricInValueSetCheck
extends MetricCheck {
    public static final String TYPE = "valueSet";
    public List<String> values = Lists.newArrayList();

    public MetricInValueSetCheck() {
        this.type = TYPE;
        this.meta.withName("Metric in set");
    }

    public List<String> getValues() {
        return this.values;
    }

    @Override
    public AbstractCheckContext.CheckResult run(AuthCtx authCtx, AbstractCheckContext context, MetricsComputationService.MetricsCheckRunReport runReport) throws Exception {
        ReadOnlyJobsInternalDB.MetricDataPoint metricValue = context.getCurrentValue(this.metricId);
        if (metricValue == null) {
            return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.EMPTY, "Cannot check: no value");
        }
        if (metricValue.value == null) {
            return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.EMPTY, "Cannot check: empty value");
        }
        boolean includes = Sets.newHashSet(this.values).contains(metricValue.value);
        return new AbstractCheckContext.CheckResult(includes ? AbstractCheckContext.CheckOutcome.OK : AbstractCheckContext.CheckOutcome.ERROR, includes ? metricValue.value : String.format("%s not in {%s}", metricValue.value, String.join((CharSequence)", ", this.values)));
    }

    @Override
    public Check trimForSave() {
        return this;
    }

    @Override
    public String getLegacyDatabaseId() {
        String label;
        if (this.meta != null && !StringUtils.isBlank((String)this.meta.getLabel())) {
            return this.meta.getLabel();
        }
        String string = label = this.meta != null ? this.meta.getName() : null;
        if (StringUtils.isBlank((String)label)) {
            label = this.getType();
        }
        return label + " of " + this.getMetricId();
    }
}

