/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss;

import com.dataiku.dip.pivot.backend.dss.DataTensor;
import com.dataiku.dip.pivot.backend.dss.TensorType;
import com.dataiku.dip.utils.NotImplementedException;
import java.util.Arrays;

public class DoubleDataTensor
extends DataTensor<Double> {
    public double[] tensor;
    public double[][] axes;
    public double min = Double.MAX_VALUE;
    public double max = -1.7976931348623157E308;
    protected final transient double tensorDefaultValue;

    protected DoubleDataTensor(int[] axisLengths, boolean dimension1MemorySaving, boolean initNonNullCounts, double tensorDefaultValue) {
        super(axisLengths, TensorType.NUMERICAL, dimension1MemorySaving, initNonNullCounts, Double.class);
        this.tensorDefaultValue = tensorDefaultValue;
        this.tensor = new double[this.tensorSize];
        this.initDefaultValue(this.tensor, tensorDefaultValue);
        if (!dimension1MemorySaving) {
            this.axes = new double[this.numAxes][];
            for (int i = 0; i < this.numAxes; ++i) {
                this.axes[i] = new double[axisLengths[i]];
                this.initDefaultValue(this.axes[i], tensorDefaultValue);
            }
        }
    }

    protected DoubleDataTensor(int[] axisLengths, boolean dimension1MemorySaving, boolean initNonNullCounts) {
        this(axisLengths, dimension1MemorySaving, initNonNullCounts, 0.0);
    }

    private void initDefaultValue(double[] listToInit, double defaultValue) {
        if (defaultValue != 0.0) {
            Arrays.fill(listToInit, defaultValue);
        }
    }

    public void put(int[] coordinates, double data) {
        this.tensor[this.loc((int[])coordinates)] = data;
    }

    @Override
    public Double getOrDefault(int[] coordinates, Double defaultValue) {
        int index = this.loc(coordinates);
        if (Double.isNaN(this.tensor[index])) {
            this.tensor[index] = defaultValue;
        }
        return this.tensor[index];
    }

    @Override
    public int getAxisLength(int index) {
        return this.axes[index].length;
    }

    @Override
    public void set(int location, Double data) {
        this.tensor[location] = data;
    }

    @Override
    public void set(int location, Double data, boolean inferType) {
        this.set(location, data);
    }

    @Override
    public void resize(int newCapacity) {
        this.tensor = Arrays.copyOf(this.tensor, newCapacity);
        this.tensorSize = newCapacity;
    }

    @Override
    public Double get(int location) {
        return this.tensor[location];
    }

    @Override
    public Double get(int location, boolean realType) {
        return this.tensor[location];
    }

    @Override
    public Double getAxis(int i, int j) {
        return this.axes[i][j];
    }

    @Override
    public void setAxis(int i, int j, Double value) {
        this.axes[i][j] = value;
    }

    @Override
    public void setAsDouble(int location, double value) {
        this.tensor[location] = value;
    }

    @Override
    public void setAsDouble(int[] coords, double value) {
        this.setAsDouble(this.loc(coords), value);
    }

    @Override
    public double getAsDouble(int location) {
        return this.tensor[location];
    }

    @Override
    public double getAxisAsDouble(int i, int j) {
        return this.axes[i][j];
    }

    @Override
    public double[] getAxisAsDouble(int i) {
        return this.axes[i];
    }

    @Override
    public void setAxisAsDouble(int i, int j, double value) {
        this.axes[i][j] = value;
    }

    @Override
    public double[] getDoubleTensor() {
        return this.tensor;
    }

    @Override
    public double[][] getDoubleAxes() {
        return this.axes;
    }

    @Override
    public int getAxesLength() {
        return this.axes.length;
    }

    public Double[] getTensor() {
        throw new NotImplementedException("Should call getDoubleTensor in GenericDataTensor");
    }

    @Override
    public DataTensor<Double> createMergeDT(int[] axisLengths) {
        return this.createMergeDT(axisLengths, this.hasNullValues);
    }

    @Override
    public DataTensor<Double> createMergeDT(int axisLength) {
        return this.createMergeDT(axisLength, this.hasNullValues);
    }

    @Override
    public DataTensor<Double> createMergeDT(int[] axisLengths, boolean hasNullValues) {
        DataTensor<Double> mergeDT = new Builder().axisLengths(axisLengths).initNonNullCounts(hasNullValues).defaultTensorValue(this.tensorDefaultValue).build();
        mergeDT.type = this.type;
        mergeDT.hasNullValues = hasNullValues;
        return mergeDT;
    }

    @Override
    public DataTensor<Double> createMergeDT(int axisLength, boolean hasNullValues) {
        DataTensor<Double> mergeDT = new Builder().axisLengths(axisLength).initNonNullCounts(hasNullValues).defaultTensorValue(this.tensorDefaultValue).build();
        mergeDT.type = this.type;
        mergeDT.hasNullValues = hasNullValues;
        return mergeDT;
    }

    @Override
    public void initDoubleTensor(double value) {
        Arrays.fill(this.tensor, value);
        for (int i = 0; i < this.numAxes && !this.dimension1MemorySaving; ++i) {
            Arrays.fill(this.axes[i], value);
        }
    }

    @Override
    public void replaceInvalidValues() {
        for (int i = 0; i < this.numAxes && !this.dimension1MemorySaving; ++i) {
            for (int k = 0; k < this.axes[i].length; ++k) {
                if (!Double.isInfinite(this.axes[i][k]) && !Double.isNaN(this.axes[i][k])) continue;
                this.axes[i][k] = this.type == TensorType.NUMERICAL ? 0.0 : MIN_SAFE_INTEGER;
            }
        }
        for (int k = 0; k < this.tensor.length; ++k) {
            if (!Double.isInfinite(this.tensor[k]) && !Double.isNaN(this.tensor[k])) continue;
            this.tensor[k] = this.type == TensorType.NUMERICAL ? 0.0 : MIN_SAFE_INTEGER;
        }
    }

    public static class Builder
    extends DataTensor.Builder<Double> {
        public DoubleDataTensor build() {
            if (this.defaultTensorValue == null) {
                return new DoubleDataTensor(this.axisLengths, this.dimension1MemorySaving, this.initNonNullCounts);
            }
            return new DoubleDataTensor(this.axisLengths, this.dimension1MemorySaving, this.initNonNullCounts, (Double)this.defaultTensorValue);
        }
    }
}

