/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.aggregators;

import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.dss.AxisHandler;
import com.dataiku.dip.pivot.backend.dss.DataTensor;
import com.dataiku.dip.pivot.backend.dss.LongDataList;
import com.dataiku.dip.pivot.backend.dss.aggregators.AbstractAggregator;
import com.dataiku.dip.pivot.backend.dss.aggregators.AbstractCustomAggregator;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import com.dataiku.dip.variables.VariablesContext;
import java.io.IOException;

public class SimpleCustomAggregator
extends AbstractCustomAggregator {
    public LongDataList countList;

    public SimpleCustomAggregator(Aggregation req, VariablesContext variablesContext, boolean formulaValidation, LinoReader linoReader) {
        super(req, 1, variablesContext, formulaValidation, linoReader);
    }

    public SimpleCustomAggregator(Aggregation req, int bins, VariablesContext variablesContext, LinoReader linoReader) {
        super(req, bins, variablesContext, false, linoReader);
    }

    @Override
    protected void handle(double value, int[] coords) throws IOException {
        for (AbstractAggregator aggregator : this.otherAggregators) {
            aggregator.handle(value, coords);
        }
    }

    @Override
    protected void handle(Object value, int[] coords) throws IOException {
        for (AbstractAggregator aggregator : this.otherAggregators) {
            aggregator.handle(value, coords);
        }
    }

    @Override
    public void end() throws IOException {
        super.end();
        for (AbstractAggregator otherAggregator : this.otherAggregators) {
            otherAggregator.end();
            otherAggregator.parentReference.getValueForRow = loc -> otherAggregator.getValue(loc, this.countList, true);
        }
        for (int i = 0; i < this.getOutDT().tensorSize; ++i) {
            this.getOutDT().set(i, this.doCalculation(this.expression.evaluable, i), true);
        }
    }

    @Override
    public AbstractAggregator.OtherCategoryProperties<Object> retrieveOthersCategoryProperties(AxisHandler.Axis axis) {
        AbstractAggregator.OtherCategoryProperties<Object> otherCategoryProperties = new AbstractAggregator.OtherCategoryProperties<Object>();
        this.otherAggregators.forEach(agg -> {
            agg.parentReference.getValueForRow = loc -> agg.retrieveOthersCategoryProperties((AxisHandler.Axis)axis).aggrOfOthersColumn;
        });
        otherCategoryProperties.aggrOfOthersColumn = this.doCalculation(this.expression.evaluable, 0);
        return otherCategoryProperties;
    }

    @Override
    public DataTensor<Object> mergeTensor() {
        this.otherAggregators.forEach(AbstractAggregator::mergeTensor);
        return super.mergeTensor();
    }

    @Override
    public boolean expressionNeedsFix() {
        return this.formulaValidation && this.expression.hasPlusWithNotNumeric();
    }
}

