/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.maps;

import com.dataiku.dip.data.geo.AdminGeoDataUtils;
import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.dss.LinoAxisHandler;
import com.dataiku.dip.pivot.backend.model.AxisElt;
import com.dataiku.dip.pivot.backend.model.maps.PTMapAggrAdminRequest;
import com.dataiku.dip.pivot.backend.model.maps.PTMapAggrResponse;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.NotImplementedException;
import gnu.trove.TIntCollection;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.locationtech.jts.index.strtree.STRtree;
import org.opengis.feature.simple.SimpleFeature;

public class LinoPointAdminAxisHandler
implements LinoAxisHandler {
    TIntArrayList list = new TIntArrayList();
    TIntHashSet usedSet;
    private String lonCol;
    private String latCol;
    private static Map<Integer, GeoLookup> lookupPerLevel = new HashMap<Integer, GeoLookup>();
    GeoLookup lookup;
    PTMapAggrAdminRequest req;
    GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 4326);
    int gIndex = -1;
    private double outMinLon = -180.0;
    private double outMinLat = -90.0;
    private double outMaxLon = 180.0;
    private double outMaxLat = 90.0;
    private static Logger logger = Logger.getLogger((String)"dku.charts.geo");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static GeoLookup getLookup(int level) throws Exception {
        var1_1 = LinoPointAdminAxisHandler.class;
        synchronized (LinoPointAdminAxisHandler.class) {
            ps = (IPluginsRegistryService)SpringUtils.getBean(IPluginsRegistryService.class);
            resourceFolder = ps.getPluginResourceFolder("geoadmin");
            if (LinoPointAdminAxisHandler.lookupPerLevel.get(level) != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return LinoPointAdminAxisHandler.lookupPerLevel.get(level);
            }
            LinoPointAdminAxisHandler.logger.info((Object)("Build lookup structure for level " + level));
            ret = new GeoLookup();
            ret.tree = new STRtree();
            ret.data = AdminGeoDataUtils.getData(resourceFolder, level);
            dataStore = AdminGeoDataUtils.getDataStore(resourceFolder, level);
            try {
                source = AdminGeoDataUtils.getSource(dataStore);
                index = 0;
                it = source.getFeatures().features();
lbl18:
                // 2 sources

                try {
                    while (it.hasNext()) {
                        block17: {
                            feat = (SimpleFeature)it.next();
                            rd = new GeoEntry();
                            AdminGeoDataUtils.fillLeaf(feat, rd);
                            rd.adminLevel = level;
                            rd.binIndex = index++;
                            rd.centroid = rd.geom.getCentroid();
                            ret.order.add(rd);
                            if (rd.geom == null) continue;
                            if (level != 2 || !(rd.geom instanceof MultiPolygon)) break block17;
                            mp = (MultiPolygon)rd.geom;
                            LinoPointAdminAxisHandler.logger.info((Object)("MULTI COUNTRY " + rd.dataIndex + " with " + mp.getNumGeometries() + " geoms"));
                            for (i = 0; i < mp.getNumGeometries(); ++i) {
                                ret.tree.insert(mp.getGeometryN(i).getEnvelopeInternal(), (Object)rd);
                            }
                            ** GOTO lbl18
                        }
                        ret.tree.insert(rd.geom.getEnvelopeInternal(), (Object)rd);
                    }
                }
                finally {
                    if (it != null) {
                        it.close();
                    }
                }
            }
            finally {
                if (dataStore != null) {
                    dataStore.dispose();
                }
            }
            ret.tree.build();
            LinoPointAdminAxisHandler.lookupPerLevel.put(level, ret);
            LinoPointAdminAxisHandler.logger.info((Object)("Lookup structure built size=" + ret.tree.size() + " depth= " + ret.tree.depth()));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ret;
        }
    }

    public LinoPointAdminAxisHandler(String lonCol, String latCol, PTMapAggrAdminRequest req) throws Exception {
        this.lonCol = lonCol;
        this.latCol = latCol;
        this.req = req;
        this.lookup = LinoPointAdminAxisHandler.getLookup(req.adminLevel);
    }

    @Override
    public void observe(LinoReader reader, int blockIdx, boolean[] filters) throws IOException {
        ColumnBlock lonBlock = reader.readColumnBlock(this.lonCol, blockIdx);
        ColumnBlock latBlock = reader.readColumnBlock(this.latCol, blockIdx);
        int totalMaybe = 0;
        int avoided = 0;
        int oor = 0;
        int lookups = 0;
        for (int i = 0; i < lonBlock.doubles.length; ++i) {
            if (filters != null && !filters[i]) {
                this.list.add(-1);
                continue;
            }
            double lon = lonBlock.doubles[i];
            double lat = latBlock.doubles[i];
            if (lon < this.req.minLon || lon > this.req.maxLon || lat < this.req.minLat || lat > this.req.maxLat) {
                ++oor;
                this.list.add(-1);
                continue;
            }
            Coordinate coord = new Coordinate(lon, lat);
            Point point = this.factory.createPoint(coord);
            int found = -1;
            if (!Double.isNaN(lon) && !Double.isNaN(lat)) {
                this.outMinLon = Math.max(this.outMinLon, lon);
                this.outMinLat = Math.max(this.outMinLat, lat);
                this.outMaxLon = Math.min(this.outMaxLon, lon);
                this.outMaxLat = Math.min(this.outMaxLat, lat);
                ++lookups;
                List objs = this.lookup.tree.query(point.getEnvelopeInternal());
                totalMaybe += objs.size();
                if (!(lon < -1.4) || !(lon > -1.8) || !(lat > 49.4) || lat < 50.0) {
                    // empty if block
                }
                for (Object obj : objs) {
                    GeoEntry entry = (GeoEntry)obj;
                    if (!entry.env.contains(coord)) {
                        if (!(lon < -1.4) || !(lon > -1.8) || !(lat > 49.4) || lat < 50.0) {
                            // empty if block
                        }
                        ++avoided;
                        continue;
                    }
                    try {
                        if (entry.prep == null) {
                            entry.prep = PreparedGeometryFactory.prepare((Geometry)entry.geom);
                        }
                        if (entry.prep.contains((Geometry)point)) {
                            if (!(lon < -1.4) || !(lon > -1.8) || !(lat > 49.4) || lat < 50.0) {
                                // empty if block
                            }
                            found = entry.binIndex;
                            break;
                        }
                        if (lon < -1.4 && lon > -1.8 && lat > 49.4 && !(lat < 50.0)) continue;
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Failed to intersect with " + String.valueOf(this.lookup.data.data.get(entry.dataIndex).get("localName"))), (Throwable)e);
                        found = -1;
                        break;
                    }
                }
            }
            this.list.add(found);
        }
        logger.info((Object)("Had to WITHIN " + totalMaybe + " for " + lookups + " env avoided " + avoided + " (OOR: " + oor + ")"));
    }

    @Override
    public int getNbBins() {
        this.usedSet = new TIntHashSet((TIntCollection)this.list);
        logger.info((Object)("USED " + this.usedSet.size() + " bins"));
        return this.lookup.order.size();
    }

    @Override
    public void getBins(LinoReader reader, int blockIdx, int[] ret, boolean[] filters) throws IOException {
        ColumnBlock lonBlock = reader.readColumnBlock(this.lonCol, blockIdx);
        for (int i = 0; i < lonBlock.nbRecords(); ++i) {
            ++this.gIndex;
            ret[i] = filters != null && !filters[i] ? 0 : this.list.get(this.gIndex);
        }
    }

    public List<GeoAxisElt> getGeoAxisElts() throws JSONException {
        ArrayList<GeoAxisElt> ret = new ArrayList<GeoAxisElt>();
        for (int index : this.usedSet.toArray()) {
            if (index < 0) continue;
            GeoEntry entry = this.lookup.order.get(index);
            GeoAxisElt elt = new GeoAxisElt();
            elt.binIndex = index;
            elt.dataIndex = entry.dataIndex;
            elt.geom = entry.geom;
            if (entry.adminLevel == 2 && elt.geom.getNumGeometries() > 1) {
                int maxIdx = -1;
                double maxA = 0.0;
                for (int i = 0; i < elt.geom.getNumGeometries(); ++i) {
                    double area = elt.geom.getGeometryN(i).getArea();
                    if (!(area > maxA)) continue;
                    maxIdx = i;
                    maxA = area;
                }
                elt.centroid = elt.geom.getGeometryN(maxIdx).getCentroid();
            } else {
                elt.centroid = entry.centroid;
            }
            elt.label = this.lookup.data.data.get(entry.dataIndex).get("enName").toString();
            ret.add(elt);
        }
        return ret;
    }

    public void fillBounds(PTMapAggrResponse resp) {
        resp.minLon = this.outMinLon;
        resp.maxLon = this.outMaxLon;
        resp.minLat = this.outMinLat;
        resp.maxLat = this.outMaxLat;
    }

    @Override
    public List<AxisElt> getAxisElts() {
        throw new NotImplementedException();
    }

    private static class GeoLookup {
        List<GeoEntry> order = new ArrayList<GeoEntry>();
        AdminGeoDataUtils.AdminGeoData data;
        STRtree tree;

        private GeoLookup() {
        }
    }

    private static class GeoEntry
    extends AdminGeoDataUtils.TreeLeafBase {
        int binIndex;
        int adminLevel;
        Point centroid;

        private GeoEntry() {
        }
    }

    public static class GeoAxisElt {
        public int binIndex;
        public int dataIndex;
        public Geometry geom;
        public Point centroid;
        public String label;
    }
}

