/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.builders;

import com.dataiku.dip.pivot.UnsupportedOperation;
import com.dataiku.dip.pivot.backend.common.ResponseValidator;
import com.dataiku.dip.pivot.backend.common.highcardinality.BinsAndTensorsSafetyChecks;
import com.dataiku.dip.pivot.backend.common.highcardinality.PostPruneSafetyChecks;
import com.dataiku.dip.pivot.backend.dss.DataTensor;
import com.dataiku.dip.pivot.backend.dss.GenericDataTensor;
import com.dataiku.dip.pivot.backend.dss.LongDataTensor;
import com.dataiku.dip.pivot.backend.model.AxisElt;
import com.dataiku.dip.pivot.backend.model.PivotTableAggregatedRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorResponse;
import com.dataiku.dip.pivot.backend.sql.binners.AxisBinner;
import com.dataiku.dip.pivot.backend.sql.binners.BinnerBuilder;
import com.dataiku.dip.pivot.backend.sql.binners.DoubleAxisBinner;
import com.dataiku.dip.pivot.backend.sql.binners.LongAxisBinner;
import com.dataiku.dip.pivot.backend.sql.binners.StringAxisBinner;
import com.dataiku.dip.pivot.backend.sql.builders.BasicStatsBuilder;
import com.dataiku.dip.pivot.backend.sql.builders.InMemoryResultSet;
import com.dataiku.dip.pivot.backend.sql.utils.NullableDoubleArrayList;
import com.dataiku.dip.pivot.backend.sql.utils.NullableLongArrayList;
import java.util.ArrayList;

public class SimplePivotBuilder {
    private final PivotTableTensorRequest req;
    private final BasicStatsBuilder.BasicStats stats;

    public SimplePivotBuilder(PivotTableTensorRequest req, BasicStatsBuilder.BasicStats stats) {
        this.req = req;
        this.stats = stats;
    }

    private PivotTableTensorResponse dropOtherBin(int otherBinIdx, PivotTableTensorResponse resp) {
        PivotTableTensorResponse newResp = new PivotTableTensorResponse(1, this.req);
        for (AxisElt elt : resp.axisLabels[0]) {
            if (elt.binIndex == otherBinIdx) continue;
            newResp.axisLabels[0].add(elt);
        }
        newResp.counts = new LongDataTensor(resp.counts.axisLengths[0] - 1);
        int writeIndex = 0;
        for (int readIdx = 0; readIdx < resp.counts.axisLengths[0]; ++readIdx) {
            if (readIdx == otherBinIdx) continue;
            newResp.counts.tensor[writeIndex] = resp.counts.tensor[readIdx];
            ++writeIndex;
        }
        newResp.aggregations = new ArrayList();
        for (DataTensor ddt : resp.aggregations) {
            DataTensor newDdt = new GenericDataTensor.Builder<Object>().clazz(Object.class).axisLengths(ddt.axisLengths[0] - 1).build();
            newResp.aggregations.add(newDdt);
            int writeIndex2 = 0;
            for (int readIdx = 0; readIdx < ddt.axisLengths[0]; ++readIdx) {
                if (readIdx == otherBinIdx) continue;
                newDdt.set(writeIndex2, ddt.get(readIdx, true), true);
                ++writeIndex2;
            }
        }
        newResp.afterFilterRecords = resp.afterFilterRecords;
        newResp.aggregations.forEach(DataTensor::replaceInvalidValues);
        return newResp;
    }

    public PivotTableTensorResponse parseResponse(InMemoryResultSet imrs) throws BinsAndTensorsSafetyChecks.MemoryLimitExceededException {
        PivotTableTensorResponse resp = new PivotTableTensorResponse(1, this.req);
        BinnerBuilder binnerBuilder = new BinnerBuilder(this.stats, false);
        int bins = binnerBuilder.getNbBins(this.req.axes[0], imrs.axes[0]);
        BinsAndTensorsSafetyChecks.failIfTensorWouldBeTooLargeOrTooManyBins((PivotTableAggregatedRequest)this.req, new int[]{bins}, imrs.aggregations == null ? 0L : (long)imrs.aggregations.size());
        AxisBinner binner = binnerBuilder.buildFromAxis(this.req.axes[0], imrs.axes[0]);
        resp.axisLabels[0] = binner.getAxisElts();
        PostPruneSafetyChecks.checkTensorResponse(this.req, resp);
        resp.counts = new LongDataTensor(resp.axisLabels[0].size());
        for (int i = 0; i < this.req.aggregations.size(); ++i) {
            DataTensor destTensor = new GenericDataTensor.Builder<Object>().clazz(Object.class).axisLengths(resp.axisLabels[0].size()).build();
            resp.aggregations.add(destTensor);
        }
        int[] binIndexes = new int[imrs.counts.size()];
        AxisElt otherBin = binner.getOtherBin();
        int otherBinIndex = otherBin == null ? -1 : otherBin.binIndex;
        boolean otherBinIsEmpty = true;
        if (binner instanceof LongAxisBinner) {
            LongAxisBinner longBinner = (LongAxisBinner)binner;
            data = (NullableLongArrayList)((Object)imrs.axes[0]);
            for (i = 0; i < imrs.counts.size(); ++i) {
                binIndexes[i] = binIdx = longBinner.assign(((NullableLongArrayList)((Object)data)).getNullable(i));
                otherBinIsEmpty &= binIdx != otherBinIndex;
            }
        } else if (binner instanceof StringAxisBinner) {
            StringAxisBinner stringBinner = (StringAxisBinner)binner;
            data = (ArrayList)imrs.axes[0];
            for (i = 0; i < imrs.counts.size(); ++i) {
                binIndexes[i] = binIdx = stringBinner.assign((String)((ArrayList)data).get(i));
                otherBinIsEmpty &= binIdx != otherBinIndex;
            }
        } else if (binner instanceof DoubleAxisBinner) {
            DoubleAxisBinner doubleBinner = (DoubleAxisBinner)binner;
            data = (NullableDoubleArrayList)((Object)imrs.axes[0]);
            for (i = 0; i < imrs.counts.size(); ++i) {
                binIndexes[i] = binIdx = doubleBinner.assign(((NullableDoubleArrayList)((Object)data)).getNullable(i));
                otherBinIsEmpty &= binIdx != otherBinIndex;
            }
        } else {
            throw new UnsupportedOperation("Unsupported type");
        }
        for (int i = 0; i < imrs.counts.size(); ++i) {
            int binIdx = binIndexes[i];
            resp.counts.tensor[binIdx] = imrs.counts.get(i);
            for (int j = 0; j < resp.aggregations.size(); ++j) {
                DataTensor tensor = (DataTensor)resp.aggregations.get(j);
                Object v = imrs.aggregations.get(j).get(i, true);
                if (imrs.aggregations.get((int)j).nonNullCounts != null) {
                    tensor.incrementNonNullCount(binIdx, imrs.aggregations.get((int)j).nonNullCounts[i]);
                }
                if (v == null) continue;
                tensor.set(binIdx, v, true);
            }
        }
        for (long v : resp.counts.tensor) {
            resp.afterFilterRecords += v;
        }
        if (otherBinIndex != -1 && otherBinIsEmpty) {
            return this.dropOtherBin(otherBinIndex, resp);
        }
        resp.aggregations.forEach(DataTensor::replaceInvalidValues);
        ResponseValidator.validateNonEmptyAxes(resp.counts);
        return resp;
    }
}

