/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.utils;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.pivot.backend.sql.impala.ImpalaCTASWorkaround;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.ImpalaSQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.DKULogger;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ConnectionPool
implements AutoCloseable {
    private List<PooledConnection> activeConnections = new ArrayList<PooledConnection>();
    private List<ManagedStatement> activeStatements = new ArrayList<ManagedStatement>();
    private SQLConnectionProvider.SQLConnectionData connectionData;
    private boolean closed = false;
    private ConnectionPreparation preparation;
    private boolean alwaysNew;
    private AuthCtx authCtx;
    private String projectKey;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.charts.sql.connections");

    public synchronized PooledConnection get() throws SQLException, InterruptedException {
        if (this.closed) {
            throw new SQLException("Cannot allocate a new connection, because the pool has been closed");
        }
        if (this.activeConnections.isEmpty()) {
            SQLConnectionProvider.SQLConnectionWrapper sqlConnection = null;
            try {
                sqlConnection = SQLConnectionProvider.newConnection(this.connectionData, this.authCtx, this.projectKey);
                if (this.preparation != null) {
                    this.preparation.prepare(sqlConnection);
                }
                PooledConnection pc = new PooledConnection(sqlConnection);
                logger.debug((Object)"Created new SQL connection");
                return pc;
            }
            catch (SQLException e) {
                if (sqlConnection != null) {
                    sqlConnection.close();
                }
                throw e;
            }
            catch (DKUSecurityException e) {
                throw new SQLException("Unable to get connection", e);
            }
        }
        logger.debug((Object)"Reused SQL connection");
        return this.activeConnections.remove(0);
    }

    public ConnectionPool(SQLConnectionProvider.SQLConnectionData data, ConnectionPreparation preparation, boolean alwaysNew, AuthCtx authCtx, String projectKey) {
        this.connectionData = data;
        this.authCtx = authCtx;
        this.preparation = preparation;
        this.projectKey = projectKey;
        this.alwaysNew = alwaysNew;
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        int cancelled = 0;
        int cancelFailed = 0;
        while (!this.activeStatements.isEmpty()) {
            ManagedStatement stmt = this.activeStatements.get(0);
            if (stmt.cancel()) {
                ++cancelled;
                continue;
            }
            ++cancelFailed;
        }
        if (cancelled > 0) {
            logger.debug((Object)("Aborted " + cancelled + " active SQL statement(s)"));
        }
        if (cancelFailed > 0) {
            logger.error((Object)("Failed to cancel " + cancelled + " SQL statement(s)"));
        }
        int closedCount = 0;
        for (PooledConnection pc : this.activeConnections) {
            try {
                pc.sqlConnection.close();
                ++closedCount;
            }
            catch (SQLException e) {
                logger.error((Object)"Error occurred when closing SQL connection", (Throwable)e);
            }
        }
        logger.debug((Object)("Closed " + closedCount + " SQL connection(s)"));
        this.activeConnections.clear();
    }

    public static interface ConnectionPreparation {
        public void prepare(SQLConnectionProvider.SQLConnectionWrapper var1) throws SQLException;
    }

    public class PooledConnection
    implements AutoCloseable {
        private SQLConnectionProvider.SQLConnectionWrapper sqlConnection;

        public SQLConnectionProvider.SQLConnectionWrapper getSqlConnection() {
            return this.sqlConnection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            ConnectionPool connectionPool = ConnectionPool.this;
            synchronized (connectionPool) {
                if (this.sqlConnection != null) {
                    if (ConnectionPool.this.closed || ConnectionPool.this.alwaysNew) {
                        try {
                            logger.debug((Object)"Closed 1 SQL connection");
                            this.sqlConnection.close();
                        }
                        catch (SQLException e) {
                            logger.error((Object)"Error occurred when closing SQL connection", (Throwable)e);
                        }
                    } else {
                        ConnectionPool.this.activeConnections.add(this);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ManagedStatement getStatement() throws SQLException {
            ConnectionPool connectionPool = ConnectionPool.this;
            synchronized (connectionPool) {
                if (ConnectionPool.this.closed) {
                    throw new SQLException("Cannot create SQL statement, the pool has been closed");
                }
                ManagedStatement mstmt = new ManagedStatement(SQLUtils.getProperlyStreamableStatement(ConnectionPool.this.connectionData, this.sqlConnection));
                ConnectionPool.this.activeStatements.add(mstmt);
                return mstmt;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ManagedPreparedStatement getPreparedStatement(String sql) throws SQLException {
            ConnectionPool connectionPool = ConnectionPool.this;
            synchronized (connectionPool) {
                if (ConnectionPool.this.closed) {
                    throw new SQLException("Cannot create SQL statement, the pool has been closed");
                }
                ManagedPreparedStatement mstmt = new ManagedPreparedStatement(SQLUtils.getProperlyStreamablePreparedStatement(ConnectionPool.this.connectionData, this.sqlConnection, sql));
                ConnectionPool.this.activeStatements.add(mstmt);
                return mstmt;
            }
        }

        public PooledConnection(SQLConnectionProvider.SQLConnectionWrapper sqlConnection) {
            this.sqlConnection = sqlConnection;
        }
    }

    public class ManagedStatement
    implements AutoCloseable {
        private Statement sqlStatement;

        public ManagedStatement(Statement sqlStatement) {
            this.sqlStatement = sqlStatement;
        }

        public Statement get() {
            return this.sqlStatement;
        }

        public void executeCTAS(String query) throws SQLException, InterruptedException {
            this.sqlStatement.execute(query);
            if (ConnectionPool.this.connectionData.getDialect() instanceof ImpalaSQLDialect) {
                try {
                    ImpalaCTASWorkaround.waitForCTAS(this.sqlStatement);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to workaround Impala / JDBC driver CTAS issue", (Throwable)e);
                }
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("Thread: " + Thread.currentThread().getName() + " got interrupted when executing: " + query);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel() {
            ConnectionPool connectionPool = ConnectionPool.this;
            synchronized (connectionPool) {
                if (this.sqlStatement != null) {
                    try {
                        if (!ImpalaCTASWorkaround.isHiveStatementLessThan013(this.sqlStatement)) {
                            this.sqlStatement.cancel();
                        } else {
                            logger.info((Object)"Statement has NOT been cancelled because HiveStatement.cancel() is buggy in Hive < 0.13");
                        }
                    }
                    catch (SQLException e) {
                        logger.error((Object)"Error occurred when cancelling SQL statement", (Throwable)e);
                    }
                    finally {
                        this.close();
                    }
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            ConnectionPool connectionPool = ConnectionPool.this;
            synchronized (connectionPool) {
                if (this.sqlStatement != null) {
                    ConnectionPool.this.activeStatements.remove(this);
                    try {
                        if (!ImpalaCTASWorkaround.isHiveStatementLessThan013(this.sqlStatement)) {
                            this.sqlStatement.close();
                        } else {
                            logger.info((Object)"Statement has NOT been closed because HiveStatement.close() is buggy in Hive < 0.13");
                        }
                    }
                    catch (SQLException e) {
                        logger.error((Object)"Error occurred when closing SQL statement", (Throwable)e);
                    }
                }
                this.sqlStatement = null;
            }
        }
    }

    public class ManagedPreparedStatement
    extends ManagedStatement {
        public ManagedPreparedStatement(PreparedStatement sqlStatement) {
            super(sqlStatement);
        }

        @Override
        public PreparedStatement get() {
            return (PreparedStatement)super.get();
        }
    }

    public static class SynapsePreparation
    extends InitQueriesPreparation {
        public SynapsePreparation(String[] initQueries) {
            super(initQueries);
        }

        @Override
        public void prepare(SQLConnectionProvider.SQLConnectionWrapper sqlConnection) throws SQLException {
            sqlConnection.setAutoCommit(true);
            try {
                SQLUtils.safeExec(sqlConnection, "ROLLBACK TRANSACTION");
            }
            catch (Exception e) {
                if (StringUtils.defaultIfEmpty((String)e.getMessage(), (String)"").contains("No corresponding transaction found")) {
                    logger.warn((Object)"No transaction to rollback");
                }
                throw e;
            }
            super.prepare(sqlConnection);
        }
    }

    public static class InitQueriesPreparation
    implements ConnectionPreparation {
        private final String[] initQueries;

        public InitQueriesPreparation(String[] initQueries) {
            this.initQueries = initQueries != null ? initQueries : new String[]{};
        }

        @Override
        public void prepare(SQLConnectionProvider.SQLConnectionWrapper sqlConnection) throws SQLException {
            for (String sql : this.initQueries) {
                if (StringUtils.isBlank((String)sql)) continue;
                try (Statement stmt = sqlConnection.createStatement();){
                    logger.debug((Object)("Running session initialization query: " + sql));
                    stmt.execute(sql);
                    logger.debug((Object)"Statement done");
                }
            }
        }
    }
}

