/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.queries;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.queries.QueryParams;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.queries.SQLQueryRuntime;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.DKULogger;
import java.sql.SQLException;

public class LimitedTo200QueryExecutor {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.sql.queryexecutor");

    public static QueryRunResult queryTableSample(SQLDialect dialect, String connection, String catalog, String schema, String table, int limit, AuthCtx authCtx, String projectKey) throws Exception {
        SelectQueryBuilder qb = new SelectQueryBuilder();
        qb.from(catalog, schema, table, null);
        return LimitedTo200QueryExecutor.executeQuery(connection, qb.limit(Long.valueOf(limit)).toSQL(dialect), authCtx, projectKey);
    }

    public static QueryRunResult executeQuery(String connectionName, String sql, AuthCtx authCtx, String projectKey) throws Exception {
        QueryRunResult res = null;
        QueryParams qp = new QueryParams();
        qp.connection = connectionName;
        qp.sql = sql;
        SQLConnectionProvider.SQLConnectionData connData = SQLConnectionProvider.getConnectionData_NT(authCtx, projectKey, connectionName);
        final SQLQueryRuntime sqr = new SQLQueryRuntime(qp, null, connData, authCtx, projectKey);
        try (FutureAborter.AutoCloseableAbortHook aborter = FutureAborter.pushAutoCloseableHook((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    sqr.cancel();
                }
                catch (SQLException e) {
                    logger.error((Object)"Failed to cancel a query", (Throwable)e);
                }
            }
        });){
            sqr.init(0);
            res = sqr.getPage(0, 200, null);
            if (!res.success) {
                throw new RuntimeException(res.errorMessage);
            }
        }
        catch (Exception t) {
            logger.warn((Object)"Query failed", (Throwable)t);
            throw t;
        }
        finally {
            sqr.close(false, false);
        }
        logger.info((Object)("Query done totalRows=" + res.totalRows));
        return res;
    }
}

