/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda.stats;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.eda.compute.computations.AvailableResult;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.univariate.LeveneTestNSamp;
import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.eda.compute.grouping.GroupingResult;
import com.dataiku.dip.eda.compute.stats.LeveneCenter;
import com.dataiku.dip.recipes.eda.StatsTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.AbstractNSampleTestStat;
import com.dataiku.dip.recipes.eda.stats.AbstractTestStat;
import com.dataiku.dip.utils.JSON;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nullable;

public class NSampleLeveneTestStat
extends AbstractNSampleTestStat {
    private static final String N_SAMPLE_LEVENE_TEST = "LEVENE_TEST_N_SAMPLE";
    public LeveneCenter center = LeveneCenter.MEDIAN;
    @Nullable
    public Double proportionToTrim;

    public NSampleLeveneTestStat(String testColumn, String groupByColumn, @Nullable List<String> groupValues, int maxPopulations, LeveneCenter center, @Nullable Double proportionToTrim) {
        super(testColumn, groupByColumn, groupValues, maxPopulations);
        this.center = center;
        this.proportionToTrim = proportionToTrim;
    }

    public NSampleLeveneTestStat() {
    }

    @Override
    protected void fillTestParams(Row row, ColumnFactory cf) {
        super.fillTestParams(row, cf);
        row.put(cf.column("test"), N_SAMPLE_LEVENE_TEST);
        AbstractTestStat.LeveneCenterSettings leveneCenterSettings = new AbstractTestStat.LeveneCenterSettings(this.center, this.proportionToTrim);
        row.put(cf.column("center_settings"), JSON.json((Object)leveneCenterSettings));
    }

    @Override
    protected Computation getTestComputation(StatsTestRecipePayloadParams<?> payloadParams) {
        return new LeveneTestNSamp(this.testColumn, this.getPopulationGrouping(), this.center, this.proportionToTrim);
    }

    @Override
    protected void fillTestResult(AvailableResult result, double significanceLevel, ColumnFactory cf, Row row) {
        LeveneTestNSamp.LeveneTestNSampResult tr = result.as(LeveneTestNSamp.LeveneTestNSampResult.class);
        this.fillLeveneCenters(tr.groups, tr.centers, row, cf);
        double pValue = tr.pvalue;
        String conclusion = NSampleLeveneTestStat.conclusion(pValue, significanceLevel);
        row.put(cf.column("f_statistic"), tr.statistic);
        row.put(cf.column("p_value"), pValue);
        row.put(cf.column("conclusion"), conclusion);
    }

    private void fillLeveneCenters(GroupingResult groups, double[] centers, Row row, ColumnFactory cf) {
        LinkedHashMap<String, Double> leveneCenterValues = new LinkedHashMap<String, Double>();
        List<Filter> filters = groups.listFilters();
        int nGroups = filters.size();
        if (centers.length != nGroups) {
            throw new IllegalArgumentException(String.format("Expected as many center values as groups, got %d center values and %d groups", centers.length, nGroups));
        }
        for (int i = 0; i < nGroups; ++i) {
            List<String> values = NSampleLeveneTestStat.extractPopulationValues(filters.get(i));
            if (values.size() != 1) {
                throw new IllegalArgumentException(String.format("Expected exactly 1 modality, got %d", values.size()));
            }
            String modality = values.get(0);
            leveneCenterValues.put(modality, centers[i]);
        }
        if (!leveneCenterValues.isEmpty()) {
            row.put(cf.column("center_values"), JSON.json(leveneCenterValues));
        }
    }
}

