/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.extract_content;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.recipes.FakeJobActivityFromRecipeBuilder;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.DocExtractionRecipesParams;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.DocExtractionRecipesStatusComputerBase;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.DocExtractionRule;
import com.dataiku.dip.recipes.nlp.extract_content.ExtractContentRecipePayloadParams;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import java.util.List;
import java.util.Optional;

public class ExtractContentRecipeStatusComputer
extends DocExtractionRecipesStatusComputerBase {
    public ExtractContentRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
    }

    @Override
    protected boolean isOutputFolderRequired(DocExtractionRecipesParams params, List<DocExtractionRule> allCustomRules) {
        ExtractContentRecipePayloadParams desc = (ExtractContentRecipePayloadParams)JSON.parse((String)this.payload, ExtractContentRecipePayloadParams.class);
        if (params.extractionMode == DocExtractionRecipesParams.ExtractionMode.MANAGED_VISUAL_ONLY) {
            return desc.storeScreenshots;
        }
        if (params.extractionMode == DocExtractionRecipesParams.ExtractionMode.MANAGED_TEXT_ONLY) {
            return desc.storeImages;
        }
        return allCustomRules.stream().anyMatch(rule -> rule.actionToPerform.equals((Object)DocExtractionRule.ActionToPerform.VLM) && desc.storeScreenshots || rule.actionToPerform.equals((Object)DocExtractionRule.ActionToPerform.STRUCTURED) && desc.storeImages);
    }

    @Override
    public RecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            JobActivity activity;
            FlowDataset flowDataset;
            Dataset dataset;
            DocExtractionRecipesStatusComputerBase.DocExtractionRecipesStatus status = (DocExtractionRecipesStatusComputerBase.DocExtractionRecipesStatus)this.fastStatusIgnorePartitions(authCtx);
            this.fillDocExtractionCommonStatus(status, authCtx);
            Optional datasetOutput = this.recipe.getOutputsForRole("main").stream().findFirst();
            if (datasetOutput.isPresent() && (dataset = (flowDataset = (activity = new FakeJobActivityFromRecipeBuilder().buildFakeJobActivity(this.recipe)).getSubgraph().getSingleTargetDataset()).getMandatory(this.datasetsDAO)).getPartitioningSchema().isPartitioned()) {
                status.output.withFatal(RecipeCodes.ERR_RECIPE_GENERIC_ERROR, String.format("Dataset %s is partitioned. This is not supported for the extract content recipe", dataset.getFullName()));
            }
            DocExtractionRecipesStatusComputerBase.DocExtractionRecipesStatus docExtractionRecipesStatus = status;
            return docExtractionRecipesStatus;
        }
    }
}

