/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler;

import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.io.KernelUtils;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.ImpersonationResolverService;
import com.dataiku.dip.security.process.InsecureProcessesLaunchService;
import com.dataiku.dip.security.process.IsolableProcess;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.springframework.beans.factory.annotation.Autowired;

public class TicketBasedCustomPythonRunner {
    private final APITicketService apiTicketService;
    private final InsecureProcessesLaunchService insecureProcessesLaunchService;
    @Autowired
    private CodeEnvResolutionService codeEnvResolutionService;
    @Autowired
    private ImpersonationResolverService impersonationResolverService;
    private final String ticketLabel;
    private final Object initiator;
    private final AuthCtx user;
    private final File runFolder;
    private final Map<String, String> additionalLibPython = Maps.newHashMap();
    private final boolean outputToLogger;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.custompython");

    public TicketBasedCustomPythonRunner(APITicketService apiTicketService, InsecureProcessesLaunchService insecureProcessesLaunchService, String ticketLabel, AuthCtx user, File runFolder, Object initiator, boolean outputToLogger) {
        this.apiTicketService = apiTicketService;
        this.insecureProcessesLaunchService = insecureProcessesLaunchService;
        this.ticketLabel = ticketLabel;
        this.user = user;
        this.runFolder = runFolder;
        this.initiator = initiator;
        this.outputToLogger = outputToLogger;
        SpringUtils.getInstance().autowire((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String code, Map<String, String> extraEnv, Map<String, String> fileBasedEnv, String projectKey, String pluginId, CodeEnvSelection envSelection, ReportItem reportItem, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType) throws Exception {
        logger.info((Object)"Start custom python");
        final APITicketService.Ticket ticket = this.apiTicketService.createTicket(this.user, this.ticketLabel, this.initiator);
        File tmpDir = this.runFolder;
        try (FutureAborter.AutoCloseableAbortHook aborter = FutureAborter.pushAutoCloseableHook((Runnable)new Runnable(){

            @Override
            public void run() {
                TicketBasedCustomPythonRunner.this.apiTicketService.abortFutureUsingTicket(ticket);
            }
        });){
            File scriptFile = new File(tmpDir, "script.py");
            logger.info((Object)("Dumping Python script to " + String.valueOf(scriptFile)));
            DKUFileUtils.writeFileUTF8((File)scriptFile, (String)StringUtils.defaultIfBlank((String)code, (String)""));
            CodeEnvSelector envSelector = new CodeEnvSelector();
            String envName = StringUtils.isNotBlank((String)pluginId) ? envSelector.selectForCustomPythonRecipe(pluginId) : envSelector.selectForPythonRecipe(projectKey, envSelection);
            List<String> cmd = this.getCmd(projectKey, envName, scriptFile);
            ProcessBuilder builder = this.prepareBuilder(cmd, tmpDir, ticket.getSecret(), projectKey);
            builder.environment().putAll(this.codeEnvResolutionService.getEnvironmentVariablesForPythonCmd(envName, projectKey));
            for (Map.Entry<String, String> e : extraEnv.entrySet()) {
                builder.environment().put(e.getKey(), e.getValue());
            }
            for (Map.Entry<String, String> e : fileBasedEnv.entrySet()) {
                File tmpFile = new File(tmpDir, SecretKeyGenerator.generate((int)8) + ".json");
                DKUFileUtils.writeFileUTF8((File)tmpFile, (String)e.getValue());
                builder.environment().put(e.getKey(), tmpFile.getAbsolutePath());
            }
            this.execute(builder, cgrouppableProcessType, tmpDir, reportItem, projectKey);
        }
        finally {
            this.apiTicketService.expireTicket(ticket);
            FutureProgressState.checkInterrupt();
        }
        logger.info((Object)"Done custom python");
    }

    private void execute(ProcessBuilder builder, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType, File tmpDir, ReportItem reportItem, String projectKey) throws Exception {
        long started = DateTime.now().getMillis();
        final IsolableProcess p = this.insecureProcessesLaunchService.launch(this.user, projectKey, cgrouppableProcessType, tmpDir, builder);
        reportItem.withStart(started);
        try (FutureAborter.AutoCloseableAbortHook aborter = FutureAborter.pushAutoCloseableHook((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    p.niceThenEvilKill();
                }
                catch (IOException e) {
                    logger.error((Object)"Failed to stop python scenario/step/trigger", (Throwable)e);
                }
            }
        });){
            File tmpLogData = new File(tmpDir, "script.log");
            tmpLogData = DKUFileUtils.getWithAutoDecompress((File)tmpLogData);
            try (FileOutputStream tmpLogStream = new FileOutputStream(tmpLogData);){
                DKUtils.LineOrientedThreadSafeCopyStreamEaterWithLogging errLogger;
                DKUtils.LineOrientedThreadSafeCopyStreamEaterWithLogging outLogger;
                if (this.outputToLogger) {
                    outLogger = new DKUtils.LineOrientedThreadSafeCopyStreamEaterWithLogging(p.getInputStream(), (OutputStream)tmpLogStream);
                    errLogger = new DKUtils.LineOrientedThreadSafeCopyStreamEaterWithLogging(p.getErrorStream(), (OutputStream)tmpLogStream);
                } else {
                    DKUtils.SendToAppenderLineSubscription logToScenarioFiles = new DKUtils.SendToAppenderLineSubscription(((ScenarioRunContext)SpringUtils.getBean(ScenarioRunContext.class)).getLogAppender(), Level.INFO, "process");
                    outLogger = new DKUtils.LineOrientedThreadSafeCopyStreamEaterWithSubscription(p.getInputStream(), (OutputStream)tmpLogStream, (DKUtils.LineSubscription)logToScenarioFiles);
                    errLogger = new DKUtils.LineOrientedThreadSafeCopyStreamEaterWithSubscription(p.getErrorStream(), (OutputStream)tmpLogStream, (DKUtils.LineSubscription)logToScenarioFiles);
                }
                outLogger.start();
                errLogger.start();
                int rv = p.waitFor();
                outLogger.join();
                errLogger.join();
                if (rv != 0) {
                    SmartLogTail smartLogTail = new SmartLogTail();
                    String log = DKUtils.tailFile((File)tmpLogData, (int)100);
                    if (!StringUtils.isBlank((String)log)) {
                        smartLogTail.lines.addAll(Arrays.asList(log.split("\n")));
                    }
                    reportItem.withLogTail(smartLogTail).withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED);
                } else {
                    reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.SUCCESS);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            reportItem.withThrown(e).withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.ABORTED);
        }
        catch (Throwable e) {
            reportItem.withThrown(e).withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED);
            throw e;
        }
    }

    private ProcessBuilder prepareBuilder(List<String> command, File tmpDir, String secret, String projectKey) throws IOException, DKUSecurityException {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(tmpDir);
        builder.environment().put("DKU_API_TICKET", secret);
        LinkedHashMap pythonLibs = Maps.newLinkedHashMap();
        pythonLibs.putAll(this.additionalLibPython);
        boolean impersonated = this.impersonationResolverService != null && this.impersonationResolverService.isEnabled();
        KernelUtils.handlePythonAndRPath(this.user, projectKey, true, pythonLibs, tmpDir, impersonated, builder);
        builder.command(command);
        return builder;
    }

    private List<String> getCmd(String projectKey, String envName, File scriptFile) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        args.add(scriptFile.getAbsolutePath());
        return this.getPythonCmd(projectKey, envName, args);
    }

    protected List<String> getPythonCmd(String projectKey, String envName, List<String> args) throws IOException {
        return this.codeEnvResolutionService.getPythonCmd(envName, projectKey, args);
    }

    public void addPythonLib(String libName, String libFolder) {
        this.additionalLibPython.put(libName, libFolder);
    }
}

