/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.scenarios.postactions;

import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.scheduler.scenarios.postactions.PostScenarioAction;
import com.dataiku.dip.server.services.ProjectsUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Params;
import java.io.File;

public class CompressLocalconfig
extends PostScenarioAction {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.scenarios.postactions.localconfig");

    public CompressLocalconfig(ScenarioRun scenarioRun) {
        super(scenarioRun);
    }

    @Override
    public void run() throws Exception {
        logger.debug((Object)("Executing scenario post-action " + this.getClass().getSimpleName()));
        Params p = ProjectsUtils.getProjectDKUPropertiesAsParamsWithSystemOverrideEvenIfProjectDoesNotExist_AutoTXN(this.projectKey);
        File scenarioFolder = ScenarioRunContext.scenarioRunFolder(this.projectKey, this.scenarioId, this.scenarioRunId);
        File localconfigFolder = new File(scenarioFolder, FlowJobUtils.LOCALCONFIG_FOLDER_NAME);
        if (!localconfigFolder.isDirectory()) {
            logger.info((Object)"No localconfig folder to compress, skipping");
            return;
        }
        if (p.getBoolParam("dku.scenarios.postActions.compressLocalConfig.enabled", true)) {
            long minSizeForCompressionKB = p.getLongParam("dku.scenarios.postActions.compressLocalConfig.minSizeForCompressionKB", 2000L);
            try {
                ZipUnzipDir.zipDirectoryIfLargerThanSize(localconfigFolder, minSizeForCompressionKB);
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to zip scenario localconfig folder", (Throwable)e);
            }
        } else {
            logger.info((Object)"Not compressing scenario localconfig (requested by project property)");
        }
    }
}

