/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.custom.IPluginifiedHolderMeta;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.runnables.DSSRunnableResult;
import com.dataiku.dip.scheduler.runnables.DSSRunnablesService;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepMetaWithPluginifiedHolder;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DSSRunnableStepRunner
implements StepRunner {
    public static final StepMeta META = new StepMetaWithPluginifiedHolder(){

        @Override
        public Class<? extends StepParams> paramsClass() {
            return DSSRunnableStepParams.class;
        }

        @Override
        public String getType() {
            return "runnable";
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new DSSRunnableStepRunner(step, step.getParamsAs(DSSRunnableStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            return "Execute macro";
        }

        @Override
        public String buildId(Step step) {
            DSSRunnableStepParams params = step.getParamsAs(DSSRunnableStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("runmacro");
            if (params != null && StringUtils.isNotBlank((String)params.runnableType)) {
                sb.append("_");
                sb.append(params.runnableType);
            }
            return sb.toString();
        }

        @Override
        public List<IPluginifiedHolderMeta.Pluginifiable> getPluginifiables(Object object, String payload) {
            ArrayList components = Lists.newArrayList();
            Step currentStep = null;
            if (object instanceof IPluginifiedHolderMeta.Pluginifiable) {
                currentStep = (Step)((IPluginifiedHolderMeta.Pluginifiable)object).object;
            } else if (object instanceof Step) {
                currentStep = (Step)object;
            }
            if (null != currentStep) {
                DSSRunnableStepParams stepParams = currentStep.getParamsAs(DSSRunnableStepParams.class);
                components.add(new IPluginifiedHolderMeta.Pluginifiable("macro", stepParams.runnableType, stepParams.config));
            }
            return components;
        }
    };
    @Autowired
    private DSSRunnablesService dssRunnablesService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private FutureService futureService;
    private final Step step;
    private final DSSRunnableStepParams params;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.runnable");

    public DSSRunnableStepRunner(Step step, DSSRunnableStepParams params) {
        this.step = step;
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        FutureResponse<DSSRunnableResult> fr;
        long started;
        String projectKey;
        block16: {
            logger.info((Object)("Start step " + this.step.getName()));
            DSSAuthCtx authCtx = stepRun.getScenarioRun().getRunAsUser();
            projectKey = stepRun.getScenarioRun().getScenario().getProjectKey();
            String scenarioId = stepRun.getScenarioRun().getScenario().getId();
            String runId = stepRun.getScenarioRun().getRunId();
            File contextDir = DKUFileUtils.getWithin((File)ScenarioRunContext.scenarioRunFolder(projectKey, scenarioId, runId), (String[])new String[]{this.step.getName()});
            try (Transaction t = this.transactionService.beginRead();){
                if (!this.dssRunnablesService.canRun(this.params.runnableType, (AuthCtx)authCtx, projectKey)) {
                    stepReportItem.withOutcome(ReportItem.Outcome.FAILED).withThrown(new DKUSecurityException("Insufficient rights to run macro"));
                    started = 0L;
                    fr = null;
                    break block16;
                }
                started = DateTime.now().getMillis();
                CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ComputeResourceUsageContext.forMacro((AuthCtx)authCtx, (String)this.params.runnableType, (String)projectKey, (String)scenarioId, null, null));
                try {
                    fr = this.dssRunnablesService.run(this.params.runnableType, authCtx, projectKey, this.params.config, this.params.adminConfig, contextDir);
                }
                finally {
                    CurrentComputeResourceUsageContext.clear();
                }
            }
        }
        if (fr != null) {
            fr = this.futureService.waitForFinalResponse(fr);
            DSSRunnableResult result = (DSSRunnableResult)fr.result;
            long ended = DateTime.now().getMillis();
            if (result.error != null) {
                stepReportItem.withOutcome(ReportItem.Outcome.FAILED).withThrown(result.error);
            } else if (result.failure != null) {
                stepReportItem.withOutcome(ReportItem.Outcome.FAILED).withThrown(result.failure).withLogTail(result.logTail);
            } else {
                if (result.type != null && result.data != null) {
                    ReportItem.ProducedByRunnable produced = new ReportItem.ProducedByRunnable(result.data).withResultType(result.type).withResultLabel(result.label);
                    produced.withOutcome(ReportItem.Outcome.SUCCESS).withStart(started).withEnd(ended);
                    this.jobsDatabaseService.tryRegisterFlowObjectEvent(new AnyLoc(projectKey, this.params.runnableType), null, null, stepRun.getScenarioRun(), stepRun, produced);
                }
                stepReportItem.withOutcome(ReportItem.Outcome.SUCCESS);
            }
        }
        logger.info((Object)("Done step " + this.step.name));
    }

    public static class DSSRunnableStepParams
    extends NonFatalStepParams
    implements StepParams {
        public String runnableType;
        public JsonObject config;
        public JsonObject adminConfig;
    }
}

