/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.recipes.ParamsWithSelectableCodeEnv;
import com.dataiku.dip.scheduler.TicketBasedCustomPythonRunner;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepMetaWithSelectableCodeEnv;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.security.impersonation.IImpersonationResolverService;
import com.dataiku.dip.security.process.InsecureProcessesLaunchService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.com.google.common.collect.Maps;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class PytestStepRunner
implements StepRunner {
    @Autowired
    private APITicketService apiTicketService;
    @Autowired
    private InsecureProcessesLaunchService insecureProcessesLaunchService;
    @Autowired
    private IImpersonationResolverService impersonationResolverService;
    @Autowired
    private ReadWriteJobsInternalDB readWriteJobsInternalDB;
    private final Step step;
    private final PytestStepParams params;
    public static final StepMeta META = new StepMetaWithSelectableCodeEnv(){
        public static final String EXEC_PYTEST = "exec_pytest";

        @Override
        public String getType() {
            return EXEC_PYTEST;
        }

        @Override
        public Class<? extends StepParams> paramsClass() {
            return PytestStepParams.class;
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new PytestStepRunner(step, step.getParamsAs(PytestStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            return EXEC_PYTEST;
        }

        @Override
        public String buildId(Step step) {
            PytestStepParams stepParams = step.getParamsAs(PytestStepParams.class);
            StringBuilder sb = new StringBuilder(EXEC_PYTEST);
            if (stepParams != null && StringUtils.isNotBlank((String)stepParams.testsSelector)) {
                sb.append("_").append(DKUtils.md5Base64((String)stepParams.testsSelector));
            }
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario scenario, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }

        @Override
        public CodeEnvModel.EnvLang getEnvLang() {
            return CodeEnvModel.EnvLang.PYTHON;
        }
    };
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.pytestStepRunner");

    public PytestStepRunner(Step step, PytestStepParams params) {
        this.step = step;
        this.params = params;
    }

    private String getPytestScript(String projectKey, File stepRunFolder, File reportFile) {
        ArrayList<String> pytestArgs = new ArrayList<String>();
        if (!StringUtils.isBlank((String)this.params.testsSelector)) {
            pytestArgs.add(this.params.testsSelector);
        }
        pytestArgs.add("-s");
        pytestArgs.add("--junitxml");
        pytestArgs.add(reportFile.getAbsolutePath());
        pytestArgs.add("--log-level");
        pytestArgs.add(this.params.logLevel.toString());
        pytestArgs.replaceAll(arg -> String.format("'%s'", arg));
        File projectLibFolder = this.impersonationResolverService.isEnabled() ? DKUFileUtils.getWithin((File)stepRunFolder, (String[])new String[]{"project-python-libs", projectKey}) : DKUApp.getFile((String[])new String[]{"config", "projects", projectKey, "lib"});
        return String.format("import os\nimport sys\nimport pytest\n\ndef main():\n    os.chdir('%s')\n    retcode = pytest.main([%s])\n    if retcode == 5:\n        print(\"WARNING : Pytest step failed because no tests were collected.\")\n    sys.exit(retcode)\n\nif __name__ == \"__main__\":\n    main()\n", projectLibFolder.getAbsolutePath(), String.join((CharSequence)", ", pytestArgs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        logger.infoV("Start step %s", new Object[]{this.step.getName()});
        Scenario scenario = stepRun.getScenarioRun().getScenario();
        File runFolder = ScenarioRunContext.scenarioRunFolder(scenario.getProjectKey(), scenario.getId(), stepRun.getScenarioRun().getRunId());
        File stepRunFolder = DKUFileUtils.getWithin((File)runFolder, (String[])new String[]{"pytest-step-" + this.step.getName()});
        DKUFileUtils.mkdirs((File)stepRunFolder);
        TicketBasedCustomPythonRunner pythonRunner = new TicketBasedCustomPythonRunner(this.apiTicketService, this.insecureProcessesLaunchService, String.format("scenario_pytest_step:%s.%s", scenario.getProjectKey(), scenario.getId()), stepRun.getScenarioRun().getRunAsUser(), stepRunFolder, stepRun, false);
        HashMap extraEnv = Maps.newHashMap();
        HashMap fileBasedEnv = Maps.newHashMap();
        extraEnv.put("DKU_CURRENT_PROJECT_KEY", scenario.getProjectKey());
        if (stepRun.getScenarioRun().getTrigger() != null) {
            fileBasedEnv.put("DKU_CURRENT_SCENARIO_TRIGGER_FILE", JSON.json((Object)stepRun.getScenarioRun().getTrigger()));
        }
        ReportTargetItem.PythonUnitTestItem target = new ReportTargetItem.PythonUnitTestItem(this.params.testsSelector);
        ReportItem.RanPythonUnitTest ranPythonUnitTest = new ReportItem.RanPythonUnitTest(target);
        long started = DateTime.now().getMillis();
        try (AutoDelete tmpDir = DSSTempUtils.getTempFolder((String)"test-reports");){
            FilesystemACLUtils.grantFSFullACLs((AuthCtx)stepRun.getScenarioRun().getRunAsUser(), scenario.getProjectKey(), new File[]{tmpDir});
            File tmpReportFile = File.createTempFile("step-run-report", ".xml", (File)tmpDir);
            pythonRunner.run(this.getPytestScript(scenario.getProjectKey(), stepRunFolder, tmpReportFile), extraEnv, fileBasedEnv, scenario.getProjectKey(), null, this.params.envSelection, stepReportItem, GeneralSettingsDAO.CGrouppableProcessType.PYTHON_SCENARIO);
            ranPythonUnitTest.withRunReport(DKUFileUtils.readFileToStringUTF8((File)tmpReportFile)).withStart(stepReportItem.getStart()).withEnd(stepReportItem.getEnd()).withOutcome(stepReportItem.getOutcome());
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Error while running test %s", new Object[]{this.step.getName()});
            ranPythonUnitTest.withStart(started).withEnd(DateTime.now().getMillis()).withThrown(stepReportItem.getThrown()).withLogTail(stepReportItem.getLogTail()).withOutcome(ReportItem.Outcome.FAILED);
        }
        finally {
            this.readWriteJobsInternalDB.tryRegisterFlowObjectEvent(new AnyLoc(scenario.getProjectKey(), scenario.getId()), null, null, stepRun.getScenarioRun(), stepRun, ranPythonUnitTest);
        }
        logger.infoV("Done step %s", new Object[]{this.step.getName()});
    }

    public static class PytestStepParams
    extends NonFatalStepParams
    implements StepParams,
    ParamsWithSelectableCodeEnv {
        @Nullable
        private String testsSelector;
        private CodeEnvSelection envSelection = new CodeEnvSelection();
        @Nonnull
        public Level logLevel = Level.WARNING;

        @Override
        public CodeEnvSelection getCodeEnvSelection() {
            return this.envSelection;
        }

        @Override
        public void setCodeEnvSelection(CodeEnvSelection envSelection) {
            this.envSelection = envSelection;
        }

        @Override
        public List<CodeEnvModel.CodeEnvUsage> collectCodeEnvUsage(TaggableObjectsService.TaggableObject object) {
            ArrayList usages = Lists.newArrayList();
            if (this.envSelection.envMode == CodeEnvSelection.EnvMode.EXPLICIT_ENV) {
                usages.add(new CodeEnvModel.CodeEnvUsage(CodeEnvModel.EnvLang.PYTHON, this.envSelection.envName, CodeEnvModel.EnvUsage.RECIPE, object.getProjectKey(), object.getId()));
            }
            return usages;
        }

        public static enum Level {
            NOTSET,
            DEBUG,
            INFO,
            WARNING,
            ERROR,
            CRITICAL;

        }
    }
}

