/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scoring.exports.snowflake;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SnowflakeConnection;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.scoring.exports.snowflake.JarsBuilder;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.scoring.builders.Build;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.Statement;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class SnowflakePermanentFunctionExportThread
extends SimpleFutureThread<Void> {
    private final SnowflakeConnection conn;
    private final FullModelId fmi;
    private final String functionName;

    public SnowflakePermanentFunctionExportThread(AuthCtx authCtx, SnowflakeConnection conn, FullModelId fmi, String functionName) {
        super(authCtx);
        this.conn = conn;
        this.fmi = fmi;
        this.functionName = functionName;
    }

    @Override
    protected Void compute() throws Exception {
        File resources = this.fmi.getModelFolder().getAbsoluteFile();
        Build.DssPipelineMeta meta = Build.pipelineMeta((URL)resources.toURI().toURL());
        if (meta.type == null) {
            throw new IOException("Failed to parse a valid type from the dss_pipeline_meta.json");
        }
        String modelSuffix = SecretKeyGenerator.generate((int)16);
        AutoDelete compilationFolder = FlowJobUtils.getTmpFolder("jar-compilation", "tmp");
        JarsBuilder jarsBuilder = new JarsBuilder((File)compilationFolder, this.fmi, modelSuffix);
        jarsBuilder.compileAndPackageJar(meta);
        String stage = this.conn.params.javaUDFStage;
        if (StringUtils.isBlank((String)stage)) {
            throw new IllegalArgumentException("Cannot use Java functions in Snowflake: you must specify a writable stage");
        }
        String runPathInStage = PathUtils.makeLeadingNoTrailing((String)(StringUtils.defaultIfBlank((String)this.conn.params.javaUDFPathInStage, (String)"") + "/exported-models-" + modelSuffix));
        try (SQLConnectionProvider.SQLConnectionWrapper wr = SQLConnectionProvider.newConnection(this.conn.getConnectionData_NT(this.owner, this.fmi.getProjectKey()), (AuthCtx)this.getOwner(), null);){
            for (File file : jarsBuilder.getFilesToUploadToSnowflake()) {
                Statement st2 = wr.createStatement();
                try {
                    st2.execute(String.format("PUT file://%s @%s%s/ AUTO_COMPRESS=false; \n", file.getAbsolutePath(), stage, runPathInStage));
                }
                finally {
                    if (st2 == null) continue;
                    st2.close();
                }
            }
            String imports = jarsBuilder.getFilesToUploadToSnowflake().stream().map(f -> String.format("'@%s%s/%s'", stage, runPathInStage, f.getName())).collect(Collectors.joining(","));
            try (Statement st3 = wr.createStatement();){
                st3.execute(String.format("CREATE FUNCTION %s (input OBJECT) returns OBJECT LANGUAGE JAVA RUNTIME_VERSION = '17' IMPORTS = (%s) HANDLER='%s.snowflakePredictObject';\n", this.functionName, imports, jarsBuilder.getClassFullyQualifiedName()));
            }
            wr.commit();
        }
        return null;
    }

    public FuturePayload getPayload() {
        return null;
    }
}

