/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.model;

import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.coremodel.ProjectFolder;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.plugins.model.ParameterSetSettings;
import com.dataiku.dip.plugins.model.PluginSettings;
import com.dataiku.dip.plugins.presets.PluginPreset;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.model.AbstractGlobalScopePublicAPIKey;
import com.dataiku.dip.util.DatasetLocUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class LegacyGlobalScopePublicAPIKey
extends AbstractGlobalScopePublicAPIKey {
    private boolean execSQLLike;
    private Map<String, ProjectFolder.PermissionItem> projectFolders = new HashMap<String, ProjectFolder.PermissionItem>();
    private Map<String, SerializedProject.PermissionItem> projects = new HashMap<String, SerializedProject.PermissionItem>();
    private Map<CodeEnvModel.EnvLang, Map<String, CodeEnvModel.PermissionItem>> codeEnvs = new HashMap<CodeEnvModel.EnvLang, Map<String, CodeEnvModel.PermissionItem>>();
    private Map<String, Cluster.PermissionItem> clusters = new HashMap<String, Cluster.PermissionItem>();
    private Map<String, CodeStudioTemplate.PermissionItem> codeStudioTemplates = new HashMap<String, CodeStudioTemplate.PermissionItem>();
    private Map<String, PluginSettings.PermissionItem> plugins = new HashMap<String, PluginSettings.PermissionItem>();
    private Map<String, PluginPreset.PermissionItem> pluginPresets = new HashMap<String, PluginPreset.PermissionItem>();
    private Map<String, ParameterSetSettings.PermissionItem> pluginParameterSets = new HashMap<String, ParameterSetSettings.PermissionItem>();
    private UsersDAO.GroupPermissions globalPermissions = new UsersDAO.GroupPermissions();
    private List<UnscopedDatasetPrivilege> unscopedDatasets = new ArrayList<UnscopedDatasetPrivilege>();

    public LegacyGlobalScopePublicAPIKey() {
    }

    public LegacyGlobalScopePublicAPIKey(LegacyGlobalScopePublicAPIKey globalScopePublicAPIKey) {
        super(globalScopePublicAPIKey);
        this.globalPermissions = globalScopePublicAPIKey.globalPermissions.deepCopy();
        this.execSQLLike = globalScopePublicAPIKey.execSQLLike;
        globalScopePublicAPIKey.projectFolders.entrySet().stream().forEach(e -> this.projectFolders.put((String)e.getKey(), ((ProjectFolder.PermissionItem)e.getValue()).deepCopy()));
        globalScopePublicAPIKey.projects.entrySet().stream().forEach(e -> this.projects.put((String)e.getKey(), ((SerializedProject.PermissionItem)e.getValue()).deepCopy()));
        globalScopePublicAPIKey.codeEnvs.entrySet().stream().forEach(e -> this.codeEnvs.put((CodeEnvModel.EnvLang)((Object)((Object)e.getKey())), this.deepCopy((Map)e.getValue())));
        globalScopePublicAPIKey.clusters.entrySet().stream().forEach(e -> this.clusters.put((String)e.getKey(), ((Cluster.PermissionItem)e.getValue()).deepCopy()));
        globalScopePublicAPIKey.codeStudioTemplates.entrySet().stream().forEach(e -> this.codeStudioTemplates.put((String)e.getKey(), ((CodeStudioTemplate.PermissionItem)e.getValue()).deepCopy()));
        globalScopePublicAPIKey.plugins.entrySet().stream().forEach(e -> this.plugins.put((String)e.getKey(), ((PluginSettings.PermissionItem)e.getValue()).deepCopy()));
        globalScopePublicAPIKey.pluginPresets.entrySet().stream().forEach(e -> this.pluginPresets.put((String)e.getKey(), ((PluginPreset.PermissionItem)e.getValue()).deepCopy()));
        globalScopePublicAPIKey.pluginParameterSets.entrySet().stream().forEach(e -> this.pluginParameterSets.put((String)e.getKey(), ((ParameterSetSettings.PermissionItem)e.getValue()).deepCopy()));
        globalScopePublicAPIKey.unscopedDatasets.forEach(d -> this.unscopedDatasets.add(d.deepCopy()));
    }

    private Map<String, CodeEnvModel.PermissionItem> deepCopy(Map<String, CodeEnvModel.PermissionItem> map) {
        HashMap<String, CodeEnvModel.PermissionItem> copy = new HashMap<String, CodeEnvModel.PermissionItem>();
        map.entrySet().stream().forEach(e -> copy.put((String)e.getKey(), ((CodeEnvModel.PermissionItem)e.getValue()).deepCopy()));
        return copy;
    }

    @Override
    public LegacyGlobalScopePublicAPIKey deepCopy() {
        return new LegacyGlobalScopePublicAPIKey(this);
    }

    public UsersDAO.GroupPermissions getGlobalPermissions() {
        return this.globalPermissions;
    }

    public void setGlobalPermissions(UsersDAO.GroupPermissions globalPermissions) {
        this.globalPermissions = globalPermissions;
    }

    @Override
    public boolean hasDirectDatasetPrivilege(Privileges.DatasetLevelPrivilegeType privilegeType, DatasetLocUtils.DatasetLoc loc) {
        for (UnscopedDatasetPrivilege udp : this.unscopedDatasets) {
            for (String dataset : udp.datasets) {
                if (!loc.getFullName().equals(dataset) || !udp.privileges.contains((Object)privilegeType)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasProjectPrivilege(Privileges.ProjectLevelPrivilegeType privilegeType, String projectKey) {
        Validate.notNull((Object)projectKey);
        return this.globalPermissions.isAdmin() || this.projects != null && this.projects.containsKey(projectKey) && PermissionsService.permissionItemIncludes(this.projects.get(projectKey), privilegeType);
    }

    @Override
    public boolean hasProjectFolderPrivilege(Privileges.ProjectFolderLevelPrivilegeType privilegeType, String projectFolderId) {
        Validate.notNull((Object)projectFolderId);
        return this.globalPermissions.isAdmin() || this.projectFolders != null && this.projectFolders.containsKey(projectFolderId) && PermissionsService.permissionItemIncludes(this.projectFolders.get(projectFolderId), privilegeType);
    }

    @Override
    public boolean isGlobalAdmin() {
        return this.globalPermissions.isAdmin();
    }

    @Override
    public boolean hasSQLikePrivilege() {
        return this.globalPermissions.isAdmin() || this.execSQLLike;
    }

    @Override
    public boolean mayCreateCodeEnvs() {
        return this.globalPermissions.mayCreateCodeEnvs();
    }

    @Override
    public boolean mayCreateClusters() {
        return this.globalPermissions.mayCreateClusters();
    }

    @Override
    public boolean mayCreateCodeStudioTemplates() {
        return this.globalPermissions.mayCreateCodeStudioTemplates();
    }

    @Override
    public boolean mayDevelopPlugins() {
        return this.globalPermissions.mayDevelopPlugins();
    }

    @Override
    public boolean mayEditLibFolders() {
        return this.globalPermissions.mayEditLibFolders();
    }

    @Override
    public boolean mayManageCodeEnvs() {
        return this.globalPermissions.mayManageCodeEnvs();
    }

    @Override
    public boolean mayManageClusters() {
        return this.globalPermissions.mayManageClusters();
    }

    @Override
    public boolean mayManageCodeStudioTemplates() {
        return this.globalPermissions.mayManageCodeStudioTemplates();
    }

    @Override
    public boolean mayCreateActiveWebContent() {
        return this.globalPermissions.mayCreateActiveWebContent();
    }

    @Override
    public boolean hasCodeEnvPrivilege(Privileges.CodeEnvLevelPrivilegeType privilegeType, CodeEnvModel.EnvLang envLang, String envName) {
        Validate.notNull((Object)((Object)envLang));
        Validate.notNull((Object)envName);
        if (this.globalPermissions.isAdmin() || this.globalPermissions.mayManageCodeEnvs()) {
            return true;
        }
        return this.codeEnvs.containsKey((Object)envLang) && this.codeEnvs.get((Object)envLang).containsKey(envName) && PermissionsService.permissionItemIncludes(this.codeEnvs.get((Object)envLang).get(envName), privilegeType);
    }

    public void addClusterPrivileges(String clusterId, Cluster.PermissionItem item) {
        this.clusters.put(clusterId, item);
    }

    @Override
    public boolean hasClusterPrivilege(Privileges.ClusterLevelPrivilegeType privilegeType, String clusterId) {
        Validate.notNull((Object)clusterId);
        if (this.globalPermissions.isAdmin() || this.globalPermissions.mayManageClusters()) {
            return true;
        }
        return this.clusters.containsKey(clusterId) && PermissionsService.permissionItemIncludes(this.clusters.get(clusterId), privilegeType);
    }

    public boolean hasSameClusterPrivilegesAs(Map<String, Cluster.PermissionItem> clusterPermissionItems) {
        if (!this.clusters.keySet().equals(clusterPermissionItems.keySet())) {
            return false;
        }
        return this.clusters.keySet().stream().allMatch(clusterId -> this.clusters.get(clusterId).hasSamePrivilegesAs((Cluster.PermissionItem)clusterPermissionItems.get(clusterId)));
    }

    @Override
    public boolean hasCodeStudioTemplatePrivilege(Privileges.CodeStudioTemplatePrivilegeType privilegeType, String codeStudioTemplateId) {
        Validate.notNull((Object)codeStudioTemplateId);
        if (this.globalPermissions.isAdmin() || this.globalPermissions.mayManageCodeStudioTemplates()) {
            return true;
        }
        return this.codeStudioTemplates.containsKey(codeStudioTemplateId) && PermissionsService.permissionItemIncludes(this.codeStudioTemplates.get(codeStudioTemplateId), privilegeType);
    }

    @Override
    public boolean hasPluginPrivilege(Privileges.PluginLevelPrivilegeType privilegeType, boolean isDev, String pluginId) {
        Validate.notNull((Object)pluginId);
        if (this.globalPermissions.isAdmin()) {
            return true;
        }
        if (isDev && this.globalPermissions.mayDevelopPlugins()) {
            return true;
        }
        return this.plugins.containsKey(pluginId) && PermissionsService.permissionItemIncludes(this.plugins.get(pluginId), privilegeType);
    }

    @Override
    public boolean hasPluginPresetPrivilege(Privileges.PluginPresetLevelPrivilegeType privilegeType, boolean isDev, String elementType) {
        Validate.notNull((Object)elementType);
        if (this.globalPermissions.isAdmin()) {
            return true;
        }
        if (isDev && this.globalPermissions.mayDevelopPlugins()) {
            return true;
        }
        return this.pluginPresets.containsKey(elementType) && PermissionsService.permissionItemIncludes(this.pluginPresets.get(elementType), privilegeType);
    }

    @Override
    public boolean hasPluginParameterSetPrivilege(Privileges.PluginParameterSetLevelPrivilegeType privilegeType, boolean isDev, String elementType) {
        Validate.notNull((Object)elementType);
        if (this.globalPermissions.isAdmin()) {
            return true;
        }
        if (isDev && this.globalPermissions.mayDevelopPlugins()) {
            return true;
        }
        return this.pluginParameterSets.containsKey(elementType) && PermissionsService.permissionItemIncludes(this.pluginParameterSets.get(elementType), privilegeType);
    }

    @Override
    public boolean mayManageFeatureStore() {
        return this.globalPermissions.isAdmin() || this.globalPermissions.mayManageFeatureStore();
    }

    static class UnscopedDatasetPrivilege {
        List<String> datasets = new ArrayList<String>();
        List<Privileges.DatasetLevelPrivilegeType> privileges = new ArrayList<Privileges.DatasetLevelPrivilegeType>();

        public UnscopedDatasetPrivilege() {
        }

        public UnscopedDatasetPrivilege(UnscopedDatasetPrivilege privilege) {
            this.datasets = new ArrayList<String>(privilege.datasets);
            this.privileges = new ArrayList<Privileges.DatasetLevelPrivilegeType>(privilege.privileges);
        }

        public UnscopedDatasetPrivilege deepCopy() {
            return new UnscopedDatasetPrivilege(this);
        }
    }
}

