/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.agents.tools.AgentToolsCRUDService;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.code.DesignNodeCodeEnvsService;
import com.dataiku.dip.code.PythonCodeEnvPackagesUtils;
import com.dataiku.dip.connections.PineconeConnection;
import com.dataiku.dip.connections.VectorStoreConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.llm.retrieval.KnowledgeBankCodeEnvCompatibilityComputer;
import com.dataiku.dip.llm.retrieval.KnowledgeBankDataService;
import com.dataiku.dip.llm.retrieval.KnowledgeBankManagementService;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeCRUDService;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.recipes.nlp.rag_embedding.RAGEmbeddingRecipePayloadParams;
import com.dataiku.dip.savedmodels.SavedModelsRetrievalAugmentedLlmService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ConnectionsService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.NavigatorService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class RetrievableKnowledgeController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private ConnectionsService connectionsService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    @Autowired
    private RetrievableKnowledgeCRUDService crudService;
    @Autowired
    private NavigatorService navigatorService;
    @Autowired
    private TimelinesService timelinesService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private DesignNodeCodeEnvsService designNodeEnvsService;
    @Autowired
    private KnowledgeBankManagementService kbMgmtService;
    @Autowired
    private KnowledgeBankDataService kbDataService;
    @Autowired
    private SavedModelsRetrievalAugmentedLlmService retrievalAugmentedLlmService;
    @Autowired
    private AgentToolsCRUDService agentToolsCRUDService;
    static DKULogger logger = DKULogger.getLogger((String)"dku.llm.rag.controller");

    @AuditedCall(value={"msgType", "knowledge-bank-get", "projectKey", "${projectKey}", "knowledgeBankRef", "${knowledgeBankRef}"})
    @ResponseBody
    @RequestMapping(value={"/api/knowledge-bank/get"})
    public RetrievableKnowledge getRetrievableKnowledge(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String knowledgeBankRef) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            AnyLoc loc = AnyLoc.resolveSmart(projectKey, knowledgeBankRef);
            this.projectsService.failIfNoRetrievableKnowledgeReadUseAccess(u, loc, projectKey);
            RetrievableKnowledge retrievableKnowledge = (RetrievableKnowledge)this.retrievableKnowledgeDAO.getMandatory(loc);
            return retrievableKnowledge;
        }
    }

    @AuditedCall(value={"msgType", "knowledge-bank-get", "projectKey", "${projectKey}", "knowledgeBankRef", "${knowledgeBankRef}"})
    @ResponseBody
    @RequestMapping(value={"/api/knowledge-bank/get-full-info"})
    public NavigatorService.RetrievableKnowledgeFullInfo getFullInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String knowledgeBankRef) throws Exception {
        NavigatorService.RetrievableKnowledgeFullInfo info;
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            AnyLoc loc = AnyLoc.resolveSmart(projectKey, knowledgeBankRef);
            this.projectsService.failIfNoRetrievableKnowledgeReadUseAccess(u, loc, projectKey);
            info = this.navigatorService.getRetrievableKnowledgeFullInfo(loc, projectKey, u);
        }
        this.navigatorService.addInfo_NT(info, u);
        return info;
    }

    @AuditedCall(value={"msgType", "knowledge-bank-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/knowledge-bank/list"})
    @ResponseBody
    public List<RetrievableKnowledge> listRK(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            List<RetrievableKnowledge> list = this.retrievableKnowledgeDAO.listUnsafe(projectKey);
            return list;
        }
    }

    @AuditedCall(value={"msgType", "knowledge-bank-list-heads", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/knowledge-bank/list-heads"})
    public void listRKHeads(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        AuthCtx authCtx;
        ArrayList<RetrievableKnowledge.RetrievableKnowledgeListItem> heads = new ArrayList<RetrievableKnowledge.RetrievableKnowledgeListItem>();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            for (RetrievableKnowledge rk : this.retrievableKnowledgeDAO.list(projectKey)) {
                RetrievableKnowledge.RetrievableKnowledgeListItem item = new RetrievableKnowledge.RetrievableKnowledgeListItem(rk);
                this.taggableObjectsService.setEditionInfoFromTags(rk, item);
                heads.add(item);
            }
        }
        this.interestsService.enrichListItems(authCtx.getAssociatedDSSUser(), projectKey, heads);
        RetrievableKnowledgeController.writeJSON((HttpServletResponse)resp, heads);
    }

    @AuditInline
    @RequestMapping(value={"/api/knowledge-bank/save"}, method={RequestMethod.POST})
    public void save(HttpServletRequest req, HttpServletResponse resp, @RequestParam String data, @RequestParam(required=false) String saveInfo) throws Exception {
        RetrievableKnowledge rk = (RetrievableKnowledge)JSON.parse((String)data, RetrievableKnowledge.class);
        TaggableObjectsService.TaggableObjectSaveInfo si = TaggableObjectsService.TaggableObjectSaveInfo.parse(saveInfo);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, rk.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.crudService.save(rk, si.summaryOnly);
            if (si.summaryOnly) {
                t.commit("Updated summary for knowledge bank " + rk.projectKey + "." + rk.name + " (id: " + rk.id + ")", 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
            } else {
                t.commit("Saved knowledge bank " + rk.projectKey + "." + rk.name + " (id: " + rk.id + ")");
            }
            this.auditTrailService.generic("knowledge-bank-save").with("projectKey", rk.projectKey).with("kbId", rk.id).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("knowledge-bank-save", (Throwable)e).with("projectKey", rk.projectKey).with("kbId", rk.id).emit();
            throw e;
        }
        RetrievableKnowledgeController.writeJSONString((HttpServletResponse)resp, (String)"{}");
    }

    @AuditInline
    @RequestMapping(value={"/api/knowledge-bank/clear"}, method={RequestMethod.POST})
    @ResponseBody
    public InfoMessage.InfoMessages clear(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String knowledgeBankRef) throws Exception {
        RetrievableKnowledge rk;
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            AnyLoc loc = AnyLoc.resolveSmart(projectKey, knowledgeBankRef);
            this.projectsService.failIfNoRetrievableKnowledgeReadUseAccess(u, loc, projectKey);
            rk = (RetrievableKnowledge)this.retrievableKnowledgeDAO.getMandatory(loc);
        }
        return this.kbDataService.clear_NT(u, rk, projectKey);
    }

    @AuditedCall(value={"msgType", "knowledge-bank-get-recipe-info", "projectKey", "${projectKey}", "knowledgeBankRef", "${knowledgeBankRef}"})
    @RequestMapping(value={"/api/knowledge-bank/get-current-version-info"}, method={RequestMethod.GET})
    @ResponseBody
    public CurrentVersionInfo getCurrentVersionInfo(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String knowledgeBankRef) throws Exception {
        RetrievableKnowledge rk;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            AnyLoc loc = AnyLoc.resolveSmart(projectKey, knowledgeBankRef);
            this.projectsService.failIfNoRetrievableKnowledgeReadUseAccess(u, loc, projectKey);
            rk = (RetrievableKnowledge)this.retrievableKnowledgeDAO.getMandatory(loc);
        }
        String currentVersion = this.kbMgmtService.getCurrentlyUsedVersion(rk);
        CurrentVersionInfo settings = new CurrentVersionInfo();
        settings.isBuilt = !Objects.equals(currentVersion, "not-built");
        this.kbMgmtService.readKnowledgeBankFolder(rk, currentVersion, folder -> {
            File rkSettingsFile;
            File settingsFile = DKUApp.getFile((File)folder, (String[])new String[]{"recipe_settings.json"});
            if (settingsFile.exists()) {
                settings.embeddingRecipeParams = (RAGEmbeddingRecipePayloadParams)JSON.parseFile((File)settingsFile, RAGEmbeddingRecipePayloadParams.class);
            }
            if ((rkSettingsFile = ApplicationConfigurator.getFile((File)folder, (String[])new String[]{"kb.json"})).exists()) {
                settings.rkAtVersion = (RetrievableKnowledge)JSON.parseFile((File)rkSettingsFile, RetrievableKnowledge.class);
            }
        });
        return settings;
    }

    @AuditedCall(value={"msgType", "knowledge-bank-list-vector-store-connections"})
    @RequestMapping(value={"/api/knowledge-bank/list-vector-store-connections"}, method={RequestMethod.GET})
    @ResponseBody
    public List<VectorStoreConnection.SanitisedConnectionForKB> listVectorStoreConnections(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
        }
        return this.connectionsService.listUsableVectorStoreConnections(u);
    }

    @AuditedCall(value={"msgType", "knowledge-bank-check-pinecone-compatibility"})
    @RequestMapping(value={"/api/knowledge-bank/check-pinecone-compatibility"}, method={RequestMethod.GET})
    @ResponseBody
    public PythonCodeEnvPackagesUtils.CompatibilityInfo checkPineconeCompatibility(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String pineconeConnection, @RequestParam CodeEnvSelection envSelection) throws Exception {
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
        }
        PineconeConnection connection = this.connectionsService.getPineconeConnection(u, pineconeConnection);
        String resolvedCodeEnvName = new CodeEnvSelector().selectForPythonRecipe(projectKey, envSelection);
        if (null == resolvedCodeEnvName) {
            return KnowledgeBankCodeEnvCompatibilityComputer.isEnvCompatibleWithConnection(connection, null);
        }
        CodeEnvModel.DesignUIPythonEnv env = this.designNodeEnvsService.getPythonEnvForUI(resolvedCodeEnvName, false);
        PythonCodeEnvPackagesUtils.PythonEnvPackages packages = PythonCodeEnvPackagesUtils.getEnvPackages(env);
        return KnowledgeBankCodeEnvCompatibilityComputer.isEnvCompatibleWithConnection(connection, packages);
    }

    @AuditedCall(value={"msgType", "knowledge-bank-get-retrieval-augmented-llm-list", "projectKey", "${projectKey}", "knowledgeBankRef", "${knowledgeBankRef}"})
    @RequestMapping(value={"/api/knowledge-bank/get-retrieval-augmented-llm-list"}, method={RequestMethod.GET})
    @ResponseBody
    public List<SavedModel> getRetrievalAugmentedLLMList(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String knowledgeBankRef) throws Exception {
        List<SavedModel> savedModelUsingKb;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            AnyLoc loc = AnyLoc.resolveSmart(projectKey, knowledgeBankRef);
            this.projectsService.failIfNoRetrievableKnowledgeReadUseAccess(u, loc, projectKey);
            savedModelUsingKb = this.retrievalAugmentedLlmService.listRetrievalAugmentedLLMFromKbRef(projectKey, knowledgeBankRef);
        }
        return savedModelUsingKb;
    }

    @AuditedCall(value={"msgType", "knowledge-bank-search", "projectKey", "${projectKey}", "knowledgeBankRef", "${knowledgeBankRef}"})
    @RequestMapping(value={"/api/knowledge-bank/search"}, method={RequestMethod.POST})
    @ResponseBody
    public AgentToolsCRUDService.ToolQuickTestResponse search(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String knowledgeBankRef, @RequestParam String input, @RequestParam JsonObject params) throws Exception {
        RetrievableKnowledge rk;
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            AnyLoc loc = AnyLoc.resolveSmart(projectKey, knowledgeBankRef);
            this.projectsService.failIfNoRetrievableKnowledgeReadUseAccess(u, loc, projectKey);
            rk = (RetrievableKnowledge)this.retrievableKnowledgeDAO.getMandatory(loc);
        }
        return this.agentToolsCRUDService.searchKnowledgeBank(u, rk, input, params);
    }

    public static class CurrentVersionInfo {
        @Nullable
        RAGEmbeddingRecipePayloadParams embeddingRecipeParams;
        @Nullable
        RetrievableKnowledge rkAtVersion;
        boolean isBuilt;
    }
}

