/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.projects.TutorialsService;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class TutorialsController
extends DIPInternalControllerBase {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private TutorialsService tutorialsService;

    @AuditNotNeeded
    @RequestMapping(value={"/api/tutorials/list"})
    public void listTutorials(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction ignored = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        TutorialsController.writeJSON((HttpServletResponse)resp, (Object)this.tutorialsService.getList());
    }

    @AuditedCall(value={"msgType", "tutorial-create", "tutorialId", "${id}"})
    @RequestMapping(value={"/api/projects/create-tutorial"})
    public void create(HttpServletRequest req, HttpServletResponse resp, @RequestParam String id, @RequestParam String type, @RequestParam(required=false) String projectFolderId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            DSSAuthCtx liu = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            if (!liu.getPermissions().mayCreateProjectsFromTemplates()) {
                throw new SecurityException("You may not create new projects from templates");
            }
            TutorialsController.writeJSON((HttpServletResponse)resp, this.tutorialsService.createProject(liu, id, type, projectFolderId));
        }
    }

    @AuditedCall(value={"msgType", "tutorial-download", "tutorialId", "${id}"})
    @RequestMapping(value={"/api/projects/download-tutorial"}, method={RequestMethod.POST})
    public void download(HttpServletRequest req, HttpServletResponse resp, @RequestParam String id, @RequestParam String type) throws Exception {
        DSSAuthCtx liu;
        try (Transaction t = this.transactionService.beginRead();){
            liu = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            if (!liu.getPermissions().mayCreateProjectsFromTemplates()) {
                throw new SecurityException("You may not create new projects from templates");
            }
        }
        TutorialsController.writeJSON((HttpServletResponse)resp, this.tutorialsService.downloadProject(liu, id, type));
    }

    @AuditedCall(value={"msgType", "tutorial-prepare", "importId", "${importId}"})
    @RequestMapping(value={"/api/projects/prepare-tutorial"}, method={RequestMethod.POST})
    public void prepare(HttpServletRequest req, HttpServletResponse resp, @RequestParam String importId) throws Exception {
        DSSAuthCtx liu;
        try (Transaction t = this.transactionService.beginRead();){
            liu = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            if (!liu.getPermissions().mayCreateProjectsFromTemplates()) {
                throw new SecurityException("You may not create new projects from templates");
            }
        }
        TutorialsController.writeJSON((HttpServletResponse)resp, (Object)this.tutorialsService.prepareImport(liu, importId));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/projects/start-import-tutorial"}, method={RequestMethod.POST})
    public void startImport(HttpServletRequest req, HttpServletResponse resp, @RequestParam String importId, @RequestParam String tutorialId, @RequestParam String targetProjectKey, @RequestParam String targetProjectFolderId) throws Exception {
        DSSAuthCtx liu;
        try (Transaction t = this.transactionService.beginRead();){
            liu = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            if (!liu.getPermissions().mayCreateProjectsFromTemplates()) {
                throw new SecurityException("You may not create new projects from templates");
            }
        }
        TutorialsController.writeJSON((HttpServletResponse)resp, this.tutorialsService.processImport(liu, importId, tutorialId, targetProjectKey, targetProjectFolderId));
    }
}

