/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers.labeling;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.labeling.AnnotationService;
import com.dataiku.dip.labeling.LabelingImageService;
import com.dataiku.dip.labeling.LabelingPermissionsService;
import com.dataiku.dip.labeling.LabelingRecord;
import com.dataiku.dip.labeling.LabelingRecordToAnnotate;
import com.dataiku.dip.labeling.LabelingService;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.LabelingTaskStats;
import com.dataiku.dip.labeling.LabelingTasksCRUDService;
import com.dataiku.dip.labeling.LabelingTasksDAO;
import com.dataiku.dip.labeling.VerifiedLabelingAnswer;
import com.dataiku.dip.labeling.consensus.ResolutionResult;
import com.dataiku.dip.labeling.consensus.ResolutionService;
import com.dataiku.dip.managedfolder.ManagedFoldersService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.MimeTypesSecurity;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ConflictCheckService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.NavigatorService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.server.SerializedMemTableV2;
import com.dataiku.dip.shaker.server.SerializedTableChunk;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class LabelingTasksController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private LabelingTasksDAO labelingTasksDAO;
    @Autowired
    private LabelingTasksCRUDService labelingTasksCRUDService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private NavigatorService navigatorService;
    @Autowired
    private AnnotationService annotationService;
    @Autowired
    private ResolutionService resolutionService;
    @Autowired
    private ConflictCheckService conflictCheckService;
    @Autowired
    private LabelingImageService labelingImageService;
    @Autowired
    private LabelingPermissionsService labelingPermissionsService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private ManagedFoldersService managedFoldersService;
    @Autowired
    private LabelingService labelingService;

    @AuditedCall(value={"msgType", "labelingtasks-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/labelingtasks/list"})
    @ResponseBody
    public List<LabelingTask> list(HttpServletRequest req, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
            List<LabelingTask> list = this.labelingTasksCRUDService.listAccessibleUnsafe(authCtx, projectKey);
            return list;
        }
    }

    @AuditedCall(value={"msgType", "labelingtasks-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/labelingtasks/list-heads"})
    @ResponseBody
    public List<LabelingTask.LabelingTaskListItem> listHeads(HttpServletRequest req, @RequestParam String projectKey) throws Exception {
        AuthCtx authCtx;
        ArrayList<LabelingTask.LabelingTaskListItem> heads = new ArrayList<LabelingTask.LabelingTaskListItem>();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
            List<LabelingTask> list = this.labelingTasksCRUDService.listAccessibleUnsafe(authCtx, projectKey);
            for (LabelingTask labelingTask : list) {
                LabelingTask.LabelingTaskListItem item = new LabelingTask.LabelingTaskListItem(labelingTask);
                this.taggableObjectsService.setEditionInfoFromTags(labelingTask, item);
                heads.add(item);
            }
        }
        this.interestsService.enrichListItems(authCtx.getAssociatedDSSUser(), projectKey, heads);
        return heads;
    }

    @AuditedCall(value={"msgType", "labelingtasks-list-annotator-ids", "projectKey", "${projectKey}", "labelingTaskId", "${labelingTaskId}"})
    @RequestMapping(value={"/api/labelingtasks/list-annotator-ids"})
    @ResponseBody
    public List<String> listAnnotatorIds(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String labelingTaskId) throws Exception {
        LabelingTask labelingTask;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            labelingTask = (LabelingTask)this.labelingTasksDAO.getMandatory(projectKey, labelingTaskId);
            this.labelingPermissionsService.checkPerm(authCtx, labelingTask, Privileges.LabelingLevelPrivilegeType.REVIEW);
        }
        return this.annotationService.listAnnotatorIds(authCtx, labelingTask);
    }

    @AuditedCall(value={"msgType", "labelingtasks-get", "projectKey", "${projectKey}", "id", "${id}"})
    @RequestMapping(value={"/api/labelingtasks/get"}, method={RequestMethod.GET})
    @ResponseBody
    public LabelingTask getLabelingTask(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String id) throws IOException, DKUSecurityException {
        LabelingTask labelingTask;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            labelingTask = (LabelingTask)this.labelingTasksDAO.getMandatory(projectKey, id);
            this.labelingPermissionsService.checkPerm(authCtx, labelingTask, Privileges.LabelingLevelPrivilegeType.READ);
        }
        return labelingTask;
    }

    @AuditInline
    @RequestMapping(value={"/api/labelingtasks/save"}, method={RequestMethod.POST})
    @ResponseBody
    public LabelingTask save(HttpServletRequest req, @RequestParam LabelingTask labelingTask, @RequestParam(required=false) String commitMessage, @RequestParam(required=false) String zoneId, @RequestParam(required=false) String saveInfo) throws Exception {
        LabelingTask savedTask;
        TaggableObjectsService.TaggableObjectSaveInfo si = TaggableObjectsService.TaggableObjectSaveInfo.parse(saveInfo);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.labelingPermissionsService.checkPerm(req, labelingTask, Privileges.LabelingLevelPrivilegeType.WRITE_CONF);
            savedTask = this.labelingTasksCRUDService.upsertLabelingTask(labelingTask, zoneId);
            if (si.summaryOnly) {
                t.commit("Updated summary for labeling task " + savedTask.projectKey + "." + savedTask.name + " (id: " + savedTask.id + ")", 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
            } else if (StringUtils.isNotBlank((String)commitMessage)) {
                t.commit(commitMessage);
            } else {
                t.commit("Saved labeling task " + savedTask.projectKey + "." + savedTask.name + " (id: " + savedTask.id + ")");
            }
            this.auditTrailService.generic("labelingtask-save").with("projectKey", savedTask.projectKey).with("labelingTaskId", savedTask.id).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("labelingtask-save", (Throwable)e).with("projectKey", labelingTask.projectKey).with("labelingTaskId", labelingTask.id).emit();
            throw e;
        }
        return savedTask;
    }

    @AuditedCall(value={"msgType", "labeling-task-rename", "projectKey", "${projectKey}", "id", "${id}", "newName", "${newName}"})
    @RequestMapping(value={"/api/labelingtasks/rename"})
    public void renameLabelingTask(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id, @RequestParam String newName) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.labelingPermissionsService.checkPerm(req, projectKey, id, Privileges.LabelingLevelPrivilegeType.WRITE_CONF);
            this.labelingTasksCRUDService.rename(projectKey, id, newName);
            t.commit("Renamed labeling task (" + id + ") to " + newName);
        }
    }

    @AuditedCall(value={"msgType", "labelingtask-get-next-record-to-annotate", "projectKey", "${projectKey}", "labelingTaskId", "${labelingTaskId}"})
    @RequestMapping(value={"/api/labelingtasks/get-next-record-to-annotate"})
    @ResponseBody
    public LabelingRecordToAnnotate getNextRecordToAnnotate(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String labelingTaskId, @RequestParam(required=false) String currentRecordId) throws Exception {
        LabelingTask labelingTask;
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            labelingTask = (LabelingTask)this.labelingTasksDAO.getMandatory(projectKey, labelingTaskId);
            this.labelingPermissionsService.checkPerm(user, labelingTask, Privileges.LabelingLevelPrivilegeType.ANNOTATE);
        }
        return this.annotationService.getNextRecordToAnnotate(user, labelingTask, currentRecordId);
    }

    @AuditedCall(value={"msgType", "labeling-task-get-record", "projectKey", "${projectKey}", "labelingTaskId", "${labelingTaskId}", "recordId", "${recordId}"})
    @RequestMapping(value={"/api/labelingtasks/get-record"})
    @ResponseBody
    public LabelingRecord getRecord(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String labelingTaskId, @RequestParam String recordId) throws Exception {
        LabelingTask task;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            task = (LabelingTask)this.labelingTasksDAO.getMandatory(projectKey, labelingTaskId);
            this.labelingPermissionsService.checkPerm(authCtx, task, Privileges.LabelingLevelPrivilegeType.ANNOTATE);
        }
        LabelingRecord record = this.annotationService.getRecord(authCtx, task, recordId);
        if (record == null) {
            throw new NotFoundException("Cannot find record with id " + recordId);
        }
        return record;
    }

    @AuditedCall(value={"msgType", "labelingtask-get-record-ids-to-review", "projectKey", "${projectKey}", "labelingTaskId", "${labelingTaskId}"})
    @RequestMapping(value={"/api/labelingtasks/get-record-ids-to-review"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> getRecordIdsToReview(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String labelingTaskId) throws Exception {
        LabelingTask labelingTask;
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            labelingTask = (LabelingTask)this.labelingTasksDAO.getMandatory(projectKey, labelingTaskId);
            this.labelingPermissionsService.checkPerm(user, labelingTask, Privileges.LabelingLevelPrivilegeType.REVIEW);
        }
        return this.annotationService.getRecordIdsToReview(user, labelingTask);
    }

    @AuditedCall(value={"msgType", "labelingtask-get-reviewed-record-ids", "projectKey", "${projectKey}", "labelingTaskId", "${labelingTaskId}"})
    @RequestMapping(value={"/api/labelingtasks/get-reviewed-record-ids"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> getReviewedRecordIds(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String labelingTaskId) throws Exception {
        LabelingTask labelingTask;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            labelingTask = (LabelingTask)this.labelingTasksDAO.getMandatory(projectKey, labelingTaskId);
            this.labelingPermissionsService.checkPerm(authCtx, labelingTask, Privileges.LabelingLevelPrivilegeType.REVIEW);
        }
        return this.annotationService.getReviewedRecordIds(authCtx, labelingTask);
    }

    @AuditedCall(value={"msgType", "labelingtask-invalidate-metadata-table-cache", "projectKey", "${projectKey}", "labelingTaskId", "${labelingTaskId}"})
    @RequestMapping(value={"/api/labelingtasks/invalidate-metadata-table-cache"}, method={RequestMethod.GET})
    @ResponseBody
    public void invalidateMetadataTableCache(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String labelingTaskId) throws Exception {
        LabelingTask labelingTask;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            labelingTask = (LabelingTask)this.labelingTasksDAO.getMandatory(projectKey, labelingTaskId);
            this.labelingPermissionsService.checkPerm(user, labelingTask, Privileges.LabelingLevelPrivilegeType.ANNOTATE);
        }
        this.labelingTasksCRUDService.invalidateMetadataTableCache(labelingTask);
    }

    @RequestMapping(value={"/api/labelingtasks/get-labeling-task-privileges"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> getLabelingTaskPrivileges(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String labelingTaskId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            LabelingTask labelingTask = (LabelingTask)this.labelingTasksDAO.getMandatory(projectKey, labelingTaskId);
            this.labelingPermissionsService.checkPerm(u, labelingTask, Privileges.LabelingLevelPrivilegeType.READ);
            List<String> list = this.labelingPermissionsService.getPrivileges(u, labelingTask);
            return list;
        }
    }

    @AuditedCall(value={"msgType", "labelingtasks-get-full-info", "projectKey", "${projectKey}", "labelingTaskId", "${id}"})
    @RequestMapping(value={"/api/labelingtasks/get-full-info"})
    @ResponseBody
    public NavigatorService.LabelingTaskFullInfo getFullInfo(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        NavigatorService.LabelingTaskFullInfo info;
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.labelingPermissionsService.checkPerm(req, projectKey, id, Privileges.LabelingLevelPrivilegeType.READ);
            info = this.navigatorService.getLabelingTaskFullInfo(projectKey, id);
        }
        this.navigatorService.addInfo_NT(info, u);
        return info;
    }

    @AuditedCall(value={"msgType", "labelingtasks-resolve-record", "projectKey", "${projectKey}", "labelingTaskId", "${labelingTaskId}"})
    @RequestMapping(value={"/api/labelingtasks/resolve-record"}, method={RequestMethod.POST})
    @ResponseBody
    public VerifiedLabelingAnswer resolveWithAnswer(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String labelingTaskId, @RequestParam VerifiedLabelingAnswer labelingAnswer) throws Exception {
        LabelingTask labelingTask;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            labelingTask = (LabelingTask)this.labelingTasksDAO.getMandatory(projectKey, labelingTaskId);
            this.labelingPermissionsService.checkPerm(authCtx, labelingTask, Privileges.LabelingLevelPrivilegeType.REVIEW);
        }
        return this.resolutionService.saveConsensus(labelingTask, labelingAnswer, authCtx);
    }

    @AuditedCall(value={"msgType", "labeling-tasks-preview-image", "labelingTaskId", "{labelingTaskId}", "contextProjectKey", "${contextProjectKey}", "projectKey", "${projectKey}", "folderId", "${odbId}", "path", "${itemPath}"})
    @RequestMapping(value={"/api/labelingtasks/preview-image"}, method={RequestMethod.GET})
    public void previewImage(HttpServletRequest req, HttpServletResponse resp, @RequestParam String labelingTaskId, @RequestParam String contextProjectKey, @RequestParam String projectKey, @RequestParam String odbId, @RequestParam String itemPath, @RequestParam String contentType) throws Exception {
        AuthCtx authCtx;
        MimeTypesSecurity.failIfNotSafeImageType((String)contentType);
        AnyLoc loc = AnyLoc.resolveSmart(projectKey, odbId);
        SmartObjectRef ref = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.MANAGED_FOLDER, loc.getSmartName(contextProjectKey));
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUserNoXSRF(req);
            LabelingTask labelingTask = (LabelingTask)this.labelingTasksDAO.getMandatory(contextProjectKey, labelingTaskId);
            AnyLoc managedFolderLoc = labelingTask.getManagedFolderLoc();
            if (!(this.projectsService.isObjectAvailableInProject(ref, contextProjectKey) && managedFolderLoc.getProjectKey().equals(projectKey) && managedFolderLoc.getId().equals(odbId))) {
                throw new UnauthorizedException("Action forbidden", "labeling-task-authorization-failure");
            }
            this.labelingPermissionsService.checkPerm(authCtx, labelingTask, Privileges.LabelingLevelPrivilegeType.READ);
        }
        this.managedFoldersService.handlePreviewImageRequest_NT(ref.getProjectKey(projectKey), ref.objectId, itemPath, authCtx, contentType, resp);
    }

    @AuditedCall(value={"msgType", "labelingtasks-resolve-consensual-records", "projectKey", "${projectKey}", "labelingTaskId", "${labelingTaskId}"})
    @RequestMapping(value={"/api/labelingtasks/resolve-consensual-records"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<ResolutionResult> resolveConsensualRecords(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String labelingTaskId) throws Exception {
        LabelingTask labelingTask;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            labelingTask = (LabelingTask)this.labelingTasksDAO.getMandatory(projectKey, labelingTaskId);
            this.labelingPermissionsService.checkPerm(authCtx, labelingTask, Privileges.LabelingLevelPrivilegeType.REVIEW);
        }
        return this.resolutionService.resolveConsensualRecordsInFuture(labelingTask, authCtx);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/labelingtasks/check-save-conflict"})
    @ResponseBody
    public VersionTag.ConflictCheckResult checkSaveConflict(HttpServletRequest req, @RequestParam LabelingTask newLabelingTask) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.labelingPermissionsService.checkPerm(req, newLabelingTask, Privileges.LabelingLevelPrivilegeType.WRITE_CONF);
            LabelingTask existingTask = (LabelingTask)this.labelingTasksDAO.getOrNullUnsafe(newLabelingTask.projectKey, newLabelingTask.id);
            VersionTag.ConflictCheckResult ccr = existingTask != null ? this.conflictCheckService.checkConflict(existingTask.versionTag, newLabelingTask.versionTag) : this.conflictCheckService.checkConflict(null, newLabelingTask.versionTag);
            if (!ccr.canBeSaved) {
                ccr.message = "This labeling task is being edited by more than one user.";
            }
            VersionTag.ConflictCheckResult conflictCheckResult = ccr;
            return conflictCheckResult;
        }
    }

    @AuditedCall(value={"msgType", "labeling-refresh-images-data-sample", "projectKey", "${projectKey}", "labelingTaskId", "${labelingTaskId}", "nbRows", "${nbRows}"})
    @RequestMapping(value={"/api/labelingtasks/refresh-images-data-sample"}, method={RequestMethod.GET})
    @ResponseBody
    public SerializedMemTableV2 refreshImagesDataSample(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String labelingTaskId, @RequestParam int nbRows) throws Exception {
        LabelingTask labelingTask;
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            labelingTask = (LabelingTask)this.labelingTasksDAO.getMandatory(projectKey, labelingTaskId);
            this.labelingPermissionsService.checkPerm(user, labelingTask, Privileges.LabelingLevelPrivilegeType.READ);
        }
        return this.labelingImageService.refreshImagesDataSample_NT(labelingTask, nbRows, user);
    }

    @AuditedCall(value={"msgType", "labeling-get-images-data-chunk", "projectKey", "${projectKey}", "labelingTaskId", "${labelingTaskId}"})
    @RequestMapping(value={"/api/labelingtasks/get-images-data-chunk"}, method={RequestMethod.GET})
    @ResponseBody
    public SerializedTableChunk getImagesDataChunk(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String labelingTaskId, @RequestParam int nbRows, @RequestParam int offset) throws Exception {
        LabelingTask labelingTask;
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            labelingTask = (LabelingTask)this.labelingTasksDAO.getMandatory(projectKey, labelingTaskId);
            this.labelingPermissionsService.checkPerm(req, labelingTask, Privileges.LabelingLevelPrivilegeType.READ);
        }
        return this.labelingImageService.getImagesMetadataChunk_NT(labelingTask, user, nbRows, offset);
    }

    @AuditedCall(value={"msgType", "labeling-get-stats", "projectKey", "${projectKey}", "labelingTaskId", "${labelingTaskId}"})
    @RequestMapping(value={"/api/labelingtasks/get-stats"}, method={RequestMethod.GET})
    @ResponseBody
    public LabelingTaskStats getStats(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String labelingTaskId) throws Exception {
        boolean canReadPerAnnotatorStats;
        LabelingTask labelingTask;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            labelingTask = (LabelingTask)this.labelingTasksDAO.getMandatory(projectKey, labelingTaskId);
            this.labelingPermissionsService.checkPerm(authCtx, labelingTask, Privileges.LabelingLevelPrivilegeType.READ_CONF);
            canReadPerAnnotatorStats = this.labelingPermissionsService.canReview(authCtx, labelingTask);
        }
        return this.labelingTasksCRUDService.getStats_NT(authCtx, labelingTask, canReadPerAnnotatorStats);
    }

    @AuditedCall(value={"msgType", "labeling-check", "projectKey", "${projectKey}", "labelingTaskId", "${labelingTaskId}"})
    @RequestMapping(value={"/api/labelingtasks/check"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean check(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String labelingTaskId) throws Exception {
        LabelingTask labelingTask;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            labelingTask = (LabelingTask)this.labelingTasksDAO.getMandatory(projectKey, labelingTaskId);
            this.labelingPermissionsService.checkPerm(authCtx, labelingTask, Privileges.LabelingLevelPrivilegeType.READ_CONF);
        }
        this.labelingTasksCRUDService.check_NT(authCtx, labelingTask);
        return true;
    }
}

