/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.datasets;

import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopConfig;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.fs.FilesSelectionRules;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.datasets.FSDatasetBrowseService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class FSDatasetBrowseController
extends DIPInternalControllerBase {
    @Autowired
    private FSDatasetBrowseService service;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private ProjectsService projectsService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fsproviders.controller");

    @AuditInline
    @RequestMapping(value={"/api/fsproviders/test-connection/"})
    public void testFSProviderConnection(HttpServletRequest req, HttpServletResponse resp, @RequestParam String type, @RequestParam String params, @RequestParam String projectKey, @RequestParam String contextVars, @RequestParam(required=false, defaultValue="false") boolean listBuckets) throws Exception {
        AuthCtx authCtx;
        AbstractFSDatasetHandler.AbstractFSConfig config = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkReadProjectContentAllowed(authCtx);
            config = (AbstractFSDatasetHandler.AbstractFSConfig)JSON.parse((String)params, DatasetHandlerFactory.getParamsClass(type));
            DatasetInspector.checkDatasetConnectionPermission(config, authCtx, "browse");
            if (StringUtils.isBlank((String)config.path)) {
                config.path = "/";
            }
        }
        try {
            FSDatasetBrowseController.writeJSON((HttpServletResponse)resp, this.service.testConnection(authCtx, type, config, listBuckets));
            config = (AbstractFSDatasetHandler.AbstractFSConfig)JSON.parse((String)params, AbstractFSDatasetHandler.AbstractFSConfig.class);
            this.auditTrailService.generic("fsprovider-test").with("fsproviderType", type).with("connection", config.connection).with("providerPath", config.path).emit();
        }
        catch (Exception e) {
            config = (AbstractFSDatasetHandler.AbstractFSConfig)JSON.parse((String)params, AbstractFSDatasetHandler.AbstractFSConfig.class);
            this.auditTrailService.failure("fsprovider-test", (Throwable)e).with("fsproviderType", type).with("connection", config.connection).with("providerPath", config.path).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/fsproviders/fs-browse/"})
    public void browseFSProviderPath(HttpServletRequest req, HttpServletResponse resp, @RequestParam String type, @RequestParam String params, @RequestParam String path, @RequestParam String projectKey, @RequestParam String contextVars, @RequestParam(required=false, defaultValue="false") boolean isDirectory) throws Exception {
        AuthCtx authCtx;
        AbstractFSDatasetHandler.AbstractFSConfig config = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkReadProjectContentAllowed(authCtx);
            config = (AbstractFSDatasetHandler.AbstractFSConfig)JSON.parse((String)params, DatasetHandlerFactory.getParamsClass(type));
            DatasetInspector.checkDatasetConnectionPermission(config, authCtx, "browse");
            if (StringUtils.isBlank((String)config.path)) {
                config.path = "/";
            }
        }
        CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ComputeResourceUsageContext.forDatasetOrConnectionTesting((AuthCtx)authCtx, (String)projectKey, null));
        try {
            Map context = (Map)JSON.parse((String)contextVars, (TypeToken)new TypeToken<Map<String, String>>(){});
            FSProvider.FSBrowseStrategy strategy = isDirectory ? FSProvider.FSBrowseStrategy.DIRECTORY : FSProvider.FSBrowseStrategy.FILE_OR_DIRECTORY;
            FSDatasetBrowseController.writeJSON((HttpServletResponse)resp, (Object)this.service.browse(authCtx, type, config, path, projectKey, context, strategy));
            config = (AbstractFSDatasetHandler.AbstractFSConfig)JSON.parse((String)params, AbstractFSDatasetHandler.AbstractFSConfig.class);
            this.auditTrailService.generic("fsprovider-browse").with("fsproviderType", type).with("connection", config.connection).with("providerPath", config.path).with("browsePath", path).emit();
        }
        catch (Exception e) {
            config = (AbstractFSDatasetHandler.AbstractFSConfig)JSON.parse((String)params, AbstractFSDatasetHandler.AbstractFSConfig.class);
            this.auditTrailService.failure("fsprovider-browse", (Throwable)e).with("fsproviderType", type).with("connection", config.connection).with("providerPath", config.path).with("browsePath", path).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/fsproviders/list-files/"})
    public void listFSProviderFiles(HttpServletRequest req, HttpServletResponse resp, @RequestParam String type, @RequestParam String params, @RequestParam String projectKey, @RequestParam String contextVars, @RequestParam String selectionRules, @RequestParam boolean selectedOnly) throws Exception {
        VariablesExpansionLoopConfig veLoopConfig;
        AbstractFSDatasetHandler.AbstractFSConfig config;
        AuthCtx authCtx;
        Map context = (Map)JSON.parse((String)contextVars, (TypeToken)new TypeToken<Map<String, String>>(){});
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            this.licenseEnforcementService.checkReadProjectContentAllowed(authCtx);
            if ("FilesInFolder".equals(type)) {
                logger.info((Object)"Listing files on files-in-folder dataset");
                BuiltinFSDatasets.FilesInFolderConfig filesInFolderConfig = (BuiltinFSDatasets.FilesInFolderConfig)JSON.parse((String)params, BuiltinFSDatasets.FilesInFolderConfig.class);
                if (StringUtils.isBlank((String)filesInFolderConfig.folderSmartId)) {
                    throw new IllegalArgumentException("Folder not specified");
                }
                ManagedFolder folder = (ManagedFolder)this.managedFolderDAO.getMandatory(DatasetLocUtils.DatasetLoc.resolveSmart(projectKey, filesInFolderConfig.folderSmartId));
                type = folder.getType();
                logger.info((Object)("Listing files on provider type=" + type + " clazz=" + String.valueOf(DatasetHandlerFactory.getParamsClass(type))));
                config = folder.getParams();
                veLoopConfig = filesInFolderConfig.variablesExpansionLoopConfig;
                context.put("projectKey", folder.getProjectKey());
                context.put("odbId", folder.getId());
            } else {
                logger.info((Object)("Listing files on provider type=" + type + " clazz=" + String.valueOf(DatasetHandlerFactory.getParamsClass(type))));
                config = (AbstractFSDatasetHandler.AbstractFSConfig)JSON.parse((String)params, DatasetHandlerFactory.getParamsClass(type));
                veLoopConfig = config.variablesExpansionLoopConfig;
            }
            DatasetInspector.checkDatasetConnectionPermission(config, authCtx, "list-files");
            if (StringUtils.isBlank((String)config.path)) {
                config.path = "/";
            }
        }
        FilesSelectionRules selectionRulesObj = (FilesSelectionRules)JSON.parse((String)selectionRules, FilesSelectionRules.class);
        if (selectionRulesObj == null) {
            selectionRulesObj = new FilesSelectionRules();
        }
        CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ComputeResourceUsageContext.forDatasetOrConnectionTesting((AuthCtx)authCtx, (String)projectKey, null));
        FSDatasetBrowseController.writeJSON((HttpServletResponse)resp, (Object)this.service.listFiles(authCtx, type, config, projectKey, context, selectionRulesObj, veLoopConfig, selectedOnly));
        config = (AbstractFSDatasetHandler.AbstractFSConfig)JSON.parse((String)params, AbstractFSDatasetHandler.AbstractFSConfig.class);
        this.auditTrailService.generic("fsprovider-list").with("fsproviderType", type).with("connection", config.connection).with("providerPath", config.path).emit();
    }

    @AuditInline
    @RequestMapping(value={"/api/fsproviders/expand-selection-rules/"})
    public void expandSelectionRules(HttpServletRequest req, HttpServletResponse resp, @RequestParam String type, @RequestParam String params, @RequestParam String projectKey) throws Exception {
        AuthCtx authCtx;
        Class<? extends DatasetHandler.DatasetParams> clazz = DatasetHandlerFactory.getParamsClass(type);
        AbstractFSDatasetHandler.AbstractFSConfig config = (AbstractFSDatasetHandler.AbstractFSConfig)JSON.parse((String)params, clazz);
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            logger.infoV("Expanding selection rules on provider type=%s clazz=%s", new Object[]{type, clazz});
        }
        this.service.expandSelectionRulesInPlace(authCtx, config, projectKey);
        FSDatasetBrowseController.writeJSON((HttpServletResponse)resp, (Object)config.filesSelectionRules);
        VariablesExpansionLoopConfig veLoopConfig = config.variablesExpansionLoopConfig;
        this.auditTrailService.generic("fsprovider-expand-selection-rules").with("projectKey", projectKey).with("veLoopConfigDatasetRef", veLoopConfig != null && veLoopConfig.isEnabled() ? veLoopConfig.datasetRef : null).emit();
    }
}

