/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.datasets.renaming.code;

import com.dataiku.dip.server.datasets.renaming.code.CodeRenamer;
import com.dataiku.dip.server.datasets.renaming.code.RegexParser;
import com.dataiku.dip.server.datasets.renaming.code.WhitespaceParser;
import com.dataiku.dip.util.DatasetLocUtils;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public abstract class RegexCodeRenamer
implements CodeRenamer {
    private final String replacementHeader;
    private final RegexParser whitespaceParser = new WhitespaceParser();

    public RegexCodeRenamer(String oldContextProjectKey, String newContextProjectKey, DatasetLocUtils.DatasetLoc oldDataset, DatasetLocUtils.DatasetLoc newDataset, String user, Date date) {
        String oldDatasetName = oldDataset.getSmartName(oldContextProjectKey);
        String newDatasetName = newDataset.getSmartName(newContextProjectKey);
        this.replacementHeader = "# " + CodeRenamer.getReplacementMessage(oldDatasetName, newDatasetName, user, date);
    }

    public abstract List<RegexParser> getParsers();

    @Override
    public boolean requiresRenaming(String payload) {
        return this.updatePayload(payload, new StringBuilder(), true);
    }

    @Override
    public String updatePayload(String payload) {
        StringBuilder newPayload = new StringBuilder();
        this.updatePayload(payload, newPayload, false, true);
        return newPayload.toString();
    }

    public String updatePayload(String payload, boolean includeReplacementHeader) {
        StringBuilder newPayload = new StringBuilder();
        this.updatePayload(payload, newPayload, false, includeReplacementHeader);
        return newPayload.toString();
    }

    private boolean updatePayload(String payload, StringBuilder newPayload, boolean stopFirstOccurrence) {
        return this.updatePayload(payload, newPayload, stopFirstOccurrence, true);
    }

    private boolean updatePayload(String payload, StringBuilder newPayload, boolean stopFirstOccurrence, boolean includeReplacementHeader) {
        if (payload == null) {
            return false;
        }
        if (this.shouldSkipRenamingForPayload(payload)) {
            newPayload.append(payload);
            return false;
        }
        StringBuilder newStatement = new StringBuilder();
        boolean foundDatasetOccurrence = false;
        int i = 0;
        while (i < payload.length()) {
            String input = payload.substring(i);
            Optional<RegexParser> parser = this.getParsers().stream().filter(p -> p.matches(input)).findFirst();
            if (parser.isPresent()) {
                if (stopFirstOccurrence && (foundDatasetOccurrence |= parser.get().datasetReferences() > 0)) {
                    return true;
                }
                String match = parser.get().getMatch();
                newStatement.append(parser.get().getReplacement());
                i += match.length();
            } else {
                newStatement.append(payload.charAt(i));
                ++i;
            }
            if (payload.charAt(i - 1) != '\n' && i < payload.length()) continue;
            if (foundDatasetOccurrence) {
                foundDatasetOccurrence = false;
                if (includeReplacementHeader) {
                    if (this.whitespaceParser.matches(newStatement.toString())) {
                        newPayload.append(this.whitespaceParser.getReplacement());
                    }
                    newPayload.append(this.replacementHeader);
                }
            }
            newPayload.append((CharSequence)newStatement);
            newStatement.setLength(0);
        }
        return false;
    }
}

