/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.datasets.renaming.code.python;

import com.dataiku.dip.server.datasets.renaming.code.RegexParser;
import com.dataiku.dip.server.datasets.renaming.code.python.ImportedDataikuLibParser;
import com.dataiku.dip.server.datasets.renaming.code.python.ImportedDatasetFactoryParser;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class DatasetInstantiationParser
implements RegexParser {
    private final String datasetNameRegex;
    private final String datasetNameReplacement;
    private final List<Pattern> patterns;
    private final ImportedDataikuLibParser importedDataikuLibParser;
    private final ImportedDatasetFactoryParser importedDatasetFactoryParser;
    private boolean matchesImportedDataikuLibParser;
    private boolean matchesImportedDatasetFactoryParser;
    private Matcher matcher;
    private int count;

    public DatasetInstantiationParser(String datasetNameRegex, String datasetNameReplacement) {
        this.datasetNameRegex = datasetNameRegex;
        this.datasetNameReplacement = datasetNameReplacement;
        this.patterns = new ArrayList<Pattern>();
        this.importedDataikuLibParser = new ImportedDataikuLibParser();
        this.importedDatasetFactoryParser = new ImportedDatasetFactoryParser();
        this.compile();
    }

    private void compile() {
        Set<String> dataikuLibNames = this.importedDataikuLibParser.getLibNames();
        try (Formatter regexFormatter = new Formatter();){
            regexFormatter.format("^(\\s*+(?:\\\\(?:(?!%1$s)[^\\\\])*+)*+(?:%1$s)\\s*+\\\\?\\s*+\\.\\s*+\\\\?\\s*+%2$s\\s*+\\\\?\\s*+\\(\\s*+\\\\?\\s*+)(?:\"%3$s\"|'%3$s')([^\\)]*+\\))", String.join((CharSequence)"|", dataikuLibNames), "Dataset", this.datasetNameRegex);
            Pattern pattern = Pattern.compile(regexFormatter.toString());
            this.patterns.add(pattern);
        }
        Set<String> datasetFactoryNames = this.importedDatasetFactoryParser.getFactoryNames();
        if (!datasetFactoryNames.isEmpty()) {
            try (Formatter regexFormatter = new Formatter();){
                regexFormatter.format("^(\\s*+(?:\\\\(?:(?!(?:%1$s))[^\\\\])*+)*+\\s*+\\\\?\\s*+(?:%1$s)\\s*+\\\\?\\s*+\\(\\s*+\\\\?\\s*+)(?:\"%2$s\"|'%2$s')([^\\)]*+\\))", String.join((CharSequence)"|", datasetFactoryNames), this.datasetNameRegex);
                Pattern pattern = Pattern.compile(regexFormatter.toString());
                this.patterns.add(pattern);
            }
        }
    }

    @Override
    public boolean matches(String input) {
        this.matchesImportedDataikuLibParser = this.importedDataikuLibParser.matches(input);
        if (this.matchesImportedDataikuLibParser) {
            this.compile();
            return true;
        }
        this.matchesImportedDatasetFactoryParser = this.importedDatasetFactoryParser.matches(input);
        if (this.matchesImportedDatasetFactoryParser) {
            this.compile();
            return true;
        }
        for (Pattern pattern : this.patterns) {
            this.matcher = pattern.matcher(input);
            if (!this.matcher.find()) continue;
            ++this.count;
            return true;
        }
        return false;
    }

    @Override
    public String getMatch() {
        if (this.matchesImportedDataikuLibParser) {
            return this.importedDataikuLibParser.getMatch();
        }
        if (this.matchesImportedDatasetFactoryParser) {
            return this.importedDatasetFactoryParser.getMatch();
        }
        return this.matcher.group(0);
    }

    @Override
    public String getReplacement() {
        if (this.matchesImportedDataikuLibParser) {
            return this.importedDataikuLibParser.getReplacement();
        }
        if (this.matchesImportedDatasetFactoryParser) {
            return this.importedDatasetFactoryParser.getReplacement();
        }
        return this.matcher.pattern().matcher(this.matcher.group(0)).replaceFirst(this.datasetNameReplacement);
    }

    @Override
    public int datasetReferences() {
        return this.count;
    }
}

