/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.code.JupyterCodeEnvUtils;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.GitReferencesService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.JupyterUtils;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.FileFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JupyterCRUDService {
    @Autowired
    GitReferencesService gitReferencesService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.jupyterCrudService");

    public JupyterUtils.JupyterNotebookListEntry getOrNullUnsafe(String projectKey, String notebookName) throws IOException {
        return this.get(projectKey, notebookName, this.getNotebookFile(projectKey, notebookName), true, true, false);
    }

    public JupyterUtils.JupyterNotebookListEntry getOrNull(String projectKey, String notebookName) throws IOException {
        return this.get(projectKey, notebookName, this.getNotebookFile(projectKey, notebookName), false, true, false);
    }

    public JupyterUtils.JupyterNotebookListEntry getOrNullWithGitInformation(String projectKey, String notebookName) throws IOException {
        return this.get(projectKey, notebookName, this.getNotebookFile(projectKey, notebookName), false, true, true);
    }

    public JupyterUtils.JupyterNotebookListEntry getMandatoryUnsafe(String projectKey, String notebookName, boolean withGitInformation) throws IOException {
        return this.get(projectKey, notebookName, this.getNotebookFile(projectKey, notebookName), true, false, withGitInformation);
    }

    public JupyterUtils.JupyterNotebookListEntry getMandatory(String projectKey, String notebookName, boolean withGitInformation) throws IOException {
        return this.get(projectKey, notebookName, this.getNotebookFile(projectKey, notebookName), false, false, withGitInformation);
    }

    public JupyterUtils.JupyterNotebookListEntry get(String projectKey, String notebookName, RelFile notebookFile, boolean unsafe, boolean supportNull, boolean withGitInformation) throws IOException {
        JupyterUtils.NotebookSafeForWritingNew nb;
        TransactionRef t = TransactionContext.retrieveRead();
        JupyterUtils.JupyterNotebookListEntry jupyterNbk = new JupyterUtils.JupyterNotebookListEntry();
        jupyterNbk.projectKey = projectKey;
        jupyterNbk.name = StringUtils.removeEnd((String)notebookFile.getLeafName(), (String)".ipynb");
        logger.trace(() -> "Loading notebook file: " + jupyterNbk.name);
        try {
            nb = unsafe ? (JupyterUtils.NotebookSafeForWritingNew)t.readObjectUnsafe(notebookFile, JupyterUtils.NotebookSafeForWritingNew.class) : (JupyterUtils.NotebookSafeForWritingNew)t.readObject(notebookFile, JupyterUtils.NotebookSafeForWritingNew.class);
        }
        catch (IOException e) {
            if (supportNull) {
                return null;
            }
            throw new NotFoundException(ITaggingService.TaggableType.JUPYTER_NOTEBOOK.name() + " does not exist: " + projectKey + "." + notebookName, (Throwable)e);
        }
        try {
            jupyterNbk.associatedRecipe = JupyterUtils.getAssociatedRecipe(nb);
            jupyterNbk.analyzedDataset = JupyterUtils.getAssociatedDataset(nb);
            JupyterUtils.JupyterKernelSpecInNotebook specInfo = JupyterUtils.getKernelSpecInfo(nb);
            if (specInfo == null) {
                jupyterNbk.language = "unknown";
                jupyterNbk.displayKernelSpec = null;
            } else {
                JupyterUtils.DisplayKernelSpec ks = new JupyterUtils.DisplayKernelSpec();
                ks.name = specInfo.name;
                jupyterNbk.language = JupyterCodeEnvUtils.getLanguageFromKernelName(StringUtils.defaultIfBlank((String)specInfo.name, (String)"unknown"));
                jupyterNbk.displayKernelSpec = ks;
            }
            jupyterNbk.creator = JupyterUtils.getCreator(nb);
            if (jupyterNbk.creator != null) {
                jupyterNbk.creationTag = new VersionTag(jupyterNbk.creator, JupyterUtils.safeGetMetadataLong(nb, "createdOn"), 0L);
            }
            jupyterNbk.lastModifiedOn = t.getLastModified(notebookFile);
            jupyterNbk.lastGitInteraction = JupyterUtils.getLastGitInteraction(nb);
            JupyterUtils.setCreationTag(nb, jupyterNbk);
            JupyterUtils.setVersionTag(nb, jupyterNbk);
            TaggableObjectsService.TaggableObjectMetadata md = this.getMetadata(projectKey, notebookName);
            jupyterNbk.description = md.description;
            jupyterNbk.tags = md.tags;
            jupyterNbk.shortDesc = md.shortDesc;
            jupyterNbk.automationLocal = JupyterUtils.isAutomationLocal(nb);
            jupyterNbk.customFields = md.customFields;
            if (withGitInformation) {
                this.enrichWithGitInformation(jupyterNbk, nb);
            }
            return jupyterNbk;
        }
        catch (IOException e) {
            logger.error((Object)("Failed to read notebook: " + jupyterNbk.name), (Throwable)e);
            throw new IOException("Failed to read notebook: " + jupyterNbk.name);
        }
    }

    private void enrichWithGitInformation(JupyterUtils.JupyterNotebookListEntry jupyterNbk, JupyterUtils.NotebookSafeForWritingNew nb) {
        JsonObject dkuMetadata;
        if (nb.metadata != null && nb.metadata.has("dkuGit") && nb.metadata.get("dkuGit") != null && nb.metadata.get("dkuGit").isJsonObject() && (dkuMetadata = nb.metadata.getAsJsonObject("dkuGit")).has("gitReference") && dkuMetadata.get("gitReference") != null && dkuMetadata.get("gitReference").isJsonObject()) {
            jupyterNbk.gitReference = this.gitReferencesService.decryptProjectGitReference((GitModel.GitReference)JSON.parse((JsonElement)dkuMetadata.getAsJsonObject("gitReference"), GitModel.GitReference.class));
        }
    }

    public List<JupyterUtils.JupyterNotebookListEntry> list(String projectKey) throws IOException {
        return this.list(projectKey, false, false);
    }

    public List<JupyterUtils.JupyterNotebookListEntry> listWithGitInformation(String projectKey) throws IOException {
        return this.list(projectKey, false, true);
    }

    public List<JupyterUtils.JupyterNotebookListEntry> listSimple(String projectKey) throws IOException {
        return this.list(projectKey, false, false);
    }

    public List<JupyterUtils.JupyterNotebookListEntry> listUnsafe(String projectKey) throws IOException {
        return this.list(projectKey, true, false);
    }

    public List<JupyterUtils.JupyterNotebookListEntry> listUnsafeWithGitInformation(String projectKey) throws IOException {
        return this.list(projectKey, true, true);
    }

    private List<JupyterUtils.JupyterNotebookListEntry> list(String projectKey, boolean unsafe, boolean withGitInformation) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        ArrayList<JupyterUtils.JupyterNotebookListEntry> ret = new ArrayList<JupyterUtils.JupyterNotebookListEntry>();
        RelFile notebooksFolder = this.getNotebooksDir(projectKey);
        if (!t.exists(notebooksFolder)) {
            return ret;
        }
        for (RelFile notebookFile : t.listFiles(notebooksFolder, (RelFileFilter)new FileFilter("ipynb"))) {
            JupyterUtils.JupyterNotebookListEntry jupyterNbk = new JupyterUtils.JupyterNotebookListEntry();
            jupyterNbk.projectKey = projectKey;
            jupyterNbk.name = StringUtils.removeEnd((String)notebookFile.getLeafName(), (String)".ipynb");
            try {
                logger.trace(() -> "Loading notebook file: " + jupyterNbk.name);
                JupyterUtils.NotebookSafeForWritingNew nb = unsafe ? (JupyterUtils.NotebookSafeForWritingNew)t.readObjectUnsafe(notebookFile, JupyterUtils.NotebookSafeForWritingNew.class) : (JupyterUtils.NotebookSafeForWritingNew)t.readObject(notebookFile, JupyterUtils.NotebookSafeForWritingNew.class);
                jupyterNbk.associatedRecipe = JupyterUtils.getAssociatedRecipe(nb);
                jupyterNbk.analyzedDataset = JupyterUtils.getAssociatedDataset(nb);
                JupyterUtils.JupyterKernelSpecInNotebook specInfo = JupyterUtils.getKernelSpecInfo(nb);
                if (specInfo == null) {
                    jupyterNbk.language = "unknown";
                    jupyterNbk.displayKernelSpec = null;
                } else {
                    JupyterUtils.DisplayKernelSpec ks = new JupyterUtils.DisplayKernelSpec();
                    ks.name = specInfo.name;
                    jupyterNbk.language = JupyterCodeEnvUtils.getLanguageFromKernelName(StringUtils.defaultIfBlank((String)specInfo.name, (String)"unknown"));
                    jupyterNbk.displayKernelSpec = ks;
                }
                jupyterNbk.creator = JupyterUtils.getCreator(nb);
                if (jupyterNbk.creator != null) {
                    jupyterNbk.creationTag = new VersionTag(jupyterNbk.creator, JupyterUtils.safeGetMetadataLong(nb, "createdOn"), 0L);
                }
                jupyterNbk.lastModifiedOn = t.getLastModified(notebookFile);
                jupyterNbk.lastGitInteraction = JupyterUtils.getLastGitInteraction(nb);
                JupyterUtils.setCreationTag(nb, jupyterNbk);
                JupyterUtils.setVersionTag(nb, jupyterNbk);
                TaggableObjectsService.TaggableObjectMetadata md = this.getMetadata(jupyterNbk.projectKey, jupyterNbk.name);
                jupyterNbk.tags = md.tags;
                jupyterNbk.description = md.description;
                jupyterNbk.shortDesc = md.shortDesc;
                jupyterNbk.automationLocal = JupyterUtils.isAutomationLocal(nb);
                jupyterNbk.customFields = md.customFields;
                if (withGitInformation) {
                    this.enrichWithGitInformation(jupyterNbk, nb);
                }
                ret.add(jupyterNbk);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to read notebook: " + jupyterNbk.name), (Throwable)e);
            }
        }
        return ret;
    }

    public boolean exists(String projectKey, String id) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        return t.isFile(this.getNotebookFile(projectKey, id));
    }

    public RelFile getNotebooksDir(String projectKey) {
        return JupyterUtils.getNotebooksDir(JupyterUtils.getProjectRootDir(projectKey));
    }

    public TaggableObjectsService.TaggableObjectMetadata getMetadata(String projectKey, String name) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        RelFile f = this.getNotebookFile(projectKey, name);
        JupyterUtils.NotebookSafeForWritingNew nb = (JupyterUtils.NotebookSafeForWritingNew)t.readObjectUnsafe(f, JupyterUtils.NotebookSafeForWritingNew.class);
        TaggableObjectsService.TaggableObjectMetadata md = new TaggableObjectsService.TaggableObjectMetadata();
        md.tags = this.getTags(f);
        md.shortDesc = JupyterUtils.safeGetMetadataStr(nb, "shortdesc");
        md.description = JupyterUtils.safeGetMetadataStr(nb, "description");
        md.customFields = JupyterUtils.safeGetMetadataJsonObject(nb, "customFields");
        return md;
    }

    public List<String> getTags(String projectKey, String name) throws IOException {
        RelFile f = this.getNotebookFile(projectKey, name);
        return this.getTags(f);
    }

    public List<String> getTags(RelFile nbkFile) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        ArrayList<String> tags = new ArrayList<String>();
        JupyterUtils.NotebookSafeForWritingNew nb = (JupyterUtils.NotebookSafeForWritingNew)t.readObjectUnsafe(nbkFile, JupyterUtils.NotebookSafeForWritingNew.class);
        return JupyterUtils.readTagMetadata(nb, tags);
    }

    public RelFile getNotebookFile(String projectKey, String name) {
        return JupyterCRUDService.getNotebookFile(JupyterUtils.getProjectRootDir(projectKey), name);
    }

    public static RelFile getNotebookFile(RelFile projectRootDir, String name) {
        List<String> path = Arrays.asList(name.split("/"));
        path.set(path.size() - 1, path.get(path.size() - 1) + ".ipynb");
        return JupyterUtils.getNotebooksDir(projectRootDir).append(path.toArray(new String[0]));
    }
}

