/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.activity.JobsReportBuilder;
import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.JobState;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.dataquality.DataQualityOutcome;
import com.dataiku.dip.dataquality.DataQualityRule;
import com.dataiku.dip.dataquality.DataQualityRunOrigin;
import com.dataiku.dip.dataquality.UIRuleHistory;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.jobsdb.JobsdbDatasetParams;
import com.dataiku.dip.db.AbstractDSSDBService;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.pivot.backend.sql.utils.QueryUtils;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.ProjectRunsSummary;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunKey;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.triggers.Trigger;
import com.dataiku.dip.scheduler.triggers.TriggerFire;
import com.dataiku.dip.server.services.FlowExecutionService2;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.sql.queries.SimpleSelectQueryBuilder;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.ObjectArrays;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.text.StringSubstitutor;

public class ReadOnlyJobsInternalDB
extends AbstractDSSDBService {
    public static final String DB_NAME = "jobs";
    private static final int SCHEMA_VERSION = 17;
    public static final String NULL_AS_STRING = "__null__";
    static final String NOT_PARTITIONED = "NP";
    private String fromScenarioWithTriggerFire = "";
    static final ExpressionBuilder.ExpressionBuilderFactory EBF = new ExpressionBuilder.ExpressionBuilderFactory();
    public static final String PARTITION_COLUMN = "PARTITION";
    public static final String PROJECT_KEY_COLUMN = "PROJECT_KEY";
    public static final String OBJECT_ID_COLUMN = "OBJECT_ID";
    public static final String TIME_COMPUTE_COLUMN = "TIME_COMPUTE";
    public static final String JOB_TABLE = "JOB";
    public static final String JOB_PROJECT_KEY_COLUMN = "JOB_PROJECT_KEY";
    private static final SchemaColumn JOB_PROJECT_KEY_SCHEMA_COLUMN = new SchemaColumn("JOB_PROJECT_KEY", Type.STRING);
    static final String STATE_COLUMN = "STATE";
    private static final SchemaColumn STATE_SCHEMA_COLUMN = new SchemaColumn("STATE", Type.STRING);
    public static final String SCENARIO_RUNS_TABLE = "SCENARIO_RUNS";
    public static final String TRIGGER_FIRES_TABLE = "TRIGGER_FIRES";
    public static final String STEP_RUNS_TABLE = "STEP_RUNS";
    public static final String FLOW_OBJECT_ACTION_TABLE = "FLOW_OBJECT_ACTION";
    public static final String FLOW_OBJECT_ACTION_HISTORY_TABLE = "FLOW_OBJECT_ACTION_HISTORY";
    public static final String METRICS_SESSIONS_TABLE = "METRICS_SESSIONS";
    public static final String METRICS_HISTORY_TABLE = "METRICS_HISTORY";
    public static final String METRICS_LAST_TABLE = "METRICS_LAST";
    public static final String SESSION_INDEX_COLUMN = "SESSION_INDEX";
    public static final String METRIC_ID_COLUMN = "METRIC_ID";
    public static final String CHECKS_SESSIONS_TABLE = "CHECKS_SESSIONS";
    public static final String CHECKS_HISTORY_TABLE = "CHECKS_HISTORY";
    public static final String CHECKS_LAST_TABLE = "CHECKS_LAST";
    public static final String NAME_COLUMN = "NAME";
    static final String FLOW_OBJECT_ACTION_NULLS_TABLE = "FLOW_OBJECT_ACTION_NULLS";
    static final String METRICS_LAST_NULLS_TABLE = "METRICS_LAST_NULLS";
    static final String CHECKS_LAST_NULLS_TABLE = "CHECKS_LAST_NULLS";
    private static final String DELETED_COLUMN = "DELETED";
    static final String STABLE_STATE_COLUMN = "STABLE_STATE";
    static final String RESULT_COLUMN = "RESULT";
    static final SchemaColumn DELETED_SCHEMA_COLUMN = new SchemaColumn("DELETED", Type.BOOLEAN);
    private static final String VALUE_TYPE_COLUMN = "VALUE_TYPE";
    private static final String VALUE_COLUMN = "VALUE";
    private static final String HASH_COLUMN = "HASH";
    static final String JOB_ID_COLUMN = "JOB_ID";
    static final String TIME_START_COLUMN = "TIME_START";
    static final SchemaColumn TIME_START_SCHEMA_COLUMN = new SchemaColumn("TIME_START", Type.BIGINT);
    public static final String TIME_END_COLUMN = "TIME_END";
    static final String OUTCOME_COLUMN = "OUTCOME";
    static final String WARNINGS_COUNT_COLUMN = "WARNINGS_COUNT";
    static final String TYPE_COLUMN = "TYPE";
    private static final String CHECK_JSON_COLUMN = "CHECK_JSON";
    private static final String MESSAGE_COLUMN = "MESSAGE";
    protected static final String RUN_ORIGIN_COLUMN = "RUN_ORIGIN";
    private static final String JOB_DEF_COLUMN = "JOB_DEF";
    static final String ACTIVITY_ID_COLUMN = "ACTIVITY_ID";
    public static final String SCENARIO_PROJECT_KEY_COLUMN = "SCENARIO_PROJECT_KEY";
    static final String SCENARIO_ID_COLUMN = "SCENARIO_ID";
    static final String SCENARIO_RUN_ID_COLUMN = "SCENARIO_RUN_ID";
    static final String STEP_RUN_ID_COLUMN = "STEP_RUN_ID";
    public static final String STEP_ID_COLUMN = "STEP_ID";
    public static final String TRIGGER_ID_COLUMN = "TRIGGER_ID";
    public static final String TRIGGER_RUN_ID_COLUMN = "TRIGGER_RUN_ID";
    private static final String RUN_AS_USER_IDENTIFIER_COLUMN = "RUN_AS_USER_IDENTIFIER";
    private static final String RUN_AS_USER_VIA_COLUMN = "RUN_AS_USER_VIA";
    static final String SCENARIO_COLUMN = "SCENARIO";
    static final SchemaColumn SCENARIO_SCHEMA_COLUMN = new SchemaColumn("SCENARIO", Type.STRING);
    static final String VARIABLES_COLUMN = "VARIABLES";
    public static final String TIME_TRIGGER_COLUMN = "TIME_TRIGGER";
    private static final String TRIGGER_STATE_COLUMN = "TRIGGER_STATE";
    private static final String CANCELLED_COLUMN = "CANCELLED";
    private static final String TRIGGER_PARAMS_COLUMN = "TRIGGER_PARAMS";
    private static final String TRIGGER_COLUMN = "TRIGGER";
    static final String STEP_COLUMN = "STEP";
    static final String BUNDLE_ID = "BUNDLE_ID";
    static final String MARKED_AS_TEST = "MARKED_AS_TEST";
    public static final String SCENARIO_RUNS_PRJ_ID_BEGIN_END_IDX = "scenario_runs_prj_id_begin_end_idx";
    private final List<String> scenarioRunShortVersionIgnoredColumns = Arrays.asList("SCENARIO", "RESULT", "VARIABLES");
    public static final String DATA_QUALITY_PARTITION_HISTORY_TABLE = "DATA_QUALITY_PARTITION_HISTORY";
    public static final String DATA_QUALITY_PARTITION_LAST_TABLE = "DATA_QUALITY_PARTITION_LAST";
    public static final String DATA_QUALITY_OBJECT_HISTORY_TABLE = "DATA_QUALITY_OBJECT_HISTORY";
    public static final String DATA_QUALITY_OBJECT_LAST_TABLE = "DATA_QUALITY_OBJECT_LAST";
    public static final String DATA_QUALITY_PROJECT_HISTORY_TABLE = "DATA_QUALITY_PROJECT_HISTORY";
    public static final String DATA_QUALITY_PROJECT_LAST_TABLE = "DATA_QUALITY_PROJECT_LAST";
    static final String ERROR_COUNT_COLUMN = "ERROR_COUNT";
    static final String WARNING_COUNT_COLUMN = "WARNING_COUNT";
    static final String OK_COUNT_COLUMN = "OK_COUNT";
    static final String EMPTY_COUNT_COLUMN = "EMPTY_COUNT";
    static final String WORST_ERROR_COUNT_COLUMN = "WORST_ERROR_COUNT";
    static final String WORST_WARNING_COUNT_COLUMN = "WORST_WARNING_COUNT";
    static final String WORST_OK_COUNT_COLUMN = "WORST_OK_COUNT";
    static final String WORST_EMPTY_COUNT_COLUMN = "WORST_EMPTY_COUNT";
    static final String COMPUTED_RULES_COLUMN = "COMPUTED_RULES";
    static final String OBJECT_HISTORY_REFS_COLUMN = "OBJECT_HISTORY_REFS";
    static final String DISPLAY_NAME_COLUMN = "DATASET_DISPLAY_NAME";
    static final String WORST_MONITORED_OUTCOME_COLUMN = "WORST_MONITORED_OUTCOME";
    static final String MONITORED_COLUMN = "MONITORED";
    static final String DAY_COLUMN = "DAY";
    static final String UPDATE_TIME_COLUMN = "UPDATE_TIME";
    public static final String LAST_RULE_COMPUTE_TIME_COLUMN = "LAST_RULE_COMPUTE_TIME";
    static final SchemaColumn[] DATA_QUALITY_PARTITION_HISTORY_KEY_COLUMNS = new SchemaColumn[]{new SchemaColumn("PROJECT_KEY", Type.STRING), new SchemaColumn("OBJECT_ID", Type.STRING), new SchemaColumn("PARTITION", Type.STRING), new SchemaColumn("DAY", Type.BIGINT)};
    static final SchemaColumn[] DATA_QUALITY_PARTITION_HISTORY_DATA_COLUMNS = new SchemaColumn[]{new SchemaColumn("ERROR_COUNT", Type.INT), new SchemaColumn("WARNING_COUNT", Type.INT), new SchemaColumn("OK_COUNT", Type.INT), new SchemaColumn("EMPTY_COUNT", Type.INT), new SchemaColumn("WORST_ERROR_COUNT", Type.INT), new SchemaColumn("WORST_WARNING_COUNT", Type.INT), new SchemaColumn("WORST_OK_COUNT", Type.INT), new SchemaColumn("WORST_EMPTY_COUNT", Type.INT), new SchemaColumn("COMPUTED_RULES", Type.STRING), new SchemaColumn("LAST_RULE_COMPUTE_TIME", Type.BIGINT)};
    static final SchemaColumn[] DATA_QUALITY_PARTITION_LAST_KEY_COLUMNS = new SchemaColumn[]{new SchemaColumn("PROJECT_KEY", Type.STRING), new SchemaColumn("OBJECT_ID", Type.STRING), new SchemaColumn("PARTITION", Type.STRING)};
    static final SchemaColumn[] DATA_QUALITY_PARTITION_LAST_DATA_COLUMNS = new SchemaColumn[]{new SchemaColumn("UPDATE_TIME", Type.BIGINT), new SchemaColumn("ERROR_COUNT", Type.INT), new SchemaColumn("WARNING_COUNT", Type.INT), new SchemaColumn("OK_COUNT", Type.INT), new SchemaColumn("EMPTY_COUNT", Type.INT), new SchemaColumn("WORST_ERROR_COUNT", Type.INT), new SchemaColumn("WORST_WARNING_COUNT", Type.INT), new SchemaColumn("WORST_OK_COUNT", Type.INT), new SchemaColumn("WORST_EMPTY_COUNT", Type.INT), new SchemaColumn("LAST_RULE_COMPUTE_TIME", Type.BIGINT)};
    static final SchemaColumn[] DATA_QUALITY_OBJECT_HISTORY_KEY_COLUMNS = new SchemaColumn[]{new SchemaColumn("PROJECT_KEY", Type.STRING), new SchemaColumn("OBJECT_ID", Type.STRING), new SchemaColumn("DAY", Type.BIGINT)};
    static final SchemaColumn[] DATA_QUALITY_OBJECT_HISTORY_DATA_COLUMNS = new SchemaColumn[]{new SchemaColumn("ERROR_COUNT", Type.INT), new SchemaColumn("WARNING_COUNT", Type.INT), new SchemaColumn("OK_COUNT", Type.INT), new SchemaColumn("EMPTY_COUNT", Type.INT), new SchemaColumn("WORST_ERROR_COUNT", Type.INT), new SchemaColumn("WORST_WARNING_COUNT", Type.INT), new SchemaColumn("WORST_OK_COUNT", Type.INT), new SchemaColumn("WORST_EMPTY_COUNT", Type.INT), new SchemaColumn("MONITORED", Type.BOOLEAN), new SchemaColumn("DELETED", Type.BOOLEAN), new SchemaColumn("LAST_RULE_COMPUTE_TIME", Type.BIGINT)};
    static final SchemaColumn[] DATA_QUALITY_OBJECT_LAST_KEY_COLUMNS = new SchemaColumn[]{new SchemaColumn("PROJECT_KEY", Type.STRING), new SchemaColumn("OBJECT_ID", Type.STRING)};
    static final SchemaColumn[] DATA_QUALITY_OBJECT_LAST_DATA_COLUMNS = new SchemaColumn[]{new SchemaColumn("UPDATE_TIME", Type.BIGINT), new SchemaColumn("ERROR_COUNT", Type.INT), new SchemaColumn("WARNING_COUNT", Type.INT), new SchemaColumn("OK_COUNT", Type.INT), new SchemaColumn("EMPTY_COUNT", Type.INT), new SchemaColumn("WORST_ERROR_COUNT", Type.INT), new SchemaColumn("WORST_WARNING_COUNT", Type.INT), new SchemaColumn("WORST_OK_COUNT", Type.INT), new SchemaColumn("WORST_EMPTY_COUNT", Type.INT), new SchemaColumn("WORST_MONITORED_OUTCOME", Type.STRING), new SchemaColumn("DATASET_DISPLAY_NAME", Type.STRING), new SchemaColumn("DELETED", Type.BOOLEAN), new SchemaColumn("LAST_RULE_COMPUTE_TIME", Type.BIGINT)};
    static final SchemaColumn[] DATA_QUALITY_PROJECT_HISTORY_KEY_COLUMNS = new SchemaColumn[]{new SchemaColumn("PROJECT_KEY", Type.STRING), new SchemaColumn("DAY", Type.BIGINT)};
    static final SchemaColumn[] DATA_QUALITY_PROJECT_HISTORY_DATA_COLUMNS = new SchemaColumn[]{new SchemaColumn("ERROR_COUNT", Type.INT), new SchemaColumn("WARNING_COUNT", Type.INT), new SchemaColumn("OK_COUNT", Type.INT), new SchemaColumn("EMPTY_COUNT", Type.INT), new SchemaColumn("WORST_ERROR_COUNT", Type.INT), new SchemaColumn("WORST_WARNING_COUNT", Type.INT), new SchemaColumn("WORST_OK_COUNT", Type.INT), new SchemaColumn("WORST_EMPTY_COUNT", Type.INT), new SchemaColumn("OBJECT_HISTORY_REFS", Type.STRING), new SchemaColumn("LAST_RULE_COMPUTE_TIME", Type.BIGINT)};
    static final SchemaColumn[] DATA_QUALITY_PROJECT_LAST_KEY_COLUMNS = new SchemaColumn[]{new SchemaColumn("PROJECT_KEY", Type.STRING)};
    static final SchemaColumn[] DATA_QUALITY_PROJECT_LAST_DATA_COLUMNS = new SchemaColumn[]{new SchemaColumn("UPDATE_TIME", Type.BIGINT), new SchemaColumn("ERROR_COUNT", Type.INT), new SchemaColumn("WARNING_COUNT", Type.INT), new SchemaColumn("OK_COUNT", Type.INT), new SchemaColumn("EMPTY_COUNT", Type.INT), new SchemaColumn("WORST_ERROR_COUNT", Type.INT), new SchemaColumn("WORST_WARNING_COUNT", Type.INT), new SchemaColumn("WORST_OK_COUNT", Type.INT), new SchemaColumn("WORST_EMPTY_COUNT", Type.INT), new SchemaColumn("LAST_RULE_COMPUTE_TIME", Type.BIGINT)};
    private Map<String, String> lastTriggerStateCache = new HashMap<String, String>();
    SchemaColumn[] jobIdColumns = new SchemaColumn[]{JOB_PROJECT_KEY_SCHEMA_COLUMN, new SchemaColumn("JOB_ID", Type.STRING)};
    SchemaColumn[] activityIdColumns = new SchemaColumn[]{this.jobIdColumns[0], this.jobIdColumns[1], new SchemaColumn("ACTIVITY_ID", Type.STRING)};
    SchemaColumn[] jobInfoColumns = new SchemaColumn[]{new SchemaColumn("STABLE_STATE", Type.BOOLEAN), STATE_SCHEMA_COLUMN, new SchemaColumn("WARNINGS_COUNT", Type.INT), new SchemaColumn("JOB_DEF", Type.STRING)};
    SchemaColumn[] scenarioIdColumns = new SchemaColumn[]{new SchemaColumn("SCENARIO_PROJECT_KEY", Type.STRING), new SchemaColumn("SCENARIO_ID", Type.STRING)};
    SchemaColumn[] scenarioRunIdColumns = new SchemaColumn[]{this.scenarioIdColumns[0], this.scenarioIdColumns[1], new SchemaColumn("SCENARIO_RUN_ID", Type.STRING)};
    SchemaColumn[] stepIdColumns = new SchemaColumn[]{new SchemaColumn("STEP_ID", Type.STRING), new SchemaColumn("STEP_RUN_ID", Type.STRING)};
    SchemaColumn[] triggerIdColumns = new SchemaColumn[]{new SchemaColumn("TRIGGER_ID", Type.STRING), new SchemaColumn("TRIGGER_RUN_ID", Type.STRING)};
    SchemaColumn[] actionTimeColumns = new SchemaColumn[]{TIME_START_SCHEMA_COLUMN, new SchemaColumn("TIME_END", Type.BIGINT)};
    private SchemaColumn[] outcomeColumns = new SchemaColumn[]{new SchemaColumn("OUTCOME", Type.STRING), new SchemaColumn("WARNINGS_COUNT", Type.INT)};
    SchemaColumn[] actionOutcomeColumns = new SchemaColumn[]{this.outcomeColumns[0], this.outcomeColumns[1], new SchemaColumn("RESULT", Type.STRING)};
    SchemaColumn[] scenarioRunUserColumns = new SchemaColumn[]{new SchemaColumn("RUN_AS_USER_IDENTIFIER", Type.STRING), new SchemaColumn("RUN_AS_USER_VIA", Type.STRING)};
    SchemaColumn[] scenarioBundleAndTestColumns = new SchemaColumn[]{new SchemaColumn("BUNDLE_ID", Type.STRING), new SchemaColumn("MARKED_AS_TEST", Type.BOOLEAN)};
    SchemaColumn[] scenarioRunInfoColumns = new SchemaColumn[]{SCENARIO_SCHEMA_COLUMN, new SchemaColumn("VARIABLES", Type.STRING), this.triggerIdColumns[0], this.triggerIdColumns[1], this.scenarioRunUserColumns[0], this.scenarioRunUserColumns[1]};
    SchemaColumn[] scenarioRunInfoWithoutScenarioColumns = new SchemaColumn[]{new SchemaColumn("VARIABLES", Type.STRING), this.triggerIdColumns[0], this.triggerIdColumns[1], this.scenarioRunUserColumns[0], this.scenarioRunUserColumns[1]};
    SchemaColumn[] triggerInfoColumns = new SchemaColumn[]{new SchemaColumn("TIME_TRIGGER", Type.BIGINT), new SchemaColumn("TRIGGER_STATE", Type.STRING), new SchemaColumn("TRIGGER_PARAMS", Type.STRING), new SchemaColumn("CANCELLED", Type.BOOLEAN), new SchemaColumn("TRIGGER", Type.STRING)};
    SchemaColumn[] stepInfoColumns = new SchemaColumn[]{new SchemaColumn("STEP", Type.STRING)};
    SchemaColumn[] objectIdColumns = new SchemaColumn[]{new SchemaColumn("PROJECT_KEY", Type.STRING), new SchemaColumn("OBJECT_ID", Type.STRING)};
    SchemaColumn[] objectPartitionIdColumns = new SchemaColumn[]{this.objectIdColumns[0], this.objectIdColumns[1], new SchemaColumn("PARTITION", Type.STRING)};
    SchemaColumn[] objectDenormalizedColumns = new SchemaColumn[]{new SchemaColumn("TYPE", Type.STRING)};
    SchemaColumn[] metricsSessionColumns = new SchemaColumn[]{new SchemaColumn("SESSION_INDEX", Type.INT), new SchemaColumn("PROJECT_KEY", Type.STRING), new SchemaColumn("OBJECT_ID", Type.STRING), new SchemaColumn("PARTITION", Type.STRING), new SchemaColumn("TIME_COMPUTE", Type.BIGINT), new SchemaColumn("HASH", Type.STRING)};
    SchemaColumn[] metricsDataColumns = new SchemaColumn[]{new SchemaColumn("METRIC_ID", Type.STRING), new SchemaColumn("VALUE_TYPE", Type.STRING), new SchemaColumn("VALUE", Type.STRING)};
    SchemaColumn[] metricsColumns = new SchemaColumn[]{new SchemaColumn("SESSION_INDEX", Type.INT), this.metricsDataColumns[0], this.metricsDataColumns[1], this.metricsDataColumns[2]};
    protected SchemaColumn[] checksSessionColumnsLegacyBeforeV15 = new SchemaColumn[]{new SchemaColumn("SESSION_INDEX", Type.INT), new SchemaColumn("PROJECT_KEY", Type.STRING), new SchemaColumn("OBJECT_ID", Type.STRING), new SchemaColumn("PARTITION", Type.STRING), new SchemaColumn("TIME_COMPUTE", Type.BIGINT)};
    SchemaColumn runOriginColumn = new SchemaColumn("RUN_ORIGIN", Type.STRING);
    SchemaColumn[] checksSessionColumns = (SchemaColumn[])ObjectArrays.concat((Object[])this.checksSessionColumnsLegacyBeforeV15, (Object)this.runOriginColumn);
    SchemaColumn[] checksDataColumns = new SchemaColumn[]{new SchemaColumn("NAME", Type.STRING), new SchemaColumn("CHECK_JSON", Type.STRING), new SchemaColumn("OUTCOME", Type.STRING), new SchemaColumn("MESSAGE", Type.STRING)};
    SchemaColumn[] checksColumns = new SchemaColumn[]{new SchemaColumn("SESSION_INDEX", Type.INT), this.checksDataColumns[0], this.checksDataColumns[1], this.checksDataColumns[2], this.checksDataColumns[3]};
    public static final List<String> TABLES = ImmutableList.of((Object)"JOB", (Object)"SCENARIO_RUNS", (Object)"TRIGGER_FIRES", (Object)"STEP_RUNS", (Object)"FLOW_OBJECT_ACTION", (Object)"FLOW_OBJECT_ACTION_HISTORY", (Object)"METRICS_SESSIONS", (Object)"METRICS_HISTORY", (Object)"METRICS_LAST", (Object)"CHECKS_SESSIONS", (Object)"CHECKS_HISTORY", (Object)"CHECKS_LAST", (Object[])new String[]{"DATA_QUALITY_PARTITION_LAST", "DATA_QUALITY_PARTITION_HISTORY", "DATA_QUALITY_OBJECT_LAST", "DATA_QUALITY_OBJECT_HISTORY", "DATA_QUALITY_PROJECT_HISTORY", "DATA_QUALITY_PROJECT_LAST"});
    private static final SchemaColumn[] jobsViewColumns = new SchemaColumn[]{new SchemaColumn("JOB_PROJECT_KEY", Type.STRING), new SchemaColumn("JOB_ID", Type.STRING), new SchemaColumn("TIME_START", Type.DATE), new SchemaColumn("TIME_END", Type.DATE), new SchemaColumn("STABLE_STATE", Type.BOOLEAN), new SchemaColumn("STATE", Type.STRING), new SchemaColumn("WARNINGS_COUNT", Type.BIGINT), new SchemaColumn("SCENARIO_PROJECT_KEY", Type.STRING), new SchemaColumn("SCENARIO_ID", Type.STRING), new SchemaColumn("SCENARIO_RUN_ID", Type.STRING), new SchemaColumn("STEP_ID", Type.STRING), new SchemaColumn("STEP_RUN_ID", Type.STRING), new SchemaColumn("JOB_DEF_TYPE", Type.STRING), new SchemaColumn("JOB_DEF_TRIGGER_TYPE", Type.STRING), new SchemaColumn("JOB_DEF_INITIATOR", Type.STRING), new SchemaColumn("JOB_DEF_INITIATED", Type.DATE), new SchemaColumn("JOB_DEF_REFRESH_METASTORE", Type.BOOLEAN), new SchemaColumn("JOB_DEF_OUTPUTS", Type.STRING)};
    private static final String SCENARIO_NAME_COLUMN = "SCENARIO_NAME";
    private static final String TRIGGER_NAME_COLUMN = "TRIGGER_NAME";
    private static final String SCENARIO_RUN_AS_USER_COLUMN = "SCENARIO_RUN_AS_USER";
    private static final SchemaColumn[] scenarioRunsViewColumns = new SchemaColumn[]{new SchemaColumn("SCENARIO_PROJECT_KEY", Type.STRING), new SchemaColumn("SCENARIO_ID", Type.STRING), new SchemaColumn("SCENARIO_RUN_ID", Type.STRING), new SchemaColumn("TIME_START", Type.DATE), new SchemaColumn("TIME_END", Type.DATE), new SchemaColumn("OUTCOME", Type.STRING), new SchemaColumn("WARNINGS_COUNT", Type.BIGINT), new SchemaColumn("SCENARIO_NAME", Type.STRING), new SchemaColumn("TRIGGER_NAME", Type.STRING), new SchemaColumn("SCENARIO_RUN_AS_USER", Type.STRING), new SchemaColumn("RUN_AS_USER_IDENTIFIER", Type.STRING), new SchemaColumn("RUN_AS_USER_VIA", Type.STRING)};
    private static final SchemaColumn[] flowActionsViewColumns = new SchemaColumn[]{new SchemaColumn("PROJECT_KEY", Type.STRING), new SchemaColumn("OBJECT_ID", Type.STRING), new SchemaColumn("PARTITION", Type.STRING), new SchemaColumn("JOB_PROJECT_KEY", Type.STRING), new SchemaColumn("JOB_ID", Type.STRING), new SchemaColumn("ACTIVITY_ID", Type.STRING), new SchemaColumn("SCENARIO_PROJECT_KEY", Type.STRING), new SchemaColumn("SCENARIO_ID", Type.STRING), new SchemaColumn("SCENARIO_RUN_ID", Type.STRING), new SchemaColumn("STEP_ID", Type.STRING), new SchemaColumn("STEP_RUN_ID", Type.STRING), new SchemaColumn("TIME_START", Type.DATE), new SchemaColumn("TIME_END", Type.DATE), new SchemaColumn("OUTCOME", Type.STRING), new SchemaColumn("RESULT", Type.STRING), new SchemaColumn("WARNINGS_COUNT", Type.BIGINT), new SchemaColumn("TYPE", Type.STRING), new SchemaColumn("IS_LAST", Type.BOOLEAN)};
    private static DKULogger logger = DKULogger.getLogger((String)"dku.jobsdb.access");

    public ReadOnlyJobsInternalDB(boolean autoserver) {
        super(ApplicationConfigurator.getDatabaseFile(DB_NAME), DB_NAME, DB_NAME, 17, autoserver);
    }

    public ReadOnlyJobsInternalDB() {
        super(ApplicationConfigurator.getDatabaseFile(DB_NAME), DB_NAME, DB_NAME, 17, true);
    }

    @Override
    protected void initDB(int currentSchemaVersion, DSSDBConnection conn) throws CodedSQLException {
        assert (false);
    }

    protected String getList(SchemaColumn[] ... columnGroups) {
        return this.getList("", columnGroups);
    }

    protected String getList(String prefix, SchemaColumn[] ... columnGroups) {
        return this.getList(prefix, Collections.emptyList(), columnGroups);
    }

    protected String getList(String prefix, List<String> ignoredColumns, SchemaColumn[] ... columnGroups) {
        ArrayList columns = Lists.newArrayList();
        SchemaColumn[][] schemaColumnArray = columnGroups;
        int n = schemaColumnArray.length;
        for (int i = 0; i < n; ++i) {
            SchemaColumn[] columnGroup;
            for (SchemaColumn column : columnGroup = schemaColumnArray[i]) {
                String columnName = column.getName();
                if (ignoredColumns.contains(columnName)) continue;
                columns.add(this.quote(columnName));
            }
        }
        return prefix + Joiner.on((String)(", " + prefix)).join((Iterable)columns);
    }

    public static void setNotNullStringParameter(PreparedStatement preparedStatement, int index, @Nullable String parameterValue, String valueForNull) throws SQLException {
        preparedStatement.setString(index, ReadOnlyJobsInternalDB.getNotNullStringParameterOrDefault(parameterValue, valueForNull));
    }

    static String getNotNullStringParameterOrDefault(@Nullable String parameterValue, String valueForNull) {
        return StringUtils.defaultIfBlank((String)parameterValue, (String)valueForNull);
    }

    private static String parseNullableString(@Nullable String nullableValue) {
        return NULL_AS_STRING.equals(nullableValue) ? "" : nullableValue;
    }

    static ExpressionBuilder buildNullableWhere(String columnName, @Nullable Object nullableValue) {
        ExpressionBuilder col = EBF.col(columnName);
        return nullableValue == null ? col.isnull() : col.eq(nullableValue);
    }

    String getDefinition(SchemaColumn[] ... columnGroups) {
        ArrayList columns = Lists.newArrayList();
        SchemaColumn[][] schemaColumnArray = columnGroups;
        int n = schemaColumnArray.length;
        for (int i = 0; i < n; ++i) {
            SchemaColumn[] columnGroup;
            for (SchemaColumn column : columnGroup = schemaColumnArray[i]) {
                columns.add(this.getDefinition(column));
            }
        }
        return Joiner.on((String)", ").join((Iterable)columns);
    }

    String getDefinition(SchemaColumn column) {
        return column.getName() + " " + this.getDialect().getSQLType((SchemaColumn)column, null).sqlDecl;
    }

    private FlowExecutionService2.JobSummary getJS(ResultSet rs2) throws SQLException {
        FlowExecutionService2.JobSummary js = new FlowExecutionService2.JobSummary();
        String def = rs2.getString(JOB_DEF_COLUMN);
        if (def != null) {
            js.def = (JobDef)JSON.parse((String)def, JobDef.class);
        }
        js.stableState = rs2.getBoolean(STABLE_STATE_COLUMN);
        if (js.stableState) {
            js.state = JobState.valueOf(rs2.getString(STATE_COLUMN));
        }
        js.warningsCount = rs2.getInt(WARNINGS_COUNT_COLUMN);
        long st2 = rs2.getLong(TIME_START_COLUMN);
        js.startTime = !rs2.wasNull() || st2 != 0L ? st2 : -1L;
        long et = rs2.getLong(TIME_END_COLUMN);
        js.endTime = !rs2.wasNull() || et != 0L ? et : -1L;
        js.scenarioId = rs2.getString(SCENARIO_ID_COLUMN);
        js.scenarioProjectKey = rs2.getString(SCENARIO_PROJECT_KEY_COLUMN);
        if (js.scenarioId != null && js.scenarioId.length() > 0) {
            js.stepId = rs2.getString(STEP_ID_COLUMN);
            js.scenarioRunId = rs2.getString(SCENARIO_RUN_ID_COLUMN);
            js.stepRunId = rs2.getString(STEP_RUN_ID_COLUMN);
        }
        return js;
    }

    private DatasetBuild getDatasetBuild(ResultSet rs2) throws SQLException {
        DatasetBuild db = new DatasetBuild();
        db.datasetProjectKey = rs2.getString(PROJECT_KEY_COLUMN);
        db.datasetName = ReadOnlyJobsInternalDB.parseNullableString(rs2.getString(OBJECT_ID_COLUMN));
        db.jobProjectKey = rs2.getString(JOB_PROJECT_KEY_COLUMN);
        db.jobId = rs2.getString(JOB_ID_COLUMN);
        ReportItem.Outcome o = ReportItem.Outcome.valueOf(rs2.getString(OUTCOME_COLUMN));
        db.buildSuccess = o == ReportItem.Outcome.SUCCESS || o == ReportItem.Outcome.WARNING;
        db.partition = rs2.getString(PARTITION_COLUMN);
        db.buildEndTime = rs2.getLong(TIME_END_COLUMN);
        return db;
    }

    private ObjectBuild getObjectBuild(ResultSet rs2) throws SQLException {
        ObjectBuild db = new ObjectBuild();
        db.projectKey = rs2.getString(PROJECT_KEY_COLUMN);
        db.id = ReadOnlyJobsInternalDB.parseNullableString(rs2.getString(OBJECT_ID_COLUMN));
        db.jobProjectKey = rs2.getString(JOB_PROJECT_KEY_COLUMN);
        db.jobId = rs2.getString(JOB_ID_COLUMN);
        ReportItem.Outcome o = ReportItem.Outcome.valueOf(rs2.getString(OUTCOME_COLUMN));
        db.buildSuccess = o == ReportItem.Outcome.SUCCESS || o == ReportItem.Outcome.WARNING;
        db.buildStartTime = rs2.getLong(TIME_START_COLUMN);
        db.buildEndTime = rs2.getLong(TIME_END_COLUMN);
        return db;
    }

    public List<FlowExecutionService2.JobSummary> getLastJobs_NT(String projectKey, int maxNb) throws SQLException {
        ArrayList<FlowExecutionService2.JobSummary> ret = new ArrayList<FlowExecutionService2.JobSummary>();
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.db.jobs.access.getLastJobs");){
            ArrayList<FlowExecutionService2.JobSummary> arrayList;
            block20: {
                DSSDBConnection ac = this.acquireConnection();
                try {
                    try (PreparedStatement ps2 = ac.prepareNonPersistedStatement("SELECT * FROM " + this.getQuotedFullResolvedTableName(JOB_TABLE) + " WHERE " + this.quote(JOB_PROJECT_KEY_COLUMN) + "=? ORDER BY " + this.quote(TIME_START_COLUMN) + " DESC LIMIT ?");){
                        ps2.setString(1, projectKey);
                        ps2.setInt(2, maxNb);
                        ps2.execute();
                        ResultSet rs2 = ps2.getResultSet();
                        while (rs2.next()) {
                            ret.add(this.getJS(rs2));
                        }
                    }
                    arrayList = ret;
                    if (ac == null) break block20;
                }
                catch (Throwable throwable) {
                    if (ac != null) {
                        try {
                            ac.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ac.close();
            }
            return arrayList;
        }
    }

    private int getSingleIntResult(Statement st2, String colName) throws SQLException {
        ResultSet rs2 = st2.getResultSet();
        assert (rs2 != null);
        boolean hasNext = rs2.next();
        assert (hasNext);
        return rs2.getInt(colName);
    }

    public void fillProjectReport(String projectKey, JobsReportBuilder.ProjectJobsReport report, long since) throws SQLException {
        try (DSSDBConnection ac = this.acquireConnection();){
            ResultSet rs2;
            SelectQueryBuilder sqb = new SelectQueryBuilder();
            sqb.from(this.resolveTable(JOB_TABLE), JOB_TABLE);
            sqb.select(EBF.count("*"), "nb_jobs");
            sqb.select(EBF.caseWhen(EBF.col(SCENARIO_ID_COLUMN).isnotnull(), 1, 0).sum(), "nb_jobs_from_scenarios");
            sqb.select(EBF.col(WARNINGS_COUNT_COLUMN).sum(), "nb_warnings");
            sqb.select(EBF.caseWhen(EBF.col(STATE_COLUMN).eq(JobState.DONE.name()), 1, 0).sum(), "jobs_done");
            sqb.select(EBF.caseWhen(EBF.col(STATE_COLUMN).eq(JobState.FAILED.name()), 1, 0).sum(), "jobs_failed");
            sqb.select(EBF.caseWhen(EBF.col(STATE_COLUMN).eq(JobState.ABORTED.name()), 1, 0).sum(), "jobs_aborted");
            sqb.select(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).sum(), "total_duration");
            sqb.select(EBF.caseWhen(EBF.col(SCENARIO_ID_COLUMN).isnotnull(), EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN), 0)).sum(), "total_duration_from_scenarios");
            sqb.select(EBF.caseWhen(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).gte(0).and(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).lte(30000)), 1, 0).sum(), "nb_jobs_0_30");
            sqb.select(EBF.caseWhen(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).gte(30000).and(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).lte(60000)), 1, 0).sum(), "nb_jobs_30_60");
            sqb.select(EBF.caseWhen(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).gte(60000).and(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).lte(180000)), 1, 0).sum(), "nb_jobs_60_180");
            sqb.select(EBF.caseWhen(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).gte(180000).and(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).lte(900000)), 1, 0).sum(), "nb_jobs_180_900");
            sqb.select(EBF.caseWhen(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).gte(900000).and(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).lte(3600000)), 1, 0).sum(), "nb_jobs_900_3600");
            sqb.select(EBF.caseWhen(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).gte(3600000), 1, 0).sum(), "nb_jobs_3600_above");
            sqb.select(EBF.caseWhen(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).gte(0).and(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).lte(30000)), EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)), 0).sum(), "total_duration_0_30");
            sqb.select(EBF.caseWhen(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).gte(30000).and(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).lte(60000)), EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)), 0).sum(), "total_duration_30_60");
            sqb.select(EBF.caseWhen(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).gte(60000).and(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).lte(180000)), EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)), 0).sum(), "total_duration_60_180");
            sqb.select(EBF.caseWhen(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).gte(180000).and(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).lte(900000)), EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)), 0).sum(), "total_duration_180_900");
            sqb.select(EBF.caseWhen(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).gte(900000).and(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).lte(3600000)), EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)), 0).sum(), "total_duration_900_3600");
            sqb.select(EBF.caseWhen(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).gte(3600000), EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)), 0).sum(), "total_duration_3600_above");
            sqb.select(EBF.caseWhen(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).gte(0).and(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).lte(30000)).and(EBF.col(SCENARIO_ID_COLUMN).isnotnull()), 1, 0).sum(), "nb_jobs_0_30_from_scenarios");
            sqb.select(EBF.caseWhen(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).gte(30000).and(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).lte(60000)).and(EBF.col(SCENARIO_ID_COLUMN).isnotnull()), 1, 0).sum(), "nb_jobs_30_60_from_scenarios");
            sqb.select(EBF.caseWhen(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).gte(60000).and(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).lte(180000)).and(EBF.col(SCENARIO_ID_COLUMN).isnotnull()), 1, 0).sum(), "nb_jobs_60_180_from_scenarios");
            sqb.select(EBF.caseWhen(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).gte(180000).and(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).lte(900000)).and(EBF.col(SCENARIO_ID_COLUMN).isnotnull()), 1, 0).sum(), "nb_jobs_180_900_from_scenarios");
            sqb.select(EBF.caseWhen(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).gte(900000).and(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).lte(3600000)).and(EBF.col(SCENARIO_ID_COLUMN).isnotnull()), 1, 0).sum(), "nb_jobs_900_3600_from_scenarios");
            sqb.select(EBF.caseWhen(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).gte(3600000).and(EBF.col(SCENARIO_ID_COLUMN).isnotnull()), 1, 0).sum(), "nb_jobs_3600_above_from_scenarios");
            sqb.select(EBF.caseWhen(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).gte(0).and(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).lte(30000)).and(EBF.col(SCENARIO_ID_COLUMN).isnotnull()), EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)), 0).sum(), "total_duration_0_30_from_scenarios");
            sqb.select(EBF.caseWhen(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).gte(30000).and(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).lte(60000)).and(EBF.col(SCENARIO_ID_COLUMN).isnotnull()), EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)), 0).sum(), "total_duration_30_60_from_scenarios");
            sqb.select(EBF.caseWhen(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).gte(60000).and(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).lte(180000)).and(EBF.col(SCENARIO_ID_COLUMN).isnotnull()), EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)), 0).sum(), "total_duration_60_180_from_scenarios");
            sqb.select(EBF.caseWhen(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).gte(180000).and(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).lte(900000)).and(EBF.col(SCENARIO_ID_COLUMN).isnotnull()), EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)), 0).sum(), "total_duration_180_900_from_scenarios");
            sqb.select(EBF.caseWhen(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).gte(900000).and(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).lte(3600000)).and(EBF.col(SCENARIO_ID_COLUMN).isnotnull()), EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)), 0).sum(), "total_duration_900_3600_from_scenarios");
            sqb.select(EBF.caseWhen(EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)).gte(3600000).and(EBF.col(SCENARIO_ID_COLUMN).isnotnull()), EBF.col(TIME_END_COLUMN).minus(EBF.col(TIME_START_COLUMN)), 0).sum(), "total_duration_3600_above_from_scenarios");
            sqb.where(EBF.parameterizedColumnOperation(JOB_PROJECT_KEY_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ).and(EBF.parameterizedColumnOperation(TIME_START_COLUMN, QueryUtils.OperatorType.GT)).and(EBF.col(TIME_END_COLUMN).isnotnull()).and(EBF.col(TIME_START_COLUMN).isnotnull()).and(EBF.col(TIME_END_COLUMN).gt(EBF.col(TIME_START_COLUMN))).and(EBF.col(TIME_START_COLUMN).gt(0)));
            try (PreparedStatement ps2 = ac.prepareNonPersistedStatement(sqb.toSQL(this.getDialect()));){
                ps2.setString(1, projectKey);
                ps2.setLong(2, since);
                ps2.execute();
                rs2 = ps2.getResultSet();
                boolean hasNext = rs2.next();
                assert (hasNext);
                report.nbJobs = rs2.getInt("nb_jobs");
                report.nbJobsFromScenarios = rs2.getInt("nb_jobs_from_scenarios");
                report.nbJobs_0_30 = rs2.getInt("nb_jobs_0_30");
                report.nbJobs_30_60 = rs2.getInt("nb_jobs_30_60");
                report.nbJobs_60_180 = rs2.getInt("nb_jobs_60_180");
                report.nbJobs_180_900 = rs2.getInt("nb_jobs_180_900");
                report.nbJobs_900_3600 = rs2.getInt("nb_jobs_900_3600");
                report.nbJobs_3600_and_above = rs2.getInt("nb_jobs_3600_above");
                report.nbJobsFromScenarios_0_30 = rs2.getInt("nb_jobs_0_30_from_scenarios");
                report.nbJobsFromScenarios_30_60 = rs2.getInt("nb_jobs_30_60_from_scenarios");
                report.nbJobsFromScenarios_60_180 = rs2.getInt("nb_jobs_60_180_from_scenarios");
                report.nbJobsFromScenarios_180_900 = rs2.getInt("nb_jobs_180_900_from_scenarios");
                report.nbJobsFromScenarios_900_3600 = rs2.getInt("nb_jobs_900_3600_from_scenarios");
                report.nbJobsFromScenarios_3600_and_above = rs2.getInt("nb_jobs_3600_above_from_scenarios");
                report.totalWarnings = rs2.getInt("nb_warnings");
                report.totalDuration = rs2.getLong("total_duration");
                report.totalDurationFromScenarios = rs2.getLong("total_duration_from_scenarios");
                report.totalDuration_0_30 = rs2.getInt("total_duration_0_30");
                report.totalDuration_30_60 = rs2.getInt("total_duration_30_60");
                report.totalDuration_60_180 = rs2.getInt("total_duration_60_180");
                report.totalDuration_180_900 = rs2.getInt("total_duration_180_900");
                report.totalDuration_900_3600 = rs2.getInt("total_duration_900_3600");
                report.totalDuration_3600_and_above = rs2.getInt("total_duration_3600_above");
                report.totalDurationFromScenarios_0_30 = rs2.getInt("total_duration_0_30_from_scenarios");
                report.totalDurationFromScenarios_30_60 = rs2.getInt("total_duration_30_60_from_scenarios");
                report.totalDurationFromScenarios_60_180 = rs2.getInt("total_duration_60_180_from_scenarios");
                report.totalDurationFromScenarios_180_900 = rs2.getInt("total_duration_180_900_from_scenarios");
                report.totalDurationFromScenarios_900_3600 = rs2.getInt("total_duration_900_3600_from_scenarios");
                report.totalDurationFromScenarios_3600_and_above = rs2.getInt("total_duration_3600_above_from_scenarios");
                report.jobsDone = rs2.getInt("jobs_done");
                report.jobsFailed = rs2.getInt("jobs_failed");
                report.jobsAborted = rs2.getInt("jobs_aborted");
            }
            sqb = new SelectQueryBuilder();
            sqb.from(this.resolveTable(STEP_RUNS_TABLE), STEP_RUNS_TABLE);
            sqb.select(STEP_COLUMN);
            sqb.select(OUTCOME_COLUMN);
            sqb.select(EBF.count("*"), "nb");
            sqb.where(EBF.parameterizedColumnOperation(SCENARIO_PROJECT_KEY_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ).and(EBF.parameterizedColumnOperation(TIME_START_COLUMN, QueryUtils.OperatorType.GT)));
            sqb.group(STEP_COLUMN).group(OUTCOME_COLUMN);
            ps2 = ac.prepareNonPersistedStatement(sqb.toSQL(this.getDialect()));
            try {
                ps2.setString(1, projectKey);
                ps2.setLong(2, since);
                ps2.execute();
                rs2 = ps2.getResultSet();
                while (rs2.next()) {
                    try {
                        String step = rs2.getString(STEP_COLUMN);
                        JsonObject obj = (JsonObject)JSON.parse((String)step, JsonObject.class);
                        String x = obj.get("type").getAsString() + "-" + rs2.getString(OUTCOME_COLUMN);
                        if (!report.stepRuns.containsKey(x)) {
                            report.stepRuns.put(x, 0);
                        }
                        report.stepRuns.put(x, report.stepRuns.get(x) + rs2.getInt("nb"));
                    }
                    catch (Exception e) {
                        logger.warn((Object)"invalid ", (Throwable)e);
                    }
                }
            }
            finally {
                if (ps2 != null) {
                    ps2.close();
                }
            }
            sqb = new SelectQueryBuilder();
            sqb.from(this.resolveTable(SCENARIO_RUNS_TABLE), SCENARIO_RUNS_TABLE);
            sqb.select(EBF.count("*"), "count");
            sqb.where(EBF.parameterizedColumnOperation(SCENARIO_PROJECT_KEY_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ).and(EBF.parameterizedColumnOperation(TIME_START_COLUMN, QueryUtils.OperatorType.GT)));
            ps2 = ac.prepareNonPersistedStatement(sqb.toSQL(this.getDialect()));
            try {
                ps2.setString(1, projectKey);
                ps2.setLong(2, since);
                ps2.execute();
                report.scenarioRuns = this.getSingleIntResult(ps2, "count");
            }
            finally {
                if (ps2 != null) {
                    ps2.close();
                }
            }
            sqb = new SelectQueryBuilder();
            sqb.from(this.resolveTable(FLOW_OBJECT_ACTION_TABLE), FLOW_OBJECT_ACTION_TABLE);
            sqb.select(TYPE_COLUMN);
            sqb.select(OUTCOME_COLUMN);
            sqb.select(EBF.count("*"), "nb");
            sqb.where(EBF.parameterizedColumnOperation(JOB_PROJECT_KEY_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ).and(EBF.parameterizedColumnOperation(TIME_START_COLUMN, QueryUtils.OperatorType.GT)));
            sqb.group(TYPE_COLUMN).group(OUTCOME_COLUMN);
            ps2 = ac.prepareNonPersistedStatement(sqb.toSQL(this.getDialect()));
            try {
                ps2.setString(1, projectKey);
                ps2.setLong(2, since);
                ps2.execute();
                rs2 = ps2.getResultSet();
                while (rs2.next()) {
                    String x = rs2.getString(TYPE_COLUMN) + "-" + rs2.getString(OUTCOME_COLUMN);
                    report.reportItems.put(x, rs2.getInt("nb"));
                }
            }
            finally {
                if (ps2 != null) {
                    ps2.close();
                }
            }
        }
    }

    List<FlowExecutionService2.JobSummary> getRunningJobs(String projectKey) throws SQLException {
        ArrayList<FlowExecutionService2.JobSummary> ret = new ArrayList<FlowExecutionService2.JobSummary>();
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.db.jobs.access.getRunningJobs");){
            ArrayList<FlowExecutionService2.JobSummary> arrayList;
            block23: {
                DSSDBConnection ac = this.acquireConnection();
                try {
                    StringBuilder sql = new StringBuilder("SELECT * FROM " + this.getQuotedFullResolvedTableName(JOB_TABLE) + " WHERE ");
                    if (projectKey != null) {
                        sql.append(this.quote(JOB_PROJECT_KEY_COLUMN)).append("=? AND ");
                    }
                    sql.append("(").append(this.quote(STATE_COLUMN)).append(" IS NULL OR (");
                    boolean first = true;
                    for (JobState state : JobState.values()) {
                        if (!state.isFinished()) continue;
                        sql.append(!first ? "AND " : "").append(this.quote(STATE_COLUMN)).append(" != '").append(state.name()).append("' ");
                        first = false;
                    }
                    sql.append("))");
                    try (PreparedStatement preparedStatement = ac.prepareNonPersistedStatement(sql.toString());){
                        if (projectKey != null) {
                            preparedStatement.setString(1, projectKey);
                        }
                        preparedStatement.execute();
                        ResultSet rs2 = preparedStatement.getResultSet();
                        while (rs2.next()) {
                            ret.add(this.getJS(rs2));
                        }
                    }
                    arrayList = ret;
                    if (ac == null) break block23;
                }
                catch (Throwable throwable) {
                    if (ac != null) {
                        try {
                            ac.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ac.close();
            }
            return arrayList;
        }
    }

    /*
     * Exception decompiling
     */
    public DatasetBuild getLatestBuildForDataset(String projectKey, String dataset) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Map<String, Long> getLatestBuildTimeForDatasets(Set<AnyLoc> datasetLocs) throws SQLException {
        logger.trace(() -> "Get last build for " + datasetLocs.size() + " datasets");
        String query = "SELECT MAX(" + this.quote(TIME_START_COLUMN) + ") FROM " + this.getQuotedFullResolvedTableName(FLOW_OBJECT_ACTION_TABLE) + " WHERE " + this.quote(PROJECT_KEY_COLUMN) + "=? AND " + this.quote(OBJECT_ID_COLUMN) + "=? AND " + this.quote(OUTCOME_COLUMN) + " IN (" + this.quoteString(ReportItem.Outcome.SUCCESS.toString()) + ", " + this.quoteString(ReportItem.Outcome.WARNING.toString()) + ") AND " + this.quote(TYPE_COLUMN) + " = " + this.quoteString("BUILT_DATASET");
        HashMap<String, Long> resultAsMap = new HashMap<String, Long>(datasetLocs.size());
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.db.jobs.access.getLatestBuildTimeForDatasetCollection");
             DSSDBConnection ac = this.acquireConnection();
             PreparedStatement ps2 = ac.prepareNonPersistedStatement(query);){
            for (AnyLoc datasetLoc : datasetLocs) {
                ps2.setString(1, datasetLoc.getProjectKey());
                ps2.setString(2, datasetLoc.getId());
                ps2.execute();
                ResultSet rs2 = ps2.getResultSet();
                if (!rs2.next()) continue;
                long timestamp = rs2.getLong(1);
                if (rs2.wasNull()) continue;
                resultAsMap.put(datasetLoc.getFullName(), timestamp);
            }
        }
        return resultAsMap;
    }

    public Map<AnyLoc, List<MetricDataPoint>> readAllLastProjectMetrics(List<String> metrics, List<AnyLoc> objects) throws SQLException {
        logger.debug((Object)("Getting known last metrics " + metrics.toString() + " for " + objects.size() + "objects"));
        HashMap<AnyLoc, List<MetricDataPoint>> resultAsMap = new HashMap<AnyLoc, List<MetricDataPoint>>();
        if (metrics.isEmpty()) {
            return resultAsMap;
        }
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.db.jobs.access.readAllLastProjectMetrics");){
            HashMap<AnyLoc, List<MetricDataPoint>> hashMap;
            block21: {
                DSSDBConnection ac = this.acquireConnection();
                try {
                    SimpleSelectQueryBuilder sqb = SimpleSelectQueryBuilder.select().columns(this.metricsColumns, this.metricsSessionColumns).from(this.resolveTable(METRICS_LAST_TABLE), METRICS_LAST_TABLE).where(EBF.parameterizedColumnOperation(PROJECT_KEY_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ)).where(EBF.parameterizedColumnOperation(OBJECT_ID_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ)).where(EBF.col(METRIC_ID_COLUMN).inList(metrics));
                    try (PreparedStatement ps2 = ac.prepareNonPersistedStatement(sqb.toSQL(this.getDialect()));){
                        for (AnyLoc object : objects) {
                            ReadOnlyJobsInternalDB.setNotNullStringParameter(ps2, 1, object.getProjectKey(), NULL_AS_STRING);
                            ReadOnlyJobsInternalDB.setNotNullStringParameter(ps2, 2, object.getId(), NULL_AS_STRING);
                            ps2.execute();
                            ResultSet rs2 = ps2.getResultSet();
                            resultAsMap.put(object, ReadOnlyJobsInternalDB.mapMetricToObjectIds(rs2));
                        }
                    }
                    hashMap = resultAsMap;
                    if (ac == null) break block21;
                }
                catch (Throwable throwable) {
                    if (ac != null) {
                        try {
                            ac.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ac.close();
            }
            return hashMap;
        }
    }

    private static List<MetricDataPoint> mapMetricToObjectIds(ResultSet rs2) throws SQLException {
        ArrayList<MetricDataPoint> res = new ArrayList<MetricDataPoint>();
        while (rs2.next()) {
            String metricId = ReadOnlyJobsInternalDB.parseNullableString(rs2.getString(METRIC_ID_COLUMN));
            res.add(new MetricDataPoint(Metric.deserializeMetric(metricId).withId(metricId), ReadOnlyJobsInternalDB.parseNullableString(rs2.getString(PROJECT_KEY_COLUMN)), ReadOnlyJobsInternalDB.parseNullableString(rs2.getString(OBJECT_ID_COLUMN)), rs2.getLong(TIME_COMPUTE_COLUMN), rs2.getString(VALUE_COLUMN), Type.valueOf((String)rs2.getString(VALUE_TYPE_COLUMN)), rs2.getString(PARTITION_COLUMN), rs2.getString(HASH_COLUMN)));
        }
        return res;
    }

    /*
     * Exception decompiling
     */
    public ObjectBuild getLatestBuildForObject(TaggableObjectsService.TaggableObjectRef objectId) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PreparedStatement latestSuccessfulBuildQuery(DSSDBConnection ac, String table) throws CodedSQLException {
        return ac.prepareNonPersistedStatement("SELECT " + this.getList(this.objectPartitionIdColumns, this.jobIdColumns, this.actionTimeColumns, this.outcomeColumns) + " FROM " + this.getQuotedFullResolvedTableName(table) + " WHERE " + this.quote(PROJECT_KEY_COLUMN) + "=? AND " + this.quote(OBJECT_ID_COLUMN) + "=? AND " + this.quote(OUTCOME_COLUMN) + " IN ('" + String.valueOf((Object)ReportItem.Outcome.SUCCESS) + "', '" + String.valueOf((Object)ReportItem.Outcome.WARNING) + "') AND " + this.quote(TYPE_COLUMN) + " IN ('BUILT_DATASET', 'BUILT_MODEL', 'BUILT_FOLDER', 'BUILT_STREAMING_ENDPOINT', 'BUILT_EVALUATION_STORE', 'BUILT_RETRIEVABLE_KNOWLEDGE') ORDER BY " + this.quote(TIME_START_COLUMN) + " DESC LIMIT 1");
    }

    /*
     * Exception decompiling
     */
    public ObjectBuild getLatestSuccessfulBuildForObject(String projectKey, String id) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public FlowExecutionService2.JobSummary getJobSummary(String projectKey, String jobId) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private TriggerFire buildTriggerFire(ResultSet rs2) throws SQLException {
        String triggerId = rs2.getString(TRIGGER_ID_COLUMN);
        if (triggerId == null) {
            return null;
        }
        TriggerFire ret = new TriggerFire();
        ret = ret.withProjectKey(rs2.getString(SCENARIO_PROJECT_KEY_COLUMN));
        ret = ret.withScenarioId(rs2.getString(SCENARIO_ID_COLUMN));
        ret = ret.withRunId(rs2.getString(TRIGGER_RUN_ID_COLUMN));
        String triggerJson = rs2.getString(TRIGGER_COLUMN);
        ret = triggerJson != null ? ret.withTrigger((Trigger)JSON.parse((String)triggerJson, Trigger.class)) : ret.withTrigger(new Trigger().withId(triggerId));
        long timestamp = rs2.getLong(TIME_TRIGGER_COLUMN);
        if (!rs2.wasNull() && timestamp != 0L) {
            ret = ret.withTimestamp(timestamp);
        }
        ret = ret.withTriggerState(rs2.getString(TRIGGER_STATE_COLUMN));
        String paramsJson = rs2.getString(TRIGGER_PARAMS_COLUMN);
        if (paramsJson != null) {
            ret = ret.withParams((JsonObject)JSON.parse((String)paramsJson, JsonObject.class));
        }
        ret = ret.withCancelled(rs2.getBoolean(CANCELLED_COLUMN));
        return ret;
    }

    private ScenarioRun buildScenarioRun(ResultSet rs2, boolean shortVersion) throws SQLException {
        String variablesJson;
        String resultJson;
        ScenarioRun ret = new ScenarioRun();
        ret = (ScenarioRun)ret.withRunId(rs2.getString(SCENARIO_RUN_ID_COLUMN));
        String scenarioJson = shortVersion ? null : rs2.getString(SCENARIO_COLUMN);
        ret = scenarioJson != null ? (ScenarioRun)ret.withScenario((Scenario)JSON.parse((String)scenarioJson, Scenario.class)) : (ScenarioRun)ret.withScenario(this.buildBestEffortScenarioFromResultSet(rs2));
        long start = rs2.getLong(TIME_START_COLUMN);
        if (!rs2.wasNull() && start != 0L) {
            ret = ret.withStart(start);
        }
        long end = rs2.getLong(TIME_END_COLUMN);
        if (!rs2.wasNull() && end != 0L) {
            ret = ret.withEnd(end);
        }
        String string = resultJson = shortVersion ? null : rs2.getString(RESULT_COLUMN);
        if (resultJson != null) {
            ret = ret.withResult((ReportItem)JSON.parse((String)resultJson, ReportItem.class));
        } else {
            String outcomeStr = rs2.getString(OUTCOME_COLUMN);
            if (StringUtils.isNotBlank((String)outcomeStr)) {
                ReportItem.Outcome outcome = ReportItem.Outcome.valueOf(outcomeStr);
                ret = ret.withResult(new ReportItem.ScenarioDone(new ReportTargetItem.ScenarioItem(rs2.getString(SCENARIO_PROJECT_KEY_COLUMN), rs2.getString(SCENARIO_ID_COLUMN))).withOutcome(outcome));
            }
        }
        String string2 = variablesJson = shortVersion ? null : rs2.getString(VARIABLES_COLUMN);
        if (variablesJson != null) {
            ret = ret.withVariables((JsonObject)JSON.parse((String)variablesJson, JsonObject.class));
        }
        return ret;
    }

    private Scenario buildBestEffortScenarioFromResultSet(ResultSet rs2) throws SQLException {
        return new Scenario().withProjectKey(rs2.getString(SCENARIO_PROJECT_KEY_COLUMN)).withId(rs2.getString(SCENARIO_ID_COLUMN));
    }

    private ScenarioRun buildScenarioRunWithTrigger(ResultSet rs2, boolean shortVersion) throws SQLException {
        ScenarioRun ret = this.buildScenarioRun(rs2, shortVersion);
        if (!shortVersion) {
            ret = ret.withTrigger(this.buildTriggerFire(rs2));
        }
        return ret;
    }

    private ScenarioRun buildScenarioRunWithTest(ResultSet rs2) throws SQLException {
        ScenarioRun ret = this.buildScenarioRunWithTrigger(rs2, false);
        String bundleId = rs2.getString(BUNDLE_ID);
        ret = ret.withBundleId(bundleId).withMarkedAsTest(rs2.getBoolean(MARKED_AS_TEST));
        return ret;
    }

    private StepRun buildStepRun(ResultSet rs2, ScenarioRun scenarioRun) throws SQLException {
        String resultJson;
        StepRun ret = new StepRun();
        if (scenarioRun == null) {
            scenarioRun = new ScenarioRun();
            scenarioRun = (ScenarioRun)scenarioRun.withScenario(this.buildBestEffortScenarioFromResultSet(rs2)).withRunId(rs2.getString(SCENARIO_RUN_ID_COLUMN));
        }
        ret = ret.withScenarioRun(scenarioRun);
        ret = ret.withRunId(rs2.getString(STEP_RUN_ID_COLUMN));
        String stepJson = rs2.getString(STEP_COLUMN);
        ret = stepJson != null ? ret.withStep((Step)JSON.parse((String)stepJson, Step.class)) : ret.withStep(new Step().withId(rs2.getString(STEP_ID_COLUMN)));
        long start = rs2.getLong(TIME_START_COLUMN);
        if (!rs2.wasNull() && start != 0L) {
            ret = ret.withStart(start);
        }
        long end = rs2.getLong(TIME_END_COLUMN);
        if (!rs2.wasNull() && end != 0L) {
            ret = ret.withEnd(end);
        }
        if ((resultJson = rs2.getString(RESULT_COLUMN)) != null) {
            ret = ret.withResult((ReportItem)JSON.parse((String)resultJson, ReportItem.class));
        }
        return ret;
    }

    /*
     * Exception decompiling
     */
    public ScenarioRun getScenarioRun(String projectKey, String scenarioId, String scenarioRunId) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public ScenarioRun getSimpleScenarioRun(String projectKey, String scenarioId, String scenarioRunId) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public ScenarioRun getScenarioRunOfTriggerFire(String projectKey, String scenarioId, String triggerId, String triggerRunId) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    List<StepRun> getStepRuns(ScenarioRunKey scenarioRun) throws SQLException {
        return this.getStepRuns(scenarioRun.getScenario().getProjectKey(), scenarioRun.getScenario().getId(), scenarioRun.getRunId());
    }

    List<StepRun> getStepRuns(String projectKey, String scenarioId, String scenarioRunId) throws SQLException {
        logger.debug((Object)("Get step runs for " + projectKey + "." + scenarioId + "#" + scenarioRunId));
        ArrayList ret = Lists.newArrayList();
        ScenarioRun scenarioRun = this.getScenarioRun(projectKey, scenarioId, scenarioRunId);
        if (scenarioRun == null) {
            return ret;
        }
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.db.jobs.access.getStepRuns.inner");){
            ArrayList arrayList;
            block31: {
                DSSDBConnection ac = this.acquireConnection();
                try {
                    try (PreparedStatement ps2 = ac.prepareNonPersistedStatement(SimpleSelectQueryBuilder.select().columns(this.scenarioRunIdColumns, this.stepIdColumns, this.stepInfoColumns, this.actionTimeColumns, this.actionOutcomeColumns).from(this.resolveTable(STEP_RUNS_TABLE), STEP_RUNS_TABLE).where(ReadOnlyJobsInternalDB.buildNullableWhere(SCENARIO_PROJECT_KEY_COLUMN, projectKey)).where(ReadOnlyJobsInternalDB.buildNullableWhere(SCENARIO_ID_COLUMN, scenarioId)).where(ReadOnlyJobsInternalDB.buildNullableWhere(SCENARIO_RUN_ID_COLUMN, scenarioRunId)).orderedBy(STEP_RUN_ID_COLUMN).ascending().toSQL(this.getDialect()));){
                        ps2.execute();
                        ResultSet rs2 = ps2.getResultSet();
                        while (rs2.next()) {
                            ret.add(this.buildStepRun(rs2, scenarioRun));
                        }
                    }
                    HashMap stepRunsByIndex = Maps.newHashMap();
                    StepRun prevStepRun = null;
                    for (StepRun stepRun : ret) {
                        if (prevStepRun != null && prevStepRun.getStep().getId().equals(stepRun.getStep().getId())) {
                            stepRun.withRetryIndex(prevStepRun.getRetryIndex() + 1);
                        }
                        stepRunsByIndex.put(stepRun.getRunId(), stepRun);
                        prevStepRun = stepRun;
                    }
                    try (PreparedStatement ps3 = ac.prepareNonPersistedStatement(SimpleSelectQueryBuilder.select().columns(new SchemaColumn[][]{this.stepIdColumns}).column(RESULT_COLUMN).from(this.resolveTable(FLOW_OBJECT_ACTION_HISTORY_TABLE), FLOW_OBJECT_ACTION_HISTORY_TABLE).where(ReadOnlyJobsInternalDB.buildNullableWhere(SCENARIO_PROJECT_KEY_COLUMN, projectKey)).where(ReadOnlyJobsInternalDB.buildNullableWhere(SCENARIO_ID_COLUMN, scenarioId)).where(ReadOnlyJobsInternalDB.buildNullableWhere(SCENARIO_RUN_ID_COLUMN, scenarioRunId)).where(EBF.col(RESULT_COLUMN).isnotnull()).toSQL(this.getDialect()));){
                        ps3.execute();
                        ResultSet rs3 = ps3.getResultSet();
                        while (rs3.next()) {
                            String stepRunId = rs3.getString(STEP_RUN_ID_COLUMN);
                            ReportItem result = (ReportItem)JSON.parse((String)rs3.getString(RESULT_COLUMN), ReportItem.class);
                            ((StepRun)stepRunsByIndex.get(stepRunId)).getAdditionalReportItems().add(result);
                        }
                    }
                    arrayList = ret;
                    if (ac == null) break block31;
                }
                catch (Throwable throwable) {
                    if (ac != null) {
                        try {
                            ac.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ac.close();
            }
            return arrayList;
        }
    }

    Map<ScenarioRunKey, List<StepRun>> getStepRunsBulk(List<ScenarioRun> scenarioRuns) throws SQLException {
        logger.info((Object)("Get step runs in bulk for " + scenarioRuns.size() + " scenarioRuns"));
        HashMap scenarios = Maps.newHashMap();
        for (ScenarioRun scenarioRun : scenarioRuns) {
            String fullName = scenarioRun.getScenario().getProjectKey() + "." + scenarioRun.getScenario().getId();
            if (!scenarios.containsKey(fullName)) {
                scenarios.put(fullName, new ArrayList());
            }
            ((List)scenarios.get(fullName)).add(scenarioRun);
        }
        HashMap ret = Maps.newHashMap();
        try (DSSDBConnection ac = this.acquireConnection();){
            for (List runs : scenarios.values()) {
                String scenarioRunId;
                ResultSet rs2;
                ScenarioRun firstRun = (ScenarioRun)runs.get(0);
                String minScenarioRunId = firstRun.getRunId();
                String maxScenarioRunId = firstRun.getRunId();
                HashMap runById = Maps.newHashMap();
                for (ScenarioRun scenarioRun : runs) {
                    String scenarioRunId2 = scenarioRun.getRunId();
                    runById.put(scenarioRunId2, scenarioRun);
                    if (minScenarioRunId.compareTo(scenarioRunId2) > 0) {
                        minScenarioRunId = scenarioRunId2;
                    }
                    if (maxScenarioRunId.compareTo(scenarioRunId2) >= 0) continue;
                    maxScenarioRunId = scenarioRunId2;
                }
                HashMap stepRunsByIndex = Maps.newHashMap();
                try (Object ps2 = ac.prepareNonPersistedStatement(SimpleSelectQueryBuilder.select().columns(this.scenarioRunIdColumns, this.stepIdColumns, this.stepInfoColumns, this.actionTimeColumns, this.actionOutcomeColumns).from(this.resolveTable(STEP_RUNS_TABLE), STEP_RUNS_TABLE).where(ReadOnlyJobsInternalDB.buildNullableWhere(SCENARIO_PROJECT_KEY_COLUMN, firstRun.getScenario().getProjectKey())).where(ReadOnlyJobsInternalDB.buildNullableWhere(SCENARIO_ID_COLUMN, firstRun.getScenario().getId())).where(EBF.col(SCENARIO_RUN_ID_COLUMN).gte(minScenarioRunId)).where(EBF.col(SCENARIO_RUN_ID_COLUMN).lte(maxScenarioRunId)).toSQL(this.getDialect()));){
                    ps2.execute();
                    rs2 = ps2.getResultSet();
                    while (rs2.next()) {
                        scenarioRunId = rs2.getString(SCENARIO_RUN_ID_COLUMN);
                        if (!runById.containsKey(scenarioRunId)) continue;
                        ScenarioRun scenarioRun = (ScenarioRun)runById.get(scenarioRunId);
                        StepRun stepRun = this.buildStepRun(rs2, scenarioRun);
                        if (!ret.containsKey(scenarioRun)) {
                            ret.put(scenarioRun, new ArrayList());
                        }
                        ((List)ret.get(scenarioRun)).add(stepRun);
                        stepRunsByIndex.put(scenarioRunId + "." + stepRun.getRunId(), stepRun);
                    }
                }
                for (List stepRuns : ret.values()) {
                    Collections.sort(stepRuns, Comparator.comparing(StepRun::getRunId));
                    StepRun prevStepRun = null;
                    for (StepRun stepRun : stepRuns) {
                        if (prevStepRun != null && prevStepRun.getStep().getId().equals(stepRun.getStep().getId())) {
                            stepRun.withRetryIndex(prevStepRun.getRetryIndex() + 1);
                        }
                        prevStepRun = stepRun;
                    }
                }
                ps2 = ac.prepareNonPersistedStatement(SimpleSelectQueryBuilder.select().columns(this.scenarioRunIdColumns, this.stepIdColumns).column(RESULT_COLUMN).from(this.resolveTable(FLOW_OBJECT_ACTION_HISTORY_TABLE), FLOW_OBJECT_ACTION_HISTORY_TABLE).where(ReadOnlyJobsInternalDB.buildNullableWhere(SCENARIO_PROJECT_KEY_COLUMN, firstRun.getScenario().getProjectKey())).where(ReadOnlyJobsInternalDB.buildNullableWhere(SCENARIO_ID_COLUMN, firstRun.getScenario().getId())).where(EBF.col(SCENARIO_RUN_ID_COLUMN).gte(minScenarioRunId)).where(EBF.col(SCENARIO_RUN_ID_COLUMN).lte(maxScenarioRunId)).where(EBF.col(RESULT_COLUMN).isnotnull()).toSQL(this.getDialect()));
                try {
                    ps2.execute();
                    rs2 = ps2.getResultSet();
                    while (rs2.next()) {
                        scenarioRunId = rs2.getString(SCENARIO_RUN_ID_COLUMN);
                        String stepRunId = rs2.getString(STEP_RUN_ID_COLUMN);
                        ReportItem result = (ReportItem)JSON.parse((String)rs2.getString(RESULT_COLUMN), ReportItem.class);
                        String fullId = scenarioRunId + "." + stepRunId;
                        if (!stepRunsByIndex.containsKey(fullId)) continue;
                        ((StepRun)stepRunsByIndex.get(fullId)).getAdditionalReportItems().add(result);
                    }
                }
                finally {
                    if (ps2 == null) continue;
                    ps2.close();
                }
            }
            HashMap hashMap = ret;
            return hashMap;
        }
    }

    public void fetchStepRunAdditionalReportItems(StepRun stepRun) throws SQLException {
        logger.info((Object)("Get additional report items for stepRun" + stepRun.getRunId()));
        ScenarioRun scenarioRun = stepRun.getScenarioRun();
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.db.jobs.access.fetchStepRunAdditionalReportItems");
             DSSDBConnection ac = this.acquireConnection();
             PreparedStatement ps2 = ac.prepareNonPersistedStatement(SimpleSelectQueryBuilder.select().columns(new SchemaColumn[][]{this.stepIdColumns}).column(RESULT_COLUMN).from(this.resolveTable(FLOW_OBJECT_ACTION_HISTORY_TABLE), FLOW_OBJECT_ACTION_HISTORY_TABLE).where(ReadOnlyJobsInternalDB.buildNullableWhere(SCENARIO_PROJECT_KEY_COLUMN, scenarioRun.getScenario().getProjectKey())).where(ReadOnlyJobsInternalDB.buildNullableWhere(SCENARIO_ID_COLUMN, scenarioRun.getScenario().getId())).where(ReadOnlyJobsInternalDB.buildNullableWhere(SCENARIO_RUN_ID_COLUMN, scenarioRun.getRunId())).where(ReadOnlyJobsInternalDB.buildNullableWhere(STEP_RUN_ID_COLUMN, stepRun.getRunId())).where(EBF.col(RESULT_COLUMN).isnotnull()).toSQL(this.getDialect()));){
            ps2.execute();
            ResultSet rs2 = ps2.getResultSet();
            while (rs2.next()) {
                ReportItem result = (ReportItem)JSON.parse((String)rs2.getString(RESULT_COLUMN), ReportItem.class);
                stepRun.getAdditionalReportItems().add(result);
            }
        }
    }

    List<ReportItem> getStepRunMessages(String projectKey, String scenarioId, String scenarioRunId, String stepId, String stepRunId) throws SQLException {
        logger.info((Object)("Get messages for " + projectKey + "." + scenarioId + "#" + scenarioRunId + "/" + stepId + "#" + stepRunId));
        ArrayList ret = Lists.newArrayList();
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.db.jobs.access.getStepRunMessages");){
            ArrayList arrayList;
            block20: {
                DSSDBConnection ac = this.acquireConnection();
                try {
                    SelectQueryBuilder sqb = new SelectQueryBuilder();
                    sqb.from(this.resolveTable(FLOW_OBJECT_ACTION_HISTORY_TABLE), FLOW_OBJECT_ACTION_HISTORY_TABLE);
                    sqb.select(RESULT_COLUMN);
                    sqb.where(EBF.parameterizedColumnOperation(SCENARIO_PROJECT_KEY_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ).and(EBF.parameterizedColumnOperation(SCENARIO_ID_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ)).and(EBF.parameterizedColumnOperation(SCENARIO_RUN_ID_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ)).and(EBF.parameterizedColumnOperation(STEP_ID_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ)).and(EBF.parameterizedColumnOperation(STEP_RUN_ID_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ)).and(EBF.col(RESULT_COLUMN).isnotnull()));
                    try (PreparedStatement ps2 = ac.prepareNonPersistedStatement(sqb.toSQL(this.getDialect()));){
                        ps2.setString(1, projectKey);
                        ps2.setString(2, scenarioId);
                        ps2.setString(3, scenarioRunId);
                        ps2.setString(4, stepId);
                        ps2.setString(5, stepRunId);
                        ps2.execute();
                        ResultSet rs2 = ps2.getResultSet();
                        while (rs2.next()) {
                            ReportItem result = (ReportItem)JSON.parse((String)rs2.getString(RESULT_COLUMN), ReportItem.class);
                            ret.add(result);
                        }
                    }
                    arrayList = ret;
                    if (ac == null) break block20;
                }
                catch (Throwable throwable) {
                    if (ac != null) {
                        try {
                            ac.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ac.close();
            }
            return arrayList;
        }
    }

    public String getLastRunId(Scenario scenario) throws SQLException {
        return this.getLastRunId(scenario.getProjectKey(), scenario.getId());
    }

    private String getFromScenarioWithTriggerFire() {
        if (this.fromScenarioWithTriggerFire.isEmpty()) {
            this.fromScenarioWithTriggerFire = "FROM " + this.getQuotedFullResolvedTableName(SCENARIO_RUNS_TABLE) + " s LEFT OUTER JOIN " + this.getQuotedFullResolvedTableName(TRIGGER_FIRES_TABLE) + " t ON t." + this.quote(SCENARIO_PROJECT_KEY_COLUMN) + " = s." + this.quote(SCENARIO_PROJECT_KEY_COLUMN) + " AND t." + this.quote(SCENARIO_ID_COLUMN) + " = s." + this.quote(SCENARIO_ID_COLUMN) + " AND t." + this.quote(TRIGGER_ID_COLUMN) + " = s." + this.quote(TRIGGER_ID_COLUMN) + " AND t." + this.quote(TRIGGER_RUN_ID_COLUMN) + " = s." + this.quote(TRIGGER_RUN_ID_COLUMN);
        }
        return this.fromScenarioWithTriggerFire;
    }

    /*
     * Exception decompiling
     */
    public String getLastRunId(String projectKey, String scenarioId) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCachedLastTriggerState(String projectKey, String scenarioId, String triggerId, String state) {
        String fullTriggerId = projectKey + "." + scenarioId + "." + triggerId;
        Map<String, String> map = this.lastTriggerStateCache;
        synchronized (map) {
            this.lastTriggerStateCache.put(fullTriggerId, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCachedLastTriggerState(String projectKey, String scenarioId, String triggerId) {
        String fullTriggerId = projectKey + "." + scenarioId + "." + triggerId;
        Map<String, String> map = this.lastTriggerStateCache;
        synchronized (map) {
            return this.lastTriggerStateCache.get(fullTriggerId);
        }
    }

    public String getLastTriggerFireState(String projectKey, String scenarioId, String triggerId) throws SQLException {
        String state = this.getCachedLastTriggerState(projectKey, scenarioId, triggerId);
        if (StringUtils.isBlank((String)state)) {
            TriggerFire triggerFire = this.getLastTriggerFire(projectKey, scenarioId, triggerId);
            if (triggerFire != null) {
                state = triggerFire.getTriggerState();
            }
            this.setCachedLastTriggerState(projectKey, scenarioId, triggerId, state);
        }
        return state;
    }

    /*
     * Exception decompiling
     */
    public TriggerFire getLastTriggerFire(String projectKey, String scenarioId, String triggerId) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public TriggerFire getTriggerFire(String projectKey, String scenarioId, String triggerId, String runId) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<ScenarioRun> getLastRuns(Scenario scenario, int count, boolean onlyFinishedRuns, boolean withFullScenario) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public ScenarioRun getLatestTestCompletedRun(Scenario scenario, @Nullable String bundleId) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String lastRunsQuery(boolean withFullScenario, String outcomeFilter, int count) {
        String fullScenarioSelect = (String)(withFullScenario ? "s." + this.quote(SCENARIO_COLUMN) : "NULL") + " AS " + this.quote(SCENARIO_COLUMN);
        return String.join((CharSequence)"\n", "", "    SELECT", "        " + fullScenarioSelect + ", " + this.getList("s.", (SchemaColumn[][])new SchemaColumn[][]{this.scenarioRunIdColumns, this.scenarioRunInfoWithoutScenarioColumns, this.actionTimeColumns, this.actionOutcomeColumns, this.scenarioBundleAndTestColumns}) + ", ", "        " + this.getList("t.", (SchemaColumn[][])new SchemaColumn[][]{this.scenarioIdColumns, this.triggerIdColumns, this.triggerInfoColumns}), "    FROM (", "        SELECT * FROM " + this.getQuotedFullResolvedTableName(SCENARIO_RUNS_TABLE) + " s", "        WHERE s." + this.quote(SCENARIO_PROJECT_KEY_COLUMN) + " = ?", "        AND s." + this.quote(SCENARIO_ID_COLUMN) + " = ?" + outcomeFilter, "        ORDER BY                 s." + this.quote(SCENARIO_PROJECT_KEY_COLUMN) + ", ", "                s." + this.quote(SCENARIO_ID_COLUMN) + ", ", "                s." + this.quote(SCENARIO_RUN_ID_COLUMN) + " DESC", "            LIMIT " + count, "    ) s", "    LEFT JOIN " + this.getQuotedFullResolvedTableName(TRIGGER_FIRES_TABLE) + " t", "        ON t." + this.quote(SCENARIO_PROJECT_KEY_COLUMN) + " = s." + this.quote(SCENARIO_PROJECT_KEY_COLUMN), "        AND t." + this.quote(SCENARIO_ID_COLUMN) + " = s." + this.quote(SCENARIO_ID_COLUMN), "        AND t." + this.quote(TRIGGER_ID_COLUMN) + " = s." + this.quote(TRIGGER_ID_COLUMN), "        AND t." + this.quote(TRIGGER_RUN_ID_COLUMN) + " = s." + this.quote(TRIGGER_RUN_ID_COLUMN), "    ORDER BY s." + this.quote(SCENARIO_RUN_ID_COLUMN) + " DESC");
    }

    /*
     * Exception decompiling
     */
    public List<TriggerFire> getLastFires(Scenario scenario) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String generateScenarioFilter(List<Scenario> scenarios) {
        String constantStringTypeCast = StringUtils.equals((String)"H2", (String)this.getDialect().getId()) ? "" : "::text";
        ArrayList scenarioSubClauses = Lists.newArrayList();
        for (Scenario scenario : scenarios) {
            scenarioSubClauses.add("( " + this.quoteString(scenario.getProjectKey()) + constantStringTypeCast + ", " + this.quoteString(scenario.getId()) + constantStringTypeCast + ")");
        }
        if (StringUtils.equals((String)"H2", (String)this.getDialect().getId())) {
            return "JOIN(SELECT C1 as pkey, C2 as scid FROM (VALUES " + Joiner.on((String)",").join((Iterable)scenarioSubClauses) + ") ) scenarios";
        }
        return "JOIN ( VALUES " + Joiner.on((String)",").join((Iterable)scenarioSubClauses) + " ) scenarios(pkey, scid)";
    }

    /*
     * Exception decompiling
     */
    public ScenarioRunsBoundaries getScenarioRunsBoundaries(long fromDate, long toDate, List<Scenario> scenarios) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public ScenarioRunsBoundaries getScenarioRunsBoundaries(long fromDate, long toDate, String ... projectKeys) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public ScenarioRunsBoundaries getScenarioRunsBoundaries(String projectKey, String scenarioId) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Map<String, Integer> getRunCounts(Map<String, Set<String>> checkIds) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<ScenarioRun> getRuns(long from, long to, boolean shortVersion, String ... projectKeys) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<ScenarioRun> getRuns(String projectKey, String scenarioId, long from, long to, boolean shortVersion) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ProjectRunsSummary getRunsSummary(String projectKey, long from, long to) throws SQLException {
        logger.info((Object)("Get scenario runs summary for " + projectKey + " in range [" + from + " -> " + to + "]"));
        String truncatedToDayTimeStart = StringUtils.equals((String)"H2", (String)this.getDialect().getId()) ? "TRUNCATE(DATEADD('SECOND', s." + this.quote(TIME_START_COLUMN) + "/1000, DATE '1970-01-01'))" : "date_trunc('day',(to_timestamp(s." + this.quote(TIME_START_COLUMN) + "/1000)))";
        ProjectRunsSummary ret = new ProjectRunsSummary();
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.db.jobs.access.getRunsSummary");
             DSSDBConnection ac = this.acquireConnection();
             PreparedStatement ps2 = ac.prepareNonPersistedStatement("SELECT count(*) c, s." + this.quote(OUTCOME_COLUMN) + ", s." + this.quote(SCENARIO_ID_COLUMN) + ", " + truncatedToDayTimeStart + " ts\nFROM " + this.getQuotedFullResolvedTableName(SCENARIO_RUNS_TABLE) + " s\nWHERE s." + this.quote(SCENARIO_PROJECT_KEY_COLUMN) + "=? AND s." + this.quote(TIME_START_COLUMN) + " <= ? AND (s." + this.quote(TIME_END_COLUMN) + " >= ? OR s." + this.quote(TIME_END_COLUMN) + " IS NULL)\nGROUP BY s." + this.quote(OUTCOME_COLUMN) + ", s." + this.quote(SCENARIO_ID_COLUMN) + ", ts");){
            ps2.setString(1, projectKey);
            ps2.setLong(2, to);
            ps2.setLong(3, from);
            ps2.execute();
            ResultSet rs2 = ps2.getResultSet();
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
            while (rs2.next()) {
                long count = rs2.getLong("c");
                String outcome = rs2.getString(OUTCOME_COLUMN);
                String scenarioId = rs2.getString(SCENARIO_ID_COLUMN);
                Timestamp dayAsTS = rs2.getTimestamp("ts");
                String dayAsString = fmt.format(dayAsTS);
                ProjectRunsSummary.ScenarioRunsSummary scenarioRunsSummary = ret.countsByScenario.getOrDefault(scenarioId, new ProjectRunsSummary.ScenarioRunsSummary());
                ProjectRunsSummary.ScenarioRunDaySummary scenarioRunSummaryForDay = scenarioRunsSummary.countsByDay.getOrDefault(dayAsString, new ProjectRunsSummary.ScenarioRunDaySummary());
                scenarioRunSummaryForDay.countByOutcome.put(outcome, count);
                scenarioRunsSummary.countsByDay.putIfAbsent(dayAsString, scenarioRunSummaryForDay);
                ret.countsByScenario.putIfAbsent(scenarioId, scenarioRunsSummary);
            }
        }
        ret.compute();
        return ret;
    }

    public List<MetricDataPoint> getMetrics(final AnyLoc loc, final String partitionId, final String metricId) throws Exception {
        logger.debug((Object)("Getting data of metric " + metricId + " for " + loc.getFullName()));
        final ArrayList data = Lists.newArrayList();
        MetricDataPointConsumer consumer = new MetricDataPointConsumer(){

            @Override
            public void setParameters(PreparedStatement select) throws SQLException {
                select.setString(1, loc.getProjectKey());
                ReadOnlyJobsInternalDB.setNotNullStringParameter(select, 2, loc.getId(), ReadOnlyJobsInternalDB.NULL_AS_STRING);
                ReadOnlyJobsInternalDB.setNotNullStringParameter(select, 3, partitionId, ReadOnlyJobsInternalDB.NOT_PARTITIONED);
                select.setString(4, metricId);
            }

            @Override
            public boolean handle(MetricDataPoint point) {
                data.add(point);
                return true;
            }

            @Override
            public String getFilterClause(boolean last) {
                return "s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.PROJECT_KEY_COLUMN) + " = ? AND s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.OBJECT_ID_COLUMN) + " = ? AND s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.PARTITION_COLUMN) + " = ? AND h." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.METRIC_ID_COLUMN) + " = ? AND h." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.METRIC_ID_COLUMN) + " != " + ReadOnlyJobsInternalDB.this.quoteString(ReadOnlyJobsInternalDB.NULL_AS_STRING);
            }

            @Override
            public boolean caresAboutOrder() {
                return true;
            }
        };
        this.readMetrics(consumer);
        return data;
    }

    public void browseRecentMetricData(final AnyLoc loc, final String partitionId, final String metricId, final Predicate<MetricDataPoint> handleMethod) throws Exception {
        logger.debug((Object)("Getting recent data for metric " + metricId + " for " + loc.getFullName() + " (" + partitionId + ")"));
        MetricDataPointConsumer consumer = new MetricDataPointConsumer(){

            @Override
            public void setParameters(PreparedStatement select) throws SQLException {
                select.setString(1, loc.getProjectKey());
                ReadOnlyJobsInternalDB.setNotNullStringParameter(select, 2, loc.getId(), ReadOnlyJobsInternalDB.NULL_AS_STRING);
                ReadOnlyJobsInternalDB.setNotNullStringParameter(select, 3, partitionId, ReadOnlyJobsInternalDB.NOT_PARTITIONED);
                select.setString(4, metricId);
            }

            @Override
            public boolean handle(MetricDataPoint point) {
                return handleMethod.test(point);
            }

            @Override
            public String getFilterClause(boolean last) {
                return "s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.PROJECT_KEY_COLUMN) + " = ? AND s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.OBJECT_ID_COLUMN) + " = ? AND s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.PARTITION_COLUMN) + " = ? AND h." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.METRIC_ID_COLUMN) + " = ? AND h." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.METRIC_ID_COLUMN) + " != " + ReadOnlyJobsInternalDB.this.quoteString(ReadOnlyJobsInternalDB.NULL_AS_STRING);
            }

            @Override
            public boolean caresAboutOrder() {
                return true;
            }

            @Override
            public boolean orderDesc() {
                return true;
            }
        };
        this.readMetrics(consumer);
    }

    public List<MetricDataPoint> getMetrics(final DatasetLocUtils.DatasetLoc loc, final String metricId) throws Exception {
        logger.debug((Object)("Getting data of metric " + metricId + " for " + loc.getFullName() + " (any partition)"));
        final ArrayList data = Lists.newArrayList();
        MetricDataPointConsumer consumer = new MetricDataPointConsumer(){

            @Override
            public void setParameters(PreparedStatement select) throws SQLException {
                select.setString(1, loc.getProjectKey());
                ReadOnlyJobsInternalDB.setNotNullStringParameter(select, 2, loc.getName(), ReadOnlyJobsInternalDB.NULL_AS_STRING);
                select.setString(3, metricId);
            }

            @Override
            public boolean handle(MetricDataPoint point) {
                data.add(point);
                return true;
            }

            @Override
            public String getFilterClause(boolean last) {
                return "s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.PROJECT_KEY_COLUMN) + " = ? AND s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.OBJECT_ID_COLUMN) + " = ? AND h." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.METRIC_ID_COLUMN) + " = ? AND h." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.METRIC_ID_COLUMN) + " != " + ReadOnlyJobsInternalDB.this.quoteString(ReadOnlyJobsInternalDB.NULL_AS_STRING);
            }

            @Override
            public boolean caresAboutOrder() {
                return true;
            }
        };
        this.readMetrics(consumer);
        return data;
    }

    public String getColumn(boolean last, String columnName) {
        return (last ? "s." : "h.") + this.quote(columnName);
    }

    public void readMetrics(MetricDataPointConsumer consumer) throws Exception {
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.db.jobs.access.readMetrics");
             DSSDBConnection ac = this.acquireConnection();){
            String query = "SELECT s." + this.quote(TIME_COMPUTE_COLUMN) + ", s." + this.quote(PARTITION_COLUMN) + ", h." + this.quote(METRIC_ID_COLUMN) + ", h." + this.quote(VALUE_TYPE_COLUMN) + ", h." + this.quote(VALUE_COLUMN) + ", s." + this.quote(HASH_COLUMN) + ", s." + this.quote(PROJECT_KEY_COLUMN) + ", s." + this.quote(OBJECT_ID_COLUMN) + " ";
            query = query + "FROM " + this.getQuotedFullResolvedTableName(METRICS_HISTORY_TABLE) + " h INNER JOIN " + this.getQuotedFullResolvedTableName(METRICS_SESSIONS_TABLE) + " s ON s." + this.quote(SESSION_INDEX_COLUMN) + " = h." + this.quote(SESSION_INDEX_COLUMN);
            String clause = consumer.getFilterClause(false);
            query = query + (String)(StringUtils.isBlank((String)clause) ? "" : " WHERE " + clause);
            if (consumer.caresAboutOrder()) {
                query = query + " ORDER BY s." + this.quote(TIME_COMPUTE_COLUMN);
                if (consumer.orderDesc()) {
                    query = query + " DESC";
                }
            }
            try (PreparedStatement select = ac.prepareNonPersistedStatement(query);){
                consumer.setParameters(select);
                ResultSet rs2 = select.executeQuery();
                while (rs2.next()) {
                    Metric metric;
                    long time = rs2.getLong(1);
                    String partition = rs2.getString(2);
                    String metricId = ReadOnlyJobsInternalDB.parseNullableString(rs2.getString(3));
                    Type valueType = Type.valueOf((String)rs2.getString(4));
                    String value = rs2.getString(5);
                    String hash = rs2.getString(6);
                    if (StringUtils.isBlank((String)metricId) || consumer.handle(new MetricDataPoint((metric = Metric.deserializeMetric(metricId)).withId(metricId).withDataType(valueType), rs2.getString(7), ReadOnlyJobsInternalDB.parseNullableString(rs2.getString(8)), time, value, valueType, partition, hash))) continue;
                    break;
                }
            }
        }
    }

    public void readLastMetrics(MetricDataPointConsumer consumer) throws Exception {
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.db.jobs.access.readLastMetrics");
             DSSDBConnection ac = this.acquireConnection();){
            String query = "SELECT s." + this.quote(TIME_COMPUTE_COLUMN) + ", s." + this.quote(PARTITION_COLUMN) + ", s." + this.quote(METRIC_ID_COLUMN) + ", s." + this.quote(VALUE_TYPE_COLUMN) + ", s." + this.quote(VALUE_COLUMN) + ", s." + this.quote(HASH_COLUMN) + ", s." + this.quote(PROJECT_KEY_COLUMN) + ", s." + this.quote(OBJECT_ID_COLUMN) + " ";
            String clause = consumer.getFilterClause(true);
            query = query + "FROM " + this.getQuotedFullResolvedTableName(METRICS_LAST_TABLE) + " s " + (String)(StringUtils.isBlank((String)clause) ? "" : " WHERE " + clause);
            if (consumer.caresAboutOrder()) {
                query = query + " ORDER BY s." + this.quote(TIME_COMPUTE_COLUMN);
                if (consumer.orderDesc()) {
                    query = query + " DESC";
                }
            }
            try (PreparedStatement select = ac.prepareNonPersistedStatement(query);){
                consumer.setParameters(select);
                ResultSet rs2 = select.executeQuery();
                while (rs2.next()) {
                    Metric metric;
                    long time = rs2.getLong(1);
                    String partition = rs2.getString(2);
                    String metricId = ReadOnlyJobsInternalDB.parseNullableString(rs2.getString(3));
                    Type valueType = Type.valueOf((String)rs2.getString(4));
                    String value = rs2.getString(5);
                    String hash = rs2.getString(6);
                    if (StringUtils.isBlank((String)metricId) || consumer.handle(new MetricDataPoint((metric = Metric.deserializeMetric(metricId)).withId(metricId).withDataType(valueType), rs2.getString(7), ReadOnlyJobsInternalDB.parseNullableString(rs2.getString(8)), time, value, valueType, partition, hash))) continue;
                    break;
                }
            }
        }
    }

    public List<String> getMetricIdsList(AnyLoc loc) throws SQLException {
        return this.getMetricIdsList(loc.getProjectKey(), loc.getId());
    }

    public List<String> getMetricIdsList(String projectKey, String objectId) throws SQLException {
        logger.debug((Object)("Getting known metrics ids for " + projectKey + "." + objectId));
        ArrayList computed = Lists.newArrayList();
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.db.jobs.access.getMetricIdsList");
             DSSDBConnection ac = this.acquireConnection();
             PreparedStatement select = ac.prepareNonPersistedStatement("select " + this.quote(METRIC_ID_COLUMN) + ", count(*) from " + this.getQuotedFullResolvedTableName(METRICS_LAST_TABLE) + " where " + this.quote(PROJECT_KEY_COLUMN) + " = ? and " + this.quote(OBJECT_ID_COLUMN) + " = ? group by " + this.quote(METRIC_ID_COLUMN));){
            select.setString(1, projectKey);
            ReadOnlyJobsInternalDB.setNotNullStringParameter(select, 2, objectId, NULL_AS_STRING);
            ResultSet rs2 = select.executeQuery();
            while (rs2.next()) {
                String metricId = ReadOnlyJobsInternalDB.parseNullableString(rs2.getString(1));
                computed.add(metricId);
            }
        }
        return computed;
    }

    public Map<String, String> getCheckIdsAndDisplayNames(AnyLoc loc) throws SQLException {
        return this.getCheckIdsAndDisplayNames(loc.getProjectKey(), loc.getId());
    }

    public Map<String, String> getCheckIdsAndDisplayNames(String projectKey, String objectId) throws SQLException {
        logger.debug((Object)("Getting known check ids/display names for " + projectKey + "." + objectId));
        HashMap computed = Maps.newHashMap();
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.db.jobs.access.getCheckIdsList");
             DSSDBConnection ac = this.acquireConnection();
             PreparedStatement select = ac.prepareNonPersistedStatement("select " + this.quote(NAME_COLUMN) + ", MIN(" + this.quote(CHECK_JSON_COLUMN) + ") from " + this.getQuotedFullResolvedTableName(CHECKS_LAST_TABLE) + " where " + this.quote(PROJECT_KEY_COLUMN) + " = ? and " + this.quote(OBJECT_ID_COLUMN) + " = ? group by " + this.quote(NAME_COLUMN));){
            select.setString(1, projectKey);
            ReadOnlyJobsInternalDB.setNotNullStringParameter(select, 2, objectId, NULL_AS_STRING);
            ResultSet rs2 = select.executeQuery();
            while (rs2.next()) {
                String name = ReadOnlyJobsInternalDB.parseNullableString(rs2.getString(1));
                String checkData = rs2.getString(2);
                computed.put(name, this.getCheckDisplayName(checkData));
            }
        }
        return computed;
    }

    public Set<String> getDistinctPartitionWhereChecksComputed(String projectKey, String objectId, Set<String> checkIds) throws SQLException {
        if (checkIds.isEmpty()) {
            return Collections.emptySet();
        }
        String checkIdListString = checkIds.stream().map(x$0 -> this.quoteString((String)x$0)).collect(Collectors.joining(","));
        logger.debug((Object)("Getting distinct partitions for " + projectKey + "." + objectId + " where the following rules have already been computed :" + checkIdListString));
        HashSet<String> partitions = new HashSet<String>();
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.db.jobs.access.getDistinctPartitionWhereChecksComputed");
             DSSDBConnection ac = this.acquireConnection();){
            String query = "select distinct " + this.quote(PARTITION_COLUMN) + " from " + this.getQuotedFullResolvedTableName(CHECKS_LAST_TABLE) + " where " + this.quote(PROJECT_KEY_COLUMN) + " = " + this.quoteString(projectKey) + " and " + this.quote(OBJECT_ID_COLUMN) + " = " + this.quoteString(objectId) + " and " + this.quote(NAME_COLUMN) + " in (" + checkIdListString + ")";
            try (PreparedStatement select = ac.prepareNonPersistedStatement(query);){
                ResultSet rs2 = select.executeQuery();
                while (rs2.next()) {
                    String partition = rs2.getString(1);
                    partitions.add(partition);
                }
            }
        }
        return partitions;
    }

    public Map<String, CheckDataPoint> getLastChecksResultForPartition(final String projectKey, final String objectId, final String partition, final @Nullable String ruleId) throws Exception {
        logger.debug((Object)("Getting last checks results for project " + projectKey + "  on dataset " + objectId + " for partition " + partition));
        final HashMap<String, CheckDataPoint> computed = new HashMap<String, CheckDataPoint>();
        this.readLastChecks(new CheckDataPointConsumer(){

            @Override
            public boolean caresAboutOrder() {
                return false;
            }

            @Override
            public String getFilterClause(boolean last) {
                String filterClause = "s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.PROJECT_KEY_COLUMN) + " = ? AND s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.OBJECT_ID_COLUMN) + " = ? AND s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.PARTITION_COLUMN) + " = ?";
                if (ruleId != null) {
                    filterClause = filterClause + " AND s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.NAME_COLUMN) + " = ?";
                }
                return filterClause;
            }

            @Override
            public void setParameters(PreparedStatement select) throws SQLException {
                select.setString(1, projectKey);
                ReadOnlyJobsInternalDB.setNotNullStringParameter(select, 2, objectId, ReadOnlyJobsInternalDB.NULL_AS_STRING);
                ReadOnlyJobsInternalDB.setNotNullStringParameter(select, 3, partition, ReadOnlyJobsInternalDB.NOT_PARTITIONED);
                if (ruleId != null) {
                    select.setString(4, ruleId);
                }
            }

            @Override
            public boolean handle(CheckDataPoint point) throws Exception {
                computed.put(point.check.getId(), point);
                return true;
            }
        });
        return computed;
    }

    public List<MetricDataPoint> getLastMetrics(final AnyLoc loc, final String partitionId) throws Exception {
        logger.debug((Object)("Getting last computed metrics for " + loc.getFullName() + " (" + partitionId + ")"));
        final ArrayList computed = Lists.newArrayList();
        this.readLastMetrics(new MetricDataPointConsumer(){

            @Override
            public void setParameters(PreparedStatement select) throws SQLException {
                select.setString(1, loc.getProjectKey());
                ReadOnlyJobsInternalDB.setNotNullStringParameter(select, 2, loc.getId(), ReadOnlyJobsInternalDB.NULL_AS_STRING);
                ReadOnlyJobsInternalDB.setNotNullStringParameter(select, 3, partitionId, ReadOnlyJobsInternalDB.NOT_PARTITIONED);
            }

            @Override
            public boolean handle(MetricDataPoint point) throws Exception {
                computed.add(point);
                return true;
            }

            @Override
            public String getFilterClause(boolean last) {
                return "s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.PROJECT_KEY_COLUMN) + " = ? AND s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.OBJECT_ID_COLUMN) + " = ? AND s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.PARTITION_COLUMN) + " = ? AND s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.METRIC_ID_COLUMN) + " != " + ReadOnlyJobsInternalDB.this.quoteString(ReadOnlyJobsInternalDB.NULL_AS_STRING);
            }

            @Override
            public boolean caresAboutOrder() {
                return false;
            }
        });
        return computed;
    }

    public List<MetricDataPoint> getLastMetrics(final DatasetLocUtils.DatasetLoc loc) throws Exception {
        logger.debug((Object)("Getting last computed metrics for " + loc.getFullName()));
        final ArrayList computed = Lists.newArrayList();
        this.readLastMetrics(new MetricDataPointConsumer(){

            @Override
            public void setParameters(PreparedStatement select) throws SQLException {
                select.setString(1, loc.getProjectKey());
                ReadOnlyJobsInternalDB.setNotNullStringParameter(select, 2, loc.getName(), ReadOnlyJobsInternalDB.NULL_AS_STRING);
            }

            @Override
            public boolean handle(MetricDataPoint point) throws Exception {
                computed.add(point);
                return true;
            }

            @Override
            public String getFilterClause(boolean last) {
                return "s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.PROJECT_KEY_COLUMN) + " = ? AND s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.OBJECT_ID_COLUMN) + " = ? AND s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.METRIC_ID_COLUMN) + " != " + ReadOnlyJobsInternalDB.this.quoteString(ReadOnlyJobsInternalDB.NULL_AS_STRING);
            }

            @Override
            public boolean caresAboutOrder() {
                return false;
            }
        });
        return computed;
    }

    public List<MetricDataPoint> getLastMetricValues(final DatasetLocUtils.DatasetLoc loc, final String metricId) throws Exception {
        logger.trace(() -> "Getting last computed values of " + metricId + " for " + loc.getFullName());
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.db.jobs.access.getLastMetricValues.metricId");){
            final ArrayList computed = Lists.newArrayList();
            this.readLastMetrics(new MetricDataPointConsumer(){

                @Override
                public void setParameters(PreparedStatement select) throws SQLException {
                    select.setString(1, loc.getProjectKey());
                    ReadOnlyJobsInternalDB.setNotNullStringParameter(select, 2, loc.getName(), ReadOnlyJobsInternalDB.NULL_AS_STRING);
                    select.setString(3, metricId);
                }

                @Override
                public boolean handle(MetricDataPoint point) throws Exception {
                    computed.add(point);
                    return true;
                }

                @Override
                public String getFilterClause(boolean last) {
                    return "s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.PROJECT_KEY_COLUMN) + " = ? AND s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.OBJECT_ID_COLUMN) + " = ? AND s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.METRIC_ID_COLUMN) + " = ?";
                }

                @Override
                public boolean caresAboutOrder() {
                    return false;
                }
            });
            ArrayList arrayList = computed;
            return arrayList;
        }
    }

    public List<MetricDataPoint> getLastMetricValues(final DatasetLocUtils.DatasetLoc loc, final String partitionId, final List<String> metricIds) throws Exception {
        logger.trace(() -> "Getting last computed values of " + metricIds.size() + " metrics for " + loc.getFullName());
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.db.jobs.access.getLastMetricValues.metricIds");){
            final ArrayList computed = Lists.newArrayList();
            if (metricIds.isEmpty()) {
                logger.traceV("No metrics selected for %s. You need to select columns.", new Object[]{loc.getFullName()});
                ArrayList arrayList = computed;
                return arrayList;
            }
            this.readLastMetrics(new MetricDataPointConsumer(){

                @Override
                public void setParameters(PreparedStatement select) throws SQLException {
                    select.setString(1, loc.getProjectKey());
                    ReadOnlyJobsInternalDB.setNotNullStringParameter(select, 2, loc.getName(), ReadOnlyJobsInternalDB.NULL_AS_STRING);
                    ReadOnlyJobsInternalDB.setNotNullStringParameter(select, 3, partitionId, ReadOnlyJobsInternalDB.NOT_PARTITIONED);
                }

                @Override
                public boolean handle(MetricDataPoint point) throws Exception {
                    computed.add(point);
                    return true;
                }

                @Override
                public String getFilterClause(boolean last) {
                    return "s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.PROJECT_KEY_COLUMN) + " = ? AND s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.OBJECT_ID_COLUMN) + " = ? AND s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.PARTITION_COLUMN) + " = ? AND " + QueryUtils.inValues(ReadOnlyJobsInternalDB.this.getDialect(), "s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.METRIC_ID_COLUMN), metricIds, null, Type.STRING);
                }

                @Override
                public boolean caresAboutOrder() {
                    return false;
                }
            });
            ArrayList arrayList = computed;
            return arrayList;
        }
    }

    private PreparedStatement prepareStatementForRetrievalScope(DSSDBConnection conn, String sql, JobsdbDatasetParams.RetrievalScope scope, AnyLoc loc) throws SQLException {
        switch (scope) {
            case SINGLE_OBJECT: {
                PreparedStatement ps2 = conn.prepareNonPersistedStatement(sql + " where " + this.quote(PROJECT_KEY_COLUMN) + " = ? and " + this.quote(OBJECT_ID_COLUMN) + " = ?");
                ps2.setString(1, loc.getProjectKey());
                ReadOnlyJobsInternalDB.setNotNullStringParameter(ps2, 2, loc.getId(), NULL_AS_STRING);
                return ps2;
            }
            case PROJECT: {
                PreparedStatement ps3 = conn.prepareNonPersistedStatement(sql + " where " + this.quote(PROJECT_KEY_COLUMN) + " = ? and " + this.quote(OBJECT_ID_COLUMN) + " = " + this.quoteString(NULL_AS_STRING));
                ps3.setString(1, loc.getProjectKey());
                return ps3;
            }
            case PROJECT_WHOLE: {
                PreparedStatement ps4 = conn.prepareNonPersistedStatement(sql + " where " + this.quote(PROJECT_KEY_COLUMN) + " = ?");
                ps4.setString(1, loc.getProjectKey());
                return ps4;
            }
            case INSTANCE: {
                return conn.prepareNonPersistedStatement(sql);
            }
        }
        throw new Error("unreachable");
    }

    private long returnFirstResultAsLong(PreparedStatement ps2) throws SQLException {
        ResultSet rs2 = ps2.executeQuery();
        if (rs2.next()) {
            return rs2.getLong(1);
        }
        return 0L;
    }

    /*
     * Exception decompiling
     */
    public long getMetricHistoryCount(JobsdbDatasetParams.RetrievalScope scope, AnyLoc loc) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean hasMetricHistory(@Nonnull AnyLoc loc, @Nonnull ProbeTypeFilter probeTypeFilter) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public long getMetricLastCount(JobsdbDatasetParams.RetrievalScope scope, AnyLoc loc) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public long getCheckHistoryCount(JobsdbDatasetParams.RetrievalScope scope, AnyLoc loc) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public long getCheckLastCount(JobsdbDatasetParams.RetrievalScope scope, AnyLoc loc) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<CheckDataPoint> getChecks(DatasetLocUtils.DatasetLoc loc, String partitionId, String checkName) throws Exception {
        return this.getChecks(loc.getProjectKey(), loc.getId(), partitionId, checkName);
    }

    public List<CheckDataPoint> getChecks(final String projectKey, final String objectId, final String partitionId, final String name) throws Exception {
        logger.debug((Object)("Getting data of check " + name + " for " + objectId + "on project" + projectKey));
        final ArrayList data = Lists.newArrayList();
        CheckDataPointConsumer consumer = new CheckDataPointConsumer(){

            @Override
            public void setParameters(PreparedStatement select) throws SQLException {
                select.setString(1, projectKey);
                ReadOnlyJobsInternalDB.setNotNullStringParameter(select, 2, objectId, ReadOnlyJobsInternalDB.NULL_AS_STRING);
                ReadOnlyJobsInternalDB.setNotNullStringParameter(select, 3, partitionId, ReadOnlyJobsInternalDB.NOT_PARTITIONED);
                select.setString(4, name);
            }

            @Override
            public boolean handle(CheckDataPoint point) {
                data.add(point);
                return true;
            }

            @Override
            public String getFilterClause(boolean last) {
                return "s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.PROJECT_KEY_COLUMN) + " = ? AND s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.OBJECT_ID_COLUMN) + " = ? AND s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.PARTITION_COLUMN) + " = ? AND h." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.NAME_COLUMN) + " = ? AND h." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.NAME_COLUMN) + " != " + ReadOnlyJobsInternalDB.this.quoteString(ReadOnlyJobsInternalDB.NULL_AS_STRING);
            }

            @Override
            public boolean caresAboutOrder() {
                return true;
            }
        };
        this.readChecks(consumer);
        return data;
    }

    public List<CheckDataPoint> getChecks(final DatasetLocUtils.DatasetLoc loc, final String checkName) throws Exception {
        logger.debug((Object)("Getting data of check " + checkName + " for " + loc.getFullName() + " (any partition)"));
        final ArrayList data = Lists.newArrayList();
        CheckDataPointConsumer consumer = new CheckDataPointConsumer(){

            @Override
            public void setParameters(PreparedStatement select) throws SQLException {
                select.setString(1, loc.getProjectKey());
                ReadOnlyJobsInternalDB.setNotNullStringParameter(select, 2, loc.getName(), ReadOnlyJobsInternalDB.NULL_AS_STRING);
                select.setString(3, checkName);
            }

            @Override
            public boolean handle(CheckDataPoint point) {
                data.add(point);
                return true;
            }

            @Override
            public String getFilterClause(boolean last) {
                return "s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.PROJECT_KEY_COLUMN) + " = ? AND s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.OBJECT_ID_COLUMN) + " = ? AND h." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.NAME_COLUMN) + " = ? AND h." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.NAME_COLUMN) + " != " + ReadOnlyJobsInternalDB.this.quoteString(ReadOnlyJobsInternalDB.NULL_AS_STRING);
            }

            @Override
            public boolean caresAboutOrder() {
                return true;
            }
        };
        this.readChecks(consumer);
        return data;
    }

    public void readChecks(CheckDataPointConsumer consumer) throws Exception {
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.db.jobs.access.readChecks");
             DSSDBConnection ac = this.acquireConnection();){
            String query = "SELECT s." + this.quote(TIME_COMPUTE_COLUMN) + ", s." + this.quote(PARTITION_COLUMN) + ", h." + this.quote(NAME_COLUMN) + ", h." + this.quote(CHECK_JSON_COLUMN) + ", h." + this.quote(OUTCOME_COLUMN) + ", h." + this.quote(MESSAGE_COLUMN) + ", s." + this.quote(PROJECT_KEY_COLUMN) + ", s." + this.quote(OBJECT_ID_COLUMN) + ", s." + this.quote(SESSION_INDEX_COLUMN) + ", s." + this.quote(RUN_ORIGIN_COLUMN) + " ";
            query = query + "FROM " + this.getQuotedFullResolvedTableName(CHECKS_HISTORY_TABLE) + " h INNER JOIN " + this.getQuotedFullResolvedTableName(CHECKS_SESSIONS_TABLE) + " s ON s." + this.quote(SESSION_INDEX_COLUMN) + " = h." + this.quote(SESSION_INDEX_COLUMN);
            String clause = consumer.getFilterClause(false);
            query = query + (String)(StringUtils.isBlank((String)clause) ? "" : " WHERE " + clause);
            if (consumer.caresAboutOrder()) {
                query = query + " ORDER BY s." + this.quote(TIME_COMPUTE_COLUMN);
                if (consumer.reverseOrder()) {
                    query = query + " DESC";
                }
            }
            try (PreparedStatement select = ac.prepareNonPersistedStatement(query);){
                consumer.setParameters(select);
                ResultSet rs2 = select.executeQuery();
                while (rs2.next()) {
                    long time = rs2.getLong(1);
                    String partition = rs2.getString(2);
                    String name = ReadOnlyJobsInternalDB.parseNullableString(rs2.getString(3));
                    String checkData = rs2.getString(4);
                    AbstractCheckContext.CheckOutcome outcome = AbstractCheckContext.CheckOutcome.valueOf(rs2.getString(5));
                    String message = rs2.getString(6);
                    String projectKey = rs2.getString(7);
                    String objectId = ReadOnlyJobsInternalDB.parseNullableString(rs2.getString(8));
                    int sessionIndex = rs2.getInt(9);
                    DataQualityRunOrigin runOrigin = DataQualityRunOrigin.parse(ReadOnlyJobsInternalDB.parseNullableString(rs2.getString(10)));
                    DataQualityRule check = StringUtils.isBlank((String)checkData) ? null : (DataQualityRule)JSON.parse((String)checkData, DataQualityRule.class);
                    if (consumer.handle(new CheckDataPoint(check, projectKey, objectId, time, name, outcome, message, partition, sessionIndex, runOrigin))) continue;
                    break;
                }
            }
        }
    }

    private String getCheckDisplayName(String checkData) {
        if (StringUtils.isBlank((String)checkData)) {
            return "";
        }
        DataQualityRule check = (DataQualityRule)JSON.parse((String)checkData, DataQualityRule.class);
        check.updateDisplayName();
        return check.displayName;
    }

    public Map<String, String> getAllRulesThatEverExisted(String projectKey, String datasetName, @Nullable String partition) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        try (DSSDBConnection ac = this.acquireConnection();){
            String query = "SELECT h." + this.quote(NAME_COLUMN) + ", MIN(" + this.quote(CHECK_JSON_COLUMN) + ") FROM " + this.getQuotedFullResolvedTableName(CHECKS_HISTORY_TABLE) + " h INNER JOIN " + this.getQuotedFullResolvedTableName(CHECKS_SESSIONS_TABLE) + " s ON s." + this.quote(SESSION_INDEX_COLUMN) + " = h." + this.quote(SESSION_INDEX_COLUMN) + " WHERE  s." + this.quote(PROJECT_KEY_COLUMN) + " = " + this.quoteString(projectKey) + " AND  s." + this.quote(OBJECT_ID_COLUMN) + " = " + this.quoteString(datasetName) + (String)(partition != null ? " AND s." + this.quote(PARTITION_COLUMN) + " = " + this.quoteString(partition) : "") + " GROUP BY h." + this.quote(NAME_COLUMN);
            try (PreparedStatement select = ac.prepareNonPersistedStatement(query);){
                ResultSet rs2 = select.executeQuery();
                while (rs2.next()) {
                    String checkData = rs2.getString(2);
                    result.put(rs2.getString(1), this.getCheckDisplayName(checkData));
                }
            }
        }
        return result;
    }

    public List<UIRuleHistory.RuleHistoryPoint> getChecksWithFilter(String projectKey, String objectId, UIRuleHistory.PageFilters filters) throws Exception {
        ArrayList<UIRuleHistory.RuleHistoryPoint> result = new ArrayList<UIRuleHistory.RuleHistoryPoint>();
        try (DSSDBConnection ac = this.acquireConnection();){
            String query = "SELECT s." + this.quote(TIME_COMPUTE_COLUMN) + ", s." + this.quote(PARTITION_COLUMN) + ", h." + this.quote(NAME_COLUMN) + ", h." + this.quote(CHECK_JSON_COLUMN) + ", h." + this.quote(OUTCOME_COLUMN) + ", h." + this.quote(MESSAGE_COLUMN) + ", s." + this.quote(RUN_ORIGIN_COLUMN) + " FROM " + this.getQuotedFullResolvedTableName(CHECKS_HISTORY_TABLE) + " h INNER JOIN " + this.getQuotedFullResolvedTableName(CHECKS_SESSIONS_TABLE) + " s ON s." + this.quote(SESSION_INDEX_COLUMN) + " = h." + this.quote(SESSION_INDEX_COLUMN) + " WHERE  s." + this.quote(PROJECT_KEY_COLUMN) + " = " + this.quoteString(projectKey) + " AND  s." + this.quote(OBJECT_ID_COLUMN) + " = " + this.quoteString(objectId);
            if (!filters.rules.isEmpty()) {
                String rules = filters.rules.stream().map(x$0 -> this.quoteString((String)x$0)).collect(Collectors.joining(","));
                query = query + " AND  h." + this.quote(NAME_COLUMN) + " IN (" + rules + ")";
            }
            if (!filters.outcomes.isEmpty()) {
                String outcomes = filters.outcomes.stream().map(Enum::name).map(x$0 -> this.quoteString((String)x$0)).collect(Collectors.joining(","));
                query = query + " AND  h." + this.quote(OUTCOME_COLUMN) + " IN (" + outcomes + ")";
            }
            if (!filters.partitions.isEmpty()) {
                String partitions = filters.partitions.stream().map(x$0 -> this.quoteString((String)x$0)).collect(Collectors.joining(","));
                query = query + " AND  s." + this.quote(PARTITION_COLUMN) + " IN (" + partitions + ")";
            }
            if (filters.startTime != -1L) {
                query = query + " AND  s." + this.quote(TIME_COMPUTE_COLUMN) + " >= " + filters.startTime;
            }
            if (filters.endTime != -1L) {
                query = query + " AND  s." + this.quote(TIME_COMPUTE_COLUMN) + " <= " + filters.endTime;
            }
            query = query + " ORDER BY s." + this.quote(TIME_COMPUTE_COLUMN) + " DESC, h." + this.quote(NAME_COLUMN);
            if (filters.page > 0) {
                query = query + " OFFSET " + filters.page * filters.pageSize;
            }
            if (filters.pageSize > 0) {
                query = query + " LIMIT " + filters.pageSize;
            }
            try (PreparedStatement select = ac.prepareNonPersistedStatement(query);){
                ResultSet rs2 = select.executeQuery();
                while (rs2.next()) {
                    UIRuleHistory.RuleHistoryPoint point = new UIRuleHistory.RuleHistoryPoint();
                    String checkData = rs2.getString(4);
                    point.displayName = this.getCheckDisplayName(checkData);
                    point.id = rs2.getString(3);
                    point.computationTime = rs2.getLong(1);
                    point.message = rs2.getString(6);
                    point.outcome = AbstractCheckContext.CheckOutcome.valueOf(rs2.getString(5));
                    point.runOrigin = DataQualityRunOrigin.parse(ReadOnlyJobsInternalDB.parseNullableString(rs2.getString(7)));
                    point.partition = rs2.getString(2);
                    result.add(point);
                }
            }
        }
        return result;
    }

    public long countCheckWithFilter(String projectKey, String objectId, UIRuleHistory.PageFilters filters) throws Exception {
        try (DSSDBConnection ac = this.acquireConnection();){
            long l;
            block17: {
                String query = "SELECT COUNT(*) FROM " + this.getQuotedFullResolvedTableName(CHECKS_HISTORY_TABLE) + " h INNER JOIN " + this.getQuotedFullResolvedTableName(CHECKS_SESSIONS_TABLE) + " s ON s." + this.quote(SESSION_INDEX_COLUMN) + " = h." + this.quote(SESSION_INDEX_COLUMN) + " WHERE  s." + this.quote(PROJECT_KEY_COLUMN) + " = " + this.quoteString(projectKey) + " AND  s." + this.quote(OBJECT_ID_COLUMN) + " = " + this.quoteString(objectId);
                if (!filters.rules.isEmpty()) {
                    String rules = filters.rules.stream().map(x$0 -> this.quoteString((String)x$0)).collect(Collectors.joining(","));
                    query = query + " AND  h." + this.quote(NAME_COLUMN) + " IN (" + rules + ")";
                }
                if (!filters.outcomes.isEmpty()) {
                    String outcomes = filters.outcomes.stream().map(Enum::name).map(x$0 -> this.quoteString((String)x$0)).collect(Collectors.joining(","));
                    query = query + " AND  h." + this.quote(OUTCOME_COLUMN) + " IN (" + outcomes + ")";
                }
                if (!filters.partitions.isEmpty()) {
                    String partitions = filters.partitions.stream().map(x$0 -> this.quoteString((String)x$0)).collect(Collectors.joining(","));
                    query = query + " AND  s." + this.quote(PARTITION_COLUMN) + " IN (" + partitions + ")";
                }
                if (filters.startTime != -1L) {
                    query = query + " AND  s." + this.quote(TIME_COMPUTE_COLUMN) + " >= " + filters.startTime;
                }
                if (filters.endTime != -1L) {
                    query = query + " AND  s." + this.quote(TIME_COMPUTE_COLUMN) + " <= " + filters.endTime;
                }
                PreparedStatement select = ac.prepareNonPersistedStatement(query);
                try {
                    l = this.returnFirstResultAsLong(select);
                    if (select == null) break block17;
                }
                catch (Throwable throwable) {
                    if (select != null) {
                        try {
                            select.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                select.close();
            }
            return l;
        }
    }

    public boolean hasDataInChecksHistory(String projectKey, String objectId, @Nullable List<String> partitionList) throws Exception {
        if (partitionList != null && partitionList.isEmpty()) {
            return false;
        }
        try (DSSDBConnection ac = this.acquireConnection();){
            boolean bl;
            block14: {
                String query = "SELECT 1 FROM " + this.getQuotedFullResolvedTableName(CHECKS_SESSIONS_TABLE) + " WHERE " + this.quote(PROJECT_KEY_COLUMN) + " = " + this.quoteString(projectKey) + " AND " + this.quote(OBJECT_ID_COLUMN) + " = " + this.quoteString(objectId);
                if (partitionList != null) {
                    String partitions = partitionList.stream().map(x$0 -> this.quoteString((String)x$0)).collect(Collectors.joining(","));
                    query = query + " AND " + this.quote(PARTITION_COLUMN) + " IN (" + partitions + ")";
                }
                query = query + " LIMIT 1";
                PreparedStatement select = ac.prepareNonPersistedStatement(query);
                try {
                    ResultSet rs2 = select.executeQuery();
                    bl = rs2.next();
                    if (select == null) break block14;
                }
                catch (Throwable throwable) {
                    if (select != null) {
                        try {
                            select.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                select.close();
            }
            return bl;
        }
    }

    @Nullable
    public DataQualityLastObjectPoint getLastDataQualityObjectStatus(String projectKey, String objectId) throws SQLException {
        AnyLoc loc = new AnyLoc(projectKey, objectId);
        return this.getLastDataQualityObjectStatusesForList(Collections.singletonList(loc)).getOrDefault(loc, null);
    }

    public Map<AnyLoc, DataQualityLastObjectPoint> getLastDataQualityObjectStatusesForList(Collection<AnyLoc> objects) throws SQLException {
        logger.debug((Object)("Getting DQ object statuses for " + objects.size() + " objects"));
        SelectQueryBuilder builder = new SelectQueryBuilder();
        builder.from(this.resolveTable(DATA_QUALITY_OBJECT_LAST_TABLE), "object_last");
        Stream.of(UPDATE_TIME_COLUMN, ERROR_COUNT_COLUMN, WARNING_COUNT_COLUMN, OK_COUNT_COLUMN, EMPTY_COUNT_COLUMN, WORST_ERROR_COUNT_COLUMN, WORST_WARNING_COUNT_COLUMN, WORST_OK_COUNT_COLUMN, WORST_EMPTY_COUNT_COLUMN, DISPLAY_NAME_COLUMN, WORST_MONITORED_OUTCOME_COLUMN, DELETED_COLUMN, LAST_RULE_COMPUTE_TIME_COLUMN).forEach(builder::select);
        builder.where(EBF.col(PROJECT_KEY_COLUMN).nullUnsafeEq(EBF.expr("?"))).where(EBF.col(OBJECT_ID_COLUMN).nullUnsafeEq(EBF.expr("?")));
        HashMap<AnyLoc, DataQualityLastObjectPoint> res = new HashMap<AnyLoc, DataQualityLastObjectPoint>();
        try (DSSDBConnection ac = this.acquireConnection();
             PreparedStatement select = ac.prepareNonPersistedStatement(builder.toSQL(this.getDialect()));){
            for (AnyLoc obj : objects) {
                select.setString(1, obj.getProjectKey());
                select.setString(2, obj.getId());
                ResultSet rs2 = select.executeQuery();
                if (!rs2.next()) continue;
                res.put(new AnyLoc(obj.getProjectKey(), obj.getId()), new DataQualityLastObjectPoint(obj.getProjectKey(), obj.getId(), rs2.getLong(1), rs2.getLong(13), this.readDataQualityOutcome(rs2, 2), this.readDataQualityOutcome(rs2, 6), rs2.getString(10), this.parseNullableCheckOutcome(rs2.getString(11)), rs2.getBoolean(12)));
            }
        }
        return res;
    }

    public Map<String, DataQualityLastObjectPoint> getLastDataQualityObjectStatusesForProject(String projectKey) throws SQLException {
        logger.debug((Object)("Getting DQ object statuses for project " + projectKey));
        SelectQueryBuilder builder = new SelectQueryBuilder();
        builder.from(this.resolveTable(DATA_QUALITY_OBJECT_LAST_TABLE), "object_last");
        Stream.of(OBJECT_ID_COLUMN, UPDATE_TIME_COLUMN, ERROR_COUNT_COLUMN, WARNING_COUNT_COLUMN, OK_COUNT_COLUMN, EMPTY_COUNT_COLUMN, WORST_ERROR_COUNT_COLUMN, WORST_WARNING_COUNT_COLUMN, WORST_OK_COUNT_COLUMN, WORST_EMPTY_COUNT_COLUMN, DISPLAY_NAME_COLUMN, WORST_MONITORED_OUTCOME_COLUMN, DELETED_COLUMN, LAST_RULE_COMPUTE_TIME_COLUMN).forEach(builder::select);
        builder.where(EBF.col(PROJECT_KEY_COLUMN).nullUnsafeEq(projectKey));
        HashMap<String, DataQualityLastObjectPoint> res = new HashMap<String, DataQualityLastObjectPoint>();
        try (DSSDBConnection ac = this.acquireConnection();
             PreparedStatement select = ac.prepareNonPersistedStatement(builder.toSQL(this.getDialect()));){
            ResultSet rs2 = select.executeQuery();
            while (rs2.next()) {
                String objectId = rs2.getString(1);
                res.put(objectId, new DataQualityLastObjectPoint(projectKey, objectId, rs2.getLong(2), rs2.getLong(14), this.readDataQualityOutcome(rs2, 3), this.readDataQualityOutcome(rs2, 7), rs2.getString(11), this.parseNullableCheckOutcome(rs2.getString(12)), rs2.getBoolean(13)));
            }
        }
        return res;
    }

    @Nullable
    public DataQualityPartitionPoint getLastDataQualityPartitionStatus(String projectKey, String objectId, String partitionId) throws SQLException {
        return this.getLastDataQualityPartitionStatusesForList(projectKey, objectId, Collections.singletonList(partitionId)).getOrDefault(partitionId, null);
    }

    public Map<String, DataQualityPartitionPoint> getLastDataQualityPartitionStatusesForList(String projectKey, String objectId, Collection<String> partitionIds) throws SQLException {
        logger.debug((Object)("Getting DQ partition statuses for " + String.join((CharSequence)"/", projectKey, objectId) + " over " + partitionIds.size() + " partition(s)"));
        SelectQueryBuilder builder = new SelectQueryBuilder();
        builder.from(this.resolveTable(DATA_QUALITY_PARTITION_LAST_TABLE), "partition_last");
        Stream.of(UPDATE_TIME_COLUMN, ERROR_COUNT_COLUMN, WARNING_COUNT_COLUMN, OK_COUNT_COLUMN, EMPTY_COUNT_COLUMN, WORST_ERROR_COUNT_COLUMN, WORST_WARNING_COUNT_COLUMN, WORST_OK_COUNT_COLUMN, WORST_EMPTY_COUNT_COLUMN, LAST_RULE_COMPUTE_TIME_COLUMN).forEach(builder::select);
        builder.where(EBF.col(PROJECT_KEY_COLUMN).nullUnsafeEq(projectKey)).where(EBF.col(OBJECT_ID_COLUMN).nullUnsafeEq(objectId)).where(EBF.col(PARTITION_COLUMN).nullUnsafeEq(EBF.expr("?")));
        HashMap<String, DataQualityPartitionPoint> results = new HashMap<String, DataQualityPartitionPoint>();
        try (DSSDBConnection ac = this.acquireConnection();
             PreparedStatement select = ac.prepareNonPersistedStatement(builder.toSQL(this.getDialect()));){
            for (String partitionId : partitionIds) {
                select.setString(1, partitionId);
                ResultSet rs2 = select.executeQuery();
                if (!rs2.next()) continue;
                results.put(partitionId, new DataQualityPartitionPoint(projectKey, objectId, partitionId, rs2.getLong(1), rs2.getLong(10), this.readDataQualityOutcome(rs2, 2), this.readDataQualityOutcome(rs2, 6)));
            }
        }
        return results;
    }

    public List<DataQualityPartitionPoint> getDataQualityPartitionTimeline(String projectKey, String objectId, String partitionId, long startComputeTime, long endComputeTime) throws SQLException {
        logger.debug((Object)("Getting DQ partition status timeline for " + String.join((CharSequence)"/", projectKey, objectId, partitionId) + " between " + startComputeTime + " and " + endComputeTime));
        ArrayList<DataQualityPartitionPoint> points = new ArrayList<DataQualityPartitionPoint>();
        try (DSSDBConnection ac = this.acquireConnection();){
            String query = "SELECT\n   ${DAY_COLUMN},\n   ${ERROR_COUNT_COLUMN},\n   ${WARNING_COUNT_COLUMN},\n   ${OK_COUNT_COLUMN},\n   ${EMPTY_COUNT_COLUMN},\n   ${WORST_ERROR_COUNT_COLUMN},\n   ${WORST_WARNING_COUNT_COLUMN},\n   ${WORST_OK_COUNT_COLUMN},\n   ${WORST_EMPTY_COUNT_COLUMN},\n   ${LAST_RULE_COMPUTE_TIME_COLUMN}\nFROM ${RULESET_TABLE}\nWHERE ${PROJECT_KEY_COLUMN} = ${PROJECT_KEY} AND\n      ${OBJECT_ID_COLUMN} = ${OBJECT_ID} AND\n      ${PARTITION_COLUMN} = ${PARTITION_ID} AND\n      ${DAY_COLUMN} BETWEEN ${START_COMPUTE_TIME} AND ${END_COMPUTE_TIME}";
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("DAY_COLUMN", this.quote(DAY_COLUMN));
            placeholders.put("ERROR_COUNT_COLUMN", this.quote(ERROR_COUNT_COLUMN));
            placeholders.put("WARNING_COUNT_COLUMN", this.quote(WARNING_COUNT_COLUMN));
            placeholders.put("OK_COUNT_COLUMN", this.quote(OK_COUNT_COLUMN));
            placeholders.put("EMPTY_COUNT_COLUMN", this.quote(EMPTY_COUNT_COLUMN));
            placeholders.put("WORST_ERROR_COUNT_COLUMN", this.quote(WORST_ERROR_COUNT_COLUMN));
            placeholders.put("WORST_WARNING_COUNT_COLUMN", this.quote(WORST_WARNING_COUNT_COLUMN));
            placeholders.put("WORST_OK_COUNT_COLUMN", this.quote(WORST_OK_COUNT_COLUMN));
            placeholders.put("WORST_EMPTY_COUNT_COLUMN", this.quote(WORST_EMPTY_COUNT_COLUMN));
            placeholders.put("LAST_RULE_COMPUTE_TIME_COLUMN", this.quote(LAST_RULE_COMPUTE_TIME_COLUMN));
            placeholders.put("RULESET_TABLE", this.getQuotedFullResolvedTableName(DATA_QUALITY_PARTITION_HISTORY_TABLE));
            placeholders.put("PROJECT_KEY_COLUMN", this.quote(PROJECT_KEY_COLUMN));
            placeholders.put(PROJECT_KEY_COLUMN, this.quoteString(projectKey));
            placeholders.put("OBJECT_ID_COLUMN", this.quote(OBJECT_ID_COLUMN));
            placeholders.put(OBJECT_ID_COLUMN, this.quoteString(objectId));
            placeholders.put("PARTITION_COLUMN", this.quote(PARTITION_COLUMN));
            placeholders.put("PARTITION_ID", this.quoteString(partitionId));
            placeholders.put("START_COMPUTE_TIME", String.valueOf(startComputeTime));
            placeholders.put("END_COMPUTE_TIME", String.valueOf(endComputeTime));
            StringSubstitutor substitutor = new StringSubstitutor(placeholders, "${", "}");
            query = substitutor.replace(query);
            try (PreparedStatement select = ac.prepareNonPersistedStatement(query);){
                ResultSet rs2 = select.executeQuery();
                while (rs2.next()) {
                    long computeDay = rs2.getLong(1);
                    long lastRunRuleComputeTime = rs2.getLong(10);
                    DataQualityOutcome outcome = this.readDataQualityOutcome(rs2, 2);
                    DataQualityOutcome worstDayDQOutcome = this.readDataQualityOutcome(rs2, 6);
                    points.add(new DataQualityPartitionPoint(projectKey, objectId, partitionId, computeDay, lastRunRuleComputeTime, outcome, worstDayDQOutcome));
                }
            }
        }
        return points;
    }

    public DataQualityPartitionPoint getMostRecentDataQualityPartitionStatus(String projectKey, String objectId, String partitionId, long computeTime) throws SQLException {
        logger.debug((Object)("Getting DQ partition most recent daily status for " + String.join((CharSequence)"/", projectKey, objectId, partitionId) + " before " + computeTime));
        SelectQueryBuilder builder = new SelectQueryBuilder();
        builder.from(this.resolveTable(DATA_QUALITY_PARTITION_HISTORY_TABLE), "partition_history");
        Stream.of(DAY_COLUMN, ERROR_COUNT_COLUMN, WARNING_COUNT_COLUMN, OK_COUNT_COLUMN, EMPTY_COUNT_COLUMN, WORST_ERROR_COUNT_COLUMN, WORST_WARNING_COUNT_COLUMN, WORST_OK_COUNT_COLUMN, WORST_EMPTY_COUNT_COLUMN, LAST_RULE_COMPUTE_TIME_COLUMN).forEach(builder::select);
        builder.where(EBF.col(PROJECT_KEY_COLUMN).nullUnsafeEq(projectKey)).where(EBF.col(OBJECT_ID_COLUMN).nullUnsafeEq(objectId)).where(EBF.col(PARTITION_COLUMN).nullUnsafeEq(EBF.cst((Object)partitionId, Type.STRING))).where(EBF.col(DAY_COLUMN).lt(computeTime));
        builder.order(DAY_COLUMN, QueryAst.OrderType.DESC).limit(1L);
        try (DSSDBConnection ac = this.acquireConnection();
             PreparedStatement select = ac.prepareNonPersistedStatement(builder.toSQL(this.getDialect()));){
            ResultSet rs2 = select.executeQuery();
            if (rs2.next()) {
                long computeDay = rs2.getLong(1);
                long lastRunRuleComputeTime = rs2.getLong(10);
                DataQualityOutcome outcome = this.readDataQualityOutcome(rs2, 2);
                DataQualityOutcome worstDayDQOutcome = this.readDataQualityOutcome(rs2, 6);
                DataQualityPartitionPoint dataQualityPartitionPoint = new DataQualityPartitionPoint(projectKey, objectId, partitionId, computeDay, lastRunRuleComputeTime, outcome, worstDayDQOutcome);
                return dataQualityPartitionPoint;
            }
        }
        return null;
    }

    public List<DataQualityHistoryObjectPoint> getDataQualityProjectHistoryTimeline(String projectKey, long startDay, long endDay) throws Exception {
        logger.debug((Object)("Getting object statuses for " + projectKey + " between " + startDay + " and " + endDay));
        SelectQueryBuilder builder = new SelectQueryBuilder();
        builder.from(this.resolveTable(DATA_QUALITY_OBJECT_HISTORY_TABLE), "object_history");
        Stream.of(ERROR_COUNT_COLUMN, WARNING_COUNT_COLUMN, OK_COUNT_COLUMN, EMPTY_COUNT_COLUMN, WORST_ERROR_COUNT_COLUMN, WORST_WARNING_COUNT_COLUMN, WORST_OK_COUNT_COLUMN, WORST_EMPTY_COUNT_COLUMN, MONITORED_COLUMN, DELETED_COLUMN, LAST_RULE_COMPUTE_TIME_COLUMN, DAY_COLUMN, OBJECT_ID_COLUMN).forEach(builder::select);
        builder.where(EBF.col(PROJECT_KEY_COLUMN).nullUnsafeEq(projectKey)).where(EBF.col(DAY_COLUMN).gte(startDay)).where(EBF.col(DAY_COLUMN).lte(endDay));
        ArrayList<DataQualityHistoryObjectPoint> points = new ArrayList<DataQualityHistoryObjectPoint>();
        try (DSSDBConnection ac = this.acquireConnection();
             PreparedStatement select = ac.prepareNonPersistedStatement(builder.toSQL(this.getDialect()));){
            ResultSet rs2 = select.executeQuery();
            while (rs2.next()) {
                long computeDay = rs2.getLong(12);
                long lastRunRuleComputeTime = rs2.getLong(11);
                DataQualityOutcome last = this.readDataQualityOutcome(rs2, 1);
                DataQualityOutcome worst = this.readDataQualityOutcome(rs2, 5);
                boolean monitored = rs2.getBoolean(9);
                boolean deleted = rs2.getBoolean(10);
                String objectId = rs2.getString(13);
                points.add(new DataQualityHistoryObjectPoint(projectKey, objectId, computeDay, lastRunRuleComputeTime, last, worst, monitored, deleted));
            }
        }
        return points;
    }

    public List<DataQualityProjectPoint> getDataQualityProjectTimeline(String projectKey, long startComputeTime, long endComputeTime) throws SQLException {
        logger.debug((Object)("Getting DQ ruleset status timeline for " + projectKey + " between " + startComputeTime + " and " + endComputeTime));
        SelectQueryBuilder builder = new SelectQueryBuilder();
        builder.from(this.resolveTable(DATA_QUALITY_PROJECT_HISTORY_TABLE), "project_history");
        Stream.of(DAY_COLUMN, ERROR_COUNT_COLUMN, WARNING_COUNT_COLUMN, OK_COUNT_COLUMN, EMPTY_COUNT_COLUMN, WORST_ERROR_COUNT_COLUMN, WORST_WARNING_COUNT_COLUMN, WORST_OK_COUNT_COLUMN, WORST_EMPTY_COUNT_COLUMN, LAST_RULE_COMPUTE_TIME_COLUMN).forEach(builder::select);
        builder.where(EBF.col(PROJECT_KEY_COLUMN).nullUnsafeEq(projectKey)).where(EBF.col(DAY_COLUMN).gte(startComputeTime)).where(EBF.col(DAY_COLUMN).lte(endComputeTime));
        ArrayList<DataQualityProjectPoint> points = new ArrayList<DataQualityProjectPoint>();
        try (DSSDBConnection ac = this.acquireConnection();
             PreparedStatement select = ac.prepareNonPersistedStatement(builder.toSQL(this.getDialect()));){
            ResultSet rs2 = select.executeQuery();
            while (rs2.next()) {
                long computeDay = rs2.getLong(1);
                long lastRunRuleComputeTime = rs2.getLong(10);
                DataQualityOutcome last = this.readDataQualityOutcome(rs2, 2);
                DataQualityOutcome worst = this.readDataQualityOutcome(rs2, 6);
                points.add(new DataQualityProjectPoint(projectKey, computeDay, lastRunRuleComputeTime, last, worst));
            }
        }
        return points;
    }

    public DataQualityProjectPoint getMostRecentDataQualityProjectStatus(String projectKey, long computeTime) throws SQLException {
        logger.debug((Object)("Getting DQ ruleset most recent daily status for " + projectKey + " before " + computeTime));
        SelectQueryBuilder builder = new SelectQueryBuilder();
        builder.from(this.resolveTable(DATA_QUALITY_PROJECT_HISTORY_TABLE), "project_history");
        int computeDayIdx = builder.select(DAY_COLUMN).getIndex();
        int lastRunRuleComputeTimeIdx = builder.select(LAST_RULE_COMPUTE_TIME_COLUMN).getIndex();
        int lastIdx = this.selectDataQualityOutcome(builder);
        int worstIdx = this.selectDataQualityWorstOutcome(builder);
        builder.where(EBF.col(PROJECT_KEY_COLUMN).nullUnsafeEq(projectKey)).where(EBF.col(DAY_COLUMN).lte(computeTime)).order(DAY_COLUMN, QueryAst.OrderType.DESC).limit(1L);
        try (DSSDBConnection ac = this.acquireConnection();
             PreparedStatement select = ac.prepareNonPersistedStatement(builder.toSQL(this.getDialect()));){
            ResultSet rs2 = select.executeQuery();
            if (rs2.next()) {
                DataQualityProjectPoint dataQualityProjectPoint = new DataQualityProjectPoint(projectKey, rs2.getLong(computeDayIdx), rs2.getLong(lastRunRuleComputeTimeIdx), this.readDataQualityOutcome(rs2, lastIdx), this.readDataQualityOutcome(rs2, worstIdx));
                return dataQualityProjectPoint;
            }
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private List<ObjectHistoryRef> internalGetDataQualityObjectHistoryRefs(String projectKey, ExpressionBuilder timeCondition) throws SQLException {
        block16: {
            SelectQueryBuilder builder = new SelectQueryBuilder();
            builder.from(this.resolveTable(DATA_QUALITY_PROJECT_HISTORY_TABLE), "project_history");
            builder.select(OBJECT_HISTORY_REFS_COLUMN).getIndex();
            builder.where(EBF.col(PROJECT_KEY_COLUMN).nullUnsafeEq(projectKey)).where(timeCondition).order(DAY_COLUMN, QueryAst.OrderType.DESC).limit(1L);
            try (DSSDBConnection ac = this.acquireConnection();){
                List list;
                PreparedStatement select;
                block17: {
                    String objectHistoryRefs;
                    select = ac.prepareNonPersistedStatement(builder.toSQL(this.getDialect()));
                    ResultSet rs2 = select.executeQuery();
                    if (!rs2.next() || (objectHistoryRefs = rs2.getString(1)) == null) break block16;
                    list = (List)JSON.parse((String)objectHistoryRefs, (TypeToken)new TypeToken<List<ObjectHistoryRef>>(){});
                    if (select == null) break block17;
                    select.close();
                }
                return list;
                {
                    catch (Exception e) {
                        try {
                            logger.info((Object)("Failed to fetch computed datasets for project " + projectKey), (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (select != null) {
                                select.close();
                            }
                        }
                    }
                }
            }
        }
        return new ArrayList<ObjectHistoryRef>();
    }

    public List<ObjectHistoryRef> getExactDayDataQualityObjectHistoryRefs(String projectKey, long computeDay) throws SQLException {
        logger.debug((Object)("Read project DQ objects for " + projectKey + " on " + computeDay));
        return this.internalGetDataQualityObjectHistoryRefs(projectKey, EBF.col(DAY_COLUMN).nullUnsafeEq(computeDay));
    }

    public List<ObjectHistoryRef> getMostRecentDataQualityObjectHistoryRefs(String projectKey, long computeTime) throws SQLException {
        logger.debug((Object)("Getting most recent project DQ objects for " + projectKey + " before " + computeTime));
        return this.internalGetDataQualityObjectHistoryRefs(projectKey, EBF.col(DAY_COLUMN).lte(computeTime));
    }

    public Map<ComputedRule, CheckDataPoint> getHistoryChecks(String projectKey, String objectId, String partitionId, List<ComputedRule> computedRules) throws SQLException {
        logger.debug((Object)("Getting " + computedRules.size() + " history checks for " + String.join((CharSequence)"/", projectKey, objectId, partitionId)));
        HashMap<ComputedRule, CheckDataPoint> computed = new HashMap<ComputedRule, CheckDataPoint>();
        try (DSSDBConnection ac = this.acquireConnection();){
            String query = "SELECT\n   h.${CHECK_JSON_COLUMN},\n   h.${OUTCOME_COLUMN},\n   h.${MESSAGE_COLUMN},\n   s.${TIME_COMPUTE_COLUMN},\n   s.${RUN_ORIGIN_COLUMN}\nFROM (\n   SELECT *\n   FROM ${CHECKS_HISTORY_TABLE}\n   WHERE ${SESSION_INDEX_COLUMN} = ? AND\n         ${NAME_COLUMN} = ?\n) AS h\nINNER JOIN (\n   SELECT *\n   FROM ${CHECKS_SESSIONS_TABLE}\n   WHERE ${PROJECT_KEY_COLUMN} = ${PROJECT_KEY} AND\n         ${OBJECT_ID_COLUMN} = ${OBJECT_ID} AND\n         ${PARTITION_COLUMN} = ${PARTITION_ID}\n) AS s\nON h.${SESSION_INDEX_COLUMN} = s.${SESSION_INDEX_COLUMN}";
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("CHECK_JSON_COLUMN", this.quote(CHECK_JSON_COLUMN));
            placeholders.put("OUTCOME_COLUMN", this.quote(OUTCOME_COLUMN));
            placeholders.put("MESSAGE_COLUMN", this.quote(MESSAGE_COLUMN));
            placeholders.put("TIME_COMPUTE_COLUMN", this.quote(TIME_COMPUTE_COLUMN));
            placeholders.put("RUN_ORIGIN_COLUMN", this.quote(RUN_ORIGIN_COLUMN));
            placeholders.put("CHECKS_HISTORY_TABLE", this.getQuotedFullResolvedTableName(CHECKS_HISTORY_TABLE));
            placeholders.put("CHECKS_SESSIONS_TABLE", this.getQuotedFullResolvedTableName(CHECKS_SESSIONS_TABLE));
            placeholders.put("PROJECT_KEY_COLUMN", this.quote(PROJECT_KEY_COLUMN));
            placeholders.put(PROJECT_KEY_COLUMN, this.quoteString(projectKey));
            placeholders.put("OBJECT_ID_COLUMN", this.quote(OBJECT_ID_COLUMN));
            placeholders.put(OBJECT_ID_COLUMN, this.quoteString(objectId));
            placeholders.put("PARTITION_COLUMN", this.quote(PARTITION_COLUMN));
            placeholders.put("PARTITION_ID", this.quoteString(partitionId));
            placeholders.put("SESSION_INDEX_COLUMN", this.quote(SESSION_INDEX_COLUMN));
            placeholders.put("NAME_COLUMN", this.quote(NAME_COLUMN));
            StringSubstitutor substitutor = new StringSubstitutor(placeholders, "${", "}");
            query = substitutor.replace(query);
            try (PreparedStatement select = ac.prepareNonPersistedStatement(query);){
                for (ComputedRule rule : computedRules) {
                    select.setInt(1, rule.sessionIndex);
                    select.setString(2, rule.id);
                    ResultSet rs2 = select.executeQuery();
                    if (!rs2.next()) continue;
                    String checkData = rs2.getString(1);
                    AbstractCheckContext.CheckOutcome outcome = AbstractCheckContext.CheckOutcome.valueOf(rs2.getString(2));
                    String message = rs2.getString(3);
                    long time = rs2.getLong(4);
                    DataQualityRunOrigin runOrigin = DataQualityRunOrigin.parse(ReadOnlyJobsInternalDB.parseNullableString(rs2.getString(5)));
                    DataQualityRule check = StringUtils.isBlank((String)checkData) ? null : (DataQualityRule)JSON.parse((String)checkData, DataQualityRule.class);
                    CheckDataPoint point = new CheckDataPoint(check, projectKey, objectId, time, rule.id, outcome, message, partitionId, rule.sessionIndex, runOrigin);
                    computed.put(rule, point);
                }
            }
        }
        return computed;
    }

    public Map<String, DataQualityHistoryObjectPoint> getExactDataQualityObjectStatusesForHistoryRefList(String projectKey, Collection<ObjectHistoryRef> historyRefs) throws SQLException {
        logger.debug((Object)("Getting object statuses for " + projectKey + " over " + historyRefs.size() + " objects"));
        SelectQueryBuilder builder = new SelectQueryBuilder();
        builder.from(this.resolveTable(DATA_QUALITY_OBJECT_HISTORY_TABLE), "object_history");
        Stream.of(ERROR_COUNT_COLUMN, WARNING_COUNT_COLUMN, OK_COUNT_COLUMN, EMPTY_COUNT_COLUMN, WORST_ERROR_COUNT_COLUMN, WORST_WARNING_COUNT_COLUMN, WORST_OK_COUNT_COLUMN, WORST_EMPTY_COUNT_COLUMN, MONITORED_COLUMN, DELETED_COLUMN, LAST_RULE_COMPUTE_TIME_COLUMN).forEach(builder::select);
        builder.where(EBF.col(PROJECT_KEY_COLUMN).nullUnsafeEq(projectKey)).where(EBF.col(OBJECT_ID_COLUMN).nullUnsafeEq(EBF.expr("?"))).where(EBF.col(DAY_COLUMN).nullUnsafeEq(EBF.expr("?")));
        HashMap<String, DataQualityHistoryObjectPoint> computed = new HashMap<String, DataQualityHistoryObjectPoint>();
        try (DSSDBConnection ac = this.acquireConnection();
             PreparedStatement select = ac.prepareNonPersistedStatement(builder.toSQL(this.getDialect()));){
            for (ObjectHistoryRef ref : historyRefs) {
                if (ref.computeDay == -1L) continue;
                select.setString(1, ref.objectId);
                select.setLong(2, ref.computeDay);
                ResultSet rs2 = select.executeQuery();
                if (!rs2.next()) continue;
                computed.put(ref.objectId, new DataQualityHistoryObjectPoint(projectKey, ref.objectId, ref.computeDay, rs2.getLong(11), this.readDataQualityOutcome(rs2, 1), this.readDataQualityOutcome(rs2, 5), rs2.getBoolean(9), rs2.getBoolean(10)));
            }
        }
        return computed;
    }

    public Map<String, AbstractCheckContext.CheckOutcome> getExactDayDataQualityRuleWorstOutcomeForPartition(String projectKey, String objectId, String partitionId, long computeTime) throws SQLException {
        logger.debug((Object)("Getting checks worst outcome for " + String.join((CharSequence)"/", projectKey, objectId, partitionId) + " on the day of " + computeTime));
        long computeDay = new DateTime(computeTime).withZone(DateTimeZone.UTC).withTimeAtStartOfDay().getMillis();
        HashMap<String, AbstractCheckContext.CheckOutcome> computed = new HashMap<String, AbstractCheckContext.CheckOutcome>();
        try (DSSDBConnection ac = this.acquireConnection();){
            String query = "SELECT\n   ${NAME_COLUMN},\n   CASE WHEN worst_outcome_rank = 0 THEN ${ERROR_OUTCOME}\n        WHEN worst_outcome_rank = 1 THEN ${WARNING_OUTCOME}\n        WHEN worst_outcome_rank = 2 THEN ${OK_OUTCOME}\n        WHEN worst_outcome_rank = 3 THEN ${EMPTY_OUTCOME}\n   END AS worst_outcome\nFROM (\n   SELECT\n      ${NAME_COLUMN},\n      MIN(CASE WHEN ${OUTCOME_COLUMN} = ${ERROR_OUTCOME} THEN 0\n               WHEN ${OUTCOME_COLUMN} = ${WARNING_OUTCOME} THEN 1\n               WHEN ${OUTCOME_COLUMN} = ${OK_OUTCOME} THEN 2\n               WHEN ${OUTCOME_COLUMN} = ${EMPTY_OUTCOME} THEN 3\n      END) AS worst_outcome_rank\n   FROM ${CHECKS_HISTORY_TABLE} AS h\n   INNER JOIN (\n      SELECT *\n      FROM ${CHECKS_SESSIONS_TABLE} s\n      WHERE ${PROJECT_KEY_COLUMN} = ${PROJECT_KEY} AND\n            ${OBJECT_ID_COLUMN} = ${OBJECT_ID} AND\n            ${PARTITION_COLUMN} = ${PARTITION_ID} AND\n            ${TIME_COMPUTE_COLUMN} >= ${START_TIME} AND\n            ${TIME_COMPUTE_COLUMN} < ${END_TIME}\n   ) AS s\n   ON h.${SESSION_INDEX_COLUMN} = s.${SESSION_INDEX_COLUMN}\n   GROUP BY ${NAME_COLUMN}\n) AS inner_query";
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("NAME_COLUMN", this.quote(NAME_COLUMN));
            placeholders.put("OUTCOME_COLUMN", this.quote(OUTCOME_COLUMN));
            placeholders.put("ERROR_OUTCOME", this.quoteString(AbstractCheckContext.CheckOutcome.ERROR.name()));
            placeholders.put("WARNING_OUTCOME", this.quoteString(AbstractCheckContext.CheckOutcome.WARNING.name()));
            placeholders.put("EMPTY_OUTCOME", this.quoteString(AbstractCheckContext.CheckOutcome.EMPTY.name()));
            placeholders.put("OK_OUTCOME", this.quoteString(AbstractCheckContext.CheckOutcome.OK.name()));
            placeholders.put("CHECKS_HISTORY_TABLE", this.getQuotedFullResolvedTableName(CHECKS_HISTORY_TABLE));
            placeholders.put("CHECKS_SESSIONS_TABLE", this.getQuotedFullResolvedTableName(CHECKS_SESSIONS_TABLE));
            placeholders.put("PROJECT_KEY_COLUMN", this.quote(PROJECT_KEY_COLUMN));
            placeholders.put(PROJECT_KEY_COLUMN, this.quoteString(projectKey));
            placeholders.put("OBJECT_ID_COLUMN", this.quote(OBJECT_ID_COLUMN));
            placeholders.put(OBJECT_ID_COLUMN, this.quoteString(objectId));
            placeholders.put("PARTITION_COLUMN", this.quote(PARTITION_COLUMN));
            placeholders.put("PARTITION_ID", this.quoteString(partitionId));
            placeholders.put("TIME_COMPUTE_COLUMN", this.quote(TIME_COMPUTE_COLUMN));
            placeholders.put("START_TIME", String.valueOf(computeDay));
            placeholders.put("END_TIME", String.valueOf(computeDay + 86400000L));
            placeholders.put("SESSION_INDEX_COLUMN", this.quote(SESSION_INDEX_COLUMN));
            StringSubstitutor substitutor = new StringSubstitutor(placeholders, "${", "}");
            query = substitutor.replace(query);
            try (PreparedStatement select = ac.prepareNonPersistedStatement(query);){
                ResultSet rs2 = select.executeQuery();
                while (rs2.next()) {
                    String name = ReadOnlyJobsInternalDB.parseNullableString(rs2.getString(1));
                    String worstOutcome = rs2.getString(2);
                    computed.put(name, worstOutcome != null ? AbstractCheckContext.CheckOutcome.valueOf(worstOutcome) : null);
                }
            }
        }
        return computed;
    }

    public Map<String, DataQualityPartitionPoint> getLastDataQualityPartitionStatusesForObject(String projectKey, String objectId) throws SQLException {
        SelectQueryBuilder builder = new SelectQueryBuilder();
        builder.from(this.resolveTable(DATA_QUALITY_PARTITION_LAST_TABLE), "partition_last");
        Stream.of(UPDATE_TIME_COLUMN, PARTITION_COLUMN, ERROR_COUNT_COLUMN, WARNING_COUNT_COLUMN, OK_COUNT_COLUMN, EMPTY_COUNT_COLUMN, WORST_ERROR_COUNT_COLUMN, WORST_WARNING_COUNT_COLUMN, WORST_OK_COUNT_COLUMN, WORST_EMPTY_COUNT_COLUMN, LAST_RULE_COMPUTE_TIME_COLUMN).forEach(builder::select);
        builder.where(EBF.col(PROJECT_KEY_COLUMN).nullUnsafeEq(projectKey)).where(EBF.col(OBJECT_ID_COLUMN).nullUnsafeEq(objectId));
        HashMap<String, DataQualityPartitionPoint> points = new HashMap<String, DataQualityPartitionPoint>();
        try (DSSDBConnection ac = this.acquireConnection();
             PreparedStatement select = ac.prepareNonPersistedStatement(builder.toSQL(this.getDialect()));){
            ResultSet rs2 = select.executeQuery();
            while (rs2.next()) {
                long computeTime = rs2.getLong(1);
                long lastRunRuleComputeTime = rs2.getLong(11);
                String partitionId = rs2.getString(2);
                points.put(partitionId, new DataQualityPartitionPoint(projectKey, objectId, partitionId, computeTime, lastRunRuleComputeTime, this.readDataQualityOutcome(rs2, 3), this.readDataQualityOutcome(rs2, 7)));
            }
        }
        return points;
    }

    public List<String> getAllPartitionsWithChecksForObjectIncludingLegacy(String projectKey, String objectId) throws SQLException {
        SelectQueryBuilder builder = new SelectQueryBuilder();
        builder.from(this.resolveTable(CHECKS_SESSIONS_TABLE), "sessions");
        builder.select(EBF.col(PARTITION_COLUMN).distinct());
        builder.where(EBF.col(PROJECT_KEY_COLUMN).nullUnsafeEq(projectKey)).where(EBF.col(OBJECT_ID_COLUMN).nullUnsafeEq(objectId));
        ArrayList<String> points = new ArrayList<String>();
        try (DSSDBConnection ac = this.acquireConnection();
             PreparedStatement select = ac.prepareNonPersistedStatement(builder.toSQL(this.getDialect()));){
            ResultSet rs2 = select.executeQuery();
            while (rs2.next()) {
                points.add(rs2.getString(1));
            }
        }
        return points;
    }

    public Map<AnyLoc, DataQualityPartitionPoint> getLastDataQualityPartitionStatusesForNPObjectList(List<AnyLoc> objectLocs) throws SQLException {
        SelectQueryBuilder builder = new SelectQueryBuilder();
        builder.from(this.resolveTable(DATA_QUALITY_PARTITION_LAST_TABLE), "partition_last");
        Stream.of(UPDATE_TIME_COLUMN, LAST_RULE_COMPUTE_TIME_COLUMN, ERROR_COUNT_COLUMN, WARNING_COUNT_COLUMN, OK_COUNT_COLUMN, EMPTY_COUNT_COLUMN, WORST_ERROR_COUNT_COLUMN, WORST_WARNING_COUNT_COLUMN, WORST_OK_COUNT_COLUMN, WORST_EMPTY_COUNT_COLUMN).forEach(builder::select);
        builder.where(EBF.col(PROJECT_KEY_COLUMN).nullUnsafeEq(EBF.expr("?"))).where(EBF.col(OBJECT_ID_COLUMN).nullUnsafeEq(EBF.expr("?"))).where(EBF.col(PARTITION_COLUMN).nullUnsafeEq(EBF.cst(NOT_PARTITIONED)));
        HashMap<AnyLoc, DataQualityPartitionPoint> points = new HashMap<AnyLoc, DataQualityPartitionPoint>();
        try (DSSDBConnection ac = this.acquireConnection();
             PreparedStatement select = ac.prepareNonPersistedStatement(builder.toSQL(this.getDialect()));){
            for (AnyLoc objectLoc : objectLocs) {
                select.setString(1, objectLoc.getProjectKey());
                select.setString(2, objectLoc.getId());
                ResultSet rs2 = select.executeQuery();
                while (rs2.next()) {
                    long timestamp = rs2.getLong(1);
                    long lastRunRuleComputeTime = rs2.getLong(2);
                    points.put(objectLoc, new DataQualityPartitionPoint(objectLoc.getProjectKey(), objectLoc.getId(), NOT_PARTITIONED, timestamp, lastRunRuleComputeTime, this.readDataQualityOutcome(rs2, 3), this.readDataQualityOutcome(rs2, 7)));
                }
            }
        }
        return points;
    }

    public Map<String, DataQualityPartitionPoint> getLastDataQualityPartitionStatusesForNPProject(String projectKey) throws SQLException {
        SelectQueryBuilder builder = new SelectQueryBuilder();
        builder.from(this.resolveTable(DATA_QUALITY_PARTITION_LAST_TABLE), "partition_last");
        Stream.of(OBJECT_ID_COLUMN, UPDATE_TIME_COLUMN, LAST_RULE_COMPUTE_TIME_COLUMN, ERROR_COUNT_COLUMN, WARNING_COUNT_COLUMN, OK_COUNT_COLUMN, EMPTY_COUNT_COLUMN, WORST_ERROR_COUNT_COLUMN, WORST_WARNING_COUNT_COLUMN, WORST_OK_COUNT_COLUMN, WORST_EMPTY_COUNT_COLUMN).forEach(builder::select);
        builder.where(EBF.col(PROJECT_KEY_COLUMN).nullUnsafeEq(projectKey)).where(EBF.col(PARTITION_COLUMN).nullUnsafeEq(EBF.cst(NOT_PARTITIONED)));
        HashMap<String, DataQualityPartitionPoint> points = new HashMap<String, DataQualityPartitionPoint>();
        try (DSSDBConnection ac = this.acquireConnection();
             PreparedStatement select = ac.prepareNonPersistedStatement(builder.toSQL(this.getDialect()));){
            ResultSet rs2 = select.executeQuery();
            while (rs2.next()) {
                String objectId = rs2.getString(1);
                long timestamp = rs2.getLong(2);
                long lastRunRuleComputeTime = rs2.getLong(3);
                points.put(objectId, new DataQualityPartitionPoint(projectKey, objectId, NOT_PARTITIONED, timestamp, lastRunRuleComputeTime, this.readDataQualityOutcome(rs2, 4), this.readDataQualityOutcome(rs2, 8)));
            }
        }
        return points;
    }

    private List<ComputedRule> internalGetDataQualityComputedRules(String projectKey, String objectId, String partitionId, ExpressionBuilder timeCondition) throws SQLException {
        SelectQueryBuilder builder = new SelectQueryBuilder();
        builder.from(this.resolveTable(DATA_QUALITY_PARTITION_HISTORY_TABLE), "partition_history");
        int computedRulesIdx = builder.select(COMPUTED_RULES_COLUMN).getIndex();
        builder.where(EBF.col(PROJECT_KEY_COLUMN).nullUnsafeEq(projectKey)).where(EBF.col(OBJECT_ID_COLUMN).nullUnsafeEq(objectId)).where(EBF.col(PARTITION_COLUMN).nullUnsafeEq(EBF.cst((Object)partitionId, Type.STRING))).where(timeCondition).order(DAY_COLUMN, QueryAst.OrderType.DESC).limit(1L);
        try (DSSDBConnection ac = this.acquireConnection();
             PreparedStatement select = ac.prepareNonPersistedStatement(builder.toSQL(this.getDialect()));){
            String computedRules;
            ResultSet rs2 = select.executeQuery();
            if (rs2.next() && (computedRules = rs2.getString(computedRulesIdx)) != null) {
                List list = (List)JSON.parse((String)computedRules, (TypeToken)new TypeToken<List<ComputedRule>>(){});
                return list;
            }
        }
        return Collections.emptyList();
    }

    public List<ComputedRule> getMostRecentDataQualityComputedRules(String projectKey, String objectId, String partitionId, long computeTime) throws SQLException {
        logger.debug((Object)("Getting most recent DQ computed rules for " + String.join((CharSequence)"/", projectKey, objectId, partitionId) + " before " + computeTime));
        return this.internalGetDataQualityComputedRules(projectKey, objectId, partitionId, EBF.col(DAY_COLUMN).lte(computeTime));
    }

    public List<ComputedRule> getExactDayDataQualityComputedRules(String projectKey, String objectId, String partitionId, long computeDay) throws SQLException {
        logger.debug((Object)("Getting DQ computed rules for " + String.join((CharSequence)"/", projectKey, objectId, partitionId) + " on " + computeDay));
        return this.internalGetDataQualityComputedRules(projectKey, objectId, partitionId, EBF.col(DAY_COLUMN).eq(computeDay));
    }

    @Nullable
    public DataQualityProjectPoint getLastDataQualityProjectStatus(String projectKey) throws SQLException {
        return this.getLastDataQualityProjectStatusesForList(Collections.singletonList(projectKey)).get(projectKey);
    }

    public Map<String, DataQualityProjectPoint> getLastDataQualityProjectStatusesForList(List<String> projectKeys) throws SQLException {
        logger.debug((Object)("Getting last projects data quality statuses for " + String.join((CharSequence)", ", projectKeys)));
        SelectQueryBuilder builder = new SelectQueryBuilder();
        builder.from(this.resolveTable(DATA_QUALITY_PROJECT_LAST_TABLE), "project_last");
        int updateTimeIdx = builder.select(UPDATE_TIME_COLUMN).getIndex();
        int lastRunRuleComputeTimeIdx = builder.select(LAST_RULE_COMPUTE_TIME_COLUMN).getIndex();
        int lastIdx = this.selectDataQualityOutcome(builder);
        int worstIdx = this.selectDataQualityWorstOutcome(builder);
        builder.where(EBF.col(PROJECT_KEY_COLUMN).nullUnsafeEq(EBF.expr("?")));
        HashMap<String, DataQualityProjectPoint> res = new HashMap<String, DataQualityProjectPoint>();
        try (DSSDBConnection ac = this.acquireConnection();
             PreparedStatement select = ac.prepareNonPersistedStatement(builder.toSQL(this.getDialect()));){
            for (String projectKey : projectKeys) {
                select.setString(1, projectKey);
                ResultSet rs2 = select.executeQuery();
                if (!rs2.next()) continue;
                res.put(projectKey, new DataQualityProjectPoint(projectKey, rs2.getLong(updateTimeIdx), rs2.getLong(lastRunRuleComputeTimeIdx), this.readDataQualityOutcome(rs2, lastIdx), this.readDataQualityOutcome(rs2, worstIdx)));
            }
        }
        return res;
    }

    public Map<String, CheckDataPoint> getLastDatasetRulesStatus(final String projectKey, final String objectId, final String partitionId) throws Exception {
        logger.debug((Object)("Getting last computed rules for " + projectKey + "." + objectId + " (" + partitionId + ")"));
        final HashMap<String, CheckDataPoint> computed = new HashMap<String, CheckDataPoint>();
        this.readLastChecks(new CheckDataPointConsumer(){

            @Override
            public void setParameters(PreparedStatement select) throws SQLException {
                select.setString(1, projectKey);
                ReadOnlyJobsInternalDB.setNotNullStringParameter(select, 2, objectId, ReadOnlyJobsInternalDB.NULL_AS_STRING);
                ReadOnlyJobsInternalDB.setNotNullStringParameter(select, 3, partitionId, ReadOnlyJobsInternalDB.NOT_PARTITIONED);
            }

            @Override
            public boolean handle(CheckDataPoint point) {
                computed.put(point.name, point);
                return true;
            }

            @Override
            public String getFilterClause(boolean last) {
                return "s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.PROJECT_KEY_COLUMN) + " = ? AND s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.OBJECT_ID_COLUMN) + " = ? AND s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.PARTITION_COLUMN) + " = ?";
            }

            @Override
            public boolean caresAboutOrder() {
                return false;
            }
        });
        return computed;
    }

    public Set<String> getLastRunPartitions(final String projectKey, final String objectId) throws Exception {
        logger.debug((Object)("Getting last computed partitions for " + projectKey + "." + objectId));
        final HashSet<String> computed = new HashSet<String>();
        this.readLastChecks(new CheckDataPointConsumer(){
            DataQualityRunOrigin origin;

            @Override
            public void setParameters(PreparedStatement select) throws SQLException {
                select.setString(1, projectKey);
                ReadOnlyJobsInternalDB.setNotNullStringParameter(select, 2, objectId, ReadOnlyJobsInternalDB.NULL_AS_STRING);
            }

            @Override
            public boolean handle(CheckDataPoint point) {
                if (this.origin == null) {
                    computed.add(point.partition);
                    if (!point.runOrigin.isMultiPartitionCapable()) {
                        return false;
                    }
                    this.origin = point.runOrigin;
                } else if (this.origin.sameRunAs(point.runOrigin)) {
                    computed.add(point.partition);
                }
                return true;
            }

            @Override
            public String getFilterClause(boolean last) {
                return "s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.PROJECT_KEY_COLUMN) + " = ? AND s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.OBJECT_ID_COLUMN) + " = ?";
            }

            @Override
            public boolean caresAboutOrder() {
                return true;
            }

            @Override
            public boolean reverseOrder() {
                return true;
            }
        });
        return computed;
    }

    public List<CheckDataPoint> getLastChecks(final DatasetLocUtils.DatasetLoc loc) throws Exception {
        logger.debug((Object)("Getting last computed checks for " + loc.getFullName()));
        final ArrayList computed = Lists.newArrayList();
        this.readLastChecks(new CheckDataPointConsumer(){

            @Override
            public void setParameters(PreparedStatement select) throws SQLException {
                select.setString(1, loc.getProjectKey());
                ReadOnlyJobsInternalDB.setNotNullStringParameter(select, 2, loc.getName(), ReadOnlyJobsInternalDB.NULL_AS_STRING);
            }

            @Override
            public boolean handle(CheckDataPoint point) throws Exception {
                computed.add(point);
                return true;
            }

            @Override
            public String getFilterClause(boolean last) {
                return "s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.PROJECT_KEY_COLUMN) + " = ? AND s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.OBJECT_ID_COLUMN) + " = ? AND s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.NAME_COLUMN) + " != " + ReadOnlyJobsInternalDB.this.quoteString(ReadOnlyJobsInternalDB.NULL_AS_STRING);
            }

            @Override
            public boolean caresAboutOrder() {
                return false;
            }
        });
        return computed;
    }

    public List<CheckDataPoint> getLastChecks(final AnyLoc loc, final String partitionId) throws Exception {
        logger.debug((Object)("Getting last computed checks for " + loc.getFullName() + " (" + partitionId + ")"));
        final ArrayList computed = Lists.newArrayList();
        this.readLastChecks(new CheckDataPointConsumer(){

            @Override
            public void setParameters(PreparedStatement select) throws SQLException {
                select.setString(1, loc.getProjectKey());
                ReadOnlyJobsInternalDB.setNotNullStringParameter(select, 2, loc.getId(), ReadOnlyJobsInternalDB.NULL_AS_STRING);
                ReadOnlyJobsInternalDB.setNotNullStringParameter(select, 3, partitionId, ReadOnlyJobsInternalDB.NOT_PARTITIONED);
            }

            @Override
            public boolean handle(CheckDataPoint point) throws Exception {
                computed.add(point);
                return true;
            }

            @Override
            public String getFilterClause(boolean last) {
                return "s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.PROJECT_KEY_COLUMN) + " = ? AND s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.OBJECT_ID_COLUMN) + " = ? AND s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.PARTITION_COLUMN) + " = ? AND s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.NAME_COLUMN) + " != " + ReadOnlyJobsInternalDB.this.quoteString(ReadOnlyJobsInternalDB.NULL_AS_STRING);
            }

            @Override
            public boolean caresAboutOrder() {
                return false;
            }
        });
        return computed;
    }

    public List<CheckDataPoint> getLastChecks(final String projectKey, final String objectId, final String partitionId) throws Exception {
        logger.debug((Object)("Getting last computed checks (including deleted)  for " + projectKey + "." + objectId + " (" + partitionId + ")"));
        final ArrayList computed = Lists.newArrayList();
        this.readLastChecks(new CheckDataPointConsumer(){

            @Override
            public void setParameters(PreparedStatement select) throws SQLException {
                select.setString(1, projectKey);
                ReadOnlyJobsInternalDB.setNotNullStringParameter(select, 2, objectId, ReadOnlyJobsInternalDB.NULL_AS_STRING);
                ReadOnlyJobsInternalDB.setNotNullStringParameter(select, 3, partitionId, ReadOnlyJobsInternalDB.NOT_PARTITIONED);
            }

            @Override
            public boolean handle(CheckDataPoint point) {
                computed.add(point);
                return true;
            }

            @Override
            public String getFilterClause(boolean last) {
                return "s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.PROJECT_KEY_COLUMN) + " = ? AND s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.OBJECT_ID_COLUMN) + " = ? AND s." + ReadOnlyJobsInternalDB.this.quote(ReadOnlyJobsInternalDB.PARTITION_COLUMN) + " = ?";
            }

            @Override
            public boolean caresAboutOrder() {
                return false;
            }
        });
        return computed;
    }

    public void readLastChecks(CheckDataPointConsumer consumer) throws Exception {
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.db.jobs.access.readLastChecks");
             DSSDBConnection ac = this.acquireConnection();){
            String query = "SELECT s." + this.quote(TIME_COMPUTE_COLUMN) + ", s." + this.quote(PARTITION_COLUMN) + ", s." + this.quote(NAME_COLUMN) + ", s." + this.quote(CHECK_JSON_COLUMN) + ", s." + this.quote(OUTCOME_COLUMN) + ", s." + this.quote(MESSAGE_COLUMN) + ", s." + this.quote(PROJECT_KEY_COLUMN) + ", s." + this.quote(OBJECT_ID_COLUMN) + ", s." + this.quote(SESSION_INDEX_COLUMN) + ", s." + this.quote(RUN_ORIGIN_COLUMN) + " ";
            query = query + "FROM " + this.getQuotedFullResolvedTableName(CHECKS_LAST_TABLE) + " s";
            String clause = consumer.getFilterClause(true);
            query = query + (String)(StringUtils.isBlank((String)clause) ? "" : " WHERE " + clause);
            if (consumer.caresAboutOrder()) {
                query = query + " ORDER BY s." + this.quote(TIME_COMPUTE_COLUMN);
                if (consumer.reverseOrder()) {
                    query = query + " DESC";
                }
            }
            try (PreparedStatement select = ac.prepareNonPersistedStatement(query);){
                consumer.setParameters(select);
                ResultSet rs2 = select.executeQuery();
                while (rs2.next()) {
                    long time = rs2.getLong(1);
                    String partition = rs2.getString(2);
                    String name = ReadOnlyJobsInternalDB.parseNullableString(rs2.getString(3));
                    String checkData = rs2.getString(4);
                    AbstractCheckContext.CheckOutcome outcome = AbstractCheckContext.CheckOutcome.valueOf(rs2.getString(5));
                    String message = rs2.getString(6);
                    String projectKey = rs2.getString(7);
                    String objectId = ReadOnlyJobsInternalDB.parseNullableString(rs2.getString(8));
                    int sessionIndex = rs2.getInt(9);
                    DataQualityRunOrigin runOrigin = DataQualityRunOrigin.parse(ReadOnlyJobsInternalDB.parseNullableString(rs2.getString(10)));
                    DataQualityRule check = StringUtils.isBlank((String)checkData) ? null : (DataQualityRule)JSON.parse((String)checkData, DataQualityRule.class);
                    if (consumer.handle(new CheckDataPoint(check, projectKey, objectId, time, name, outcome, message, partition, sessionIndex, runOrigin))) continue;
                    break;
                }
            }
        }
    }

    protected String identifierFor(Scenario scenario) {
        return scenario.getProjectKey() + "." + scenario.getId();
    }

    protected String identifierFor(ScenarioRun scenarioRun) {
        return this.identifierFor(scenarioRun.getScenario()) + "#" + scenarioRun.getRunId();
    }

    protected String identifierFor(TriggerFire triggerFire) {
        return triggerFire.getProjectKey() + "." + triggerFire.getScenarioId() + "." + triggerFire.getTrigger().getId();
    }

    protected String identifierFor(StepRun stepRun) {
        ScenarioRun scenarioRun = stepRun.getScenarioRun();
        return this.identifierFor(scenarioRun) + "/" + stepRun.getStep().getId() + "#" + stepRun.getRunId();
    }

    @VisibleForTesting
    Row pushOneJob(ColumnFactory cf, RowFactory rf, ResultSet rs2, ResultSetMetaData rsmd, Map<String, Integer> columnIndices) throws SQLException {
        Row row = rf.row();
        String jobDefData = rs2.getString(JOB_DEF_COLUMN);
        JobDef jobDef = StringUtils.isNotBlank((String)jobDefData) ? (JobDef)JSON.parse((String)jobDefData, JobDef.class) : null;
        for (SchemaColumn schemaColumn : ReadOnlyJobsInternalDB.getJobsViewColumnsForInternalStatsDataset()) {
            String jobDefPrefix;
            String columnName = schemaColumn.getName();
            if (columnName.startsWith(jobDefPrefix = "job_def_")) {
                if (jobDef == null) continue;
                String fieldName = columnName.substring(jobDefPrefix.length());
                if ("type".equals(fieldName)) {
                    if (jobDef.type == null) continue;
                    row.put(cf.column(columnName), jobDef.type.toString());
                    continue;
                }
                if ("trigger_type".equals(fieldName)) {
                    if (jobDef.triggeredFrom == null) continue;
                    row.put(cf.column(columnName), jobDef.triggeredFrom.toString());
                    continue;
                }
                if ("initiator".equals(fieldName)) {
                    row.put(cf.column(columnName), jobDef.initiator);
                    continue;
                }
                if ("initiated".equals(fieldName)) {
                    row.put(cf.column(columnName), DKUtils.isoFormatReadableByDateFormat((long)jobDef.initiationTimestamp));
                    continue;
                }
                if ("refresh_metastore".equals(fieldName)) {
                    row.put(cf.column(columnName), jobDef.refreshHiveMetastore);
                    continue;
                }
                if (!"outputs".equals(fieldName) || jobDef.outputs == null) continue;
                row.put(cf.column(columnName), JSON.json(jobDef.outputs));
                continue;
            }
            if (columnName.equalsIgnoreCase(TIME_START_COLUMN) || columnName.equalsIgnoreCase(TIME_END_COLUMN)) {
                int i = columnIndices.get(columnName);
                String valueAsDSSString = this.getDialect().getValueAsDSSString(rs2, rsmd.getColumnType(i), i, new SchemaColumn(columnName, Type.BIGINT), true, true, DateTimeZone.getDefault());
                if (!StringUtils.isNotBlank((String)valueAsDSSString)) continue;
                row.put(cf.column(columnName), DKUtils.isoFormatReadableByDateFormat((long)Long.parseLong(valueAsDSSString)));
                continue;
            }
            int i = columnIndices.get(columnName);
            row.put(cf.column(columnName), this.getDialect().getValueAsDSSString(rs2, rsmd.getColumnType(i), i, schemaColumn, true, true, DateTimeZone.getDefault()));
        }
        return row;
    }

    @VisibleForTesting
    Row pushOneScenarioRun(ColumnFactory cf, RowFactory rf, ResultSet rs2, ResultSetMetaData rsmd, Map<String, Integer> columnIndices) throws SQLException {
        Row row = rf.row();
        String scenarioData = rs2.getString(SCENARIO_COLUMN);
        Scenario scenario = StringUtils.isNotBlank((String)scenarioData) ? (Scenario)JSON.parse((String)scenarioData, Scenario.class) : null;
        String triggerData = rs2.getString(TRIGGER_COLUMN);
        Trigger trigger = StringUtils.isNotBlank((String)triggerData) ? (Trigger)JSON.parse((String)triggerData, Trigger.class) : null;
        for (SchemaColumn schemaColumn : ReadOnlyJobsInternalDB.getScenarioRunsViewColumnsForInternalStatsDataset()) {
            int i;
            String columnName = schemaColumn.getName();
            if (columnName.equalsIgnoreCase(SCENARIO_NAME_COLUMN)) {
                if (scenario == null) continue;
                row.put(cf.column(columnName), scenario.getName());
                continue;
            }
            if (columnName.equalsIgnoreCase(SCENARIO_RUN_AS_USER_COLUMN)) {
                if (scenario == null) continue;
                row.put(cf.column(columnName), scenario.getRunAsUser());
                continue;
            }
            if (columnName.equalsIgnoreCase(TRIGGER_NAME_COLUMN)) {
                if (trigger == null) continue;
                row.put(cf.column(columnName), StringUtils.defaultIfBlank((String)trigger.getName(), (String)trigger.getId()));
                continue;
            }
            if (columnName.equalsIgnoreCase(TIME_START_COLUMN) || columnName.equalsIgnoreCase(TIME_END_COLUMN)) {
                i = columnIndices.get(columnName);
                String valueAsDSSString = this.getDialect().getValueAsDSSString(rs2, rsmd.getColumnType(i), i, new SchemaColumn(columnName, Type.BIGINT), true, true, DateTimeZone.getDefault());
                if (!StringUtils.isNotBlank((String)valueAsDSSString)) continue;
                row.put(cf.column(columnName), DKUtils.isoFormatReadableByDateFormat((long)Long.parseLong(valueAsDSSString)));
                continue;
            }
            i = columnIndices.get(columnName);
            row.put(cf.column(columnName), this.getDialect().getValueAsDSSString(rs2, rsmd.getColumnType(i), i, schemaColumn, true, true, DateTimeZone.getDefault()));
        }
        return row;
    }

    @VisibleForTesting
    Row pushOneFlowAction(ColumnFactory cf, RowFactory rf, ResultSet rs2, ResultSetMetaData rsmd, Map<String, Integer> columnIndices) throws SQLException {
        Row row = rf.row();
        for (SchemaColumn schemaColumn : ReadOnlyJobsInternalDB.getFlowActionsViewColumnsForInternalStatsDataset()) {
            String valueAsDSSString;
            int i;
            String columnName = schemaColumn.getName();
            if (columnName.equalsIgnoreCase(TIME_START_COLUMN) || columnName.equalsIgnoreCase(TIME_END_COLUMN)) {
                i = columnIndices.get(columnName);
                valueAsDSSString = this.getDialect().getValueAsDSSString(rs2, rsmd.getColumnType(i), i, new SchemaColumn(columnName, Type.BIGINT), true, true, DateTimeZone.getDefault());
                if (!StringUtils.isNotBlank((String)valueAsDSSString)) continue;
                row.put(cf.column(columnName), DKUtils.isoFormatReadableByDateFormat((long)Long.parseLong(valueAsDSSString)));
                continue;
            }
            i = columnIndices.get(columnName);
            valueAsDSSString = this.getDialect().getValueAsDSSString(rs2, rsmd.getColumnType(i), i, schemaColumn, true, true, DateTimeZone.getDefault());
            row.put(cf.column(columnName), OBJECT_ID_COLUMN.equalsIgnoreCase(columnName) ? ReadOnlyJobsInternalDB.parseNullableString(valueAsDSSString) : valueAsDSSString);
        }
        return row;
    }

    public long pushJobs(ProcessorOutput out, ColumnFactory cf, RowFactory rf, ExtractionLimit limit, InputSplitProgressListener listener, String projectKey) throws Exception {
        try (DSSDBConnection ac = this.acquireConnection();){
            String query = "SELECT * FROM " + this.getQuotedFullResolvedTableName(JOB_TABLE);
            if (StringUtils.isNotBlank((String)projectKey)) {
                query = query + " WHERE " + this.quote(JOB_PROJECT_KEY_COLUMN) + " = ?";
            }
            query = query + " ORDER BY " + this.quote(TIME_START_COLUMN) + " DESC";
            try (PreparedStatement select = ac.prepareNonPersistedStatement(query);){
                if (StringUtils.isNotBlank((String)projectKey)) {
                    select.setString(1, projectKey);
                }
                ResultSet rs2 = select.executeQuery();
                ResultSetMetaData rsmd = rs2.getMetaData();
                Map<String, Integer> columnIndices = this.buildColumnIndices(rs2, rsmd);
                long count = 0L;
                while (rs2.next()) {
                    Row row = this.pushOneJob(cf, rf, rs2, rsmd, columnIndices);
                    out.emitRow(row);
                    if (listener != null && ++count % 1000L == 0L) {
                        listener.setData(0L, 0L, count);
                    }
                    if (limit == null || limit.maxRecords < 0L || count < limit.maxRecords) continue;
                    break;
                }
            }
            long l = 0L;
            return l;
        }
    }

    private List<String> buildClauses(String prefix, String ... columns) {
        ArrayList<String> result = new ArrayList<String>();
        for (String column : columns) {
            result.add(prefix + this.quote(column) + " AS " + column);
        }
        return result;
    }

    public long pushScenarioRuns(ProcessorOutput out, ColumnFactory cf, RowFactory rf, ExtractionLimit limit, InputSplitProgressListener listener, String projectKey) throws Exception {
        try (DSSDBConnection ac = this.acquireConnection();){
            ArrayList selectClauses = Lists.newArrayList();
            selectClauses.addAll(this.buildClauses("s.", SCENARIO_PROJECT_KEY_COLUMN, SCENARIO_ID_COLUMN, SCENARIO_RUN_ID_COLUMN, TIME_START_COLUMN, TIME_END_COLUMN, OUTCOME_COLUMN, WARNINGS_COUNT_COLUMN, SCENARIO_COLUMN, RUN_AS_USER_IDENTIFIER_COLUMN, RUN_AS_USER_VIA_COLUMN));
            selectClauses.addAll(this.buildClauses("t.", TRIGGER_COLUMN));
            String query = "SELECT " + Joiner.on((String)", ").join((Iterable)selectClauses) + " " + this.getFromScenarioWithTriggerFire();
            if (StringUtils.isNotBlank((String)projectKey)) {
                query = query + " WHERE s." + this.quote(SCENARIO_PROJECT_KEY_COLUMN) + " = ?";
            }
            query = query + " ORDER BY s." + this.quote(TIME_START_COLUMN) + " DESC";
            try (PreparedStatement select = ac.prepareNonPersistedStatement(query);){
                if (StringUtils.isNotBlank((String)projectKey)) {
                    select.setString(1, projectKey);
                }
                ResultSet rs2 = select.executeQuery();
                ResultSetMetaData rsmd = rs2.getMetaData();
                Map<String, Integer> columnIndices = this.buildColumnIndices(rs2, rsmd);
                long count = 0L;
                while (rs2.next()) {
                    Row row = this.pushOneScenarioRun(cf, rf, rs2, rsmd, columnIndices);
                    out.emitRow(row);
                    if (listener != null && ++count % 1000L == 0L) {
                        listener.setData(0L, 0L, count);
                    }
                    if (limit == null || limit.maxRecords < 0L || count < limit.maxRecords) continue;
                    break;
                }
            }
            long l = 0L;
            return l;
        }
    }

    public long pushFlowActions(ProcessorOutput out, ColumnFactory cf, RowFactory rf, ExtractionLimit limit, InputSplitProgressListener listener, String projectKey, boolean orderByDate) throws Exception {
        try (DSSDBConnection ac = this.acquireConnection();){
            String query = "SELECT " + this.getList("h.", (SchemaColumn[][])new SchemaColumn[][]{this.objectPartitionIdColumns, this.activityIdColumns, this.scenarioRunIdColumns, this.stepIdColumns, this.actionTimeColumns, this.actionOutcomeColumns, this.objectDenormalizedColumns}) + ", (l." + this.quote(TIME_START_COLUMN) + " = h." + this.quote(TIME_START_COLUMN) + ") as is_last FROM " + this.getQuotedFullResolvedTableName(FLOW_OBJECT_ACTION_HISTORY_TABLE) + " h";
            query = query + " LEFT OUTER JOIN " + this.getQuotedFullResolvedTableName(FLOW_OBJECT_ACTION_TABLE) + " l ON h." + this.quote(OBJECT_ID_COLUMN) + " = l." + this.quote(OBJECT_ID_COLUMN) + " AND h." + this.quote(PROJECT_KEY_COLUMN) + " = l." + this.quote(PROJECT_KEY_COLUMN) + " AND h." + this.quote(PARTITION_COLUMN) + " = l." + this.quote(PARTITION_COLUMN) + " AND h." + this.quote(TYPE_COLUMN) + " = l." + this.quote(TYPE_COLUMN);
            if (StringUtils.isNotBlank((String)projectKey)) {
                query = query + " WHERE h." + this.quote(PROJECT_KEY_COLUMN) + " = ?";
            }
            if (orderByDate) {
                query = query + " ORDER BY h." + this.quote(TIME_START_COLUMN) + " DESC";
            }
            try (PreparedStatement select = ac.prepareNonPersistedStatement(query);){
                if (StringUtils.isNotBlank((String)projectKey)) {
                    select.setString(1, projectKey);
                }
                ResultSet rs2 = select.executeQuery();
                ResultSetMetaData rsmd = rs2.getMetaData();
                Map<String, Integer> columnIndices = this.buildColumnIndices(rs2, rsmd);
                long count = 0L;
                while (rs2.next()) {
                    Row row = this.pushOneFlowAction(cf, rf, rs2, rsmd, columnIndices);
                    out.emitRow(row);
                    if (listener != null && ++count % 1000L == 0L) {
                        listener.setData(0L, 0L, count);
                    }
                    if (limit == null || limit.maxRecords < 0L || count < limit.maxRecords) continue;
                    break;
                }
            }
            long l = 0L;
            return l;
        }
    }

    private Map<String, Integer> buildColumnIndices(ResultSet rs2, ResultSetMetaData rsmd) throws SQLException {
        HashMap columnIndices = Maps.newHashMap();
        for (int i = 1; i <= rs2.getMetaData().getColumnCount(); ++i) {
            columnIndices.put(rsmd.getColumnName(i).toLowerCase(), i);
        }
        return columnIndices;
    }

    void readAllScenarioRunsRaw(RawScenarioRunConsumer consumer) throws Exception {
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.db.jobs.access.readAllScenarioRunsRaw");
             DSSDBConnection ac = this.acquireConnection();
             Statement stmt = ac.createStatement();){
            ResultSet rs2 = stmt.executeQuery("select " + this.quote(SCENARIO_PROJECT_KEY_COLUMN) + ", " + this.quote(SCENARIO_ID_COLUMN) + ", " + this.quote(SCENARIO_RUN_ID_COLUMN) + ", " + this.quote(SCENARIO_COLUMN) + " from " + this.getQuotedFullResolvedTableName(SCENARIO_RUNS_TABLE));
            while (rs2.next()) {
                consumer.handle(rs2.getString(1), rs2.getString(2), rs2.getString(3), rs2.getString(4));
            }
        }
    }

    void readAllStepRunsRaw(RawStepRunConsumer consumer) throws Exception {
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.db.jobs.access.readAllStepRunsRaw");
             DSSDBConnection ac = this.acquireConnection();
             Statement stmt = ac.createStatement();){
            ResultSet rs2 = stmt.executeQuery("select " + this.quote(SCENARIO_PROJECT_KEY_COLUMN) + ", " + this.quote(SCENARIO_ID_COLUMN) + ", " + this.quote(SCENARIO_RUN_ID_COLUMN) + ", " + this.quote(STEP_RUN_ID_COLUMN) + ", " + this.quote(STEP_COLUMN) + " from " + this.getQuotedFullResolvedTableName(STEP_RUNS_TABLE));
            while (rs2.next()) {
                consumer.handle(rs2.getString(1), rs2.getString(2), rs2.getString(3), rs2.getString(4), rs2.getString(5));
            }
        }
    }

    void readObjectActionsForType(String type, FlowObjectActionConsumer consumer) throws Exception {
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.db.jobs.access.readObjectActionsForType");
             DSSDBConnection ac = this.acquireConnection();){
            SelectQueryBuilder sqb = new SelectQueryBuilder();
            sqb.from(this.resolveTable(FLOW_OBJECT_ACTION_TABLE), FLOW_OBJECT_ACTION_TABLE);
            sqb.select(PROJECT_KEY_COLUMN);
            sqb.select(OBJECT_ID_COLUMN);
            sqb.select(PARTITION_COLUMN);
            sqb.select(TYPE_COLUMN);
            sqb.select(TIME_START_COLUMN);
            sqb.select(RESULT_COLUMN);
            sqb.where(EBF.parameterizedColumnOperation(TYPE_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ));
            try (PreparedStatement stmt = ac.prepareNonPersistedStatement(sqb.toSQL(this.getDialect()));){
                stmt.setString(1, type);
                ResultSet rs2 = stmt.executeQuery();
                while (rs2.next()) {
                    consumer.handle(rs2.getString(1), ReadOnlyJobsInternalDB.parseNullableString(rs2.getString(2)), rs2.getString(3), rs2.getString(4), rs2.getLong(5), rs2.getString(6));
                }
            }
        }
    }

    void readObjectActionHistoryForType(String type, FlowObjectActionConsumer consumer) throws Exception {
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.db.jobs.access.readObjectActionHistoryForType");
             DSSDBConnection ac = this.acquireConnection();){
            SelectQueryBuilder sqb = new SelectQueryBuilder();
            sqb.from(this.resolveTable(FLOW_OBJECT_ACTION_HISTORY_TABLE), FLOW_OBJECT_ACTION_HISTORY_TABLE);
            sqb.select(PROJECT_KEY_COLUMN);
            sqb.select(OBJECT_ID_COLUMN);
            sqb.select(PARTITION_COLUMN);
            sqb.select(TYPE_COLUMN);
            sqb.select(TIME_START_COLUMN);
            sqb.select(RESULT_COLUMN);
            sqb.where(EBF.parameterizedColumnOperation(TYPE_COLUMN, QueryUtils.OperatorType.NULL_UNSAFE_EQ));
            try (PreparedStatement stmt = ac.prepareNonPersistedStatement(sqb.toSQL(this.getDialect()));){
                stmt.setString(1, type);
                ResultSet rs2 = stmt.executeQuery();
                while (rs2.next()) {
                    consumer.handle(rs2.getString(1), ReadOnlyJobsInternalDB.parseNullableString(rs2.getString(2)), rs2.getString(3), rs2.getString(4), rs2.getLong(5), rs2.getString(6));
                }
            }
        }
    }

    void updateJobsDatabaseObjectsRaw(String query, RawJobDatabaseObjectProducer producer) throws Exception {
        int total = 0;
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((String)"dku.db.jobs.access.updateJobsDatabaseObjectsRaw");
             DSSDBConnection ac = this.acquireConnection();){
            try (PreparedStatement stmt = ac.prepareNonPersistedStatement(query);){
                int rowsInBatch = 0;
                while (producer.handle(stmt)) {
                    stmt.addBatch();
                    ++total;
                    if (++rowsInBatch > 100) {
                        stmt.executeBatch();
                        stmt.clearBatch();
                        rowsInBatch = 0;
                    }
                    if (total % 100 != 0) continue;
                    logger.infoV("Migrated %d items", new Object[]{total});
                }
                if (rowsInBatch > 0) {
                    stmt.executeBatch();
                }
            }
            ac.commit();
        }
    }

    public static SchemaColumn[] getJobsViewColumnsForInternalStatsDataset() {
        return ReadOnlyJobsInternalDB.toLowerCase(jobsViewColumns);
    }

    public static SchemaColumn[] getScenarioRunsViewColumnsForInternalStatsDataset() {
        return ReadOnlyJobsInternalDB.toLowerCase(scenarioRunsViewColumns);
    }

    public static SchemaColumn[] getFlowActionsViewColumnsForInternalStatsDataset() {
        return ReadOnlyJobsInternalDB.toLowerCase(flowActionsViewColumns);
    }

    private int selectDataQualityOutcome(SelectQueryBuilder builder) {
        int res = builder.select(ERROR_COUNT_COLUMN).getIndex();
        builder.select(WARNING_COUNT_COLUMN);
        builder.select(OK_COUNT_COLUMN);
        builder.select(EMPTY_COUNT_COLUMN);
        return res;
    }

    private int selectDataQualityWorstOutcome(SelectQueryBuilder builder) {
        int res = builder.select(WORST_ERROR_COUNT_COLUMN).getIndex();
        builder.select(WORST_WARNING_COUNT_COLUMN);
        builder.select(WORST_OK_COUNT_COLUMN);
        builder.select(WORST_EMPTY_COUNT_COLUMN);
        return res;
    }

    private DataQualityOutcome readDataQualityOutcome(ResultSet rs2, int startingFrom) throws SQLException {
        return new DataQualityOutcome(rs2.getInt(startingFrom), rs2.getInt(startingFrom + 1), rs2.getInt(startingFrom + 2), rs2.getInt(startingFrom + 3));
    }

    private AbstractCheckContext.CheckOutcome parseNullableCheckOutcome(@Nullable String str) {
        return str == null ? null : AbstractCheckContext.CheckOutcome.valueOf(str);
    }

    private /* synthetic */ String lambda$hasMetricHistory$18(String probeType) {
        return " AND " + this.quote(METRIC_ID_COLUMN) + " not like ?";
    }

    private /* synthetic */ String lambda$hasMetricHistory$17(String probeType) {
        return " AND " + this.quote(METRIC_ID_COLUMN) + " like ?";
    }

    private static /* synthetic */ Object lambda$getScenarioRunsBoundaries$13(long after, long before) {
        return "Single scenario boundaries computation query executed in " + (after - before) + "ms";
    }

    private static /* synthetic */ Object lambda$getScenarioRunsBoundaries$12(long after, long before) {
        return "Multiple projects scenario boundaries computation query executed in " + (after - before) + "ms";
    }

    private /* synthetic */ String lambda$getLastFires$11(String triggerId) {
        return "SELECT " + this.quoteString(triggerId) + " AS requested_trigger_id";
    }

    private static /* synthetic */ Object lambda$getLastFires$10(String projectKey, String scenarioId) {
        return "Get last trigger fires for scenario " + projectKey + "." + scenarioId;
    }

    private static /* synthetic */ String lambda$getLastFires$9(Trigger t) {
        return t.id;
    }

    private static /* synthetic */ Object lambda$getLatestTestCompletedRun$8(String projectKey, String scenarioId) {
        return "Get latest completed test scenario run for " + projectKey + "." + scenarioId;
    }

    private static /* synthetic */ Object lambda$getLastRuns$7(int count, String projectKey, String scenarioId) {
        return "Get " + count + " last scenario runs for " + projectKey + "." + scenarioId;
    }

    private static /* synthetic */ Object lambda$getTriggerFire$6(String projectKey, String scenarioId, String triggerId) {
        return "Get last trigger fire for " + projectKey + "." + scenarioId + "." + triggerId;
    }

    private static /* synthetic */ Object lambda$getLastTriggerFire$5(String projectKey, String scenarioId, String triggerId) {
        return "Get last trigger fire for " + projectKey + "." + scenarioId + "." + triggerId;
    }

    private static /* synthetic */ Object lambda$getLastRunId$4(String projectKey, String scenarioId) {
        return "Get last scenario run id for " + projectKey + "." + scenarioId;
    }

    private static /* synthetic */ Object lambda$getLatestSuccessfulBuildForObject$3(String projectKey, String id) {
        return "Get last successful build for {projectKey:" + projectKey + ", type: unspecified, id:" + id + "}";
    }

    private static /* synthetic */ Object lambda$getLatestBuildForObject$2(TaggableObjectsService.TaggableObjectRef objectId) {
        return "Get last build for " + String.valueOf(objectId);
    }

    private static /* synthetic */ Object lambda$getLatestBuildForDataset$0(String projectKey, String dataset) {
        return "Get last build for " + projectKey + "." + dataset;
    }

    public static class DatasetBuild {
        public String datasetProjectKey;
        public String datasetName;
        public String partition;
        public String jobId;
        public String jobProjectKey;
        public long buildEndTime;
        public boolean buildSuccess;
    }

    public static class ObjectBuild {
        public String projectKey;
        public String id;
        public String jobId;
        public String jobProjectKey;
        public long buildStartTime;
        public long buildEndTime;
        public boolean buildSuccess;
    }

    public static class MetricDataPoint {
        public Metric metric;
        public final String projectKey;
        public final String objectId;
        public final long time;
        public final String value;
        public final Type type;
        public final String partition;
        public final String hash;

        public MetricDataPoint(Metric metric, String projectKey, String objectId, long time, String value, Type type, String partition, String hash) {
            this.projectKey = projectKey;
            this.objectId = objectId;
            this.metric = metric;
            this.time = time;
            this.value = value;
            this.type = type;
            this.partition = partition;
            this.hash = hash;
        }
    }

    public static class ScenarioRunsBoundaries {
        long minStart;
        long maxEnd;
        int notFinished;
    }

    public static interface MetricDataPointConsumer {
        public boolean caresAboutOrder();

        default public boolean orderDesc() {
            return false;
        }

        public String getFilterClause(boolean var1);

        public void setParameters(PreparedStatement var1) throws SQLException;

        public boolean handle(MetricDataPoint var1) throws Exception;
    }

    public static interface CheckDataPointConsumer {
        public boolean caresAboutOrder();

        default public boolean reverseOrder() {
            return false;
        }

        public String getFilterClause(boolean var1);

        public void setParameters(PreparedStatement var1) throws SQLException;

        public boolean handle(CheckDataPoint var1) throws Exception;
    }

    public static class ProbeTypeFilter {
        List<String> includedProbeTypes = new ArrayList<String>();
        List<String> excludedProbeTypes = new ArrayList<String>();

        public ProbeTypeFilter withIncludedProbeTypes(List<String> includedProbeTypes) {
            this.includedProbeTypes = includedProbeTypes;
            return this;
        }

        public ProbeTypeFilter withExcludedProbeTypes(List<String> excludedProbeTypes) {
            this.excludedProbeTypes = excludedProbeTypes;
            return this;
        }
    }

    public static class CheckDataPoint {
        public final String projectKey;
        public final String objectId;
        public final DataQualityRule check;
        public final long time;
        public final AbstractCheckContext.CheckOutcome outcome;
        public final String name;
        public final String message;
        public final String partition;
        public final int sessionIndex;
        public final DataQualityRunOrigin runOrigin;

        public CheckDataPoint(DataQualityRule check, String projectKey, String objectId, long time, String name, AbstractCheckContext.CheckOutcome outcome, String message, String partition, int sessionIndex, DataQualityRunOrigin runOrigin) {
            this.projectKey = projectKey;
            this.objectId = objectId;
            this.check = check;
            this.time = time;
            this.name = name;
            this.outcome = outcome;
            this.message = message;
            this.partition = partition;
            this.sessionIndex = sessionIndex;
            this.runOrigin = runOrigin;
        }
    }

    public static class DataQualityLastObjectPoint
    extends DataQualityObjectPoint {
        public final String displayName;
        @Nullable
        public final AbstractCheckContext.CheckOutcome worstMonitoredOutcome;

        public DataQualityLastObjectPoint(String projectKey, String objectId, long timestamp, long lastRunRuleComputeTime, DataQualityOutcome last, DataQualityOutcome worst, String displayName, AbstractCheckContext.CheckOutcome worstMonitoredOutcome, boolean deleted) {
            super(projectKey, objectId, timestamp, lastRunRuleComputeTime, last, worst, deleted);
            this.displayName = displayName;
            this.worstMonitoredOutcome = worstMonitoredOutcome;
        }
    }

    public static class DataQualityPartitionPoint
    extends DataQualityProjectPoint {
        public final String objectId;
        public final String partitionId;

        public DataQualityPartitionPoint(String projectKey, String objectId, String partitionId, long timestamp, long lastRunRuleComputeTime, DataQualityOutcome last, DataQualityOutcome worst) {
            super(projectKey, timestamp, lastRunRuleComputeTime, last, worst);
            this.objectId = objectId;
            this.partitionId = partitionId;
        }
    }

    public static class DataQualityHistoryObjectPoint
    extends DataQualityObjectPoint {
        public final boolean monitored;

        public DataQualityHistoryObjectPoint(String projectKey, String objectId, long computeDay, long lastRunRuleComputeTime, DataQualityOutcome last, DataQualityOutcome worst, boolean monitored, boolean deleted) {
            super(projectKey, objectId, computeDay, lastRunRuleComputeTime, last, worst, deleted);
            this.monitored = monitored;
        }
    }

    public static class DataQualityProjectPoint {
        public final String projectKey;
        public final long timestamp;
        public final long lastRunRuleComputeTime;
        public final DataQualityOutcome last;
        public final DataQualityOutcome worst;

        public DataQualityProjectPoint(String projectKey, long timestamp, long lastRunRuleComputeTime, DataQualityOutcome last, DataQualityOutcome worst) {
            this.projectKey = projectKey;
            this.timestamp = timestamp;
            this.lastRunRuleComputeTime = lastRunRuleComputeTime;
            this.last = last;
            this.worst = worst;
        }
    }

    public static class ComputedRule {
        public String id;
        public int sessionIndex;
        public AbstractCheckContext.CheckOutcome worstDailyOutcome;
        public AbstractCheckContext.CheckOutcome worstDailyOutcomeWhileEnabled;
        public boolean deleted;
        public boolean enabled;

        public ComputedRule(String id, int sessionIndex, AbstractCheckContext.CheckOutcome worstDailyOutcome, AbstractCheckContext.CheckOutcome worstDailyOutcomeWhileEnabled, boolean deleted, boolean enabled) {
            this.id = id;
            this.sessionIndex = sessionIndex;
            this.worstDailyOutcome = worstDailyOutcome;
            this.worstDailyOutcomeWhileEnabled = worstDailyOutcomeWhileEnabled;
            this.deleted = deleted;
            this.enabled = enabled;
        }
    }

    public static class ObjectHistoryRef {
        public final String objectId;
        public final long computeDay;

        public ObjectHistoryRef(String objectId, long computeDay) {
            this.objectId = objectId;
            this.computeDay = computeDay;
        }
    }

    public static interface RawScenarioRunConsumer {
        public void handle(String var1, String var2, String var3, String var4) throws Exception;
    }

    public static interface RawStepRunConsumer {
        public void handle(String var1, String var2, String var3, String var4, String var5) throws Exception;
    }

    public static interface FlowObjectActionConsumer {
        public void handle(String var1, String var2, String var3, String var4, long var5, String var7) throws Exception;
    }

    public static interface RawJobDatabaseObjectProducer {
        public boolean handle(PreparedStatement var1) throws Exception;
    }

    public static abstract class DataQualityObjectPoint
    extends DataQualityProjectPoint {
        public final String objectId;
        public final boolean deleted;

        protected DataQualityObjectPoint(String projectKey, String objectId, long timestamp, long lastRunRuleComputeTime, DataQualityOutcome last, DataQualityOutcome worst, boolean deleted) {
            super(projectKey, timestamp, lastRunRuleComputeTime, last, worst);
            this.objectId = objectId;
            this.deleted = deleted;
        }
    }
}

