/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.coremodel.AppManifest;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.Zone;
import com.dataiku.dip.dao.AnalysisCoreDAO;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SQLNotebooksDAO;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dao.SearchNotebooksDAO;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.dao.ZonesDAO;
import com.dataiku.dip.dashboards.DashboardsDAO;
import com.dataiku.dip.dashboards.insights.InsightsDAO;
import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.dataflow.graphtools.AbstractFlowTool;
import com.dataiku.dip.dataflow.graphtools.TagsView;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.labeling.LabelingTasksDAO;
import com.dataiku.dip.lambda.mgmt.FilesBasedLambdaServicesDAO;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.projects.apps.AppsService;
import com.dataiku.dip.reports.ReportsDAO;
import com.dataiku.dip.scheduler.ScenariosDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.notifications.backend.TagsListChangedEvent;
import com.dataiku.dip.server.services.FlowToolsService;
import com.dataiku.dip.server.services.IJupyterService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.JupyterUtils;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.server.services.TaggableObjectsSaveService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.WebAppsDAO;
import com.dataiku.dip.wikis.ArticlesDAO;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.lambda.model.studioconfig.DSSLambdaEndpointConfig;
import com.dataiku.lambda.model.studioconfig.LambdaService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaggingService
implements ITaggingService {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private AppsService appsService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ZonesDAO zonesDAO;
    @Autowired
    private ArticlesDAO articlesDAO;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private SQLNotebooksDAO sqlNotebooksDAO;
    @Autowired
    private SearchNotebooksDAO searchNotebooksDAO;
    @Autowired
    private AnalysisCoreDAO analysisCoreDAO;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private StreamingEndpointsDAO streamingEndpointsDAO;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private InsightsDAO insightsDAO;
    @Autowired
    private DashboardsDAO dashboardsDAO;
    @Autowired
    private WebAppsDAO webappsDAO;
    @Autowired
    private ReportsDAO reportsDAO;
    @Autowired
    private FilesBasedLambdaServicesDAO lambdaServicesDAO;
    @Autowired
    private ScenariosDAO scenariosDAO;
    @Autowired
    private ModelEvaluationStoresDAO modelEvaluationStoresDAO;
    @Autowired
    private LabelingTasksDAO labelingTaskDAO;
    @Autowired
    private IJupyterService jupyterService;
    @Autowired
    private TaggableObjectsReadService taggableObjectsReadService;
    @Autowired
    private TaggableObjectsSaveService taggableObjectsSaveService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private FlowToolsService flowToolsService;
    @Autowired
    protected TransactionService transactionService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.tagging");

    @Override
    public TagsFile listTags(String projectKey) throws Exception {
        return this.readTagsFile(projectKey, false);
    }

    @Override
    public TagsFile listTagsUnsafe(String projectKey) throws IOException {
        return this.readTagsFile(projectKey, true);
    }

    @Override
    public Map<String, TagsFile> listAllTags(AuthCtx user) throws Exception {
        return this.listAllTags(user, false);
    }

    @Override
    public Map<String, TagsFile> listAllTags(AuthCtx user, boolean includeLimitedVisibility) throws Exception {
        HashMap<String, TagsFile> map = new HashMap<String, TagsFile>();
        for (ProjectsService.UIProject project : this.projectsService.listAccessibleUnsafe(user, includeLimitedVisibility)) {
            map.put(project.projectKey, this.readTagsFile(project.projectKey, false));
        }
        return map;
    }

    public void updateGlobalTags(String projectKey, Map<String, GlobalTagUpdate> globalTags, AuthCtx user) throws Exception {
        TagsFile projectTags = this.listTags(projectKey);
        boolean changed = this.updateProjectTagsWithGlobalTags(projectTags, globalTags);
        SerializedProject sp = this.projectsService.getMandatory(projectKey);
        if (changed) {
            this.updateGlobalTagsForProjectParams(sp, projectTags);
            this.setTags(projectKey, projectTags, user);
        }
        if (sp.projectAppType != SerializedProject.ProjectAppType.REGULAR) {
            AppManifest manifest = this.getAppManifest(sp, user);
            boolean appTagsChanged = this.updateAppTagsWithGlobalTags(manifest.tags, globalTags);
            if (appTagsChanged) {
                this.appsService.saveAppTemplateManifestForProject(sp.projectKey, manifest);
            }
        }
    }

    private boolean updateProjectTagsWithGlobalTags(TagsFile projectTags, Map<String, GlobalTagUpdate> globalTags) {
        boolean changed = false;
        for (String key : globalTags.keySet()) {
            boolean removeTag;
            GlobalTagUpdate globalTagUpdate = globalTags.get(key);
            boolean bl = removeTag = globalTagUpdate.removeUsage != null && globalTagUpdate.removeUsage != false;
            if (!projectTags.tags.containsKey(key) || key.equals(globalTagUpdate.updatedTagName) && !removeTag) continue;
            changed = true;
            if (removeTag) {
                projectTags.tags.remove(key);
                continue;
            }
            projectTags.tags.put(key, new TagInfo(globalTagUpdate.updatedColor, globalTagUpdate.updatedTagName));
        }
        return changed;
    }

    private void updateGlobalTagsForProjectParams(SerializedProject sp, TagsFile projectTags) throws Exception {
        List<String> tags = TaggingService.filterTags(projectTags, sp.tags);
        if (tags != null && !tags.equals(sp.tags)) {
            sp.tags = this.execMerge(sp.tags, tags, TaggingMode.SET);
            this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.SUMMARY_ONLY);
        }
    }

    private boolean updateAppTagsWithGlobalTags(List<String> manifestTags, Map<String, GlobalTagUpdate> globalTags) {
        boolean changed = false;
        for (String globalTagName : globalTags.keySet()) {
            boolean removeTag;
            GlobalTagUpdate globalTagUpdate = globalTags.get(globalTagName);
            boolean bl = removeTag = globalTagUpdate.removeUsage != null && globalTagUpdate.removeUsage != false;
            if (!manifestTags.contains(globalTagName) || globalTagName.equals(globalTagUpdate.updatedTagName) && !removeTag) continue;
            changed = true;
            manifestTags.remove(globalTagName);
            if (removeTag || manifestTags.contains(globalTagUpdate.updatedTagName)) continue;
            manifestTags.add(globalTagUpdate.updatedTagName);
        }
        return changed;
    }

    private AppManifest getAppManifest(SerializedProject sp, AuthCtx user) throws IOException {
        return switch (sp.projectAppType) {
            case SerializedProject.ProjectAppType.APP_TEMPLATE -> this.appsService.getAppTemplateManifestForProject_T(sp.projectKey);
            case SerializedProject.ProjectAppType.APP_INSTANCE -> this.appsService.getAppInstanceManifestForProject_T(user, sp.projectKey);
            default -> throw new IllegalStateException("Unexpected project app type : " + String.valueOf((Object)sp.projectAppType));
        };
    }

    @Override
    public TagsFile setTags(String projectKey, TagsFile tagsFile, AuthCtx user) throws Exception {
        Boolean changeFlagged = false;
        changeFlagged = changeFlagged | this.filterTagsForAll(tagsFile, this.datasetsDAO.list(projectKey));
        changeFlagged = changeFlagged | this.filterTagsForAll(tagsFile, this.recipesDAO.list(projectKey));
        changeFlagged = changeFlagged | this.filterTagsForAll(tagsFile, this.sqlNotebooksDAO.list(projectKey));
        changeFlagged = changeFlagged | this.filterTagsForAll(tagsFile, this.searchNotebooksDAO.list(projectKey));
        changeFlagged = changeFlagged | this.filterTagsForAll(tagsFile, this.analysisCoreDAO.list(projectKey));
        changeFlagged = changeFlagged | this.filterTagsForAll(tagsFile, this.savedModelsDAO.list(projectKey));
        changeFlagged = changeFlagged | this.filterTagsForAll(tagsFile, this.zonesDAO.list(projectKey));
        changeFlagged = changeFlagged | this.filterTagsForAll(tagsFile, this.articlesDAO.list(projectKey));
        changeFlagged = changeFlagged | this.filterTagsForAll(tagsFile, this.streamingEndpointsDAO.list(projectKey));
        changeFlagged = changeFlagged | this.filterTagsForAll(tagsFile, this.insightsDAO.list(projectKey));
        changeFlagged = changeFlagged | this.filterTagsForAll(tagsFile, this.managedFolderDAO.list(projectKey));
        changeFlagged = changeFlagged | this.filterTagsForAll(tagsFile, this.scenariosDAO.list(projectKey));
        changeFlagged = changeFlagged | this.filterTagsForAll(tagsFile, this.dashboardsDAO.list(projectKey));
        changeFlagged = changeFlagged | this.filterTagsForAll(tagsFile, this.webappsDAO.list(projectKey));
        changeFlagged = changeFlagged | this.filterTagsForAll(tagsFile, this.reportsDAO.list(projectKey));
        changeFlagged = changeFlagged | this.filterTagsForAll(tagsFile, this.modelEvaluationStoresDAO.list(projectKey));
        changeFlagged = changeFlagged | this.filterTagsForAll(tagsFile, this.labelingTaskDAO.list(projectKey));
        changeFlagged = changeFlagged | this.filterTagsForLambdaServices(tagsFile, this.lambdaServicesDAO.list_noTag(projectKey, false));
        for (JupyterUtils.JupyterNotebookListEntry notebook : this.jupyterService.listSimple(DSSAuthCtx.newNone(), projectKey)) {
            List<String> tags = TaggingService.filterTags(tagsFile, notebook.tags);
            if (notebook.tags == tags) continue;
            this.jupyterService.setTags(projectKey, notebook.name, tags);
            logger.info((Object)("Update tags (jupyter notebook " + notebook.name + ")"));
        }
        if (user != null) {
            this.applyChangesToFocus(projectKey, tagsFile, user);
        }
        TagsFile finalisedTags = this.applyTagRenaming(tagsFile);
        this.writeTagsFile(projectKey, finalisedTags);
        if (!changeFlagged.booleanValue()) {
            this.pubSub.publishAfterTransaction(new TagsListChangedEvent(projectKey));
        }
        return finalisedTags;
    }

    private boolean filterTagsForLambdaServices(TagsFile tagsFile, List<LambdaService> services) throws Exception {
        boolean hasChanges = false;
        for (LambdaService service : services) {
            boolean serviceHasChanges = false;
            List<String> filteredServiceTags = TaggingService.filterTags(tagsFile, service.tags);
            if (filteredServiceTags != service.tags) {
                service.tags = filteredServiceTags;
                serviceHasChanges = true;
            }
            for (DSSLambdaEndpointConfig endpoint : service.endpoints) {
                List<String> filteredEndpointTags = TaggingService.filterTags(tagsFile, endpoint.tags);
                if (filteredEndpointTags == endpoint.tags) continue;
                endpoint.tags = filteredEndpointTags;
                serviceHasChanges = true;
            }
            if (!serviceHasChanges) continue;
            hasChanges |= this.tagObject(service, filteredServiceTags, TaggingMode.SET).booleanValue();
        }
        return hasChanges;
    }

    private void applyChangesToFocus(String projectKey, TagsFile tagsFile, AuthCtx user) {
        AbstractFlowTool flowView = null;
        if (this.flowToolsService.isActiveHandler(user, projectKey).booleanValue() && (flowView = this.flowToolsService.getActiveHandler(user, projectKey)) instanceof TagsView) {
            TagsView tagFlow = (TagsView)flowView;
            Collection<String> focusedTagsList = tagFlow.getCurrentFocus();
            HashSet<String> newFocused = new HashSet<String>();
            boolean isChanges = false;
            for (String focusedTag : focusedTagsList) {
                if (tagsFile.tags.containsKey(focusedTag)) {
                    if (tagsFile.tags.get((Object)focusedTag).updatedTagName != null) {
                        isChanges = true;
                        newFocused.add(tagsFile.tags.get((Object)focusedTag).updatedTagName);
                        continue;
                    }
                    newFocused.add(focusedTag);
                    continue;
                }
                isChanges = true;
            }
            if (isChanges) {
                try {
                    tagFlow.setFocus(newFocused);
                }
                catch (Exception e) {
                    logger.warn((Object)"Failed to renamed focused tags", (Throwable)e);
                }
            }
        }
    }

    private TagsFile applyTagRenaming(TagsFile tagsFile) {
        TagsFile newTagsFile = new TagsFile();
        for (Map.Entry<String, TagInfo> tag : tagsFile.tags.entrySet()) {
            String tagName = tag.getKey();
            TagInfo value = tag.getValue();
            String updatedTagName = value.updatedTagName;
            if (updatedTagName != null && updatedTagName.length() > 0 && !updatedTagName.equals(tagName)) {
                tagName = updatedTagName;
                value.updatedTagName = null;
            }
            newTagsFile.tags.put(tagName, value);
        }
        return newTagsFile;
    }

    private Boolean filterTagsForAll(TagsFile tagsFile, List<? extends TaggableObjectsService.TaggableObject> toes) throws Exception {
        Boolean changes = false;
        for (TaggableObjectsService.TaggableObject taggableObject : toes) {
            List<String> tags = TaggingService.filterTags(tagsFile, taggableObject.tags);
            if (tags == taggableObject.tags) continue;
            TaggableObjectsService.TaggableObjectRef ref = new TaggableObjectsService.TaggableObjectRef(taggableObject);
            changes = changes | this.tagObject(ref, tags, TaggingMode.SET);
        }
        return changes;
    }

    @Override
    public Map<String, List<String>> getTagNodeMap(String projectKey) throws Exception {
        HashMap<String, List<String>> nodeMap = new HashMap<String, List<String>>();
        for (ITaggingService.TaggableType type : ITaggingService.TaggableType.values()) {
            if (!type.isFlowItem()) continue;
            for (TaggableObjectsService.TaggableObject to : this.taggableObjectsReadService.listUnsafe(projectKey, type)) {
                nodeMap.put(GraphIds.forRef(to.getRef()), to.tags);
            }
        }
        for (Zone zone : this.zonesDAO.listUnsafe(projectKey)) {
            nodeMap.put("zone_" + zone.getId(), zone.tags);
        }
        for (ProjectsService.AnyLocWithType loc : this.projectsService.getAllExposedObjects(projectKey)) {
            TaggableObjectsService.TaggableObject to;
            if (loc.type == null || !loc.type.isFlowItem() || (to = this.taggableObjectsReadService.getOrNullUnsafe(loc.getProjectKey(), loc.type, loc.getId())) == null) continue;
            nodeMap.put(GraphIds.forRef(to.getRef()), to.tags);
        }
        return nodeMap;
    }

    @Override
    public Boolean onObjectSaved(String projectKey, List<String> objectTags) throws IOException {
        if (objectTags == null) {
            return false;
        }
        TagsFile projectTags = this.readTagsFile(projectKey, false);
        boolean modified = false;
        for (String ot : objectTags) {
            if (projectTags.tags.containsKey(ot)) continue;
            projectTags.tags.put(ot, new TagInfo());
            modified = true;
        }
        if (modified) {
            this.writeTagsFile(projectKey, projectTags);
            this.pubSub.publishAfterTransaction(new TagsListChangedEvent(projectKey));
        }
        return modified;
    }

    @Override
    public void executeTaggingRequest(List<TaggableObjectsService.TaggableObjectRef> elements, TaggingOperation operation) {
        for (TaggableObjectsService.TaggableObjectRef ref : elements) {
            assert (ref.projectKey != null);
            try {
                if (ref.type == ITaggingService.TaggableType.JUPYTER_NOTEBOOK) {
                    this.tagJupyterNotebook(ref.projectKey, ref.id, operation.tags, operation.mode);
                    continue;
                }
                this.tagObject(ref, operation.tags, operation.mode);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to tag " + String.valueOf((Object)ref.type) + " " + ref.id), (Throwable)e);
            }
        }
    }

    private Boolean tagObject(TaggableObjectsService.TaggableObjectRef ref, List<String> tags, TaggingMode mode) throws Exception {
        TaggableObjectsService.TaggableObject to = this.taggableObjectsReadService.getMandatory(ref);
        return this.tagObject(to, tags, mode);
    }

    private Boolean tagObject(TaggableObjectsService.TaggableObject to, List<String> tags, TaggingMode mode) throws Exception {
        to.tags = this.execMerge(to.tags, tags, mode);
        return this.taggableObjectsSaveService.save(to);
    }

    private static List<String> filterTags(TagsFile tagsFile, List<String> tags) {
        HashSet<String> output = new HashSet<String>();
        boolean same = true;
        if (tags != null) {
            for (String tag : tags) {
                if (tagsFile.tags.containsKey(tag)) {
                    String updatedTagName = tagsFile.tags.get((Object)tag).updatedTagName;
                    if (updatedTagName != null && updatedTagName.length() > 0 && !updatedTagName.equals(tag)) {
                        output.add(updatedTagName);
                        same = false;
                        continue;
                    }
                    output.add(tag);
                    continue;
                }
                same = false;
            }
        }
        if (same) {
            return tags;
        }
        return Lists.newArrayList(output);
    }

    public List<String> execMerge(List<String> originalTags, List<String> tags, TaggingMode mode) {
        logger.info((Object)("Merge " + String.valueOf(originalTags) + " with " + String.valueOf(tags)));
        switch (mode) {
            case ADD: {
                return Lists.newArrayList((Iterable)Sets.union((Set)Sets.newHashSet(originalTags), (Set)Sets.newHashSet(tags)));
            }
            case REMOVE: {
                return Lists.newArrayList((Iterable)Sets.difference((Set)Sets.newHashSet(originalTags), (Set)Sets.newHashSet(tags)));
            }
            case SET: {
                return tags;
            }
            case TOGGLE: {
                ArrayList newTags = Lists.newArrayList(originalTags);
                for (String tagToToggle : tags) {
                    if (originalTags.contains(tagToToggle)) {
                        newTags.remove(tagToToggle);
                        continue;
                    }
                    newTags.add(tagToToggle);
                }
                return newTags;
            }
        }
        throw new Error();
    }

    private void tagJupyterNotebook(String projectKey, String name, List<String> tags, TaggingMode mode) throws IOException, CodedException {
        List<String> prevTags = this.jupyterService.getTags(projectKey, name);
        List<String> outTags = this.execMerge(prevTags, tags, mode);
        this.jupyterService.setTags(projectKey, name, outTags);
    }

    private TagsFile readTagsFile(String projectKey, boolean unsafe) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        TransactionRef t = TransactionContext.retrieveRead();
        RelFile rFile = new RelFile(new String[]{"projects", projectKey, "tags.json"});
        if (unsafe) {
            return (TagsFile)t.readObjectDefaultUnsafe(rFile, TagsFile.class);
        }
        return (TagsFile)t.readObjectDefault(rFile, TagsFile.class);
    }

    private void writeTagsFile(String projectKey, TagsFile data) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.writeObject(new RelFile(new String[]{"projects", projectKey, "tags.json"}), (Object)data);
    }

    public void prepareTagsFiles14To20Migration() throws Exception {
        RWTransactionRef rwt = TransactionContext.retrieveWrite();
        TagsFile oldGlobalTags = (TagsFile)rwt.readObjectDefault("tags.json", TagsFile.class);
        List<String> projs = this.projectsService.listKeys();
        for (String spProjectKey : projs) {
            HashSet<String> projectTags = new HashSet<String>();
            TagsFile tagsFile = (TagsFile)JSON.deepCopy((Object)oldGlobalTags);
            for (SerializedDataset dataset : this.datasetsDAO.listUnsafe(spProjectKey)) {
                if (dataset.tags == null) continue;
                projectTags.addAll(dataset.tags);
            }
            for (SerializedRecipe recipe : this.recipesDAO.listUnsafe(spProjectKey)) {
                if (recipe.tags == null) continue;
                projectTags.addAll(recipe.tags);
            }
            projectTags.addAll(this.sqlNotebooksDAO.gatherTagsForProject(spProjectKey));
            projectTags.addAll(this.jupyterService.gatherTagsForProject(spProjectKey));
            for (String tag : projectTags) {
                if (tagsFile.tags.containsKey(tag)) continue;
                tagsFile.tags.put(tag, new TagInfo());
            }
            logger.info((Object)("Migration: writing tags file for " + spProjectKey));
            this.writeTagsFile(spProjectKey, tagsFile);
        }
    }

    public static class TagsFile {
        public Map<String, TagInfo> tags = new HashMap<String, TagInfo>();
    }

    public static class GlobalTagUpdate {
        public String updatedColor;
        public String updatedTagName;
        public Boolean removeUsage;

        public GlobalTagUpdate(String updatedTagName, String updatedColor, boolean removeUsage) {
            this.updatedTagName = updatedTagName;
            this.updatedColor = updatedColor;
            this.removeUsage = removeUsage;
        }
    }

    public static class TagInfo {
        public String color;
        public String updatedTagName;

        public TagInfo() {
        }

        public TagInfo(String color) {
            this.color = color;
        }

        public TagInfo(String color, String updatedTagName) {
            this.color = color;
            this.updatedTagName = updatedTagName;
        }
    }

    private static enum TaggingMode {
        ADD,
        REMOVE,
        SET,
        TOGGLE;

    }

    public static class TaggingOperation {
        public List<String> tags = new ArrayList<String>();
        public TaggingMode mode;
    }

    public static enum DEFAULT_TAG {
        IMPORTED("imported", new TagInfo("#263238")),
        SAMPLE("sample", new TagInfo("#2BB2AD")),
        TUTORIAL("tutorial", new TagInfo("#FFC425")),
        DUPLICATED("duplicated", new TagInfo("#3A85AD")),
        APP_INSTANTIATION("app instance", new TagInfo("#FF00DD"));

        public final String name;
        public final TagInfo tagInfo;

        private DEFAULT_TAG(String name, TagInfo tagInfo) {
            this.name = name;
            this.tagInfo = tagInfo;
        }

        public static DEFAULT_TAG getByName(String name) {
            if (name != null) {
                for (DEFAULT_TAG defaultTag : DEFAULT_TAG.values()) {
                    if (!defaultTag.name.toLowerCase().equals(name.toLowerCase())) continue;
                    return defaultTag;
                }
            }
            return null;
        }
    }

    @UIModel
    public static class TaggingRequest {
        public List<TaggableObjectsService.TaggableObjectRef> elements = new ArrayList<TaggableObjectsService.TaggableObjectRef>();
        public List<TaggingOperation> operations = new ArrayList<TaggingOperation>();
    }
}

