/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.facet;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.shaker.facet.AlphanumFacet;
import com.dataiku.dip.shaker.facet.CountMap;
import com.dataiku.dip.shaker.facet.FacetUtils;
import com.dataiku.dip.shaker.facet.StringLengthFacet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AlphanumFacetBuilder {
    public AlphanumFacet build(MemTable mt, FacetUtils.Sort sort, int maxResults, MemColumn col) {
        CountMap<String> counts = new CountMap<String>();
        int missing = 0;
        int invalid = 0;
        int unique = 0;
        int total = 0;
        ArrayList<Integer> stringLengths = new ArrayList<Integer>();
        for (MemRow memRow : mt.rows) {
            if (memRow.isDeleted()) continue;
            String string = memRow.get((Column)col, "");
            counts.inc(string);
            stringLengths.add(string.length());
        }
        Collections.sort(stringLengths);
        ArrayList<FacetUtils.FacetValue> values = new ArrayList<FacetUtils.FacetValue>();
        for (Map.Entry entry : counts) {
            FacetUtils.FacetValue fv = new FacetUtils.FacetValue();
            fv.key = (String)entry.getKey();
            fv.value = entry.getValue().intValue();
            values.add(fv);
            total += fv.value;
            if (fv.key.isEmpty()) {
                missing += fv.value;
            } else if (col.selectedType != null && !col.selectedType.type.validates(fv.key)) {
                invalid += fv.value;
            }
            if (fv.value != 1) continue;
            ++unique;
        }
        Collections.sort(values, sort);
        double d = 0.0;
        if (!stringLengths.isEmpty()) {
            if (stringLengths.size() % 2 == 1) {
                d = ((Integer)stringLengths.get(stringLengths.size() / 2)).intValue();
            } else {
                int mid1 = (Integer)stringLengths.get(stringLengths.size() / 2 - 1);
                int mid2 = (Integer)stringLengths.get(stringLengths.size() / 2);
                d = (double)(mid1 + mid2) / 2.0;
            }
        }
        double meanStringLength = stringLengths.stream().mapToInt(Integer::intValue).average().orElse(0.0);
        AlphanumFacet f = new AlphanumFacet();
        f.totalNbValues = counts.size();
        int countResults = Math.min(counts.size(), maxResults);
        f.counts = new int[countResults];
        f.values = new String[countResults];
        f.percentages = new double[countResults];
        f.cumPercentages = new double[countResults];
        if (!stringLengths.isEmpty()) {
            f.stringLengthFacet = new StringLengthFacet(((Integer)stringLengths.get(0)).intValue(), ((Integer)stringLengths.get(stringLengths.size() - 1)).intValue(), meanStringLength, d);
        }
        f.missing = total == 0 ? 0.0 : (double)missing / (double)total;
        f.nok = total == 0 ? 0.0 : (double)invalid / (double)total;
        f.totalRows = total;
        if (col.selectedType != null) {
            f.ok = new boolean[countResults];
        }
        int maxUniques = Math.min(6, maxResults);
        ArrayList<String> uniques = new ArrayList<String>(maxUniques);
        for (int i = 0; i < values.size() && uniques.size() < maxUniques; ++i) {
            if (((FacetUtils.FacetValue)values.get((int)i)).value != 1) continue;
            uniques.add(((FacetUtils.FacetValue)values.get((int)i)).key);
        }
        f.unique = unique;
        f.uniqueRatio = total == 0 ? 0.0 : (double)unique / (double)total;
        f.uniqueExamples = uniques.toArray(new String[uniques.size()]);
        int cur = 0;
        for (int i = 0; i < maxResults && i < values.size(); ++i) {
            FacetUtils.FacetValue fv = (FacetUtils.FacetValue)values.get(i);
            f.values[i] = fv.key;
            f.counts[i] = fv.value;
            f.percentages[i] = total == 0 ? 0.0 : (double)fv.value / (double)total;
            double d2 = f.cumPercentages[i] = total == 0 ? 0.0 : (double)(cur += fv.value) / (double)total;
            if (col.selectedType == null) continue;
            f.ok[i] = !StringUtils.isBlank((String)fv.key) && col.selectedType.type.validates(fv.key);
        }
        if (col.selectedType != null) {
            int maxNok = Math.min(8, maxResults);
            ArrayList<String> nok = new ArrayList<String>(maxNok);
            ArrayList<Integer> nokC = new ArrayList<Integer>(maxNok);
            for (int i = 0; i < values.size() && nok.size() < maxNok; ++i) {
                boolean ok;
                String key = ((FacetUtils.FacetValue)values.get((int)i)).key;
                if (StringUtils.isBlank((String)key)) continue;
                boolean bl = ok = i < maxResults ? f.ok[i] : col.selectedType.type.validates(key);
                if (ok) continue;
                nok.add(key);
                nokC.add(((FacetUtils.FacetValue)values.get((int)i)).value);
            }
            f.nokExamples = nok.toArray(new String[nok.size()]);
            f.nokCounts = new int[nokC.size()];
            for (int j = 0; j < nokC.size(); ++j) {
                f.nokCounts[j] = (Integer)nokC.get(j);
            }
        }
        return f;
    }
}

