/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.numbers;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.AppliesToProcessor;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class MeanProcessor
extends AppliesToProcessor
implements Processor {
    public static final ProcessorMeta<MeanProcessor, Parameter> META = new AppliesToProcessor.AppliesToProcessorMeta<MeanProcessor, Parameter>(){

        @Override
        public String getName() {
            return "MeanProcessor";
        }

        @Override
        public String getDocPage() {
            return "mean";
        }

        @Override
        public Category getCategory() {
            return Category.TRANSFORMATION;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.MATH});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.MeanProcessor.HELP", "This processor computes the line by line arithmetical mean (average) of a set of numeric columns.\n\nFor a given line, empty columns will be ignored, the mean will be calculated only over the non-empty columns.\nIf all columns are empty, the result will be either an empty cell, or a default value defined in the processor options.\n\n# Columns selection\n\nThis processor can compute the mean over multiple columns:\n\n-  An explicit list of columns\n-  All columns matching a given pattern\n\n# Examples\n\n-  Mean of ``[1, 2, 3]`` will be ``2``\n-  Mean of ``[1, 2, \"\"]`` will be ``1.5`` (the empty cell is ignored)\n-  Mean of ``[\"\", \"\"]`` will be an empty cell or the default value, depending on the processor options.\n\nNote that the processor doesn't support non-numeric values: Mean of ``[1, 2, \"some text\"]`` may yield an error when the recipe runs, depending on the execution environnement.\n");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withCustomForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.MeanProcessor.DESCRIPTION", 1.actionVerb("Compute the mean") + " of numerical values")).withParam(ParamDesc.string("appliesTo", this.translate(language, "SHAKER.PROCESSOR.MeanProcessor.DESCRIPTION.APPLIES_TO", "appliesTo")).withMandatory(true).withDefaultValue(AppliesToProcessor.AppliesTo.COLUMNS.toString())).withParam(ParamDesc.string("outputColumn", this.translate(language, "SHAKER.PROCESSOR.MeanProcessor.DESCRIPTION.OUTPUT_COLUMN", "Output column")).withMandatory(true).withCanBeEmpty(false).withDefaultValue("mean_output")).withParam(ParamDesc.booleanP("useDefaultValue", this.translate(language, "SHAKER.PROCESSOR.MeanProcessor.DESCRIPTION.USE_DEFAULT_VALUE", "Use default value")).withMandatory(true).withDefaultValue(false)).withParam(ParamDesc.doubleP("defaultValue", this.translate(language, "SHAKER.PROCESSOR.MeanProcessor.DESCRIPTION.DEFAULT_VALUE", "Default value")).withMandatory(false).withDefaultValue(0));
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams params, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            ProcessorMeta.ProcessorCapabilitiesSummary ret = new ProcessorMeta.ProcessorCapabilitiesSummary();
            ret.withCan(ProcessorCapabilities.SQL_TRANSLATABLE, ProcessorCapabilities.NATIVE_SPARK_IMPL);
            return ret;
        }

        @Override
        public Object selfReport(Parameter param) {
            JsonObject out = AppliesToProcessor.selfReport(param);
            out.addProperty("outputColumn", param.outputColumn);
            out.addProperty("useDefaultValue", Boolean.valueOf(param.useDefaultValue));
            out.addProperty("defaultValue", (Number)param.defaultValue);
            return out;
        }

        @Override
        public MeanProcessor build(Parameter parameter) {
            return new MeanProcessor(parameter);
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new SQLTranslator((Parameter)parameter);
        }

        @Override
        public String getNativeSparkClassname() {
            return "com.dataiku.dip.shaker.processors.numbers.MeanProcessorNS";
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            Parameter meanParam = (Parameter)pss.params;
            if (meanParam.columns == null || meanParam.columns.isEmpty() || meanParam.outputColumn.isBlank()) {
                throw new IllegalConfigurationException("Missing columns information for lineage on the mean processor.");
            }
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = this.getUpdatedDatasetPairLineage(meanParam, (DatasetPairLineage)previousDatasetPairLineage, meanParam.outputColumn, AppliesToProcessor.AppliesToProcessorMeta.RelationDirection.TO, true);
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };
    private final Parameter parameter;
    private Column outputColumn;

    public MeanProcessor(Parameter parameter) {
        this.parameter = parameter;
    }

    @Override
    public AppliesToProcessor.AppliesToParams getParams() {
        return this.parameter;
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (StringUtils.isBlank((String)this.parameter.outputColumn)) {
            throw new IllegalArgumentException("Output column is not defined");
        }
        this.outputColumn = this.getColumnFactory().column(this.parameter.outputColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
    }

    @Override
    public void processRowForColumns(Row row, Iterable<Column> cds) {
        double sum = 0.0;
        int colCnt = 0;
        for (Column col : cds) {
            double d = row.getAsDoubleOrNaN(col);
            if (Double.isNaN(d)) continue;
            sum += d;
            ++colCnt;
        }
        if (colCnt > 0) {
            row.put(this.outputColumn, sum / (double)colCnt);
        } else if (this.parameter.useDefaultValue) {
            row.put(this.outputColumn, this.parameter.defaultValue);
        } else {
            row.delete(this.outputColumn);
        }
    }

    public void postProcess() {
    }

    public static class Parameter
    extends AppliesToProcessor.AppliesToParams {
        private static final long serialVersionUID = 1L;
        public String outputColumn;
        public boolean useDefaultValue;
        public double defaultValue;
    }

    private static class SQLTranslator
    implements ProcessorSQLTranslator {
        private final Parameter parameter;
        private ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();

        private SQLTranslator(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema chain) {
            List<String> affectedColumns = chain.getAppliesToColumns(this.parameter);
            if (chain.isAnyCreatedOrModifiedByCurrentQuery(affectedColumns)) {
                chain = chain.makeSubquery();
            }
            ExpressionBuilder sum = this.ebf.cst(0);
            ExpressionBuilder colCnt = this.ebf.cst(0);
            for (String column : affectedColumns) {
                ExpressionBuilder value = chain.col(column).cast(Type.DOUBLE).coalesce(0);
                ExpressionBuilder denominatorContrib = this.ebf.caseWhen(this.ebf.op(QueryUtils.OperatorType.ISNULL, chain.col(column)), 0, 1);
                sum = sum.plus(value);
                colCnt = colCnt.plus(denominatorContrib);
            }
            ExpressionBuilder result = sum.div(colCnt);
            if (this.parameter.useDefaultValue) {
                result = result.coalesce(this.parameter.defaultValue);
            }
            chain.addLastOrReplaceColumn(null, result, Type.DOUBLE, this.parameter.outputColumn);
            return chain;
        }
    }
}

