/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.transform;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.types.Date;
import com.dataiku.dip.shaker.types.DateOnly;
import com.dataiku.dip.shaker.types.DatetimeNoTz;
import com.dataiku.dip.shaker.types.DoubleMeaning;
import com.dataiku.dip.shaker.types.LongMeaning;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class FillColumn
extends SingleRowProcessor
implements Processor {
    public static final ProcessorMeta<FillColumn, Parameter> META = new ProcessorMeta<FillColumn, Parameter>(){

        @Override
        public String getName() {
            return "FillColumn";
        }

        @Override
        public String getDocPage() {
            return "fill-column";
        }

        @Override
        public Category getCategory() {
            return Category.TRANSFORMATION;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.STRING});
        }

        @Override
        public Parameter expandParams(StepParams params, VariablesContext vc) {
            Parameter fillColumnParams = (Parameter)params;
            fillColumnParams.expandedValue = vc.expand(fillColumnParams.value);
            return fillColumnParams;
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.FillColumn.HELP", "Fill all values of a column with a fixed value.");
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.FillColumn.DESCRIPTION", 1.actionVerb("Fill") + " column")).withMNEColParam("column", this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.COLUMN", "Column")).withParam("value", "string", true, true, this.translate(language, "SHAKER.PROCESSOR.FillColumn.DESCRIPTION.VALUE", "Value"));
        }

        @Override
        public Object selfReport(Parameter parameter) {
            return JSON.deepCopyExcept((Object)parameter, (String[])new String[]{"value"});
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            ProcessorMeta.ProcessorCapabilitiesSummary ret = new ProcessorMeta.ProcessorCapabilitiesSummary().withCan(ProcessorCapabilities.SQL_TRANSLATABLE, ProcessorCapabilities.NATIVE_SPARK_IMPL);
            return ret;
        }

        @Override
        public FillColumn build(Parameter parameter) {
            return new FillColumn(parameter);
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new SQLTranslator((Parameter)parameter);
        }

        @Override
        public String getNativeSparkClassname() {
            return "com.dataiku.dip.shaker.processors.transform.FillColumnNS";
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                Parameter fillParams = (Parameter)pss.params;
                if (StringUtils.isBlank((String)fillParams.column)) {
                    throw new IllegalConfigurationException("Missing input column for FillColumn processor");
                }
                updatedDatasetPairLineage.removeRelationsOnColumn(fillParams.column);
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };
    private final Parameter parameter;
    private Column outCD;

    FillColumn(Parameter parameter) {
        this.parameter = parameter;
    }

    public void init() {
        this.outCD = this.getColumnFactory().column(this.parameter.column, Processor.ProcessorRole.OUTPUT_COLUMN);
    }

    public void processRow(Row row) {
        row.put(this.outCD, this.parameter.getExpandedValue());
    }

    public void postProcess() {
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = 1L;
        public String column;
        public String value;
        public transient String expandedValue;

        public void validate() {
        }

        public String getExpandedValue() {
            return this.expandedValue == null ? this.value : this.expandedValue;
        }
    }

    private static class SQLTranslator
    implements ProcessorSQLTranslator {
        private final Parameter parameter;

        private SQLTranslator(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema chain) {
            ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
            Type type = this.detectType(this.parameter.getExpandedValue());
            ExpressionBuilder expr = ebf.cst(this.parameter.getExpandedValue()).cast(type, chain.getDialect().getDefaultVarcharLen());
            chain.addLastOrReplaceColumn(null, expr, type, this.parameter.column);
            return chain;
        }

        private Type detectType(String value) {
            double bestScore = 0.0;
            Type selected = Type.STRING;
            double score = new DoubleMeaning().detects(value);
            if (score > bestScore) {
                selected = Type.DOUBLE;
                bestScore = score;
            }
            if ((score = new LongMeaning().detects(value)) > bestScore) {
                selected = Type.BIGINT;
                bestScore = score;
            }
            if ((score = new Date().detects(value)) > bestScore) {
                selected = Type.DATE;
                bestScore = score;
            }
            if ((score = new DateOnly().detects(value)) > bestScore) {
                selected = Type.DATEONLY;
                bestScore = score;
            }
            if ((score = new DatetimeNoTz().detects(value)) > bestScore) {
                selected = Type.DATETIMENOTZ;
                bestScore = score;
            }
            return selected;
        }
    }
}

