/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.services;

import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.utils.DKUMathsUtils;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class SuggestionEngineService {
    private Random RANDOM = new Random();
    private static Logger logger = Logger.getLogger((String)"dku.shaker.services.suggestion-engine");

    public SuggestionPreview validate(MemTable mt, String column, String regex) {
        MemColumn c2 = mt.column(column);
        SuggestionPreview preview = new SuggestionPreview();
        Pattern pattern = Pattern.compile(regex, 32);
        int max = 5;
        int foundGood = 0;
        int foundBad = 0;
        int nRows = mt.rows.size();
        for (MemRow mr : mt.rows) {
            Matched m;
            String cellValue;
            if (mr.isDeleted() || (cellValue = mr.get(c2)) == null || cellValue.length() == 0) continue;
            Matcher matcher = pattern.matcher(cellValue);
            float estimatedRatio = DKUMathsUtils.safeDivideAsFloat((int)foundGood, (int)(foundGood + foundBad));
            if (matcher.find()) {
                ++preview.nbOK;
                if (foundGood < max) {
                    m = new Matched();
                    m.cellValue = cellValue;
                    m.start = matcher.start(1);
                    m.end = matcher.end(1);
                    preview.sampleOK.add(m);
                    ++foundGood;
                    continue;
                }
                if (!((float)max / (estimatedRatio * (float)nRows) > this.RANDOM.nextFloat())) continue;
                preview.sampleOK.remove();
                m = new Matched();
                m.cellValue = cellValue;
                m.start = matcher.start(1);
                m.end = matcher.end(1);
                preview.sampleOK.add(m);
                continue;
            }
            ++preview.nbNOK;
            if (foundBad < max) {
                m = new Matched();
                m.cellValue = cellValue;
                m.start = -1;
                m.end = -1;
                preview.sampleNOK.add(m);
                ++foundBad;
                continue;
            }
            if (!((float)max / ((1.0f - estimatedRatio) * (float)nRows) > this.RANDOM.nextFloat())) continue;
            preview.sampleNOK.remove();
            m = new Matched();
            m.cellValue = cellValue;
            preview.sampleNOK.add(m);
        }
        logger.debug((Object)("validate suggestion ok=" + preview.nbOK + " nok=" + preview.nbNOK + " regex=" + regex));
        return preview;
    }

    public static class SuggestionPreview {
        Queue<Matched> sampleOK = new LinkedList<Matched>();
        Queue<Matched> sampleNOK = new LinkedList<Matched>();
        int nbOK;
        int nbNOK;
    }

    static class Matched {
        String cellValue;
        int start;
        int end;

        Matched() {
        }
    }
}

