/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.bigquery;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.SQLCodes;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.sql.SchemaOptions;
import com.dataiku.dip.sql.bigquery.Field;
import com.dataiku.dip.sql.bigquery.Schema;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.com.google.common.collect.ImmutableSet;
import com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.Field;
import com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.LegacySQLTypeName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class BigQuerySchemaHandler {
    public static final boolean HIERARCHICAL_ENABLED = DKUApp.getParams().getBoolParam("dku.sql.bigquery.hierarchical.enabled", true);
    public static final boolean HIERARCHICAL_ESCAPE_QUOTE = DKUApp.getParams().getBoolParam("dku.sql.bigquery.hierarchical.escapeQuote", true);
    private static final Map<String, Type> TYPES_MAP = new HashMap<String, Type>();
    public static final Set<String> LOSSY_TYPES;

    public static com.dataiku.dip.coremodel.Schema createDSSSchemaFromBigQuerySchema(Schema schema, SchemaOptions options) {
        Preconditions.checkNotNull((Object)schema, (Object)"schema");
        Preconditions.checkNotNull((Object)options, (Object)"options");
        com.dataiku.dip.coremodel.Schema ret = new com.dataiku.dip.coremodel.Schema();
        for (Field field : schema.fields) {
            ret.getColumns().add(BigQuerySchemaHandler.createColumnFromBigQueryField(field, options));
        }
        return ret;
    }

    public static com.dataiku.dip.coremodel.Schema createDSSSchemaFromBigQuerySchema(com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.Schema schema, SchemaOptions options) {
        Preconditions.checkNotNull((Object)schema, (Object)"schema");
        Preconditions.checkNotNull((Object)options, (Object)"options");
        com.dataiku.dip.coremodel.Schema ret = new com.dataiku.dip.coremodel.Schema();
        for (com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.Field field : schema.getFields()) {
            ret.getColumns().add(BigQuerySchemaHandler.createColumnFromBigQueryField(field, options));
        }
        return ret;
    }

    public static Schema createBigQuerySchema(com.dataiku.dip.coremodel.Schema schema) throws IOException {
        return BigQuerySchemaHandler.createBigQuerySchema(schema, false, false);
    }

    public static Schema createBigQuerySchema(com.dataiku.dip.coremodel.Schema schema, boolean convertTemporalColumnsToString, boolean convertRepeatedAndRecordsToString) throws IOException {
        List columns = schema.getColumns();
        if (columns.isEmpty()) {
            String errorMsg = "Cannot create a BigQuery table with zero column. Make sure the dataset has one or more columns in its schema.";
            throw new CodedIOException((InfoMessage.MessageCode)SQLCodes.ERR_BIGQUERY_EMPTY_SCHEMA, errorMsg);
        }
        Schema result = new Schema();
        for (SchemaColumn col : columns) {
            result.fields.add(BigQuerySchemaHandler.createBigQueryField(col, convertTemporalColumnsToString, convertRepeatedAndRecordsToString));
        }
        return result;
    }

    public static Field createBigQueryField(SchemaColumn column, boolean convertTemporalColumnsToString, boolean convertRepeatedAndRecordsToString) {
        return BigQuerySchemaHandler.createBigQueryField(column, convertTemporalColumnsToString, convertRepeatedAndRecordsToString, false);
    }

    private static String getBigQueryType(SchemaColumn schemaColumn) {
        switch (schemaColumn.getType()) {
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: {
                return "INT64";
            }
            case FLOAT: 
            case DOUBLE: {
                return "FLOAT64";
            }
            case STRING: {
                return "STRING";
            }
            case BOOLEAN: {
                return "BOOL";
            }
            case DATE: {
                return "TIMESTAMP";
            }
            case DATEONLY: {
                return "DATE";
            }
            case DATETIMENOTZ: {
                return "DATETIME";
            }
            case GEOMETRY: 
            case GEOPOINT: 
            case MAP: 
            case ARRAY: 
            case OBJECT: {
                throw ErrorContext.iaef((String)"Can't handle column type %s in BigQuery", (Object)schemaColumn.getType(), (Object[])new Object[0]);
            }
        }
        throw new Error("unreachable");
    }

    private static String getFieldType(SchemaColumn column, boolean useOriginalSQLType) {
        if (HIERARCHICAL_ENABLED && StringUtils.isNotBlank((CharSequence)column.originalSQLType)) {
            if (!useOriginalSQLType && column.getType() == Type.STRING && TYPES_MAP.get(column.originalSQLType) == Type.DATE) {
                return "STRING";
            }
            if (useOriginalSQLType) {
                return column.originalSQLType;
            }
        }
        return BigQuerySchemaHandler.getBigQueryType(column);
    }

    private static SchemaColumn createColumnFromBigQueryField(Field field, SchemaOptions options) {
        SchemaColumn ret = new SchemaColumn();
        ret.setName(field.name);
        ret.comment = field.description;
        if ("REPEATED".equals(field.mode)) {
            ret.setType(Type.ARRAY);
            if ("RECORD".equals(field.type) && !field.fields.isEmpty()) {
                ret.arrayContent = new SchemaColumn("", Type.OBJECT);
                ret.arrayContent.objectFields = new ArrayList();
                for (Field f : field.fields) {
                    ret.arrayContent.objectFields.add(BigQuerySchemaHandler.createColumnFromBigQueryField(f, options));
                }
            } else {
                ret.arrayContent = new SchemaColumn("", TYPES_MAP.get(field.type));
                ret.arrayContent.originalSQLType = field.type;
            }
        } else if ("RECORD".equals(field.type)) {
            ret.setType(Type.OBJECT);
            ret.objectFields = new ArrayList();
            for (Field f : field.fields) {
                ret.objectFields.add(BigQuerySchemaHandler.createColumnFromBigQueryField(f, options));
            }
        } else if ("DATE".equals(field.type)) {
            if (options.dateonlyReadMode == AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING) {
                ret.setType(Type.STRING);
            } else if (options.dateonlyReadMode == AbstractSQLDatasetHandler.ReadTemporalMode.AS_DATE) {
                ret.setType(Type.DATE);
                ret.withTimestampNoTzAsDate(true);
            } else {
                ret.setType(Type.DATEONLY);
            }
            ret.originalSQLType = field.type;
        } else if ("DATETIME".equals(field.type)) {
            if (options.datetimenotzReadMode == AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING) {
                ret.setType(Type.STRING);
            } else if (options.datetimenotzReadMode == AbstractSQLDatasetHandler.ReadTemporalMode.AS_DATE) {
                ret.setType(Type.DATE);
                ret.timestampNoTzAsDate = true;
            } else {
                ret.setType(Type.DATETIMENOTZ);
            }
            ret.originalSQLType = field.type;
        } else {
            ret.setType(TYPES_MAP.get(field.type));
            if (LOSSY_TYPES.contains(field.type)) {
                ret.originalSQLType = field.type;
            }
        }
        return ret;
    }

    private static SchemaColumn createColumnFromBigQueryField(com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.Field field, SchemaOptions options) {
        SchemaColumn ret = new SchemaColumn();
        ret.setName(field.getName());
        LegacySQLTypeName type = field.getType();
        String typeName = type.name();
        if (field.getMode() == Field.Mode.REPEATED) {
            ret.setType(Type.ARRAY);
            if (type == LegacySQLTypeName.RECORD && !field.getSubFields().isEmpty()) {
                ret.arrayContent = new SchemaColumn("", Type.OBJECT);
                ret.arrayContent.objectFields = new ArrayList();
                for (com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.Field f : field.getSubFields()) {
                    ret.arrayContent.objectFields.add(BigQuerySchemaHandler.createColumnFromBigQueryField(f, options));
                }
            } else {
                ret.arrayContent = new SchemaColumn("", TYPES_MAP.get(typeName));
                ret.arrayContent.originalSQLType = typeName;
            }
        } else if (type == LegacySQLTypeName.RECORD) {
            ret.setType(Type.OBJECT);
            ret.objectFields = new ArrayList();
            for (com.dataiku.dss.shadelibgcp.com.google.cloud.bigquery.Field f : field.getSubFields()) {
                ret.objectFields.add(BigQuerySchemaHandler.createColumnFromBigQueryField(f, options));
            }
        } else if (type == LegacySQLTypeName.DATE) {
            if (options.dateonlyReadMode == AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING) {
                ret.setType(Type.STRING);
            } else if (options.dateonlyReadMode == AbstractSQLDatasetHandler.ReadTemporalMode.AS_DATE) {
                ret.setType(Type.DATE);
                ret.withTimestampNoTzAsDate(true);
            } else {
                ret.setType(Type.DATEONLY);
            }
            ret.originalSQLType = typeName;
        } else if (type == LegacySQLTypeName.DATETIME) {
            if (options.datetimenotzReadMode == AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING) {
                ret.setType(Type.STRING);
            } else if (options.datetimenotzReadMode == AbstractSQLDatasetHandler.ReadTemporalMode.AS_DATE) {
                ret.setType(Type.DATE);
                ret.timestampNoTzAsDate = true;
            } else {
                ret.setType(Type.DATETIMENOTZ);
            }
            ret.originalSQLType = typeName;
        } else {
            ret.setType(TYPES_MAP.get(typeName));
            if (LOSSY_TYPES.contains(typeName)) {
                ret.originalSQLType = typeName;
            }
        }
        return ret;
    }

    private static Field createBigQueryField(SchemaColumn column, boolean convertTemporalColumnsToString, boolean convertRepeatedAndRecordsToString, boolean useOriginalSQLType) {
        Field field;
        boolean shouldStringify = convertTemporalColumnsToString && column.getType().isTemporal();
        if (!useOriginalSQLType && (shouldStringify |= convertRepeatedAndRecordsToString && (column.getType() == Type.OBJECT || column.getType() == Type.ARRAY))) {
            field = Field.of(column.getName(), "STRING");
        } else if (HIERARCHICAL_ENABLED && column.getType() == Type.ARRAY) {
            if (column.arrayContent == null) {
                throw new IllegalArgumentException("Unspecified array content type");
            }
            if (column.arrayContent.getType() == Type.ARRAY) {
                throw new IllegalArgumentException("Array of array is not supported in BigQuery");
            }
            field = BigQuerySchemaHandler.createBigQueryField(column.arrayContent, convertTemporalColumnsToString, convertRepeatedAndRecordsToString, true);
            field.name = column.getName();
            field.mode = "REPEATED";
        } else if (HIERARCHICAL_ENABLED && column.getType() == Type.OBJECT) {
            field = Field.of(column.getName(), "RECORD");
            field.fields = new ArrayList<Field>();
            for (SchemaColumn col : column.objectFields) {
                field.fields.add(BigQuerySchemaHandler.createBigQueryField(col, convertTemporalColumnsToString, convertRepeatedAndRecordsToString, true));
            }
        } else {
            String fieldType = BigQuerySchemaHandler.getFieldType(column, useOriginalSQLType);
            field = Field.of(column.getName(), fieldType);
        }
        field.description = column.comment;
        return field;
    }

    private BigQuerySchemaHandler() {
    }

    static {
        TYPES_MAP.put("STRING", Type.STRING);
        TYPES_MAP.put("BOOLEAN", Type.BOOLEAN);
        TYPES_MAP.put("INTEGER", Type.BIGINT);
        TYPES_MAP.put("INT64", Type.BIGINT);
        TYPES_MAP.put("FLOAT", Type.DOUBLE);
        TYPES_MAP.put("FLOAT64", Type.DOUBLE);
        TYPES_MAP.put("TIMESTAMP", Type.DATE);
        TYPES_MAP.put("DATE", Type.DATEONLY);
        TYPES_MAP.put("DATETIME", Type.DATETIMENOTZ);
        TYPES_MAP.put("NUMERIC", Type.DOUBLE);
        TYPES_MAP.put("BIGNUMERIC", Type.DOUBLE);
        TYPES_MAP.put("TIME", Type.STRING);
        TYPES_MAP.put("BYTES", Type.STRING);
        TYPES_MAP.put("GEOGRAPHY", Type.STRING);
        TYPES_MAP.put("JSON", Type.STRING);
        TYPES_MAP.put("INTERVAL", Type.STRING);
        LOSSY_TYPES = ImmutableSet.of((Object)"NUMERIC", (Object)"BIGNUMERIC", (Object)"TIME", (Object)"BYTES", (Object)"GEOGRAPHY", (Object)"JSON", (Object[])new String[]{"INTERVAL"});
    }
}

