/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.queries;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.sql.H2SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.AbstractQueryBuilder;
import com.dataiku.dip.sql.queries.QueryBuilderUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;

public class AddColumnQueryBuilder
extends AbstractQueryBuilder {
    private static final boolean ADD_CREATE_KEY_INSTRUCTION = true;
    private static final boolean IS_KEY = true;
    private SchemaColumn newColumn;
    private String quotedNewColumnName;
    private final boolean isKey;
    protected List<SchemaColumn> columns = new ArrayList<SchemaColumn>();

    public static AddColumnQueryBuilder addColumnTo(SQLUtils.SQLTable table) {
        return new AddColumnQueryBuilder(table, false);
    }

    private AddColumnQueryBuilder(SQLUtils.SQLTable table, boolean isKey) {
        super(table);
        this.isKey = isKey;
    }

    @Override
    protected void assertBuilderIsValid() {
        super.assertBuilderIsValid();
        Preconditions.checkState((this.columns.size() == 1 ? 1 : 0) != 0, (Object)"It is possible to add only one column.");
    }

    @Override
    void buildSQLQueries() {
        this.newColumn = this.columns.get(0);
        this.quotedNewColumnName = this.dialect.quoteIdentifier(this.newColumn.getName());
        if (!this.isKey) {
            this.queries.add(this.addColumn(false));
        } else if (this.dialect instanceof H2SQLDialect) {
            this.queries.add(this.addColumn(false));
            this.queries.add(this.setNonNull());
            this.queries.add(this.setPrimaryKey());
        } else {
            this.queries.add(this.addColumn(true));
        }
    }

    public AddColumnQueryBuilder addColumns(SchemaColumn ... columns) {
        for (SchemaColumn column : columns) {
            this.columns.add(new SchemaColumn(column));
        }
        return this;
    }

    private String addColumn(boolean createKey) {
        String result = "ALTER TABLE " + this.dialect.getQuotedTableFullName(this.table) + " ADD COLUMN " + this.newColumnDefinitionWithDeclaration();
        if (createKey) {
            result = result + ", PRIMARY KEY (" + this.quotedNewColumnName + ")";
        }
        return result;
    }

    private String setNonNull() {
        return "ALTER TABLE " + this.dialect.getQuotedTableFullName(this.table) + " ALTER COLUMN " + this.quotedNewColumnName + " SET NOT NULL";
    }

    private String setPrimaryKey() {
        return "ALTER TABLE " + this.dialect.getQuotedTableFullName(this.table) + " ADD CONSTRAINT primary_key PRIMARY KEY (" + this.quotedNewColumnName + ")";
    }

    private String newColumnDefinitionWithDeclaration() {
        Schema workingSchema = new Schema((List)ImmutableList.of((Object)this.newColumn), false);
        this.dialect.setDefaultLengthForSchemaColumn(workingSchema, this.getKey(), new InfoMessage.InfoMessages());
        return QueryBuilderUtils.columnDefinition(this.newColumn, this.dialect);
    }

    private List<SchemaColumn> getKey() {
        ImmutableList emptyList = ImmutableList.of();
        return this.isKey ? ImmutableList.of((Object)this.newColumn) : emptyList;
    }
}

