/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.fs;

import com.dataiku.dip.transactions.fs.FileContentCompressor;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;

public class DSSFileContentCompressors {
    public static final FileContentCompressor SNAPPY_COMPRESSOR = new FileContentCompressor(){

        public InputStream uncompressStream(InputStream is) throws IOException {
            return new SnappyInputStream(is);
        }

        public OutputStream compressStream(OutputStream os) throws IOException {
            return new SnappyOutputStream(os);
        }

        public String name() {
            return "snappy";
        }
    };
    public static final FileContentCompressor LZ4_COMPRESSOR = new FileContentCompressor(){

        public InputStream uncompressStream(InputStream is) {
            return new LZ4BlockInputStream(is);
        }

        public OutputStream compressStream(OutputStream os) {
            return new LZ4BlockOutputStream(os);
        }

        public String name() {
            return "lz4";
        }
    };
    public static final Map<String, FileContentCompressor> COMPRESSORS = ImmutableList.of((Object)SNAPPY_COMPRESSOR, (Object)LZ4_COMPRESSOR, (Object)FileContentCompressor.DEFLATE_COMPRESSOR, (Object)FileContentCompressor.NOOP_COMPRESSOR).stream().collect(Collectors.toMap(FileContentCompressor::name, Function.identity()));
}

