/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.git;

import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.transactions.git.GitModel;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class DSSGitModel {

    public static class ExternalLibraries {
        public Map<String, GitModel.GitReference> gitReferences = new HashMap<String, GitModel.GitReference>();
        public Set<String> pythonPath = Sets.newHashSet((Object[])new String[]{"python"});
        public Set<String> rsrcPath = Sets.newHashSet((Object[])new String[]{"R"});
        public List<String> importLibrariesFromProjects = new ArrayList<String>();

        public List<String> getNonNullLibrariesFromProjects() {
            if (this.importLibrariesFromProjects == null) {
                return new ArrayList<String>();
            }
            return this.importLibrariesFromProjects.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        }

        public List<String> getNonNullPythonPaths() {
            return this.pythonPath.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        }

        public List<String> getNonNullRSrcPaths() {
            return this.rsrcPath.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        }
    }

    public static class CodeStudioPushZoneLog {
        public List<GitModel.DKULogEntry> logEntries;
        public boolean pushCommitted = false;

        public CodeStudioPushZoneLog(ProjectFilesLog log, boolean committed) {
            this.pushCommitted = committed;
            this.logEntries = log.logEntries;
        }

        public CodeStudioPushZoneLog() {
            this.pushCommitted = false;
            this.logEntries = new ArrayList<GitModel.DKULogEntry>();
        }
    }

    public static class ProjectFilesLog
    extends GitModel.DKULog {
        public String projectKey;
        public String objectId;
    }

    public static class ObjectLog
    extends GitModel.DKULog {
        public TaggableObjectsService.TaggableObjectRef object;
    }

    public static class ProjectFilesDiff
    extends GitModel.MultiCommitDiff {
        public String projectKey;
        public String objectId;
        public String root;

        public ProjectFilesDiff(GitModel.MultiCommitDiff other, String projectKey, String objectId, String root) {
            this.diffEntries = other.diffEntries;
            this.addedLines = other.addedLines;
            this.removedLines = other.removedLines;
            this.changedFiles = other.changedFiles;
            this.commitFrom = other.commitFrom;
            this.commitTo = other.commitTo;
            this.projectKey = projectKey;
            this.objectId = objectId;
            this.root = root;
        }
    }

    public static enum ProjectFilesFolders {
        LIB("lib", false),
        RECIPES("recipes", false),
        CODE_STUDIO("code_studios", true);

        public final String value;
        public final boolean usesObjectId;

        private ProjectFilesFolders(String text, boolean usesObjectId) {
            this.value = text;
            this.usesObjectId = usesObjectId;
        }

        public String[] pathInProject(TaggableObjectsService.TaggableObjectRef tor) {
            if (this.usesObjectId) {
                return new String[]{this.value, tor.id};
            }
            return new String[]{this.value};
        }
    }

    public static class ObjectDiff
    extends GitModel.MultiCommitDiff {
        public TaggableObjectsService.TaggableObjectRef object;

        public ObjectDiff(GitModel.MultiCommitDiff other, TaggableObjectsService.TaggableObjectRef tor) {
            this.diffEntries = other.diffEntries;
            this.addedLines = other.addedLines;
            this.removedLines = other.removedLines;
            this.changedFiles = other.changedFiles;
            this.commitFrom = other.commitFrom;
            this.commitTo = other.commitTo;
            this.object = tor;
        }
    }

    public static enum PluginGitMode {
        GLOBAL,
        PLUGIN;

    }

    public static enum GitMode {
        GLOBAL,
        PROJECT;

    }
}

