/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.variables;

import com.dataiku.common.stereotype.SecuritySensitive;
import com.dataiku.dip.connections.ConnectionCredentialUtils;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithPerUserOAuth2Credentials;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.model.AbstractGlobalScopePublicAPIKey;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.IsolationLevel;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

@SecuritySensitive
public class VariablesLevelHelper {
    private static void addUserLogin(JsonObject ret, AuthCtx authCtx) {
        String associatedDSSUser;
        if (authCtx != null && authCtx.getAuthSource() != AuthCtx.AuthSource.NONE && StringUtils.isNotBlank((String)(associatedDSSUser = authCtx.getDSSUserForImpersonation()))) {
            ret.addProperty("dssUserLogin", associatedDSSUser);
        }
    }

    private static void addUserProperties(JsonObject ret, AuthCtx authCtx) throws DKUSecurityException {
        switch (authCtx.getAuthSource()) {
            case GLOBAL_API_KEY_WITH_GROUPS: 
            case CONFIGURABLE_API_KEY_GLOBAL: {
                AbstractGlobalScopePublicAPIKey apiKey = (AbstractGlobalScopePublicAPIKey)((DSSAuthCtx)authCtx).getAsPublicAPIKey();
                for (Map.Entry prop : apiKey.userProperties.entrySet()) {
                    if (prop.getValue() == null || ((JsonElement)prop.getValue()).isJsonNull()) {
                        ret.remove((String)prop.getKey());
                        continue;
                    }
                    if (!((JsonElement)prop.getValue()).isJsonPrimitive()) continue;
                    ret.addProperty("userProperty:" + (String)prop.getKey(), ((JsonElement)prop.getValue()).getAsString());
                }
                break;
            }
            case CONFIGURABLE_API_KEY_PROJECT: {
                break;
            }
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                try {
                    String login = authCtx.getAssociatedDSSUserMand();
                    UsersDAO.User user = VariablesLevelHelper.getUserUnsafeAutoTXN(login);
                    for (Map.Entry prop : user.userProperties.entrySet()) {
                        if (prop.getValue() == null || ((JsonElement)prop.getValue()).isJsonNull()) {
                            ret.remove((String)prop.getKey());
                            continue;
                        }
                        if (!((JsonElement)prop.getValue()).isJsonPrimitive()) continue;
                        ret.addProperty("userProperty:" + (String)prop.getKey(), ((JsonElement)prop.getValue()).getAsString());
                    }
                    break;
                }
                catch (IOException e) {
                    throw new DKUSecurityException("Cannot retrieve user/admin properties", (Throwable)e);
                }
            }
        }
    }

    private static void addUserAdminProperties(JsonObject ret, AuthCtx authCtx) throws DKUSecurityException {
        switch (authCtx.getAuthSource()) {
            case GLOBAL_API_KEY_WITH_GROUPS: 
            case CONFIGURABLE_API_KEY_GLOBAL: {
                AbstractGlobalScopePublicAPIKey apiKey = (AbstractGlobalScopePublicAPIKey)((DSSAuthCtx)authCtx).getAsPublicAPIKey();
                for (Map.Entry prop : apiKey.adminProperties.entrySet()) {
                    if (prop.getValue() == null || ((JsonElement)prop.getValue()).isJsonNull()) {
                        ret.remove((String)prop.getKey());
                        continue;
                    }
                    if (!((JsonElement)prop.getValue()).isJsonPrimitive()) continue;
                    ret.addProperty("adminProperty:" + (String)prop.getKey(), ((JsonElement)prop.getValue()).getAsString());
                }
                break;
            }
            case CONFIGURABLE_API_KEY_PROJECT: {
                break;
            }
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                try {
                    String login = authCtx.getAssociatedDSSUserMand();
                    UsersDAO.User user = VariablesLevelHelper.getUserUnsafeAutoTXN(login);
                    for (Map.Entry prop : user.adminProperties.entrySet()) {
                        if (prop.getValue() == null || ((JsonElement)prop.getValue()).isJsonNull()) {
                            ret.remove((String)prop.getKey());
                            continue;
                        }
                        if (!((JsonElement)prop.getValue()).isJsonPrimitive()) continue;
                        ret.addProperty("adminProperty:" + (String)prop.getKey(), ((JsonElement)prop.getValue()).getAsString());
                    }
                    break;
                }
                catch (IOException e) {
                    throw new DKUSecurityException("Cannot retrieve admin properties", (Throwable)e);
                }
            }
        }
    }

    private static UsersDAO.User getUserUnsafeAutoTXN(String login) throws IOException {
        try (Transaction t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).retrieveOrBeginRead(IsolationLevel.YOLO);){
            UsersDAO usersDAO = (UsersDAO)SpringUtils.getBean(UsersDAO.class);
            UsersDAO.User user = usersDAO.getMandatoryUnsafe(login);
            return user;
        }
    }

    public static JsonObject getNonEditableByUserUserLoginForUser(AuthCtx authCtx) throws DKUSecurityException {
        JsonObject ret = new JsonObject();
        VariablesLevelHelper.addUserLogin(ret, authCtx);
        return ret;
    }

    public static JsonObject getEditableByUserForUser(AuthCtx authCtx) throws DKUSecurityException {
        JsonObject ret = new JsonObject();
        VariablesLevelHelper.addUserProperties(ret, authCtx);
        return ret;
    }

    public static JsonObject getNonEditableByUserForUser(AuthCtx authCtx) throws DKUSecurityException {
        JsonObject ret = new JsonObject();
        VariablesLevelHelper.addUserLogin(ret, authCtx);
        VariablesLevelHelper.addUserAdminProperties(ret, authCtx);
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JsonObject getForConnection(DSSConnection connection, AuthCtx authCtx) throws DKUSecurityException {
        JsonObject ret = new JsonObject();
        if (connection instanceof ConnectionWithBasicCredential) {
            if (!((ConnectionWithBasicCredential)((Object)connection)).actuallyHasBasicCredential()) return ret;
            try {
                ICredentialsService.Credential credential = ConnectionCredentialUtils.getDecryptedCredential_autoTXN(connection, authCtx);
                if (credential instanceof ICredentialsService.BasicCredential) {
                    ICredentialsService.BasicCredential basicCred = (ICredentialsService.BasicCredential)credential;
                    ret.addProperty("pucUser", basicCred.user);
                    ret.addProperty("pucPassword", basicCred.password);
                    return ret;
                }
                if (!(credential instanceof ICredentialsService.SingleFieldCredential)) return ret;
                ICredentialsService.SingleFieldCredential singleCred = (ICredentialsService.SingleFieldCredential)credential;
                ret.addProperty("pucPassword", singleCred.value);
                return ret;
            }
            catch (DKUSecurityException | IOException e) {
                throw new DKUSecurityException("Managing credentials failed", e);
            }
        }
        if (connection instanceof ConnectionWithPerUserOAuth2Credentials || connection.credentialsMode != DSSConnection.CredentialsMode.PER_USER) return ret;
        try {
            ICredentialsService.Credential credential = ConnectionCredentialUtils.getDecryptedCredential_autoTXN(connection, authCtx);
            if (!(credential instanceof ICredentialsService.BasicCredential)) return ret;
            ICredentialsService.BasicCredential basicCred = (ICredentialsService.BasicCredential)credential;
            ret.addProperty("pucUser", basicCred.user);
            ret.addProperty("pucPassword", basicCred.password);
            return ret;
        }
        catch (DKUSecurityException | IOException e) {
            throw new DKUSecurityException("Managing credentials failed", e);
        }
    }
}

