/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.dataiku;

import com.dataiku.dip.io.ColumnBlock;
import com.google.refine.expr.CellTuple;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.WrappedCell;
import com.google.refine.expr.functions.dataiku.Val;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import com.google.refine.udaf.UdafUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Strval
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        Object fieldValue;
        WrappedCell wc;
        CellTuple tuple;
        if (args.length == 0 || args[0] == null) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects one argument");
        }
        String defaultValue = "";
        if (args.length >= 2 && args[1] != null) {
            defaultValue = args[1].toString();
        }
        String columnName = args[0].toString().trim();
        if (args.length == 3) {
            int offset = Val.extractOffset(args[2]);
            if (offset > 0) {
                Object fieldValue2;
                int index;
                List previousRows = (List)bindings.get("previousRows");
                if (previousRows != null && (index = previousRows.size() - offset) >= 0 && (fieldValue2 = ((Map)previousRows.get(index)).get(columnName)) != null) {
                    return fieldValue2.toString();
                }
                return defaultValue;
            }
            if (offset < 0) {
                throw new IllegalArgumentException("The offset argument must be a greater than or equal to zero");
            }
        }
        if ((tuple = (CellTuple)bindings.get("cells")) != null && (wc = (WrappedCell)tuple.getField(columnName, bindings)) != null && (fieldValue = wc.getField("value", bindings)) != null) {
            return fieldValue.toString();
        }
        ColumnBlock columnBlock = UdafUtils.getColumnBlock(bindings, columnName);
        if (columnBlock != null) {
            return UdafUtils.getStrColumnValue(bindings, columnBlock, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public boolean treatFirstArgumentAsColumnName() {
        return true;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Strval.DOCUMENTATION", "Returns the string value of a column. If the value is not a string, an empty value is returned. Specify an optional <code>defaultValue</code> to replace empty cells with it. Specify an optional <code>offset</code> to retrieve the value of the column on a previous row.").withParams("string columnName", "[string defaultValue]", "[number offset]").withReturns("string").withCategory("GREL.FUNCTIONS.CATEGORY.VALUE_ACCESS", "Value access functions");
    }

    @Override
    public boolean requirePreviousRows() {
        return true;
    }

    @Override
    public Map<String, Integer> getNumberOfPreviousRowsRequiredByColumns(Object[] args) {
        if (args != null && args.length == 3) {
            String columnName = args[0] != null ? args[0].toString().trim() : "";
            return Map.of(columnName, Val.extractOffset(args[2]));
        }
        return Collections.emptyMap();
    }
}

