/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.math;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;

public class Quotient
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 2 && args[0] != null && args[0] instanceof Number && args[1] != null && args[1] instanceof Number) {
            double q = Math.floor(((Number)args[0]).doubleValue() / ((Number)args[1]).doubleValue());
            long l = (long)q;
            if ((double)l == q) {
                return l;
            }
            return q;
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects two numbers");
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Quotient.DOCUMENTATION", "Returns the integer portion of a division.").withParams("number numerator, number denominator").withReturns("number").withCategory("GREL.FUNCTIONS.CATEGORY.MATHS", "Maths functions").withExample(Example.with("7", "2").returns("3.0"));
    }
}

